/*
 * Iko.travel
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our platform.  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.platform-v`1`+json.  ## Release history - 2021-07-01: v1 - Initial release  # Channel Manager API iko.travel exposes a secured REST-based JSON API to its channel manager partners. The connection is \"channel-wide\". Partners are free to integrate with the REST-based API using any programming language.  # Intended Audience This document is intended for external channel partners who wish to integrate with iko.travel.# Requirements - Active channel partner account with iko.travel. - Account credentials: Username / Password that is sent with every request in the form of a HTTP Basic Auth header entry. - Send us a list of your IP numbers. They need to be whitelisted before you can use our production environment.  # Performance A particular attention to performance should be given when integrating with this API. A few things to be aware of:  # Hypermedia We use hypermedia and resources include links to other resources in their responses. Responses are in [Hypertext Application from resource to resource. Language (HAL) format](http://stateless.co/hal_specification.html). Links can be found beneath the _links key. Users of the API should not create URIs themselves, instead they should use the above-described links to navigate. - Enable gzip compression to make payloads smaller. - Fewer large REST calls are preferred to many small ones. E.g. It is better to update many dates instead of individual dates. - It is possible to update both rate and availability in unison.. - Request only date ranges that you will use. There is no need to request an entire year if you will only be working with the first seven days.
 *
 * The version of the OpenAPI document: v1.0.0
 * Contact: bjorn@iko.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.channel.manager.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import travel.wink.channel.manager.model.Link;
import travel.wink.channel.manager.model.PropertyBookingsWithBookingNestedEntityModelPropertyBookingEntityModelEmbedded;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * PropertyBookingsWithBookingNestedEntityModelPropertyBookingEntityModel
 */
@JsonPropertyOrder({
  PropertyBookingsWithBookingNestedEntityModelPropertyBookingEntityModel.JSON_PROPERTY_EMBEDDED,
  PropertyBookingsWithBookingNestedEntityModelPropertyBookingEntityModel.JSON_PROPERTY_LINKS,
  PropertyBookingsWithBookingNestedEntityModelPropertyBookingEntityModel.JSON_PROPERTY_PROPERTY_IDENTIFIER,
  PropertyBookingsWithBookingNestedEntityModelPropertyBookingEntityModel.JSON_PROPERTY_START_DATE,
  PropertyBookingsWithBookingNestedEntityModelPropertyBookingEntityModel.JSON_PROPERTY_END_DATE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-24T12:59:27.723602+07:00[Asia/Bangkok]")
public class PropertyBookingsWithBookingNestedEntityModelPropertyBookingEntityModel {
  public static final String JSON_PROPERTY_EMBEDDED = "_embedded";
  private PropertyBookingsWithBookingNestedEntityModelPropertyBookingEntityModelEmbedded embedded;

  public static final String JSON_PROPERTY_LINKS = "_links";
  private Map<String, Link> links = null;

  public static final String JSON_PROPERTY_PROPERTY_IDENTIFIER = "propertyIdentifier";
  private String propertyIdentifier;

  public static final String JSON_PROPERTY_START_DATE = "startDate";
  private OffsetDateTime startDate;

  public static final String JSON_PROPERTY_END_DATE = "endDate";
  private OffsetDateTime endDate;

  public PropertyBookingsWithBookingNestedEntityModelPropertyBookingEntityModel() { 
  }

  public PropertyBookingsWithBookingNestedEntityModelPropertyBookingEntityModel embedded(PropertyBookingsWithBookingNestedEntityModelPropertyBookingEntityModelEmbedded embedded) {
    
    this.embedded = embedded;
    return this;
  }

   /**
   * Get embedded
   * @return embedded
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_EMBEDDED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PropertyBookingsWithBookingNestedEntityModelPropertyBookingEntityModelEmbedded getEmbedded() {
    return embedded;
  }


  @JsonProperty(JSON_PROPERTY_EMBEDDED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEmbedded(PropertyBookingsWithBookingNestedEntityModelPropertyBookingEntityModelEmbedded embedded) {
    this.embedded = embedded;
  }


  public PropertyBookingsWithBookingNestedEntityModelPropertyBookingEntityModel links(Map<String, Link> links) {
    
    this.links = links;
    return this;
  }

  public PropertyBookingsWithBookingNestedEntityModelPropertyBookingEntityModel putLinksItem(String key, Link linksItem) {
    if (this.links == null) {
      this.links = new HashMap<>();
    }
    this.links.put(key, linksItem);
    return this;
  }

   /**
   * Get links
   * @return links
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Link> getLinks() {
    return links;
  }


  @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLinks(Map<String, Link> links) {
    this.links = links;
  }


  public PropertyBookingsWithBookingNestedEntityModelPropertyBookingEntityModel propertyIdentifier(String propertyIdentifier) {
    
    this.propertyIdentifier = propertyIdentifier;
    return this;
  }

   /**
   * Get propertyIdentifier
   * @return propertyIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPropertyIdentifier() {
    return propertyIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPropertyIdentifier(String propertyIdentifier) {
    this.propertyIdentifier = propertyIdentifier;
  }


  public PropertyBookingsWithBookingNestedEntityModelPropertyBookingEntityModel startDate(OffsetDateTime startDate) {
    
    this.startDate = startDate;
    return this;
  }

   /**
   * Get startDate
   * @return startDate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getStartDate() {
    return startDate;
  }


  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStartDate(OffsetDateTime startDate) {
    this.startDate = startDate;
  }


  public PropertyBookingsWithBookingNestedEntityModelPropertyBookingEntityModel endDate(OffsetDateTime endDate) {
    
    this.endDate = endDate;
    return this;
  }

   /**
   * Get endDate
   * @return endDate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getEndDate() {
    return endDate;
  }


  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEndDate(OffsetDateTime endDate) {
    this.endDate = endDate;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PropertyBookingsWithBookingNestedEntityModelPropertyBookingEntityModel propertyBookingsWithBookingNestedEntityModelPropertyBookingEntityModel = (PropertyBookingsWithBookingNestedEntityModelPropertyBookingEntityModel) o;
    return Objects.equals(this.embedded, propertyBookingsWithBookingNestedEntityModelPropertyBookingEntityModel.embedded) &&
        Objects.equals(this.links, propertyBookingsWithBookingNestedEntityModelPropertyBookingEntityModel.links) &&
        Objects.equals(this.propertyIdentifier, propertyBookingsWithBookingNestedEntityModelPropertyBookingEntityModel.propertyIdentifier) &&
        Objects.equals(this.startDate, propertyBookingsWithBookingNestedEntityModelPropertyBookingEntityModel.startDate) &&
        Objects.equals(this.endDate, propertyBookingsWithBookingNestedEntityModelPropertyBookingEntityModel.endDate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(embedded, links, propertyIdentifier, startDate, endDate);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PropertyBookingsWithBookingNestedEntityModelPropertyBookingEntityModel {\n");
    sb.append("    embedded: ").append(toIndentedString(embedded)).append("\n");
    sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("    propertyIdentifier: ").append(toIndentedString(propertyIdentifier)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

