/*
 * Iko.travel
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our platform.  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.platform-v`1`+json.  ## Release history - 2021-07-01: v1 - Initial release  # Channel Manager API iko.travel exposes a secured REST-based JSON API to its channel manager partners. The connection is \"channel-wide\". Partners are free to integrate with the REST-based API using any programming language.  # Intended Audience This document is intended for external channel partners who wish to integrate with iko.travel.# Requirements - Active channel partner account with iko.travel. - Account credentials: Username / Password that is sent with every request in the form of a HTTP Basic Auth header entry. - Send us a list of your IP numbers. They need to be whitelisted before you can use our production environment.  # Performance A particular attention to performance should be given when integrating with this API. A few things to be aware of:  # Hypermedia We use hypermedia and resources include links to other resources in their responses. Responses are in [Hypertext Application from resource to resource. Language (HAL) format](http://stateless.co/hal_specification.html). Links can be found beneath the _links key. Users of the API should not create URIs themselves, instead they should use the above-described links to navigate. - Enable gzip compression to make payloads smaller. - Fewer large REST calls are preferred to many small ones. E.g. It is better to update many dates instead of individual dates. - It is possible to update both rate and availability in unison.. - Request only date ranges that you will use. There is no need to request an entire year if you will only be working with the first seven days.
 *
 * The version of the OpenAPI document: v1.0.0
 * Contact: bjorn@iko.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.channel.manager.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * PropertyRateUpdateDto
 */
@JsonPropertyOrder({
  PropertyRateUpdateDto.JSON_PROPERTY_START_DATE,
  PropertyRateUpdateDto.JSON_PROPERTY_END_DATE,
  PropertyRateUpdateDto.JSON_PROPERTY_AMOUNT,
  PropertyRateUpdateDto.JSON_PROPERTY_CURRENCY_CODE,
  PropertyRateUpdateDto.JSON_PROPERTY_MASTER,
  PropertyRateUpdateDto.JSON_PROPERTY_CLOSED_ON_ARRIVAL,
  PropertyRateUpdateDto.JSON_PROPERTY_CLOSED_ON_DEPARTURE,
  PropertyRateUpdateDto.JSON_PROPERTY_QUANTITY,
  PropertyRateUpdateDto.JSON_PROPERTY_MIN_LENGTH_OF_STAY,
  PropertyRateUpdateDto.JSON_PROPERTY_MAX_LENGTH_OF_STAY
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-27T09:47:42.388226+07:00[Asia/Bangkok]")
public class PropertyRateUpdateDto {
  public static final String JSON_PROPERTY_START_DATE = "startDate";
  private LocalDate startDate;

  public static final String JSON_PROPERTY_END_DATE = "endDate";
  private LocalDate endDate;

  public static final String JSON_PROPERTY_AMOUNT = "amount";
  private Double amount;

  public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
  private String currencyCode;

  public static final String JSON_PROPERTY_MASTER = "master";
  private Boolean master;

  public static final String JSON_PROPERTY_CLOSED_ON_ARRIVAL = "closedOnArrival";
  private Boolean closedOnArrival;

  public static final String JSON_PROPERTY_CLOSED_ON_DEPARTURE = "closedOnDeparture";
  private Boolean closedOnDeparture;

  public static final String JSON_PROPERTY_QUANTITY = "quantity";
  private Integer quantity;

  public static final String JSON_PROPERTY_MIN_LENGTH_OF_STAY = "minLengthOfStay";
  private Integer minLengthOfStay;

  public static final String JSON_PROPERTY_MAX_LENGTH_OF_STAY = "maxLengthOfStay";
  private Integer maxLengthOfStay;

  public PropertyRateUpdateDto() { 
  }

  public PropertyRateUpdateDto startDate(LocalDate startDate) {
    
    this.startDate = startDate;
    return this;
  }

   /**
   * Get startDate
   * @return startDate
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LocalDate getStartDate() {
    return startDate;
  }


  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStartDate(LocalDate startDate) {
    this.startDate = startDate;
  }


  public PropertyRateUpdateDto endDate(LocalDate endDate) {
    
    this.endDate = endDate;
    return this;
  }

   /**
   * Get endDate
   * @return endDate
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LocalDate getEndDate() {
    return endDate;
  }


  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEndDate(LocalDate endDate) {
    this.endDate = endDate;
  }


  public PropertyRateUpdateDto amount(Double amount) {
    
    this.amount = amount;
    return this;
  }

   /**
   * Get amount
   * @return amount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getAmount() {
    return amount;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmount(Double amount) {
    this.amount = amount;
  }


  public PropertyRateUpdateDto currencyCode(String currencyCode) {
    
    this.currencyCode = currencyCode;
    return this;
  }

   /**
   * Get currencyCode
   * @return currencyCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCurrencyCode() {
    return currencyCode;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrencyCode(String currencyCode) {
    this.currencyCode = currencyCode;
  }


  public PropertyRateUpdateDto master(Boolean master) {
    
    this.master = master;
    return this;
  }

   /**
   * Get master
   * @return master
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MASTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getMaster() {
    return master;
  }


  @JsonProperty(JSON_PROPERTY_MASTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaster(Boolean master) {
    this.master = master;
  }


  public PropertyRateUpdateDto closedOnArrival(Boolean closedOnArrival) {
    
    this.closedOnArrival = closedOnArrival;
    return this;
  }

   /**
   * Get closedOnArrival
   * @return closedOnArrival
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CLOSED_ON_ARRIVAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getClosedOnArrival() {
    return closedOnArrival;
  }


  @JsonProperty(JSON_PROPERTY_CLOSED_ON_ARRIVAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setClosedOnArrival(Boolean closedOnArrival) {
    this.closedOnArrival = closedOnArrival;
  }


  public PropertyRateUpdateDto closedOnDeparture(Boolean closedOnDeparture) {
    
    this.closedOnDeparture = closedOnDeparture;
    return this;
  }

   /**
   * Get closedOnDeparture
   * @return closedOnDeparture
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CLOSED_ON_DEPARTURE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getClosedOnDeparture() {
    return closedOnDeparture;
  }


  @JsonProperty(JSON_PROPERTY_CLOSED_ON_DEPARTURE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setClosedOnDeparture(Boolean closedOnDeparture) {
    this.closedOnDeparture = closedOnDeparture;
  }


  public PropertyRateUpdateDto quantity(Integer quantity) {
    
    this.quantity = quantity;
    return this;
  }

   /**
   * Get quantity
   * @return quantity
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getQuantity() {
    return quantity;
  }


  @JsonProperty(JSON_PROPERTY_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setQuantity(Integer quantity) {
    this.quantity = quantity;
  }


  public PropertyRateUpdateDto minLengthOfStay(Integer minLengthOfStay) {
    
    this.minLengthOfStay = minLengthOfStay;
    return this;
  }

   /**
   * Get minLengthOfStay
   * @return minLengthOfStay
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MIN_LENGTH_OF_STAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMinLengthOfStay() {
    return minLengthOfStay;
  }


  @JsonProperty(JSON_PROPERTY_MIN_LENGTH_OF_STAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinLengthOfStay(Integer minLengthOfStay) {
    this.minLengthOfStay = minLengthOfStay;
  }


  public PropertyRateUpdateDto maxLengthOfStay(Integer maxLengthOfStay) {
    
    this.maxLengthOfStay = maxLengthOfStay;
    return this;
  }

   /**
   * Get maxLengthOfStay
   * @return maxLengthOfStay
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MAX_LENGTH_OF_STAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMaxLengthOfStay() {
    return maxLengthOfStay;
  }


  @JsonProperty(JSON_PROPERTY_MAX_LENGTH_OF_STAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxLengthOfStay(Integer maxLengthOfStay) {
    this.maxLengthOfStay = maxLengthOfStay;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PropertyRateUpdateDto propertyRateUpdateDto = (PropertyRateUpdateDto) o;
    return Objects.equals(this.startDate, propertyRateUpdateDto.startDate) &&
        Objects.equals(this.endDate, propertyRateUpdateDto.endDate) &&
        Objects.equals(this.amount, propertyRateUpdateDto.amount) &&
        Objects.equals(this.currencyCode, propertyRateUpdateDto.currencyCode) &&
        Objects.equals(this.master, propertyRateUpdateDto.master) &&
        Objects.equals(this.closedOnArrival, propertyRateUpdateDto.closedOnArrival) &&
        Objects.equals(this.closedOnDeparture, propertyRateUpdateDto.closedOnDeparture) &&
        Objects.equals(this.quantity, propertyRateUpdateDto.quantity) &&
        Objects.equals(this.minLengthOfStay, propertyRateUpdateDto.minLengthOfStay) &&
        Objects.equals(this.maxLengthOfStay, propertyRateUpdateDto.maxLengthOfStay);
  }

  @Override
  public int hashCode() {
    return Objects.hash(startDate, endDate, amount, currencyCode, master, closedOnArrival, closedOnDeparture, quantity, minLengthOfStay, maxLengthOfStay);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PropertyRateUpdateDto {\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    currencyCode: ").append(toIndentedString(currencyCode)).append("\n");
    sb.append("    master: ").append(toIndentedString(master)).append("\n");
    sb.append("    closedOnArrival: ").append(toIndentedString(closedOnArrival)).append("\n");
    sb.append("    closedOnDeparture: ").append(toIndentedString(closedOnDeparture)).append("\n");
    sb.append("    quantity: ").append(toIndentedString(quantity)).append("\n");
    sb.append("    minLengthOfStay: ").append(toIndentedString(minLengthOfStay)).append("\n");
    sb.append("    maxLengthOfStay: ").append(toIndentedString(maxLengthOfStay)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

