/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our payment.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2021-07-01: v1 - Initial release  # Channel Manager API wink exposes a secured REST-based JSON API to its channel manager partners. The connection is \"channel-wide\". Partners are free to integrate with the REST-based API using any programming language.  # Intended Audience This document is intended for external channel partners who wish to integrate with wink.# Requirements - Active channel partner account with wink. - Account credentials: Username / Password that is sent with every request in the form of a HTTP Basic Auth header entry. - Send us a list of your IP numbers. They need to be whitelisted before you can use our production environment.  # Performance A particular attention to performance should be given when integrating with this API. A few things to be aware of:  # Hypermedia We use hypermedia and resources include links to other resources in their responses. Responses are in [Hypertext Application from resource to resource. Language (HAL) format](http://stateless.co/hal_specification.html). Links can be found beneath the _links key. Users of the API should not create URIs themselves, instead they should use the above-described links to navigate. - Enable gzip compression to make payloads smaller. - Fewer large REST calls are preferred to many small ones. E.g. It is better to update many dates instead of individual dates. - It is possible to update both rate and availability in unison.. - Request only date ranges that you will use. There is no need to request an entire year if you will only be working with the first seven days.
 *
 * The version of the OpenAPI document: 19.0.14-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.channel.manager.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import travel.wink.sdk.channel.manager.model.Link;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * PropertyRateEntityModel
 */
@JsonPropertyOrder({
  PropertyRateEntityModel.JSON_PROPERTY_IDENTIFIER,
  PropertyRateEntityModel.JSON_PROPERTY_PROPERTY_IDENTIFIER,
  PropertyRateEntityModel.JSON_PROPERTY_ROOM_RATE_IDENTIFIER,
  PropertyRateEntityModel.JSON_PROPERTY_AMOUNT,
  PropertyRateEntityModel.JSON_PROPERTY_CURRENCY_CODE,
  PropertyRateEntityModel.JSON_PROPERTY_MASTER,
  PropertyRateEntityModel.JSON_PROPERTY_CLOSED_ON_ARRIVAL,
  PropertyRateEntityModel.JSON_PROPERTY_CLOSED_ON_DEPARTURE,
  PropertyRateEntityModel.JSON_PROPERTY_DATE,
  PropertyRateEntityModel.JSON_PROPERTY_QUANTITY,
  PropertyRateEntityModel.JSON_PROPERTY_MIN_LENGTH_OF_STAY,
  PropertyRateEntityModel.JSON_PROPERTY_MAX_LENGTH_OF_STAY,
  PropertyRateEntityModel.JSON_PROPERTY_LINKS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-31T13:46:21.111521+07:00[Asia/Bangkok]")
public class PropertyRateEntityModel {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private String identifier;

  public static final String JSON_PROPERTY_PROPERTY_IDENTIFIER = "propertyIdentifier";
  private String propertyIdentifier;

  public static final String JSON_PROPERTY_ROOM_RATE_IDENTIFIER = "roomRateIdentifier";
  private String roomRateIdentifier;

  public static final String JSON_PROPERTY_AMOUNT = "amount";
  private Double amount;

  public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
  private String currencyCode;

  public static final String JSON_PROPERTY_MASTER = "master";
  private Boolean master;

  public static final String JSON_PROPERTY_CLOSED_ON_ARRIVAL = "closedOnArrival";
  private Boolean closedOnArrival;

  public static final String JSON_PROPERTY_CLOSED_ON_DEPARTURE = "closedOnDeparture";
  private Boolean closedOnDeparture;

  public static final String JSON_PROPERTY_DATE = "date";
  private LocalDate date;

  public static final String JSON_PROPERTY_QUANTITY = "quantity";
  private Integer quantity;

  public static final String JSON_PROPERTY_MIN_LENGTH_OF_STAY = "minLengthOfStay";
  private Integer minLengthOfStay;

  public static final String JSON_PROPERTY_MAX_LENGTH_OF_STAY = "maxLengthOfStay";
  private Integer maxLengthOfStay;

  public static final String JSON_PROPERTY_LINKS = "_links";
  private Map<String, Link> links = null;

  public PropertyRateEntityModel() { 
  }

  public PropertyRateEntityModel identifier(String identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Get identifier
   * @return identifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdentifier(String identifier) {
    this.identifier = identifier;
  }


  public PropertyRateEntityModel propertyIdentifier(String propertyIdentifier) {
    
    this.propertyIdentifier = propertyIdentifier;
    return this;
  }

   /**
   * Get propertyIdentifier
   * @return propertyIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getPropertyIdentifier() {
    return propertyIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPropertyIdentifier(String propertyIdentifier) {
    this.propertyIdentifier = propertyIdentifier;
  }


  public PropertyRateEntityModel roomRateIdentifier(String roomRateIdentifier) {
    
    this.roomRateIdentifier = roomRateIdentifier;
    return this;
  }

   /**
   * Get roomRateIdentifier
   * @return roomRateIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_ROOM_RATE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRoomRateIdentifier() {
    return roomRateIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_RATE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoomRateIdentifier(String roomRateIdentifier) {
    this.roomRateIdentifier = roomRateIdentifier;
  }


  public PropertyRateEntityModel amount(Double amount) {
    
    this.amount = amount;
    return this;
  }

   /**
   * Get amount
   * @return amount
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Double getAmount() {
    return amount;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAmount(Double amount) {
    this.amount = amount;
  }


  public PropertyRateEntityModel currencyCode(String currencyCode) {
    
    this.currencyCode = currencyCode;
    return this;
  }

   /**
   * Get currencyCode
   * @return currencyCode
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCurrencyCode() {
    return currencyCode;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCurrencyCode(String currencyCode) {
    this.currencyCode = currencyCode;
  }


  public PropertyRateEntityModel master(Boolean master) {
    
    this.master = master;
    return this;
  }

   /**
   * Get master
   * @return master
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_MASTER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getMaster() {
    return master;
  }


  @JsonProperty(JSON_PROPERTY_MASTER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMaster(Boolean master) {
    this.master = master;
  }


  public PropertyRateEntityModel closedOnArrival(Boolean closedOnArrival) {
    
    this.closedOnArrival = closedOnArrival;
    return this;
  }

   /**
   * Get closedOnArrival
   * @return closedOnArrival
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_CLOSED_ON_ARRIVAL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getClosedOnArrival() {
    return closedOnArrival;
  }


  @JsonProperty(JSON_PROPERTY_CLOSED_ON_ARRIVAL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setClosedOnArrival(Boolean closedOnArrival) {
    this.closedOnArrival = closedOnArrival;
  }


  public PropertyRateEntityModel closedOnDeparture(Boolean closedOnDeparture) {
    
    this.closedOnDeparture = closedOnDeparture;
    return this;
  }

   /**
   * Get closedOnDeparture
   * @return closedOnDeparture
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_CLOSED_ON_DEPARTURE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getClosedOnDeparture() {
    return closedOnDeparture;
  }


  @JsonProperty(JSON_PROPERTY_CLOSED_ON_DEPARTURE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setClosedOnDeparture(Boolean closedOnDeparture) {
    this.closedOnDeparture = closedOnDeparture;
  }


  public PropertyRateEntityModel date(LocalDate date) {
    
    this.date = date;
    return this;
  }

   /**
   * Get date
   * @return date
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LocalDate getDate() {
    return date;
  }


  @JsonProperty(JSON_PROPERTY_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDate(LocalDate date) {
    this.date = date;
  }


  public PropertyRateEntityModel quantity(Integer quantity) {
    
    this.quantity = quantity;
    return this;
  }

   /**
   * Get quantity
   * @return quantity
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getQuantity() {
    return quantity;
  }


  @JsonProperty(JSON_PROPERTY_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setQuantity(Integer quantity) {
    this.quantity = quantity;
  }


  public PropertyRateEntityModel minLengthOfStay(Integer minLengthOfStay) {
    
    this.minLengthOfStay = minLengthOfStay;
    return this;
  }

   /**
   * Get minLengthOfStay
   * @return minLengthOfStay
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MIN_LENGTH_OF_STAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMinLengthOfStay() {
    return minLengthOfStay;
  }


  @JsonProperty(JSON_PROPERTY_MIN_LENGTH_OF_STAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinLengthOfStay(Integer minLengthOfStay) {
    this.minLengthOfStay = minLengthOfStay;
  }


  public PropertyRateEntityModel maxLengthOfStay(Integer maxLengthOfStay) {
    
    this.maxLengthOfStay = maxLengthOfStay;
    return this;
  }

   /**
   * Get maxLengthOfStay
   * @return maxLengthOfStay
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MAX_LENGTH_OF_STAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMaxLengthOfStay() {
    return maxLengthOfStay;
  }


  @JsonProperty(JSON_PROPERTY_MAX_LENGTH_OF_STAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxLengthOfStay(Integer maxLengthOfStay) {
    this.maxLengthOfStay = maxLengthOfStay;
  }


  public PropertyRateEntityModel links(Map<String, Link> links) {
    
    this.links = links;
    return this;
  }

  public PropertyRateEntityModel putLinksItem(String key, Link linksItem) {
    if (this.links == null) {
      this.links = new HashMap<>();
    }
    this.links.put(key, linksItem);
    return this;
  }

   /**
   * Get links
   * @return links
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Link> getLinks() {
    return links;
  }


  @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLinks(Map<String, Link> links) {
    this.links = links;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PropertyRateEntityModel propertyRateEntityModel = (PropertyRateEntityModel) o;
    return Objects.equals(this.identifier, propertyRateEntityModel.identifier) &&
        Objects.equals(this.propertyIdentifier, propertyRateEntityModel.propertyIdentifier) &&
        Objects.equals(this.roomRateIdentifier, propertyRateEntityModel.roomRateIdentifier) &&
        Objects.equals(this.amount, propertyRateEntityModel.amount) &&
        Objects.equals(this.currencyCode, propertyRateEntityModel.currencyCode) &&
        Objects.equals(this.master, propertyRateEntityModel.master) &&
        Objects.equals(this.closedOnArrival, propertyRateEntityModel.closedOnArrival) &&
        Objects.equals(this.closedOnDeparture, propertyRateEntityModel.closedOnDeparture) &&
        Objects.equals(this.date, propertyRateEntityModel.date) &&
        Objects.equals(this.quantity, propertyRateEntityModel.quantity) &&
        Objects.equals(this.minLengthOfStay, propertyRateEntityModel.minLengthOfStay) &&
        Objects.equals(this.maxLengthOfStay, propertyRateEntityModel.maxLengthOfStay) &&
        Objects.equals(this.links, propertyRateEntityModel.links);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, propertyIdentifier, roomRateIdentifier, amount, currencyCode, master, closedOnArrival, closedOnDeparture, date, quantity, minLengthOfStay, maxLengthOfStay, links);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PropertyRateEntityModel {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    propertyIdentifier: ").append(toIndentedString(propertyIdentifier)).append("\n");
    sb.append("    roomRateIdentifier: ").append(toIndentedString(roomRateIdentifier)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    currencyCode: ").append(toIndentedString(currencyCode)).append("\n");
    sb.append("    master: ").append(toIndentedString(master)).append("\n");
    sb.append("    closedOnArrival: ").append(toIndentedString(closedOnArrival)).append("\n");
    sb.append("    closedOnDeparture: ").append(toIndentedString(closedOnDeparture)).append("\n");
    sb.append("    date: ").append(toIndentedString(date)).append("\n");
    sb.append("    quantity: ").append(toIndentedString(quantity)).append("\n");
    sb.append("    minLengthOfStay: ").append(toIndentedString(minLengthOfStay)).append("\n");
    sb.append("    maxLengthOfStay: ").append(toIndentedString(maxLengthOfStay)).append("\n");
    sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

