/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our payment.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Channel Manager API wink exposes a secured REST-based JSON API to its channel manager partners. The connection is \"channel-wide\". Partners are free to integrate with the REST-based API using any programming language.  # Intended Audience This document is intended for external channel partners who wish to integrate with wink.# Requirements - Active channel partner account with wink. - Account credentials: Username / Password that is sent with every request in the form of a HTTP Basic Auth header entry. - Send us a list of your IP numbers. They need to be whitelisted before you can use our production environment.  # Performance A particular attention to performance should be given when integrating with this API. A few things to be aware of:  # Hypermedia We use hypermedia and resources include links to other resources in their responses. Responses are in [Hypertext Application from resource to resource. Language (HAL) format](http://stateless.co/hal_specification.html). Links can be found beneath the _links key. Users of the API should not create URIs themselves, instead they should use the above-described links to navigate. - Enable gzip compression to make payloads smaller. - Fewer large REST calls are preferred to many small ones. E.g. It is better to update many dates instead of individual dates. - It is possible to update both rate and availability in unison.. - Request only date ranges that you will use. There is no need to request an entire year if you will only be working with the first seven days.
 *
 * The version of the OpenAPI document: 20.1.2-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.channel.manager.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import travel.wink.sdk.channel.manager.model.Link;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * PropertyBookingEntityModel
 */
@JsonPropertyOrder({
  PropertyBookingEntityModel.JSON_PROPERTY_BOOKING_IDENTIFIER,
  PropertyBookingEntityModel.JSON_PROPERTY_PROPERTY_IDENTIFIER,
  PropertyBookingEntityModel.JSON_PROPERTY_ROOM_RATE_IDENTIFIER,
  PropertyBookingEntityModel.JSON_PROPERTY_NAME,
  PropertyBookingEntityModel.JSON_PROPERTY_GUEST_ROOM_NAME,
  PropertyBookingEntityModel.JSON_PROPERTY_RATE_PLAN_NAME,
  PropertyBookingEntityModel.JSON_PROPERTY_ROOMS,
  PropertyBookingEntityModel.JSON_PROPERTY_GUESTS,
  PropertyBookingEntityModel.JSON_PROPERTY_ADULTS,
  PropertyBookingEntityModel.JSON_PROPERTY_CHILDREN,
  PropertyBookingEntityModel.JSON_PROPERTY_FIRST_NAME,
  PropertyBookingEntityModel.JSON_PROPERTY_LAST_NAME,
  PropertyBookingEntityModel.JSON_PROPERTY_EMAIL,
  PropertyBookingEntityModel.JSON_PROPERTY_AMOUNT,
  PropertyBookingEntityModel.JSON_PROPERTY_CURRENCY_CODE,
  PropertyBookingEntityModel.JSON_PROPERTY_BOOKING_CODE,
  PropertyBookingEntityModel.JSON_PROPERTY_START_DATE,
  PropertyBookingEntityModel.JSON_PROPERTY_END_DATE,
  PropertyBookingEntityModel.JSON_PROPERTY_CREATED_DATE,
  PropertyBookingEntityModel.JSON_PROPERTY_CANCELLED,
  PropertyBookingEntityModel.JSON_PROPERTY_CANCEL_DATE,
  PropertyBookingEntityModel.JSON_PROPERTY_PAYMENT_METHOD_TYPE,
  PropertyBookingEntityModel.JSON_PROPERTY_PAYMENT_METHOD_STATUS,
  PropertyBookingEntityModel.JSON_PROPERTY_LINKS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-06-11T13:46:11.659508+07:00[Asia/Bangkok]")
public class PropertyBookingEntityModel {
  public static final String JSON_PROPERTY_BOOKING_IDENTIFIER = "bookingIdentifier";
  private String bookingIdentifier;

  public static final String JSON_PROPERTY_PROPERTY_IDENTIFIER = "propertyIdentifier";
  private String propertyIdentifier;

  public static final String JSON_PROPERTY_ROOM_RATE_IDENTIFIER = "roomRateIdentifier";
  private String roomRateIdentifier;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_GUEST_ROOM_NAME = "guestRoomName";
  private String guestRoomName;

  public static final String JSON_PROPERTY_RATE_PLAN_NAME = "ratePlanName";
  private String ratePlanName;

  public static final String JSON_PROPERTY_ROOMS = "rooms";
  private Integer rooms;

  public static final String JSON_PROPERTY_GUESTS = "guests";
  private Integer guests;

  public static final String JSON_PROPERTY_ADULTS = "adults";
  private Integer adults;

  public static final String JSON_PROPERTY_CHILDREN = "children";
  private Integer children;

  public static final String JSON_PROPERTY_FIRST_NAME = "firstName";
  private String firstName;

  public static final String JSON_PROPERTY_LAST_NAME = "lastName";
  private String lastName;

  public static final String JSON_PROPERTY_EMAIL = "email";
  private String email;

  public static final String JSON_PROPERTY_AMOUNT = "amount";
  private Double amount;

  public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
  private String currencyCode;

  public static final String JSON_PROPERTY_BOOKING_CODE = "bookingCode";
  private String bookingCode;

  public static final String JSON_PROPERTY_START_DATE = "startDate";
  private LocalDate startDate;

  public static final String JSON_PROPERTY_END_DATE = "endDate";
  private LocalDate endDate;

  public static final String JSON_PROPERTY_CREATED_DATE = "createdDate";
  private OffsetDateTime createdDate;

  public static final String JSON_PROPERTY_CANCELLED = "cancelled";
  private Boolean cancelled;

  public static final String JSON_PROPERTY_CANCEL_DATE = "cancelDate";
  private OffsetDateTime cancelDate;

  /**
   * Gets or Sets paymentMethodType
   */
  public enum PaymentMethodTypeEnum {
    CREDIT_CARD("CREDIT_CARD"),
    
    BANK_TRANSFER("BANK_TRANSFER"),
    
    PAY_PAL("PAY_PAL"),
    
    CRYPTO("CRYPTO"),
    
    AGENT("AGENT"),
    
    CASH("CASH");

    private String value;

    PaymentMethodTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PaymentMethodTypeEnum fromValue(String value) {
      for (PaymentMethodTypeEnum b : PaymentMethodTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PAYMENT_METHOD_TYPE = "paymentMethodType";
  private PaymentMethodTypeEnum paymentMethodType;

  /**
   * Gets or Sets paymentMethodStatus
   */
  public enum PaymentMethodStatusEnum {
    PENDING("PENDING"),
    
    COMPLETE("COMPLETE"),
    
    PAY_ON_ARRIVAL("PAY_ON_ARRIVAL"),
    
    PROPERTY_MERCHANT_OF_RECORD("PROPERTY_MERCHANT_OF_RECORD"),
    
    FAILED("FAILED"),
    
    UNKNOWN("UNKNOWN");

    private String value;

    PaymentMethodStatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PaymentMethodStatusEnum fromValue(String value) {
      for (PaymentMethodStatusEnum b : PaymentMethodStatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PAYMENT_METHOD_STATUS = "paymentMethodStatus";
  private PaymentMethodStatusEnum paymentMethodStatus;

  public static final String JSON_PROPERTY_LINKS = "_links";
  private Map<String, Link> links = null;

  public PropertyBookingEntityModel() { 
  }

  public PropertyBookingEntityModel bookingIdentifier(String bookingIdentifier) {
    
    this.bookingIdentifier = bookingIdentifier;
    return this;
  }

   /**
   * Get bookingIdentifier
   * @return bookingIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_BOOKING_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getBookingIdentifier() {
    return bookingIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_BOOKING_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBookingIdentifier(String bookingIdentifier) {
    this.bookingIdentifier = bookingIdentifier;
  }


  public PropertyBookingEntityModel propertyIdentifier(String propertyIdentifier) {
    
    this.propertyIdentifier = propertyIdentifier;
    return this;
  }

   /**
   * Get propertyIdentifier
   * @return propertyIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getPropertyIdentifier() {
    return propertyIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPropertyIdentifier(String propertyIdentifier) {
    this.propertyIdentifier = propertyIdentifier;
  }


  public PropertyBookingEntityModel roomRateIdentifier(String roomRateIdentifier) {
    
    this.roomRateIdentifier = roomRateIdentifier;
    return this;
  }

   /**
   * Get roomRateIdentifier
   * @return roomRateIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_ROOM_RATE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRoomRateIdentifier() {
    return roomRateIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_RATE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoomRateIdentifier(String roomRateIdentifier) {
    this.roomRateIdentifier = roomRateIdentifier;
  }


  public PropertyBookingEntityModel name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public PropertyBookingEntityModel guestRoomName(String guestRoomName) {
    
    this.guestRoomName = guestRoomName;
    return this;
  }

   /**
   * Get guestRoomName
   * @return guestRoomName
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_GUEST_ROOM_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getGuestRoomName() {
    return guestRoomName;
  }


  @JsonProperty(JSON_PROPERTY_GUEST_ROOM_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setGuestRoomName(String guestRoomName) {
    this.guestRoomName = guestRoomName;
  }


  public PropertyBookingEntityModel ratePlanName(String ratePlanName) {
    
    this.ratePlanName = ratePlanName;
    return this;
  }

   /**
   * Get ratePlanName
   * @return ratePlanName
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_RATE_PLAN_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRatePlanName() {
    return ratePlanName;
  }


  @JsonProperty(JSON_PROPERTY_RATE_PLAN_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRatePlanName(String ratePlanName) {
    this.ratePlanName = ratePlanName;
  }


  public PropertyBookingEntityModel rooms(Integer rooms) {
    
    this.rooms = rooms;
    return this;
  }

   /**
   * Get rooms
   * @return rooms
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_ROOMS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getRooms() {
    return rooms;
  }


  @JsonProperty(JSON_PROPERTY_ROOMS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRooms(Integer rooms) {
    this.rooms = rooms;
  }


  public PropertyBookingEntityModel guests(Integer guests) {
    
    this.guests = guests;
    return this;
  }

   /**
   * Get guests
   * @return guests
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_GUESTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getGuests() {
    return guests;
  }


  @JsonProperty(JSON_PROPERTY_GUESTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setGuests(Integer guests) {
    this.guests = guests;
  }


  public PropertyBookingEntityModel adults(Integer adults) {
    
    this.adults = adults;
    return this;
  }

   /**
   * Get adults
   * @return adults
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_ADULTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getAdults() {
    return adults;
  }


  @JsonProperty(JSON_PROPERTY_ADULTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAdults(Integer adults) {
    this.adults = adults;
  }


  public PropertyBookingEntityModel children(Integer children) {
    
    this.children = children;
    return this;
  }

   /**
   * Get children
   * @return children
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getChildren() {
    return children;
  }


  @JsonProperty(JSON_PROPERTY_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setChildren(Integer children) {
    this.children = children;
  }


  public PropertyBookingEntityModel firstName(String firstName) {
    
    this.firstName = firstName;
    return this;
  }

   /**
   * Get firstName
   * @return firstName
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_FIRST_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getFirstName() {
    return firstName;
  }


  @JsonProperty(JSON_PROPERTY_FIRST_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setFirstName(String firstName) {
    this.firstName = firstName;
  }


  public PropertyBookingEntityModel lastName(String lastName) {
    
    this.lastName = lastName;
    return this;
  }

   /**
   * Get lastName
   * @return lastName
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_LAST_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getLastName() {
    return lastName;
  }


  @JsonProperty(JSON_PROPERTY_LAST_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLastName(String lastName) {
    this.lastName = lastName;
  }


  public PropertyBookingEntityModel email(String email) {
    
    this.email = email;
    return this;
  }

   /**
   * Get email
   * @return email
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getEmail() {
    return email;
  }


  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEmail(String email) {
    this.email = email;
  }


  public PropertyBookingEntityModel amount(Double amount) {
    
    this.amount = amount;
    return this;
  }

   /**
   * Get amount
   * @return amount
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Double getAmount() {
    return amount;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAmount(Double amount) {
    this.amount = amount;
  }


  public PropertyBookingEntityModel currencyCode(String currencyCode) {
    
    this.currencyCode = currencyCode;
    return this;
  }

   /**
   * Get currencyCode
   * @return currencyCode
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCurrencyCode() {
    return currencyCode;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCurrencyCode(String currencyCode) {
    this.currencyCode = currencyCode;
  }


  public PropertyBookingEntityModel bookingCode(String bookingCode) {
    
    this.bookingCode = bookingCode;
    return this;
  }

   /**
   * Get bookingCode
   * @return bookingCode
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_BOOKING_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getBookingCode() {
    return bookingCode;
  }


  @JsonProperty(JSON_PROPERTY_BOOKING_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBookingCode(String bookingCode) {
    this.bookingCode = bookingCode;
  }


  public PropertyBookingEntityModel startDate(LocalDate startDate) {
    
    this.startDate = startDate;
    return this;
  }

   /**
   * Get startDate
   * @return startDate
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LocalDate getStartDate() {
    return startDate;
  }


  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStartDate(LocalDate startDate) {
    this.startDate = startDate;
  }


  public PropertyBookingEntityModel endDate(LocalDate endDate) {
    
    this.endDate = endDate;
    return this;
  }

   /**
   * Get endDate
   * @return endDate
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LocalDate getEndDate() {
    return endDate;
  }


  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEndDate(LocalDate endDate) {
    this.endDate = endDate;
  }


  public PropertyBookingEntityModel createdDate(OffsetDateTime createdDate) {
    
    this.createdDate = createdDate;
    return this;
  }

   /**
   * Get createdDate
   * @return createdDate
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_CREATED_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OffsetDateTime getCreatedDate() {
    return createdDate;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCreatedDate(OffsetDateTime createdDate) {
    this.createdDate = createdDate;
  }


  public PropertyBookingEntityModel cancelled(Boolean cancelled) {
    
    this.cancelled = cancelled;
    return this;
  }

   /**
   * Get cancelled
   * @return cancelled
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_CANCELLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getCancelled() {
    return cancelled;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCancelled(Boolean cancelled) {
    this.cancelled = cancelled;
  }


  public PropertyBookingEntityModel cancelDate(OffsetDateTime cancelDate) {
    
    this.cancelDate = cancelDate;
    return this;
  }

   /**
   * Get cancelDate
   * @return cancelDate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CANCEL_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getCancelDate() {
    return cancelDate;
  }


  @JsonProperty(JSON_PROPERTY_CANCEL_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancelDate(OffsetDateTime cancelDate) {
    this.cancelDate = cancelDate;
  }


  public PropertyBookingEntityModel paymentMethodType(PaymentMethodTypeEnum paymentMethodType) {
    
    this.paymentMethodType = paymentMethodType;
    return this;
  }

   /**
   * Get paymentMethodType
   * @return paymentMethodType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PAYMENT_METHOD_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PaymentMethodTypeEnum getPaymentMethodType() {
    return paymentMethodType;
  }


  @JsonProperty(JSON_PROPERTY_PAYMENT_METHOD_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaymentMethodType(PaymentMethodTypeEnum paymentMethodType) {
    this.paymentMethodType = paymentMethodType;
  }


  public PropertyBookingEntityModel paymentMethodStatus(PaymentMethodStatusEnum paymentMethodStatus) {
    
    this.paymentMethodStatus = paymentMethodStatus;
    return this;
  }

   /**
   * Get paymentMethodStatus
   * @return paymentMethodStatus
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PAYMENT_METHOD_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PaymentMethodStatusEnum getPaymentMethodStatus() {
    return paymentMethodStatus;
  }


  @JsonProperty(JSON_PROPERTY_PAYMENT_METHOD_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaymentMethodStatus(PaymentMethodStatusEnum paymentMethodStatus) {
    this.paymentMethodStatus = paymentMethodStatus;
  }


  public PropertyBookingEntityModel links(Map<String, Link> links) {
    
    this.links = links;
    return this;
  }

  public PropertyBookingEntityModel putLinksItem(String key, Link linksItem) {
    if (this.links == null) {
      this.links = new HashMap<>();
    }
    this.links.put(key, linksItem);
    return this;
  }

   /**
   * Get links
   * @return links
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Link> getLinks() {
    return links;
  }


  @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLinks(Map<String, Link> links) {
    this.links = links;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PropertyBookingEntityModel propertyBookingEntityModel = (PropertyBookingEntityModel) o;
    return Objects.equals(this.bookingIdentifier, propertyBookingEntityModel.bookingIdentifier) &&
        Objects.equals(this.propertyIdentifier, propertyBookingEntityModel.propertyIdentifier) &&
        Objects.equals(this.roomRateIdentifier, propertyBookingEntityModel.roomRateIdentifier) &&
        Objects.equals(this.name, propertyBookingEntityModel.name) &&
        Objects.equals(this.guestRoomName, propertyBookingEntityModel.guestRoomName) &&
        Objects.equals(this.ratePlanName, propertyBookingEntityModel.ratePlanName) &&
        Objects.equals(this.rooms, propertyBookingEntityModel.rooms) &&
        Objects.equals(this.guests, propertyBookingEntityModel.guests) &&
        Objects.equals(this.adults, propertyBookingEntityModel.adults) &&
        Objects.equals(this.children, propertyBookingEntityModel.children) &&
        Objects.equals(this.firstName, propertyBookingEntityModel.firstName) &&
        Objects.equals(this.lastName, propertyBookingEntityModel.lastName) &&
        Objects.equals(this.email, propertyBookingEntityModel.email) &&
        Objects.equals(this.amount, propertyBookingEntityModel.amount) &&
        Objects.equals(this.currencyCode, propertyBookingEntityModel.currencyCode) &&
        Objects.equals(this.bookingCode, propertyBookingEntityModel.bookingCode) &&
        Objects.equals(this.startDate, propertyBookingEntityModel.startDate) &&
        Objects.equals(this.endDate, propertyBookingEntityModel.endDate) &&
        Objects.equals(this.createdDate, propertyBookingEntityModel.createdDate) &&
        Objects.equals(this.cancelled, propertyBookingEntityModel.cancelled) &&
        Objects.equals(this.cancelDate, propertyBookingEntityModel.cancelDate) &&
        Objects.equals(this.paymentMethodType, propertyBookingEntityModel.paymentMethodType) &&
        Objects.equals(this.paymentMethodStatus, propertyBookingEntityModel.paymentMethodStatus) &&
        Objects.equals(this.links, propertyBookingEntityModel.links);
  }

  @Override
  public int hashCode() {
    return Objects.hash(bookingIdentifier, propertyIdentifier, roomRateIdentifier, name, guestRoomName, ratePlanName, rooms, guests, adults, children, firstName, lastName, email, amount, currencyCode, bookingCode, startDate, endDate, createdDate, cancelled, cancelDate, paymentMethodType, paymentMethodStatus, links);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PropertyBookingEntityModel {\n");
    sb.append("    bookingIdentifier: ").append(toIndentedString(bookingIdentifier)).append("\n");
    sb.append("    propertyIdentifier: ").append(toIndentedString(propertyIdentifier)).append("\n");
    sb.append("    roomRateIdentifier: ").append(toIndentedString(roomRateIdentifier)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    guestRoomName: ").append(toIndentedString(guestRoomName)).append("\n");
    sb.append("    ratePlanName: ").append(toIndentedString(ratePlanName)).append("\n");
    sb.append("    rooms: ").append(toIndentedString(rooms)).append("\n");
    sb.append("    guests: ").append(toIndentedString(guests)).append("\n");
    sb.append("    adults: ").append(toIndentedString(adults)).append("\n");
    sb.append("    children: ").append(toIndentedString(children)).append("\n");
    sb.append("    firstName: ").append(toIndentedString(firstName)).append("\n");
    sb.append("    lastName: ").append(toIndentedString(lastName)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    currencyCode: ").append(toIndentedString(currencyCode)).append("\n");
    sb.append("    bookingCode: ").append(toIndentedString(bookingCode)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    createdDate: ").append(toIndentedString(createdDate)).append("\n");
    sb.append("    cancelled: ").append(toIndentedString(cancelled)).append("\n");
    sb.append("    cancelDate: ").append(toIndentedString(cancelDate)).append("\n");
    sb.append("    paymentMethodType: ").append(toIndentedString(paymentMethodType)).append("\n");
    sb.append("    paymentMethodStatus: ").append(toIndentedString(paymentMethodStatus)).append("\n");
    sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

