/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.channel.manager.api;

import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import travel.wink.sdk.channel.manager.invoker.ApiClient;
import travel.wink.sdk.channel.manager.model.PageableNestedResourcePropertyEntityModel;
import travel.wink.sdk.channel.manager.model.PropertyBookingEntityModel;
import travel.wink.sdk.channel.manager.model.PropertyBookingsWithBookingNestedEntityModelPropertyBookingEntityModel;
import travel.wink.sdk.channel.manager.model.PropertyRateEntityModel;
import travel.wink.sdk.channel.manager.model.PropertyRateUpdateDto;
import travel.wink.sdk.channel.manager.model.PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel;
import travel.wink.sdk.channel.manager.model.PropertyWithRoomRateNestedResourcePropertyRoomRateEntityModel;

public class ChannelManagerApi {
    private ApiClient apiClient;

    public ChannelManagerApi() {
        this(new ApiClient());
    }

    @Autowired
    public ChannelManagerApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec showPropertiesRequestCreation(Integer page, Integer size, String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "size", size));
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "application/hal+json", "application/vnd.payment-v1-hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basic_auth"};
        ParameterizedTypeReference<PageableNestedResourcePropertyEntityModel> localVarReturnType = new ParameterizedTypeReference<PageableNestedResourcePropertyEntityModel>(){};
        return this.apiClient.invokeAPI("/api/services/channelmanager/secured/property/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageableNestedResourcePropertyEntityModel> showProperties(Integer page, Integer size, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageableNestedResourcePropertyEntityModel> localVarReturnType = new ParameterizedTypeReference<PageableNestedResourcePropertyEntityModel>(){};
        return this.showPropertiesRequestCreation(page, size, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageableNestedResourcePropertyEntityModel>> showPropertiesWithHttpInfo(Integer page, Integer size, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageableNestedResourcePropertyEntityModel> localVarReturnType = new ParameterizedTypeReference<PageableNestedResourcePropertyEntityModel>(){};
        return this.showPropertiesRequestCreation(page, size, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showPropertyRequestCreation(String propertyIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showProperty", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "application/hal+json", "application/vnd.payment-v1-hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basic_auth"};
        ParameterizedTypeReference<PropertyWithRoomRateNestedResourcePropertyRoomRateEntityModel> localVarReturnType = new ParameterizedTypeReference<PropertyWithRoomRateNestedResourcePropertyRoomRateEntityModel>(){};
        return this.apiClient.invokeAPI("/api/services/channelmanager/secured/property/{propertyIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PropertyWithRoomRateNestedResourcePropertyRoomRateEntityModel> showProperty(String propertyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyWithRoomRateNestedResourcePropertyRoomRateEntityModel> localVarReturnType = new ParameterizedTypeReference<PropertyWithRoomRateNestedResourcePropertyRoomRateEntityModel>(){};
        return this.showPropertyRequestCreation(propertyIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PropertyWithRoomRateNestedResourcePropertyRoomRateEntityModel>> showPropertyWithHttpInfo(String propertyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyWithRoomRateNestedResourcePropertyRoomRateEntityModel> localVarReturnType = new ParameterizedTypeReference<PropertyWithRoomRateNestedResourcePropertyRoomRateEntityModel>(){};
        return this.showPropertyRequestCreation(propertyIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showPropertyBookingRequestCreation(String propertyIdentifier, String bookingIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showPropertyBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (bookingIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingIdentifier' when calling showPropertyBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("bookingIdentifier", bookingIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "application/hal+json", "application/vnd.payment-v1-hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basic_auth"};
        ParameterizedTypeReference<PropertyBookingEntityModel> localVarReturnType = new ParameterizedTypeReference<PropertyBookingEntityModel>(){};
        return this.apiClient.invokeAPI("/api/services/channelmanager/secured/property/{propertyIdentifier}/booking/{bookingIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PropertyBookingEntityModel> showPropertyBooking(String propertyIdentifier, String bookingIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyBookingEntityModel> localVarReturnType = new ParameterizedTypeReference<PropertyBookingEntityModel>(){};
        return this.showPropertyBookingRequestCreation(propertyIdentifier, bookingIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PropertyBookingEntityModel>> showPropertyBookingWithHttpInfo(String propertyIdentifier, String bookingIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyBookingEntityModel> localVarReturnType = new ParameterizedTypeReference<PropertyBookingEntityModel>(){};
        return this.showPropertyBookingRequestCreation(propertyIdentifier, bookingIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showPropertyBookingsRequestCreation(String propertyIdentifier, OffsetDateTime startDate, OffsetDateTime endDate, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showPropertyBookings", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (startDate == null) {
            throw new WebClientResponseException("Missing the required parameter 'startDate' when calling showPropertyBookings", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "startDate", startDate));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "endDate", endDate));
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "application/hal+json", "application/vnd.payment-v1-hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basic_auth"};
        ParameterizedTypeReference<PropertyBookingsWithBookingNestedEntityModelPropertyBookingEntityModel> localVarReturnType = new ParameterizedTypeReference<PropertyBookingsWithBookingNestedEntityModelPropertyBookingEntityModel>(){};
        return this.apiClient.invokeAPI("/api/services/channelmanager/secured/property/{propertyIdentifier}/booking/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PropertyBookingsWithBookingNestedEntityModelPropertyBookingEntityModel> showPropertyBookings(String propertyIdentifier, OffsetDateTime startDate, OffsetDateTime endDate, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyBookingsWithBookingNestedEntityModelPropertyBookingEntityModel> localVarReturnType = new ParameterizedTypeReference<PropertyBookingsWithBookingNestedEntityModelPropertyBookingEntityModel>(){};
        return this.showPropertyBookingsRequestCreation(propertyIdentifier, startDate, endDate, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PropertyBookingsWithBookingNestedEntityModelPropertyBookingEntityModel>> showPropertyBookingsWithHttpInfo(String propertyIdentifier, OffsetDateTime startDate, OffsetDateTime endDate, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyBookingsWithBookingNestedEntityModelPropertyBookingEntityModel> localVarReturnType = new ParameterizedTypeReference<PropertyBookingsWithBookingNestedEntityModelPropertyBookingEntityModel>(){};
        return this.showPropertyBookingsRequestCreation(propertyIdentifier, startDate, endDate, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showPropertyRoomRateRequestCreation(String propertyIdentifier, String masterRateIdentifier, String rateIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showPropertyRoomRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (masterRateIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'masterRateIdentifier' when calling showPropertyRoomRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (rateIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'rateIdentifier' when calling showPropertyRoomRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("masterRateIdentifier", masterRateIdentifier);
        pathParams.put("rateIdentifier", rateIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "application/hal+json", "application/vnd.payment-v1-hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basic_auth"};
        ParameterizedTypeReference<PropertyRateEntityModel> localVarReturnType = new ParameterizedTypeReference<PropertyRateEntityModel>(){};
        return this.apiClient.invokeAPI("/api/services/channelmanager/secured/property/{propertyIdentifier}/roomrate/{masterRateIdentifier}/rate/{rateIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PropertyRateEntityModel> showPropertyRoomRate(String propertyIdentifier, String masterRateIdentifier, String rateIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyRateEntityModel> localVarReturnType = new ParameterizedTypeReference<PropertyRateEntityModel>(){};
        return this.showPropertyRoomRateRequestCreation(propertyIdentifier, masterRateIdentifier, rateIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PropertyRateEntityModel>> showPropertyRoomRateWithHttpInfo(String propertyIdentifier, String masterRateIdentifier, String rateIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyRateEntityModel> localVarReturnType = new ParameterizedTypeReference<PropertyRateEntityModel>(){};
        return this.showPropertyRoomRateRequestCreation(propertyIdentifier, masterRateIdentifier, rateIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showPropertyRoomRatesRequestCreation(String propertyIdentifier, String masterRateIdentifier, LocalDate startDate, LocalDate endDate, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showPropertyRoomRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (masterRateIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'masterRateIdentifier' when calling showPropertyRoomRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (startDate == null) {
            throw new WebClientResponseException("Missing the required parameter 'startDate' when calling showPropertyRoomRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (endDate == null) {
            throw new WebClientResponseException("Missing the required parameter 'endDate' when calling showPropertyRoomRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("masterRateIdentifier", masterRateIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "startDate", startDate));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "endDate", endDate));
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "application/hal+json", "application/vnd.payment-v1-hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basic_auth"};
        ParameterizedTypeReference<PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel> localVarReturnType = new ParameterizedTypeReference<PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel>(){};
        return this.apiClient.invokeAPI("/api/services/channelmanager/secured/property/{propertyIdentifier}/roomrate/{masterRateIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel> showPropertyRoomRates(String propertyIdentifier, String masterRateIdentifier, LocalDate startDate, LocalDate endDate, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel> localVarReturnType = new ParameterizedTypeReference<PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel>(){};
        return this.showPropertyRoomRatesRequestCreation(propertyIdentifier, masterRateIdentifier, startDate, endDate, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel>> showPropertyRoomRatesWithHttpInfo(String propertyIdentifier, String masterRateIdentifier, LocalDate startDate, LocalDate endDate, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel> localVarReturnType = new ParameterizedTypeReference<PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel>(){};
        return this.showPropertyRoomRatesRequestCreation(propertyIdentifier, masterRateIdentifier, startDate, endDate, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec updateRatesRequestCreation(String propertyIdentifier, String masterRateIdentifier, PropertyRateUpdateDto propertyRateUpdateDto) throws WebClientResponseException {
        PropertyRateUpdateDto postBody = propertyRateUpdateDto;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling updateRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (masterRateIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'masterRateIdentifier' when calling updateRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (propertyRateUpdateDto == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyRateUpdateDto' when calling updateRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("masterRateIdentifier", masterRateIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/hal+json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basic_auth"};
        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/services/channelmanager/secured/property/{propertyIdentifier}/roomrate/{masterRateIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Void> updateRates(String propertyIdentifier, String masterRateIdentifier, PropertyRateUpdateDto propertyRateUpdateDto) throws WebClientResponseException {
        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>(){};
        return this.updateRatesRequestCreation(propertyIdentifier, masterRateIdentifier, propertyRateUpdateDto).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Void>> updateRatesWithHttpInfo(String propertyIdentifier, String masterRateIdentifier, PropertyRateUpdateDto propertyRateUpdateDto) throws WebClientResponseException {
        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>(){};
        return this.updateRatesRequestCreation(propertyIdentifier, masterRateIdentifier, propertyRateUpdateDto).toEntity((ParameterizedTypeReference)localVarReturnType);
    }
}

