package travel.wink.sdk.channel.manager.api;

import travel.wink.sdk.channel.manager.invoker.ApiClient;

import travel.wink.sdk.channel.manager.model.GenericErrorMessage;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import travel.wink.sdk.channel.manager.model.PageableNestedResourcePropertyEntityModel;
import travel.wink.sdk.channel.manager.model.PropertyBookingEntityModel;
import travel.wink.sdk.channel.manager.model.PropertyBookingsWithBookingNestedEntityModelPropertyBookingEntityModel;
import travel.wink.sdk.channel.manager.model.PropertyRateEntityModel;
import travel.wink.sdk.channel.manager.model.PropertyRateUpdateDto;
import travel.wink.sdk.channel.manager.model.PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel;
import travel.wink.sdk.channel.manager.model.PropertyWithRoomRateNestedResourcePropertyRoomRateEntityModel;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-07-03T20:10:21.971138+07:00[Asia/Bangkok]")
public class ChannelManagerApi {
    private ApiClient apiClient;

    public ChannelManagerApi() {
        this(new ApiClient());
    }

    @Autowired
    public ChannelManagerApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Show Properties
     * The properties endpoint provides the entry point into the listener and is used to list properties you have access to.
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param page Page through all properties owned by your account
     * @param size Limit results of records per page
     * @param accept The accept parameter
     * @return PageableNestedResourcePropertyEntityModel
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showPropertiesRequestCreation(Integer page, Integer size, String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "size", size));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json", "application/vnd.payment-v1-hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "basic_auth" };

        ParameterizedTypeReference<PageableNestedResourcePropertyEntityModel> localVarReturnType = new ParameterizedTypeReference<PageableNestedResourcePropertyEntityModel>() {};
        return apiClient.invokeAPI("/api/services/channelmanager/secured/property/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Properties
     * The properties endpoint provides the entry point into the listener and is used to list properties you have access to.
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param page Page through all properties owned by your account
     * @param size Limit results of records per page
     * @param accept The accept parameter
     * @return PageableNestedResourcePropertyEntityModel
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageableNestedResourcePropertyEntityModel> showProperties(Integer page, Integer size, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageableNestedResourcePropertyEntityModel> localVarReturnType = new ParameterizedTypeReference<PageableNestedResourcePropertyEntityModel>() {};
        return showPropertiesRequestCreation(page, size, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<PageableNestedResourcePropertyEntityModel>> showPropertiesWithHttpInfo(Integer page, Integer size, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageableNestedResourcePropertyEntityModel> localVarReturnType = new ParameterizedTypeReference<PageableNestedResourcePropertyEntityModel>() {};
        return showPropertiesRequestCreation(page, size, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Property
     * Retrieves property record for identifier.
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param propertyIdentifier Retrieve record for this propertyIdentifier
     * @param accept The accept parameter
     * @return PropertyWithRoomRateNestedResourcePropertyRoomRateEntityModel
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showPropertyRequestCreation(String propertyIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showProperty", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json", "application/vnd.payment-v1-hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "basic_auth" };

        ParameterizedTypeReference<PropertyWithRoomRateNestedResourcePropertyRoomRateEntityModel> localVarReturnType = new ParameterizedTypeReference<PropertyWithRoomRateNestedResourcePropertyRoomRateEntityModel>() {};
        return apiClient.invokeAPI("/api/services/channelmanager/secured/property/{propertyIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Property
     * Retrieves property record for identifier.
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param propertyIdentifier Retrieve record for this propertyIdentifier
     * @param accept The accept parameter
     * @return PropertyWithRoomRateNestedResourcePropertyRoomRateEntityModel
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PropertyWithRoomRateNestedResourcePropertyRoomRateEntityModel> showProperty(String propertyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyWithRoomRateNestedResourcePropertyRoomRateEntityModel> localVarReturnType = new ParameterizedTypeReference<PropertyWithRoomRateNestedResourcePropertyRoomRateEntityModel>() {};
        return showPropertyRequestCreation(propertyIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<PropertyWithRoomRateNestedResourcePropertyRoomRateEntityModel>> showPropertyWithHttpInfo(String propertyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyWithRoomRateNestedResourcePropertyRoomRateEntityModel> localVarReturnType = new ParameterizedTypeReference<PropertyWithRoomRateNestedResourcePropertyRoomRateEntityModel>() {};
        return showPropertyRequestCreation(propertyIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Booking
     * Retrieves a specific booking by property / booking combo.
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param propertyIdentifier Retrieve record owned by propertyIdentifier
     * @param bookingIdentifier Retrieve record for this bookingIdentifier
     * @param accept The accept parameter
     * @return PropertyBookingEntityModel
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showPropertyBookingRequestCreation(String propertyIdentifier, String bookingIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showPropertyBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'bookingIdentifier' is set
        if (bookingIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingIdentifier' when calling showPropertyBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("bookingIdentifier", bookingIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json", "application/vnd.payment-v1-hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "basic_auth" };

        ParameterizedTypeReference<PropertyBookingEntityModel> localVarReturnType = new ParameterizedTypeReference<PropertyBookingEntityModel>() {};
        return apiClient.invokeAPI("/api/services/channelmanager/secured/property/{propertyIdentifier}/booking/{bookingIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Booking
     * Retrieves a specific booking by property / booking combo.
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param propertyIdentifier Retrieve record owned by propertyIdentifier
     * @param bookingIdentifier Retrieve record for this bookingIdentifier
     * @param accept The accept parameter
     * @return PropertyBookingEntityModel
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PropertyBookingEntityModel> showPropertyBooking(String propertyIdentifier, String bookingIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyBookingEntityModel> localVarReturnType = new ParameterizedTypeReference<PropertyBookingEntityModel>() {};
        return showPropertyBookingRequestCreation(propertyIdentifier, bookingIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<PropertyBookingEntityModel>> showPropertyBookingWithHttpInfo(String propertyIdentifier, String bookingIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyBookingEntityModel> localVarReturnType = new ParameterizedTypeReference<PropertyBookingEntityModel>() {};
        return showPropertyBookingRequestCreation(propertyIdentifier, bookingIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Bookings
     * Retrieves a list of all bookings created for the specified property within the specified date range.
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param propertyIdentifier Retrieve record owned by this propertyIdentifier
     * @param startDate Limit results on date range starting with
     * @param endDate Limit results on date range ending with
     * @param accept The accept parameter
     * @return PropertyBookingsWithBookingNestedEntityModelPropertyBookingEntityModel
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showPropertyBookingsRequestCreation(String propertyIdentifier, OffsetDateTime startDate, OffsetDateTime endDate, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showPropertyBookings", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'startDate' is set
        if (startDate == null) {
            throw new WebClientResponseException("Missing the required parameter 'startDate' when calling showPropertyBookings", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "startDate", startDate));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "endDate", endDate));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json", "application/vnd.payment-v1-hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "basic_auth" };

        ParameterizedTypeReference<PropertyBookingsWithBookingNestedEntityModelPropertyBookingEntityModel> localVarReturnType = new ParameterizedTypeReference<PropertyBookingsWithBookingNestedEntityModelPropertyBookingEntityModel>() {};
        return apiClient.invokeAPI("/api/services/channelmanager/secured/property/{propertyIdentifier}/booking/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Bookings
     * Retrieves a list of all bookings created for the specified property within the specified date range.
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param propertyIdentifier Retrieve record owned by this propertyIdentifier
     * @param startDate Limit results on date range starting with
     * @param endDate Limit results on date range ending with
     * @param accept The accept parameter
     * @return PropertyBookingsWithBookingNestedEntityModelPropertyBookingEntityModel
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PropertyBookingsWithBookingNestedEntityModelPropertyBookingEntityModel> showPropertyBookings(String propertyIdentifier, OffsetDateTime startDate, OffsetDateTime endDate, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyBookingsWithBookingNestedEntityModelPropertyBookingEntityModel> localVarReturnType = new ParameterizedTypeReference<PropertyBookingsWithBookingNestedEntityModelPropertyBookingEntityModel>() {};
        return showPropertyBookingsRequestCreation(propertyIdentifier, startDate, endDate, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<PropertyBookingsWithBookingNestedEntityModelPropertyBookingEntityModel>> showPropertyBookingsWithHttpInfo(String propertyIdentifier, OffsetDateTime startDate, OffsetDateTime endDate, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyBookingsWithBookingNestedEntityModelPropertyBookingEntityModel> localVarReturnType = new ParameterizedTypeReference<PropertyBookingsWithBookingNestedEntityModelPropertyBookingEntityModel>() {};
        return showPropertyBookingsRequestCreation(propertyIdentifier, startDate, endDate, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Daily Rate
     * Retrieves a single daily rate for property / master rate / daily rate identifier combo.
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param propertyIdentifier Retrieve record owned by this propertyIdentifier
     * @param masterRateIdentifier Retrieve record owned by this masterRateIdentifier
     * @param rateIdentifier Retrieve rate for this rateIdentifier
     * @param accept The accept parameter
     * @return PropertyRateEntityModel
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showPropertyRoomRateRequestCreation(String propertyIdentifier, String masterRateIdentifier, String rateIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showPropertyRoomRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'masterRateIdentifier' is set
        if (masterRateIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'masterRateIdentifier' when calling showPropertyRoomRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'rateIdentifier' is set
        if (rateIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'rateIdentifier' when calling showPropertyRoomRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("masterRateIdentifier", masterRateIdentifier);
        pathParams.put("rateIdentifier", rateIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json", "application/vnd.payment-v1-hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "basic_auth" };

        ParameterizedTypeReference<PropertyRateEntityModel> localVarReturnType = new ParameterizedTypeReference<PropertyRateEntityModel>() {};
        return apiClient.invokeAPI("/api/services/channelmanager/secured/property/{propertyIdentifier}/roomrate/{masterRateIdentifier}/rate/{rateIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Daily Rate
     * Retrieves a single daily rate for property / master rate / daily rate identifier combo.
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param propertyIdentifier Retrieve record owned by this propertyIdentifier
     * @param masterRateIdentifier Retrieve record owned by this masterRateIdentifier
     * @param rateIdentifier Retrieve rate for this rateIdentifier
     * @param accept The accept parameter
     * @return PropertyRateEntityModel
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PropertyRateEntityModel> showPropertyRoomRate(String propertyIdentifier, String masterRateIdentifier, String rateIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyRateEntityModel> localVarReturnType = new ParameterizedTypeReference<PropertyRateEntityModel>() {};
        return showPropertyRoomRateRequestCreation(propertyIdentifier, masterRateIdentifier, rateIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<PropertyRateEntityModel>> showPropertyRoomRateWithHttpInfo(String propertyIdentifier, String masterRateIdentifier, String rateIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyRateEntityModel> localVarReturnType = new ParameterizedTypeReference<PropertyRateEntityModel>() {};
        return showPropertyRoomRateRequestCreation(propertyIdentifier, masterRateIdentifier, rateIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Daily Rates
     * Retrieves all daily rates for for property / master rate combo and a date range.
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param propertyIdentifier Retrieve record owned by this propertyIdentifier
     * @param masterRateIdentifier Retrieve record owned by this masterRateIdentifier
     * @param startDate Limit results on date range starting with
     * @param endDate Limit results on date range ending with
     * @param accept The accept parameter
     * @return PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showPropertyRoomRatesRequestCreation(String propertyIdentifier, String masterRateIdentifier, LocalDate startDate, LocalDate endDate, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showPropertyRoomRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'masterRateIdentifier' is set
        if (masterRateIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'masterRateIdentifier' when calling showPropertyRoomRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'startDate' is set
        if (startDate == null) {
            throw new WebClientResponseException("Missing the required parameter 'startDate' when calling showPropertyRoomRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'endDate' is set
        if (endDate == null) {
            throw new WebClientResponseException("Missing the required parameter 'endDate' when calling showPropertyRoomRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("masterRateIdentifier", masterRateIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "startDate", startDate));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "endDate", endDate));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json", "application/vnd.payment-v1-hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "basic_auth" };

        ParameterizedTypeReference<PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel> localVarReturnType = new ParameterizedTypeReference<PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel>() {};
        return apiClient.invokeAPI("/api/services/channelmanager/secured/property/{propertyIdentifier}/roomrate/{masterRateIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Daily Rates
     * Retrieves all daily rates for for property / master rate combo and a date range.
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param propertyIdentifier Retrieve record owned by this propertyIdentifier
     * @param masterRateIdentifier Retrieve record owned by this masterRateIdentifier
     * @param startDate Limit results on date range starting with
     * @param endDate Limit results on date range ending with
     * @param accept The accept parameter
     * @return PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel> showPropertyRoomRates(String propertyIdentifier, String masterRateIdentifier, LocalDate startDate, LocalDate endDate, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel> localVarReturnType = new ParameterizedTypeReference<PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel>() {};
        return showPropertyRoomRatesRequestCreation(propertyIdentifier, masterRateIdentifier, startDate, endDate, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel>> showPropertyRoomRatesWithHttpInfo(String propertyIdentifier, String masterRateIdentifier, LocalDate startDate, LocalDate endDate, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel> localVarReturnType = new ParameterizedTypeReference<PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel>() {};
        return showPropertyRoomRatesRequestCreation(propertyIdentifier, masterRateIdentifier, startDate, endDate, accept).toEntity(localVarReturnType);
    }
    /**
     * Update Daily Rates
     * Update daily rate / availability for a property / master rate combo.
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update rates owned by this propertyIdentifier
     * @param masterRateIdentifier Update rates owned by this masterRateIdentifier
     * @param propertyRateUpdateDto The propertyRateUpdateDto parameter
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateRatesRequestCreation(String propertyIdentifier, String masterRateIdentifier, PropertyRateUpdateDto propertyRateUpdateDto) throws WebClientResponseException {
        Object postBody = propertyRateUpdateDto;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling updateRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'masterRateIdentifier' is set
        if (masterRateIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'masterRateIdentifier' when calling updateRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'propertyRateUpdateDto' is set
        if (propertyRateUpdateDto == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyRateUpdateDto' when calling updateRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("masterRateIdentifier", masterRateIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/hal+json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "basic_auth" };

        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>() {};
        return apiClient.invokeAPI("/api/services/channelmanager/secured/property/{propertyIdentifier}/roomrate/{masterRateIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Daily Rates
     * Update daily rate / availability for a property / master rate combo.
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update rates owned by this propertyIdentifier
     * @param masterRateIdentifier Update rates owned by this masterRateIdentifier
     * @param propertyRateUpdateDto The propertyRateUpdateDto parameter
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Void> updateRates(String propertyIdentifier, String masterRateIdentifier, PropertyRateUpdateDto propertyRateUpdateDto) throws WebClientResponseException {
        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>() {};
        return updateRatesRequestCreation(propertyIdentifier, masterRateIdentifier, propertyRateUpdateDto).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<Void>> updateRatesWithHttpInfo(String propertyIdentifier, String masterRateIdentifier, PropertyRateUpdateDto propertyRateUpdateDto) throws WebClientResponseException {
        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>() {};
        return updateRatesRequestCreation(propertyIdentifier, masterRateIdentifier, propertyRateUpdateDto).toEntity(localVarReturnType);
    }
}
