/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](https://api.wink.travel/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](https://api.wink.travel/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](https://api.wink.travel/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Events](/docs?api=events): All APIs related to Integration events.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-06-28: v1 - Externalized channel manager API into its own API - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Channel Manager API Wink exposes a secured REST-based, HATEOAS enabled, JSON API to its channel manager partners. The connection is \"channel-wide\". Partners are free to integrate with the REST-based API using any programming language.  # Intended Audience This document is intended for external channel partners who wish to integrate with wink.  # Requirements - Active channel partner account with wink. - Account credentials: Username / Password that is sent with every request in the form of a HTTP Basic Auth header entry. - Send us a list of your IP numbers. They need to be whitelisted before you can use our production environment.  # Performance A particular attention to performance should be given when integrating with this API. A few things to be aware of:  # Hypermedia We use hypermedia and resources include links to other resources in their responses. Responses are in [Hypertext Application from resource to resource. Language (HAL) format](http://stateless.co/hal_specification.html). Links can be found beneath the _links key. Users of the API should not create URIs themselves, instead they should use the above-described links to navigate. - Enable gzip compression to make payloads smaller. - Fewer large REST calls are preferred to many small ones. E.g. It is better to update many dates instead of individual dates. - It is possible to update both rate and availability in unison.. - Request only date ranges that you will use. There is no need to request an entire year if you will only be working with the first seven days.  ## Reservation notification (PUSH) Wink supports PUSH notifications to communicate reservations. We support BASIC AUTH to your endpoint. If you want to enable PUSH, please get in touch with us at developer@wink.travel once certification is approved.
 *
 * The version of the OpenAPI document: 21.8.1-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.channel.manager.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import travel.wink.sdk.channel.manager.model.Link;
import travel.wink.sdk.channel.manager.model.Moneys;
import travel.wink.sdk.channel.manager.model.PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModelEmbedded;
import travel.wink.sdk.channel.manager.model.VariableCharge;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel
 */
@JsonPropertyOrder({
  PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel.JSON_PROPERTY_EMBEDDED,
  PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel.JSON_PROPERTY_LINKS,
  PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel.JSON_PROPERTY_IDENTIFIER,
  PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel.JSON_PROPERTY_PROPERTY_IDENTIFIER,
  PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel.JSON_PROPERTY_NAME,
  PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel.JSON_PROPERTY_GUEST_ROOM_IDENTIFIER,
  PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel.JSON_PROPERTY_RATE_PLAN_IDENTIFIER,
  PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel.JSON_PROPERTY_GUEST_ROOM_NAME,
  PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel.JSON_PROPERTY_RATE_PLAN_NAME,
  PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel.JSON_PROPERTY_MIN_OCCUPANCY,
  PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel.JSON_PROPERTY_MAX_OCCUPANCY,
  PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel.JSON_PROPERTY_MAX_ADULT_OCCUPANCY,
  PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel.JSON_PROPERTY_MAX_CHILD_OCCUPANCY,
  PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel.JSON_PROPERTY_INCLUDED_ADULT_OCCUPANCY,
  PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel.JSON_PROPERTY_INCLUDED_CHILD_OCCUPANCY,
  PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel.JSON_PROPERTY_BASE_RATE,
  PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel.JSON_PROPERTY_SINGLE_OCCUPANCY_RATE_MODIFIER,
  PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel.JSON_PROPERTY_EXTRA_PAX_RATE_MODIFIER,
  PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel.JSON_PROPERTY_EXTRA_CHILD_RATE_MODIFIER
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-16T13:27:27.669738+07:00[Asia/Bangkok]")
public class PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel {
  public static final String JSON_PROPERTY_EMBEDDED = "_embedded";
  private PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModelEmbedded embedded;

  public static final String JSON_PROPERTY_LINKS = "_links";
  private Map<String, Link> links = null;

  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private String identifier;

  public static final String JSON_PROPERTY_PROPERTY_IDENTIFIER = "propertyIdentifier";
  private String propertyIdentifier;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_GUEST_ROOM_IDENTIFIER = "guestRoomIdentifier";
  private String guestRoomIdentifier;

  public static final String JSON_PROPERTY_RATE_PLAN_IDENTIFIER = "ratePlanIdentifier";
  private String ratePlanIdentifier;

  public static final String JSON_PROPERTY_GUEST_ROOM_NAME = "guestRoomName";
  private String guestRoomName;

  public static final String JSON_PROPERTY_RATE_PLAN_NAME = "ratePlanName";
  private String ratePlanName;

  public static final String JSON_PROPERTY_MIN_OCCUPANCY = "minOccupancy";
  private Integer minOccupancy;

  public static final String JSON_PROPERTY_MAX_OCCUPANCY = "maxOccupancy";
  private Integer maxOccupancy;

  public static final String JSON_PROPERTY_MAX_ADULT_OCCUPANCY = "maxAdultOccupancy";
  private Integer maxAdultOccupancy;

  public static final String JSON_PROPERTY_MAX_CHILD_OCCUPANCY = "maxChildOccupancy";
  private Integer maxChildOccupancy;

  public static final String JSON_PROPERTY_INCLUDED_ADULT_OCCUPANCY = "includedAdultOccupancy";
  private Integer includedAdultOccupancy;

  public static final String JSON_PROPERTY_INCLUDED_CHILD_OCCUPANCY = "includedChildOccupancy";
  private Integer includedChildOccupancy;

  public static final String JSON_PROPERTY_BASE_RATE = "baseRate";
  private Moneys baseRate;

  public static final String JSON_PROPERTY_SINGLE_OCCUPANCY_RATE_MODIFIER = "singleOccupancyRateModifier";
  private VariableCharge singleOccupancyRateModifier;

  public static final String JSON_PROPERTY_EXTRA_PAX_RATE_MODIFIER = "extraPaxRateModifier";
  private VariableCharge extraPaxRateModifier;

  public static final String JSON_PROPERTY_EXTRA_CHILD_RATE_MODIFIER = "extraChildRateModifier";
  private VariableCharge extraChildRateModifier;

  public PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel() { 
  }

  public PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel embedded(PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModelEmbedded embedded) {
    
    this.embedded = embedded;
    return this;
  }

   /**
   * Get embedded
   * @return embedded
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_EMBEDDED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModelEmbedded getEmbedded() {
    return embedded;
  }


  @JsonProperty(JSON_PROPERTY_EMBEDDED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEmbedded(PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModelEmbedded embedded) {
    this.embedded = embedded;
  }


  public PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel links(Map<String, Link> links) {
    
    this.links = links;
    return this;
  }

  public PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel putLinksItem(String key, Link linksItem) {
    if (this.links == null) {
      this.links = new HashMap<>();
    }
    this.links.put(key, linksItem);
    return this;
  }

   /**
   * Get links
   * @return links
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Link> getLinks() {
    return links;
  }


  @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLinks(Map<String, Link> links) {
    this.links = links;
  }


  public PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel identifier(String identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Get identifier
   * @return identifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(String identifier) {
    this.identifier = identifier;
  }


  public PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel propertyIdentifier(String propertyIdentifier) {
    
    this.propertyIdentifier = propertyIdentifier;
    return this;
  }

   /**
   * Get propertyIdentifier
   * @return propertyIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getPropertyIdentifier() {
    return propertyIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPropertyIdentifier(String propertyIdentifier) {
    this.propertyIdentifier = propertyIdentifier;
  }


  public PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel guestRoomIdentifier(String guestRoomIdentifier) {
    
    this.guestRoomIdentifier = guestRoomIdentifier;
    return this;
  }

   /**
   * Get guestRoomIdentifier
   * @return guestRoomIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_GUEST_ROOM_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getGuestRoomIdentifier() {
    return guestRoomIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_GUEST_ROOM_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setGuestRoomIdentifier(String guestRoomIdentifier) {
    this.guestRoomIdentifier = guestRoomIdentifier;
  }


  public PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel ratePlanIdentifier(String ratePlanIdentifier) {
    
    this.ratePlanIdentifier = ratePlanIdentifier;
    return this;
  }

   /**
   * Get ratePlanIdentifier
   * @return ratePlanIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_RATE_PLAN_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRatePlanIdentifier() {
    return ratePlanIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_RATE_PLAN_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRatePlanIdentifier(String ratePlanIdentifier) {
    this.ratePlanIdentifier = ratePlanIdentifier;
  }


  public PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel guestRoomName(String guestRoomName) {
    
    this.guestRoomName = guestRoomName;
    return this;
  }

   /**
   * Get guestRoomName
   * @return guestRoomName
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_GUEST_ROOM_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getGuestRoomName() {
    return guestRoomName;
  }


  @JsonProperty(JSON_PROPERTY_GUEST_ROOM_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setGuestRoomName(String guestRoomName) {
    this.guestRoomName = guestRoomName;
  }


  public PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel ratePlanName(String ratePlanName) {
    
    this.ratePlanName = ratePlanName;
    return this;
  }

   /**
   * Get ratePlanName
   * @return ratePlanName
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_RATE_PLAN_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRatePlanName() {
    return ratePlanName;
  }


  @JsonProperty(JSON_PROPERTY_RATE_PLAN_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRatePlanName(String ratePlanName) {
    this.ratePlanName = ratePlanName;
  }


  public PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel minOccupancy(Integer minOccupancy) {
    
    this.minOccupancy = minOccupancy;
    return this;
  }

   /**
   * Get minOccupancy
   * @return minOccupancy
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_MIN_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getMinOccupancy() {
    return minOccupancy;
  }


  @JsonProperty(JSON_PROPERTY_MIN_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMinOccupancy(Integer minOccupancy) {
    this.minOccupancy = minOccupancy;
  }


  public PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel maxOccupancy(Integer maxOccupancy) {
    
    this.maxOccupancy = maxOccupancy;
    return this;
  }

   /**
   * Get maxOccupancy
   * @return maxOccupancy
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_MAX_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getMaxOccupancy() {
    return maxOccupancy;
  }


  @JsonProperty(JSON_PROPERTY_MAX_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMaxOccupancy(Integer maxOccupancy) {
    this.maxOccupancy = maxOccupancy;
  }


  public PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel maxAdultOccupancy(Integer maxAdultOccupancy) {
    
    this.maxAdultOccupancy = maxAdultOccupancy;
    return this;
  }

   /**
   * Get maxAdultOccupancy
   * @return maxAdultOccupancy
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_MAX_ADULT_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getMaxAdultOccupancy() {
    return maxAdultOccupancy;
  }


  @JsonProperty(JSON_PROPERTY_MAX_ADULT_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMaxAdultOccupancy(Integer maxAdultOccupancy) {
    this.maxAdultOccupancy = maxAdultOccupancy;
  }


  public PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel maxChildOccupancy(Integer maxChildOccupancy) {
    
    this.maxChildOccupancy = maxChildOccupancy;
    return this;
  }

   /**
   * Get maxChildOccupancy
   * @return maxChildOccupancy
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_MAX_CHILD_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getMaxChildOccupancy() {
    return maxChildOccupancy;
  }


  @JsonProperty(JSON_PROPERTY_MAX_CHILD_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMaxChildOccupancy(Integer maxChildOccupancy) {
    this.maxChildOccupancy = maxChildOccupancy;
  }


  public PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel includedAdultOccupancy(Integer includedAdultOccupancy) {
    
    this.includedAdultOccupancy = includedAdultOccupancy;
    return this;
  }

   /**
   * Get includedAdultOccupancy
   * @return includedAdultOccupancy
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_INCLUDED_ADULT_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getIncludedAdultOccupancy() {
    return includedAdultOccupancy;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDED_ADULT_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIncludedAdultOccupancy(Integer includedAdultOccupancy) {
    this.includedAdultOccupancy = includedAdultOccupancy;
  }


  public PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel includedChildOccupancy(Integer includedChildOccupancy) {
    
    this.includedChildOccupancy = includedChildOccupancy;
    return this;
  }

   /**
   * Get includedChildOccupancy
   * @return includedChildOccupancy
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_INCLUDED_CHILD_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getIncludedChildOccupancy() {
    return includedChildOccupancy;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDED_CHILD_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIncludedChildOccupancy(Integer includedChildOccupancy) {
    this.includedChildOccupancy = includedChildOccupancy;
  }


  public PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel baseRate(Moneys baseRate) {
    
    this.baseRate = baseRate;
    return this;
  }

   /**
   * Get baseRate
   * @return baseRate
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_BASE_RATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Moneys getBaseRate() {
    return baseRate;
  }


  @JsonProperty(JSON_PROPERTY_BASE_RATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBaseRate(Moneys baseRate) {
    this.baseRate = baseRate;
  }


  public PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel singleOccupancyRateModifier(VariableCharge singleOccupancyRateModifier) {
    
    this.singleOccupancyRateModifier = singleOccupancyRateModifier;
    return this;
  }

   /**
   * Get singleOccupancyRateModifier
   * @return singleOccupancyRateModifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_SINGLE_OCCUPANCY_RATE_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public VariableCharge getSingleOccupancyRateModifier() {
    return singleOccupancyRateModifier;
  }


  @JsonProperty(JSON_PROPERTY_SINGLE_OCCUPANCY_RATE_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSingleOccupancyRateModifier(VariableCharge singleOccupancyRateModifier) {
    this.singleOccupancyRateModifier = singleOccupancyRateModifier;
  }


  public PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel extraPaxRateModifier(VariableCharge extraPaxRateModifier) {
    
    this.extraPaxRateModifier = extraPaxRateModifier;
    return this;
  }

   /**
   * Get extraPaxRateModifier
   * @return extraPaxRateModifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_EXTRA_PAX_RATE_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public VariableCharge getExtraPaxRateModifier() {
    return extraPaxRateModifier;
  }


  @JsonProperty(JSON_PROPERTY_EXTRA_PAX_RATE_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setExtraPaxRateModifier(VariableCharge extraPaxRateModifier) {
    this.extraPaxRateModifier = extraPaxRateModifier;
  }


  public PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel extraChildRateModifier(VariableCharge extraChildRateModifier) {
    
    this.extraChildRateModifier = extraChildRateModifier;
    return this;
  }

   /**
   * Get extraChildRateModifier
   * @return extraChildRateModifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_EXTRA_CHILD_RATE_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public VariableCharge getExtraChildRateModifier() {
    return extraChildRateModifier;
  }


  @JsonProperty(JSON_PROPERTY_EXTRA_CHILD_RATE_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setExtraChildRateModifier(VariableCharge extraChildRateModifier) {
    this.extraChildRateModifier = extraChildRateModifier;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel propertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel = (PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel) o;
    return Objects.equals(this.embedded, propertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel.embedded) &&
        Objects.equals(this.links, propertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel.links) &&
        Objects.equals(this.identifier, propertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel.identifier) &&
        Objects.equals(this.propertyIdentifier, propertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel.propertyIdentifier) &&
        Objects.equals(this.name, propertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel.name) &&
        Objects.equals(this.guestRoomIdentifier, propertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel.guestRoomIdentifier) &&
        Objects.equals(this.ratePlanIdentifier, propertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel.ratePlanIdentifier) &&
        Objects.equals(this.guestRoomName, propertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel.guestRoomName) &&
        Objects.equals(this.ratePlanName, propertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel.ratePlanName) &&
        Objects.equals(this.minOccupancy, propertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel.minOccupancy) &&
        Objects.equals(this.maxOccupancy, propertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel.maxOccupancy) &&
        Objects.equals(this.maxAdultOccupancy, propertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel.maxAdultOccupancy) &&
        Objects.equals(this.maxChildOccupancy, propertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel.maxChildOccupancy) &&
        Objects.equals(this.includedAdultOccupancy, propertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel.includedAdultOccupancy) &&
        Objects.equals(this.includedChildOccupancy, propertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel.includedChildOccupancy) &&
        Objects.equals(this.baseRate, propertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel.baseRate) &&
        Objects.equals(this.singleOccupancyRateModifier, propertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel.singleOccupancyRateModifier) &&
        Objects.equals(this.extraPaxRateModifier, propertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel.extraPaxRateModifier) &&
        Objects.equals(this.extraChildRateModifier, propertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel.extraChildRateModifier);
  }

  @Override
  public int hashCode() {
    return Objects.hash(embedded, links, identifier, propertyIdentifier, name, guestRoomIdentifier, ratePlanIdentifier, guestRoomName, ratePlanName, minOccupancy, maxOccupancy, maxAdultOccupancy, maxChildOccupancy, includedAdultOccupancy, includedChildOccupancy, baseRate, singleOccupancyRateModifier, extraPaxRateModifier, extraChildRateModifier);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PropertyRoomRateWithRateNestedEntityModelPropertyRateEntityModel {\n");
    sb.append("    embedded: ").append(toIndentedString(embedded)).append("\n");
    sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    propertyIdentifier: ").append(toIndentedString(propertyIdentifier)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    guestRoomIdentifier: ").append(toIndentedString(guestRoomIdentifier)).append("\n");
    sb.append("    ratePlanIdentifier: ").append(toIndentedString(ratePlanIdentifier)).append("\n");
    sb.append("    guestRoomName: ").append(toIndentedString(guestRoomName)).append("\n");
    sb.append("    ratePlanName: ").append(toIndentedString(ratePlanName)).append("\n");
    sb.append("    minOccupancy: ").append(toIndentedString(minOccupancy)).append("\n");
    sb.append("    maxOccupancy: ").append(toIndentedString(maxOccupancy)).append("\n");
    sb.append("    maxAdultOccupancy: ").append(toIndentedString(maxAdultOccupancy)).append("\n");
    sb.append("    maxChildOccupancy: ").append(toIndentedString(maxChildOccupancy)).append("\n");
    sb.append("    includedAdultOccupancy: ").append(toIndentedString(includedAdultOccupancy)).append("\n");
    sb.append("    includedChildOccupancy: ").append(toIndentedString(includedChildOccupancy)).append("\n");
    sb.append("    baseRate: ").append(toIndentedString(baseRate)).append("\n");
    sb.append("    singleOccupancyRateModifier: ").append(toIndentedString(singleOccupancyRateModifier)).append("\n");
    sb.append("    extraPaxRateModifier: ").append(toIndentedString(extraPaxRateModifier)).append("\n");
    sb.append("    extraChildRateModifier: ").append(toIndentedString(extraChildRateModifier)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

