/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-10-15: v2 - Removed HATEOAS and added Wink-Version header - 2022-06-28: v1 - Externalized channel manager API into its own API - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Channel Manager API Wink exposes a secured REST-based, HATEOAS enabled, JSON API to its channel manager partners. The connection is \"channel-wide\". Partners are free to integrate with the REST-based API using any programming language.  # Intended Audience This document is intended for external channel partners who wish to integrate with wink.  # Requirements - Active channel partner account with wink. - Account credentials: Username / Password that is sent with every request in the form of a HTTP Basic Auth header entry. - Send us a list of your IP numbers. They need to be whitelisted before you can use our production environment.  # Performance A particular attention to performance should be given when integrating with this API. A few things to be aware of:  # Hypermedia We use hypermedia and resources include links to other resources in their responses. Responses are in [Hypertext Application from resource to resource. Language (HAL) format](http://stateless.co/hal_specification.html). Links can be found beneath the _links key. Users of the API should not create URIs themselves, instead they should use the above-described links to navigate. - Enable gzip compression to make payloads smaller. - Fewer large REST calls are preferred to many small ones. E.g. It is better to update many dates instead of individual dates. - It is possible to update both rate and availability in unison.. - Request only date ranges that you will use. There is no need to request an entire year if you will only be working with the first seven days.  ## Reservation notification (PUSH) Wink supports PUSH notifications to communicate reservations. We support BASIC AUTH to your endpoint. If you want to enable PUSH, please get in touch with us at developer@wink.travel once certification is approved.
 *
 * The version of the OpenAPI document: 22.0.1
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.channel.manager.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * PingResponse
 */
@JsonPropertyOrder({
  PingResponse.JSON_PROPERTY_API_VERSION,
  PingResponse.JSON_PROPERTY_PRINCIPAL,
  PingResponse.JSON_PROPERTY_NAME,
  PingResponse.JSON_PROPERTY_USERNAME,
  PingResponse.JSON_PROPERTY_PASSWORD,
  PingResponse.JSON_PROPERTY_ENABLED,
  PingResponse.JSON_PROPERTY_PUSH_BOOKINGS,
  PingResponse.JSON_PROPERTY_NOTIFICATION_URL,
  PingResponse.JSON_PROPERTY_NOTIFICATION_USERNAME,
  PingResponse.JSON_PROPERTY_NOTIFICATION_PASSWORD
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-10-18T16:40:01.906841408+07:00[Asia/Bangkok]")
public class PingResponse {
  public static final String JSON_PROPERTY_API_VERSION = "apiVersion";
  private String apiVersion;

  public static final String JSON_PROPERTY_PRINCIPAL = "principal";
  private String principal;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_USERNAME = "username";
  private String username;

  public static final String JSON_PROPERTY_PASSWORD = "password";
  private String password;

  public static final String JSON_PROPERTY_ENABLED = "enabled";
  private Boolean enabled;

  public static final String JSON_PROPERTY_PUSH_BOOKINGS = "pushBookings";
  private Boolean pushBookings;

  public static final String JSON_PROPERTY_NOTIFICATION_URL = "notificationUrl";
  private String notificationUrl;

  public static final String JSON_PROPERTY_NOTIFICATION_USERNAME = "notificationUsername";
  private String notificationUsername;

  public static final String JSON_PROPERTY_NOTIFICATION_PASSWORD = "notificationPassword";
  private String notificationPassword;

  public PingResponse() { 
  }

  public PingResponse apiVersion(String apiVersion) {
    
    this.apiVersion = apiVersion;
    return this;
  }

   /**
   * Get apiVersion
   * @return apiVersion
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_API_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getApiVersion() {
    return apiVersion;
  }


  @JsonProperty(JSON_PROPERTY_API_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setApiVersion(String apiVersion) {
    this.apiVersion = apiVersion;
  }


  public PingResponse principal(String principal) {
    
    this.principal = principal;
    return this;
  }

   /**
   * Get principal
   * @return principal
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PRINCIPAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPrincipal() {
    return principal;
  }


  @JsonProperty(JSON_PROPERTY_PRINCIPAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrincipal(String principal) {
    this.principal = principal;
  }


  public PingResponse name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }


  public PingResponse username(String username) {
    
    this.username = username;
    return this;
  }

   /**
   * Get username
   * @return username
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_USERNAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUsername() {
    return username;
  }


  @JsonProperty(JSON_PROPERTY_USERNAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUsername(String username) {
    this.username = username;
  }


  public PingResponse password(String password) {
    
    this.password = password;
    return this;
  }

   /**
   * Get password
   * @return password
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PASSWORD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPassword() {
    return password;
  }


  @JsonProperty(JSON_PROPERTY_PASSWORD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPassword(String password) {
    this.password = password;
  }


  public PingResponse enabled(Boolean enabled) {
    
    this.enabled = enabled;
    return this;
  }

   /**
   * Get enabled
   * @return enabled
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getEnabled() {
    return enabled;
  }


  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEnabled(Boolean enabled) {
    this.enabled = enabled;
  }


  public PingResponse pushBookings(Boolean pushBookings) {
    
    this.pushBookings = pushBookings;
    return this;
  }

   /**
   * Get pushBookings
   * @return pushBookings
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PUSH_BOOKINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getPushBookings() {
    return pushBookings;
  }


  @JsonProperty(JSON_PROPERTY_PUSH_BOOKINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPushBookings(Boolean pushBookings) {
    this.pushBookings = pushBookings;
  }


  public PingResponse notificationUrl(String notificationUrl) {
    
    this.notificationUrl = notificationUrl;
    return this;
  }

   /**
   * Get notificationUrl
   * @return notificationUrl
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_NOTIFICATION_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getNotificationUrl() {
    return notificationUrl;
  }


  @JsonProperty(JSON_PROPERTY_NOTIFICATION_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNotificationUrl(String notificationUrl) {
    this.notificationUrl = notificationUrl;
  }


  public PingResponse notificationUsername(String notificationUsername) {
    
    this.notificationUsername = notificationUsername;
    return this;
  }

   /**
   * Get notificationUsername
   * @return notificationUsername
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_NOTIFICATION_USERNAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getNotificationUsername() {
    return notificationUsername;
  }


  @JsonProperty(JSON_PROPERTY_NOTIFICATION_USERNAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNotificationUsername(String notificationUsername) {
    this.notificationUsername = notificationUsername;
  }


  public PingResponse notificationPassword(String notificationPassword) {
    
    this.notificationPassword = notificationPassword;
    return this;
  }

   /**
   * Get notificationPassword
   * @return notificationPassword
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_NOTIFICATION_PASSWORD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getNotificationPassword() {
    return notificationPassword;
  }


  @JsonProperty(JSON_PROPERTY_NOTIFICATION_PASSWORD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNotificationPassword(String notificationPassword) {
    this.notificationPassword = notificationPassword;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PingResponse pingResponse = (PingResponse) o;
    return Objects.equals(this.apiVersion, pingResponse.apiVersion) &&
        Objects.equals(this.principal, pingResponse.principal) &&
        Objects.equals(this.name, pingResponse.name) &&
        Objects.equals(this.username, pingResponse.username) &&
        Objects.equals(this.password, pingResponse.password) &&
        Objects.equals(this.enabled, pingResponse.enabled) &&
        Objects.equals(this.pushBookings, pingResponse.pushBookings) &&
        Objects.equals(this.notificationUrl, pingResponse.notificationUrl) &&
        Objects.equals(this.notificationUsername, pingResponse.notificationUsername) &&
        Objects.equals(this.notificationPassword, pingResponse.notificationPassword);
  }

  @Override
  public int hashCode() {
    return Objects.hash(apiVersion, principal, name, username, password, enabled, pushBookings, notificationUrl, notificationUsername, notificationPassword);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PingResponse {\n");
    sb.append("    apiVersion: ").append(toIndentedString(apiVersion)).append("\n");
    sb.append("    principal: ").append(toIndentedString(principal)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    username: ").append(toIndentedString(username)).append("\n");
    sb.append("    password: ").append(toIndentedString(password)).append("\n");
    sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
    sb.append("    pushBookings: ").append(toIndentedString(pushBookings)).append("\n");
    sb.append("    notificationUrl: ").append(toIndentedString(notificationUrl)).append("\n");
    sb.append("    notificationUsername: ").append(toIndentedString(notificationUsername)).append("\n");
    sb.append("    notificationPassword: ").append(toIndentedString(notificationPassword)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

