/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-06-28: v1 - Externalized channel manager API into its own API - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Channel Manager API Wink exposes a secured REST-based, JSON API to its channel manager partners. The connection is \"channel-wide\". Partners are free to integrate with the REST-based API using any programming language.  # Intended Audience This document is intended for external channel partners who wish to integrate with Wink.  # Requirements - Active account with Wink. Sign up for your Channel Manager account:    - Staging: [https://staging-sell.wink.travel](https://staging-sell.wink.travel).    - Production: [https://sell.wink.travel](https://sell.wink.travel). - Active application. An application provides you with Oauth2 credentials you can pass to our endpoints. One is already created for you upon account creation. - Your production IP numbers. They need to be whitelisted before you can talk to our production environment.  # Performance A particular attention to performance should be given when integrating with this API. A few things to be aware of: - Enable gzip compression to make payloads smaller. - Fewer large REST calls are preferred to many small ones. E.g. It is better to update many dates instead of individual dates. - It is possible to update both rate and availability with a single request. - Request only date ranges that you will use. There is no need to request an entire year if you will only be working with the first seven days.  ## Reservation notification (PUSH) Wink supports PUSH notifications to communicate reservations. We also support BASIC AUTH to your endpoint. If you want to enable PUSH, add your PUSH endpoint and credentials (optional) to your account.
 *
 * The version of the OpenAPI document: 23.1.1
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.channel.manager.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import travel.wink.sdk.channel.manager.model.PropertyRate;
import travel.wink.sdk.channel.manager.model.PropertyRoomRate;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * PropertyRoomRateWithRateList
 */
@JsonPropertyOrder({
  PropertyRoomRateWithRateList.JSON_PROPERTY_ROOM,
  PropertyRoomRateWithRateList.JSON_PROPERTY_RATES,
  PropertyRoomRateWithRateList.JSON_PROPERTY_START_DATE,
  PropertyRoomRateWithRateList.JSON_PROPERTY_END_DATE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-11-08T09:36:11.841744416+07:00[Asia/Bangkok]")
public class PropertyRoomRateWithRateList {
  public static final String JSON_PROPERTY_ROOM = "room";
  private PropertyRoomRate room;

  public static final String JSON_PROPERTY_RATES = "rates";
  private List<PropertyRate> rates = null;

  public static final String JSON_PROPERTY_START_DATE = "startDate";
  private LocalDate startDate;

  public static final String JSON_PROPERTY_END_DATE = "endDate";
  private LocalDate endDate;

  public PropertyRoomRateWithRateList() { 
  }

  public PropertyRoomRateWithRateList room(PropertyRoomRate room) {
    
    this.room = room;
    return this;
  }

   /**
   * Get room
   * @return room
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_ROOM)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PropertyRoomRate getRoom() {
    return room;
  }


  @JsonProperty(JSON_PROPERTY_ROOM)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoom(PropertyRoomRate room) {
    this.room = room;
  }


  public PropertyRoomRateWithRateList rates(List<PropertyRate> rates) {
    
    this.rates = rates;
    return this;
  }

  public PropertyRoomRateWithRateList addRatesItem(PropertyRate ratesItem) {
    if (this.rates == null) {
      this.rates = new ArrayList<>();
    }
    this.rates.add(ratesItem);
    return this;
  }

   /**
   * Get rates
   * @return rates
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_RATES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<PropertyRate> getRates() {
    return rates;
  }


  @JsonProperty(JSON_PROPERTY_RATES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRates(List<PropertyRate> rates) {
    this.rates = rates;
  }


  public PropertyRoomRateWithRateList startDate(LocalDate startDate) {
    
    this.startDate = startDate;
    return this;
  }

   /**
   * Get startDate
   * @return startDate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getStartDate() {
    return startDate;
  }


  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStartDate(LocalDate startDate) {
    this.startDate = startDate;
  }


  public PropertyRoomRateWithRateList endDate(LocalDate endDate) {
    
    this.endDate = endDate;
    return this;
  }

   /**
   * Get endDate
   * @return endDate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getEndDate() {
    return endDate;
  }


  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEndDate(LocalDate endDate) {
    this.endDate = endDate;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PropertyRoomRateWithRateList propertyRoomRateWithRateList = (PropertyRoomRateWithRateList) o;
    return Objects.equals(this.room, propertyRoomRateWithRateList.room) &&
        Objects.equals(this.rates, propertyRoomRateWithRateList.rates) &&
        Objects.equals(this.startDate, propertyRoomRateWithRateList.startDate) &&
        Objects.equals(this.endDate, propertyRoomRateWithRateList.endDate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(room, rates, startDate, endDate);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PropertyRoomRateWithRateList {\n");
    sb.append("    room: ").append(toIndentedString(room)).append("\n");
    sb.append("    rates: ").append(toIndentedString(rates)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

