/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md   # Channel Manager API Wink exposes a secured REST-based, JSON API to its channel manager partners. The connection is \"channel-wide\". Partners are free to integrate with the REST-based API using any programming language.  # Intended Audience This document is intended for external channel partners who wish to integrate with Wink.  # Requirements - Active account with Wink. Sign up for your Channel Manager account:    - Staging: [https://staging-studio.wink.travel](https://staging-studio.wink.travel).    - Production: [https://studio.wink.travel](https://studio.wink.travel). - Active application. An application provides you with Oauth2 credentials you can pass to our endpoints. One is already created for you upon account creation. - Your production IP numbers. They need to be whitelisted before you can talk to our production environment.  # Performance A particular attention to performance should be given when integrating with this API. A few things to be aware of: - Enable gzip compression to make payloads smaller. - Fewer large REST calls are preferred to many small ones. E.g. It is better to update many dates instead of individual dates. - It is possible to update both rate and availability with a single request. - Request only date ranges that you will use. There is no need to request an entire year if you will only be working with the first seven days.  ## Reservation notification (PUSH) Wink supports PUSH notifications to communicate reservations. We also support BASIC AUTH to your endpoint. If you want to enable PUSH, add your PUSH endpoint and credentials (optional) to your account.
 *
 * The version of the OpenAPI document: 30.9.11
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.channel.manager.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import java.time.LocalDate;
import travel.wink.sdk.channel.manager.model.VariableCharge;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * PropertyRateUpdateRequest
 */
@JsonPropertyOrder({
  PropertyRateUpdateRequest.JSON_PROPERTY_START_DATE,
  PropertyRateUpdateRequest.JSON_PROPERTY_END_DATE,
  PropertyRateUpdateRequest.JSON_PROPERTY_AMOUNT,
  PropertyRateUpdateRequest.JSON_PROPERTY_CURRENCY_CODE,
  PropertyRateUpdateRequest.JSON_PROPERTY_MASTER,
  PropertyRateUpdateRequest.JSON_PROPERTY_CLOSED_ON_ARRIVAL,
  PropertyRateUpdateRequest.JSON_PROPERTY_CLOSED_ON_DEPARTURE,
  PropertyRateUpdateRequest.JSON_PROPERTY_QUANTITY,
  PropertyRateUpdateRequest.JSON_PROPERTY_MIN_LENGTH_OF_STAY,
  PropertyRateUpdateRequest.JSON_PROPERTY_MAX_LENGTH_OF_STAY,
  PropertyRateUpdateRequest.JSON_PROPERTY_MIN_OCCUPANCY,
  PropertyRateUpdateRequest.JSON_PROPERTY_MAX_OCCUPANCY,
  PropertyRateUpdateRequest.JSON_PROPERTY_SINGLE_OCCUPANCY_RATE_MODIFIER,
  PropertyRateUpdateRequest.JSON_PROPERTY_EXTRA_PAX_RATE_MODIFIER,
  PropertyRateUpdateRequest.JSON_PROPERTY_EXTRA_CHILD_RATE_MODIFIER
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-12-27T09:36:09.753557866+07:00[Asia/Bangkok]")
public class PropertyRateUpdateRequest {
  public static final String JSON_PROPERTY_START_DATE = "startDate";
  private LocalDate startDate;

  public static final String JSON_PROPERTY_END_DATE = "endDate";
  private LocalDate endDate;

  public static final String JSON_PROPERTY_AMOUNT = "amount";
  private BigDecimal amount;

  public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
  private String currencyCode;

  public static final String JSON_PROPERTY_MASTER = "master";
  private Boolean master;

  public static final String JSON_PROPERTY_CLOSED_ON_ARRIVAL = "closedOnArrival";
  private Boolean closedOnArrival;

  public static final String JSON_PROPERTY_CLOSED_ON_DEPARTURE = "closedOnDeparture";
  private Boolean closedOnDeparture;

  public static final String JSON_PROPERTY_QUANTITY = "quantity";
  private Integer quantity;

  public static final String JSON_PROPERTY_MIN_LENGTH_OF_STAY = "minLengthOfStay";
  private Integer minLengthOfStay;

  public static final String JSON_PROPERTY_MAX_LENGTH_OF_STAY = "maxLengthOfStay";
  private Integer maxLengthOfStay;

  public static final String JSON_PROPERTY_MIN_OCCUPANCY = "minOccupancy";
  private Integer minOccupancy;

  public static final String JSON_PROPERTY_MAX_OCCUPANCY = "maxOccupancy";
  private Integer maxOccupancy;

  public static final String JSON_PROPERTY_SINGLE_OCCUPANCY_RATE_MODIFIER = "singleOccupancyRateModifier";
  private VariableCharge singleOccupancyRateModifier;

  public static final String JSON_PROPERTY_EXTRA_PAX_RATE_MODIFIER = "extraPaxRateModifier";
  private VariableCharge extraPaxRateModifier;

  public static final String JSON_PROPERTY_EXTRA_CHILD_RATE_MODIFIER = "extraChildRateModifier";
  private VariableCharge extraChildRateModifier;

  public PropertyRateUpdateRequest() {
  }

  public PropertyRateUpdateRequest startDate(LocalDate startDate) {
    
    this.startDate = startDate;
    return this;
  }

   /**
   * Get startDate
   * @return startDate
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LocalDate getStartDate() {
    return startDate;
  }


  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStartDate(LocalDate startDate) {
    this.startDate = startDate;
  }


  public PropertyRateUpdateRequest endDate(LocalDate endDate) {
    
    this.endDate = endDate;
    return this;
  }

   /**
   * Get endDate
   * @return endDate
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LocalDate getEndDate() {
    return endDate;
  }


  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEndDate(LocalDate endDate) {
    this.endDate = endDate;
  }


  public PropertyRateUpdateRequest amount(BigDecimal amount) {
    
    this.amount = amount;
    return this;
  }

   /**
   * Get amount
   * @return amount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getAmount() {
    return amount;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmount(BigDecimal amount) {
    this.amount = amount;
  }


  public PropertyRateUpdateRequest currencyCode(String currencyCode) {
    
    this.currencyCode = currencyCode;
    return this;
  }

   /**
   * Get currencyCode
   * @return currencyCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCurrencyCode() {
    return currencyCode;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrencyCode(String currencyCode) {
    this.currencyCode = currencyCode;
  }


  public PropertyRateUpdateRequest master(Boolean master) {
    
    this.master = master;
    return this;
  }

   /**
   * Get master
   * @return master
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MASTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getMaster() {
    return master;
  }


  @JsonProperty(JSON_PROPERTY_MASTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaster(Boolean master) {
    this.master = master;
  }


  public PropertyRateUpdateRequest closedOnArrival(Boolean closedOnArrival) {
    
    this.closedOnArrival = closedOnArrival;
    return this;
  }

   /**
   * Get closedOnArrival
   * @return closedOnArrival
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CLOSED_ON_ARRIVAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getClosedOnArrival() {
    return closedOnArrival;
  }


  @JsonProperty(JSON_PROPERTY_CLOSED_ON_ARRIVAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setClosedOnArrival(Boolean closedOnArrival) {
    this.closedOnArrival = closedOnArrival;
  }


  public PropertyRateUpdateRequest closedOnDeparture(Boolean closedOnDeparture) {
    
    this.closedOnDeparture = closedOnDeparture;
    return this;
  }

   /**
   * Get closedOnDeparture
   * @return closedOnDeparture
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CLOSED_ON_DEPARTURE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getClosedOnDeparture() {
    return closedOnDeparture;
  }


  @JsonProperty(JSON_PROPERTY_CLOSED_ON_DEPARTURE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setClosedOnDeparture(Boolean closedOnDeparture) {
    this.closedOnDeparture = closedOnDeparture;
  }


  public PropertyRateUpdateRequest quantity(Integer quantity) {
    
    this.quantity = quantity;
    return this;
  }

   /**
   * Get quantity
   * @return quantity
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getQuantity() {
    return quantity;
  }


  @JsonProperty(JSON_PROPERTY_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setQuantity(Integer quantity) {
    this.quantity = quantity;
  }


  public PropertyRateUpdateRequest minLengthOfStay(Integer minLengthOfStay) {
    
    this.minLengthOfStay = minLengthOfStay;
    return this;
  }

   /**
   * Get minLengthOfStay
   * @return minLengthOfStay
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MIN_LENGTH_OF_STAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMinLengthOfStay() {
    return minLengthOfStay;
  }


  @JsonProperty(JSON_PROPERTY_MIN_LENGTH_OF_STAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinLengthOfStay(Integer minLengthOfStay) {
    this.minLengthOfStay = minLengthOfStay;
  }


  public PropertyRateUpdateRequest maxLengthOfStay(Integer maxLengthOfStay) {
    
    this.maxLengthOfStay = maxLengthOfStay;
    return this;
  }

   /**
   * Get maxLengthOfStay
   * @return maxLengthOfStay
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MAX_LENGTH_OF_STAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMaxLengthOfStay() {
    return maxLengthOfStay;
  }


  @JsonProperty(JSON_PROPERTY_MAX_LENGTH_OF_STAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxLengthOfStay(Integer maxLengthOfStay) {
    this.maxLengthOfStay = maxLengthOfStay;
  }


  public PropertyRateUpdateRequest minOccupancy(Integer minOccupancy) {
    
    this.minOccupancy = minOccupancy;
    return this;
  }

   /**
   * Get minOccupancy
   * @return minOccupancy
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MIN_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMinOccupancy() {
    return minOccupancy;
  }


  @JsonProperty(JSON_PROPERTY_MIN_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinOccupancy(Integer minOccupancy) {
    this.minOccupancy = minOccupancy;
  }


  public PropertyRateUpdateRequest maxOccupancy(Integer maxOccupancy) {
    
    this.maxOccupancy = maxOccupancy;
    return this;
  }

   /**
   * Get maxOccupancy
   * @return maxOccupancy
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MAX_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMaxOccupancy() {
    return maxOccupancy;
  }


  @JsonProperty(JSON_PROPERTY_MAX_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxOccupancy(Integer maxOccupancy) {
    this.maxOccupancy = maxOccupancy;
  }


  public PropertyRateUpdateRequest singleOccupancyRateModifier(VariableCharge singleOccupancyRateModifier) {
    
    this.singleOccupancyRateModifier = singleOccupancyRateModifier;
    return this;
  }

   /**
   * Get singleOccupancyRateModifier
   * @return singleOccupancyRateModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SINGLE_OCCUPANCY_RATE_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public VariableCharge getSingleOccupancyRateModifier() {
    return singleOccupancyRateModifier;
  }


  @JsonProperty(JSON_PROPERTY_SINGLE_OCCUPANCY_RATE_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSingleOccupancyRateModifier(VariableCharge singleOccupancyRateModifier) {
    this.singleOccupancyRateModifier = singleOccupancyRateModifier;
  }


  public PropertyRateUpdateRequest extraPaxRateModifier(VariableCharge extraPaxRateModifier) {
    
    this.extraPaxRateModifier = extraPaxRateModifier;
    return this;
  }

   /**
   * Get extraPaxRateModifier
   * @return extraPaxRateModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_EXTRA_PAX_RATE_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public VariableCharge getExtraPaxRateModifier() {
    return extraPaxRateModifier;
  }


  @JsonProperty(JSON_PROPERTY_EXTRA_PAX_RATE_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExtraPaxRateModifier(VariableCharge extraPaxRateModifier) {
    this.extraPaxRateModifier = extraPaxRateModifier;
  }


  public PropertyRateUpdateRequest extraChildRateModifier(VariableCharge extraChildRateModifier) {
    
    this.extraChildRateModifier = extraChildRateModifier;
    return this;
  }

   /**
   * Get extraChildRateModifier
   * @return extraChildRateModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_EXTRA_CHILD_RATE_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public VariableCharge getExtraChildRateModifier() {
    return extraChildRateModifier;
  }


  @JsonProperty(JSON_PROPERTY_EXTRA_CHILD_RATE_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExtraChildRateModifier(VariableCharge extraChildRateModifier) {
    this.extraChildRateModifier = extraChildRateModifier;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PropertyRateUpdateRequest propertyRateUpdateRequest = (PropertyRateUpdateRequest) o;
    return Objects.equals(this.startDate, propertyRateUpdateRequest.startDate) &&
        Objects.equals(this.endDate, propertyRateUpdateRequest.endDate) &&
        Objects.equals(this.amount, propertyRateUpdateRequest.amount) &&
        Objects.equals(this.currencyCode, propertyRateUpdateRequest.currencyCode) &&
        Objects.equals(this.master, propertyRateUpdateRequest.master) &&
        Objects.equals(this.closedOnArrival, propertyRateUpdateRequest.closedOnArrival) &&
        Objects.equals(this.closedOnDeparture, propertyRateUpdateRequest.closedOnDeparture) &&
        Objects.equals(this.quantity, propertyRateUpdateRequest.quantity) &&
        Objects.equals(this.minLengthOfStay, propertyRateUpdateRequest.minLengthOfStay) &&
        Objects.equals(this.maxLengthOfStay, propertyRateUpdateRequest.maxLengthOfStay) &&
        Objects.equals(this.minOccupancy, propertyRateUpdateRequest.minOccupancy) &&
        Objects.equals(this.maxOccupancy, propertyRateUpdateRequest.maxOccupancy) &&
        Objects.equals(this.singleOccupancyRateModifier, propertyRateUpdateRequest.singleOccupancyRateModifier) &&
        Objects.equals(this.extraPaxRateModifier, propertyRateUpdateRequest.extraPaxRateModifier) &&
        Objects.equals(this.extraChildRateModifier, propertyRateUpdateRequest.extraChildRateModifier);
  }

  @Override
  public int hashCode() {
    return Objects.hash(startDate, endDate, amount, currencyCode, master, closedOnArrival, closedOnDeparture, quantity, minLengthOfStay, maxLengthOfStay, minOccupancy, maxOccupancy, singleOccupancyRateModifier, extraPaxRateModifier, extraChildRateModifier);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PropertyRateUpdateRequest {\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    currencyCode: ").append(toIndentedString(currencyCode)).append("\n");
    sb.append("    master: ").append(toIndentedString(master)).append("\n");
    sb.append("    closedOnArrival: ").append(toIndentedString(closedOnArrival)).append("\n");
    sb.append("    closedOnDeparture: ").append(toIndentedString(closedOnDeparture)).append("\n");
    sb.append("    quantity: ").append(toIndentedString(quantity)).append("\n");
    sb.append("    minLengthOfStay: ").append(toIndentedString(minLengthOfStay)).append("\n");
    sb.append("    maxLengthOfStay: ").append(toIndentedString(maxLengthOfStay)).append("\n");
    sb.append("    minOccupancy: ").append(toIndentedString(minOccupancy)).append("\n");
    sb.append("    maxOccupancy: ").append(toIndentedString(maxOccupancy)).append("\n");
    sb.append("    singleOccupancyRateModifier: ").append(toIndentedString(singleOccupancyRateModifier)).append("\n");
    sb.append("    extraPaxRateModifier: ").append(toIndentedString(extraPaxRateModifier)).append("\n");
    sb.append("    extraChildRateModifier: ").append(toIndentedString(extraChildRateModifier)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

