/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.channel.manager.api;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.channel.manager.invoker.ApiClient;
import travel.wink.sdk.channel.manager.model.PageProperty;
import travel.wink.sdk.channel.manager.model.PingResponse;
import travel.wink.sdk.channel.manager.model.PropertyBooking;
import travel.wink.sdk.channel.manager.model.PropertyRate;
import travel.wink.sdk.channel.manager.model.PropertyRateUpdateRequest;
import travel.wink.sdk.channel.manager.model.PropertyRoomRateWithRateList;
import travel.wink.sdk.channel.manager.model.PropertyWithRoomRateList;

public class ChannelManagerApi {
    private ApiClient apiClient;

    public ChannelManagerApi() {
        this(new ApiClient());
    }

    @Autowired
    public ChannelManagerApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec pingRequestCreation(String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "application/hal+json", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oAuth2ClientCredentials"};
        ParameterizedTypeReference<PingResponse> localVarReturnType = new ParameterizedTypeReference<PingResponse>(this){};
        return this.apiClient.invokeAPI("/api/channel-manager/ping", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PingResponse> ping(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PingResponse> localVarReturnType = new ParameterizedTypeReference<PingResponse>(this){};
        return this.pingRequestCreation(winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PingResponse>> pingWithHttpInfo(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PingResponse> localVarReturnType = new ParameterizedTypeReference<PingResponse>(this){};
        return this.pingRequestCreation(winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec pingWithResponseSpec(String winkVersion, String accept) throws WebClientResponseException {
        return this.pingRequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec showPropertiesRequestCreation(Integer page, Integer size, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "size", size));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "application/hal+json", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oAuth2ClientCredentials"};
        ParameterizedTypeReference<PageProperty> localVarReturnType = new ParameterizedTypeReference<PageProperty>(this){};
        return this.apiClient.invokeAPI("/api/channel-manager/property/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageProperty> showProperties(Integer page, Integer size, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageProperty> localVarReturnType = new ParameterizedTypeReference<PageProperty>(this){};
        return this.showPropertiesRequestCreation(page, size, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageProperty>> showPropertiesWithHttpInfo(Integer page, Integer size, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageProperty> localVarReturnType = new ParameterizedTypeReference<PageProperty>(this){};
        return this.showPropertiesRequestCreation(page, size, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showPropertiesWithResponseSpec(Integer page, Integer size, String winkVersion, String accept) throws WebClientResponseException {
        return this.showPropertiesRequestCreation(page, size, winkVersion, accept);
    }

    private WebClient.ResponseSpec showPropertyRequestCreation(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showProperty", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "application/hal+json", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oAuth2ClientCredentials"};
        ParameterizedTypeReference<PropertyWithRoomRateList> localVarReturnType = new ParameterizedTypeReference<PropertyWithRoomRateList>(this){};
        return this.apiClient.invokeAPI("/api/channel-manager/property/{propertyIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PropertyWithRoomRateList> showProperty(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyWithRoomRateList> localVarReturnType = new ParameterizedTypeReference<PropertyWithRoomRateList>(this){};
        return this.showPropertyRequestCreation(propertyIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PropertyWithRoomRateList>> showPropertyWithHttpInfo(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyWithRoomRateList> localVarReturnType = new ParameterizedTypeReference<PropertyWithRoomRateList>(this){};
        return this.showPropertyRequestCreation(propertyIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showPropertyWithResponseSpec(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showPropertyRequestCreation(propertyIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showPropertyBookingRequestCreation(String propertyIdentifier, String bookingIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showPropertyBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (bookingIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingIdentifier' when calling showPropertyBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("bookingIdentifier", bookingIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "application/hal+json", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oAuth2ClientCredentials"};
        ParameterizedTypeReference<PropertyBooking> localVarReturnType = new ParameterizedTypeReference<PropertyBooking>(this){};
        return this.apiClient.invokeAPI("/api/channel-manager/property/{propertyIdentifier}/booking/{bookingIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PropertyBooking> showPropertyBooking(String propertyIdentifier, String bookingIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyBooking> localVarReturnType = new ParameterizedTypeReference<PropertyBooking>(this){};
        return this.showPropertyBookingRequestCreation(propertyIdentifier, bookingIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PropertyBooking>> showPropertyBookingWithHttpInfo(String propertyIdentifier, String bookingIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyBooking> localVarReturnType = new ParameterizedTypeReference<PropertyBooking>(this){};
        return this.showPropertyBookingRequestCreation(propertyIdentifier, bookingIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showPropertyBookingWithResponseSpec(String propertyIdentifier, String bookingIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showPropertyBookingRequestCreation(propertyIdentifier, bookingIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showPropertyBookingsRequestCreation(String propertyIdentifier, LocalDateTime startDate, LocalDateTime endDate, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showPropertyBookings", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (startDate == null) {
            throw new WebClientResponseException("Missing the required parameter 'startDate' when calling showPropertyBookings", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "startDate", startDate));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "endDate", endDate));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "application/hal+json", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oAuth2ClientCredentials"};
        ParameterizedTypeReference<PropertyBooking> localVarReturnType = new ParameterizedTypeReference<PropertyBooking>(this){};
        return this.apiClient.invokeAPI("/api/channel-manager/property/{propertyIdentifier}/booking/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<PropertyBooking> showPropertyBookings(String propertyIdentifier, LocalDateTime startDate, LocalDateTime endDate, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyBooking> localVarReturnType = new ParameterizedTypeReference<PropertyBooking>(this){};
        return this.showPropertyBookingsRequestCreation(propertyIdentifier, startDate, endDate, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<PropertyBooking>>> showPropertyBookingsWithHttpInfo(String propertyIdentifier, LocalDateTime startDate, LocalDateTime endDate, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyBooking> localVarReturnType = new ParameterizedTypeReference<PropertyBooking>(this){};
        return this.showPropertyBookingsRequestCreation(propertyIdentifier, startDate, endDate, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showPropertyBookingsWithResponseSpec(String propertyIdentifier, LocalDateTime startDate, LocalDateTime endDate, String winkVersion, String accept) throws WebClientResponseException {
        return this.showPropertyBookingsRequestCreation(propertyIdentifier, startDate, endDate, winkVersion, accept);
    }

    private WebClient.ResponseSpec showPropertyRoomRatesRequestCreation(String propertyIdentifier, String masterRateIdentifier, LocalDate startDate, LocalDate endDate, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showPropertyRoomRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (masterRateIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'masterRateIdentifier' when calling showPropertyRoomRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (startDate == null) {
            throw new WebClientResponseException("Missing the required parameter 'startDate' when calling showPropertyRoomRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (endDate == null) {
            throw new WebClientResponseException("Missing the required parameter 'endDate' when calling showPropertyRoomRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("masterRateIdentifier", masterRateIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "startDate", startDate));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "endDate", endDate));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "application/hal+json", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oAuth2ClientCredentials"};
        ParameterizedTypeReference<PropertyRoomRateWithRateList> localVarReturnType = new ParameterizedTypeReference<PropertyRoomRateWithRateList>(this){};
        return this.apiClient.invokeAPI("/api/channel-manager/property/{propertyIdentifier}/master-rate/{masterRateIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PropertyRoomRateWithRateList> showPropertyRoomRates(String propertyIdentifier, String masterRateIdentifier, LocalDate startDate, LocalDate endDate, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyRoomRateWithRateList> localVarReturnType = new ParameterizedTypeReference<PropertyRoomRateWithRateList>(this){};
        return this.showPropertyRoomRatesRequestCreation(propertyIdentifier, masterRateIdentifier, startDate, endDate, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PropertyRoomRateWithRateList>> showPropertyRoomRatesWithHttpInfo(String propertyIdentifier, String masterRateIdentifier, LocalDate startDate, LocalDate endDate, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyRoomRateWithRateList> localVarReturnType = new ParameterizedTypeReference<PropertyRoomRateWithRateList>(this){};
        return this.showPropertyRoomRatesRequestCreation(propertyIdentifier, masterRateIdentifier, startDate, endDate, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showPropertyRoomRatesWithResponseSpec(String propertyIdentifier, String masterRateIdentifier, LocalDate startDate, LocalDate endDate, String winkVersion, String accept) throws WebClientResponseException {
        return this.showPropertyRoomRatesRequestCreation(propertyIdentifier, masterRateIdentifier, startDate, endDate, winkVersion, accept);
    }

    private WebClient.ResponseSpec updateRatesRequestCreation(String propertyIdentifier, String masterRateIdentifier, PropertyRateUpdateRequest propertyRateUpdateRequest, String winkVersion) throws WebClientResponseException {
        PropertyRateUpdateRequest postBody = propertyRateUpdateRequest;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling updateRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (masterRateIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'masterRateIdentifier' when calling updateRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (propertyRateUpdateRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyRateUpdateRequest' when calling updateRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("masterRateIdentifier", masterRateIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "application/hal+json", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oAuth2ClientCredentials"};
        ParameterizedTypeReference<PropertyRate> localVarReturnType = new ParameterizedTypeReference<PropertyRate>(this){};
        return this.apiClient.invokeAPI("/api/channel-manager/property/{propertyIdentifier}/master-rate/{masterRateIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<PropertyRate> updateRates(String propertyIdentifier, String masterRateIdentifier, PropertyRateUpdateRequest propertyRateUpdateRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyRate> localVarReturnType = new ParameterizedTypeReference<PropertyRate>(this){};
        return this.updateRatesRequestCreation(propertyIdentifier, masterRateIdentifier, propertyRateUpdateRequest, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<PropertyRate>>> updateRatesWithHttpInfo(String propertyIdentifier, String masterRateIdentifier, PropertyRateUpdateRequest propertyRateUpdateRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyRate> localVarReturnType = new ParameterizedTypeReference<PropertyRate>(this){};
        return this.updateRatesRequestCreation(propertyIdentifier, masterRateIdentifier, propertyRateUpdateRequest, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateRatesWithResponseSpec(String propertyIdentifier, String masterRateIdentifier, PropertyRateUpdateRequest propertyRateUpdateRequest, String winkVersion) throws WebClientResponseException {
        return this.updateRatesRequestCreation(propertyIdentifier, masterRateIdentifier, propertyRateUpdateRequest, winkVersion);
    }
}

