package travel.wink.sdk.channel.manager.api;

import travel.wink.sdk.channel.manager.invoker.ApiClient;

import travel.wink.sdk.channel.manager.model.GenericErrorMessage;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import travel.wink.sdk.channel.manager.model.PageProperty;
import travel.wink.sdk.channel.manager.model.PingResponse;
import travel.wink.sdk.channel.manager.model.PropertyBooking;
import travel.wink.sdk.channel.manager.model.PropertyRate;
import travel.wink.sdk.channel.manager.model.PropertyRateUpdateRequest;
import travel.wink.sdk.channel.manager.model.PropertyRoomRateWithRateList;
import travel.wink.sdk.channel.manager.model.PropertyWithRoomRateList;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-03-04T20:46:56.175389295+07:00[Asia/Bangkok]")
public class ChannelManagerApi {
    private ApiClient apiClient;

    public ChannelManagerApi() {
        this(new ApiClient());
    }

    @Autowired
    public ChannelManagerApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Say Hello
     * Test endpoint to validate your credentials.
     * <p><b>404</b> - Not Found
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return PingResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec pingRequestCreation(String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "application/hal+json", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oAuth2ClientCredentials" };

        ParameterizedTypeReference<PingResponse> localVarReturnType = new ParameterizedTypeReference<PingResponse>() {};
        return apiClient.invokeAPI("/api/channel-manager/ping", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Say Hello
     * Test endpoint to validate your credentials.
     * <p><b>404</b> - Not Found
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return PingResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PingResponse> ping(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PingResponse> localVarReturnType = new ParameterizedTypeReference<PingResponse>() {};
        return pingRequestCreation(winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Say Hello
     * Test endpoint to validate your credentials.
     * <p><b>404</b> - Not Found
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;PingResponse&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PingResponse>> pingWithHttpInfo(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PingResponse> localVarReturnType = new ParameterizedTypeReference<PingResponse>() {};
        return pingRequestCreation(winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Say Hello
     * Test endpoint to validate your credentials.
     * <p><b>404</b> - Not Found
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec pingWithResponseSpec(String winkVersion, String accept) throws WebClientResponseException {
        return pingRequestCreation(winkVersion, accept);
    }
    /**
     * Show Properties
     * The properties endpoint provides the entry point into the listener and is used to list properties you have access to.
     * <p><b>404</b> - Not Found
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param page Page through all properties owned by your account
     * @param size Limit results of records per page
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return PageProperty
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showPropertiesRequestCreation(Integer page, Integer size, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "size", size));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "application/hal+json", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oAuth2ClientCredentials" };

        ParameterizedTypeReference<PageProperty> localVarReturnType = new ParameterizedTypeReference<PageProperty>() {};
        return apiClient.invokeAPI("/api/channel-manager/property/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Properties
     * The properties endpoint provides the entry point into the listener and is used to list properties you have access to.
     * <p><b>404</b> - Not Found
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param page Page through all properties owned by your account
     * @param size Limit results of records per page
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return PageProperty
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageProperty> showProperties(Integer page, Integer size, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageProperty> localVarReturnType = new ParameterizedTypeReference<PageProperty>() {};
        return showPropertiesRequestCreation(page, size, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Properties
     * The properties endpoint provides the entry point into the listener and is used to list properties you have access to.
     * <p><b>404</b> - Not Found
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param page Page through all properties owned by your account
     * @param size Limit results of records per page
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;PageProperty&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PageProperty>> showPropertiesWithHttpInfo(Integer page, Integer size, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageProperty> localVarReturnType = new ParameterizedTypeReference<PageProperty>() {};
        return showPropertiesRequestCreation(page, size, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Properties
     * The properties endpoint provides the entry point into the listener and is used to list properties you have access to.
     * <p><b>404</b> - Not Found
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param page Page through all properties owned by your account
     * @param size Limit results of records per page
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showPropertiesWithResponseSpec(Integer page, Integer size, String winkVersion, String accept) throws WebClientResponseException {
        return showPropertiesRequestCreation(page, size, winkVersion, accept);
    }
    /**
     * Show Property
     * Retrieves property record with master rates included.
     * <p><b>404</b> - Not Found
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param propertyIdentifier Retrieve record for this propertyIdentifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return PropertyWithRoomRateList
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showPropertyRequestCreation(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showProperty", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "application/hal+json", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oAuth2ClientCredentials" };

        ParameterizedTypeReference<PropertyWithRoomRateList> localVarReturnType = new ParameterizedTypeReference<PropertyWithRoomRateList>() {};
        return apiClient.invokeAPI("/api/channel-manager/property/{propertyIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Property
     * Retrieves property record with master rates included.
     * <p><b>404</b> - Not Found
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param propertyIdentifier Retrieve record for this propertyIdentifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return PropertyWithRoomRateList
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PropertyWithRoomRateList> showProperty(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyWithRoomRateList> localVarReturnType = new ParameterizedTypeReference<PropertyWithRoomRateList>() {};
        return showPropertyRequestCreation(propertyIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Property
     * Retrieves property record with master rates included.
     * <p><b>404</b> - Not Found
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param propertyIdentifier Retrieve record for this propertyIdentifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;PropertyWithRoomRateList&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PropertyWithRoomRateList>> showPropertyWithHttpInfo(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyWithRoomRateList> localVarReturnType = new ParameterizedTypeReference<PropertyWithRoomRateList>() {};
        return showPropertyRequestCreation(propertyIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Property
     * Retrieves property record with master rates included.
     * <p><b>404</b> - Not Found
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param propertyIdentifier Retrieve record for this propertyIdentifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showPropertyWithResponseSpec(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showPropertyRequestCreation(propertyIdentifier, winkVersion, accept);
    }
    /**
     * Show Booking
     * Retrieves a specific booking by property / booking combo.
     * <p><b>404</b> - Not Found
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param propertyIdentifier Retrieve record owned by propertyIdentifier
     * @param bookingIdentifier Retrieve record for this bookingIdentifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return PropertyBooking
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showPropertyBookingRequestCreation(String propertyIdentifier, String bookingIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showPropertyBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'bookingIdentifier' is set
        if (bookingIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingIdentifier' when calling showPropertyBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("bookingIdentifier", bookingIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "application/hal+json", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oAuth2ClientCredentials" };

        ParameterizedTypeReference<PropertyBooking> localVarReturnType = new ParameterizedTypeReference<PropertyBooking>() {};
        return apiClient.invokeAPI("/api/channel-manager/property/{propertyIdentifier}/booking/{bookingIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Booking
     * Retrieves a specific booking by property / booking combo.
     * <p><b>404</b> - Not Found
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param propertyIdentifier Retrieve record owned by propertyIdentifier
     * @param bookingIdentifier Retrieve record for this bookingIdentifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return PropertyBooking
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PropertyBooking> showPropertyBooking(String propertyIdentifier, String bookingIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyBooking> localVarReturnType = new ParameterizedTypeReference<PropertyBooking>() {};
        return showPropertyBookingRequestCreation(propertyIdentifier, bookingIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Booking
     * Retrieves a specific booking by property / booking combo.
     * <p><b>404</b> - Not Found
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param propertyIdentifier Retrieve record owned by propertyIdentifier
     * @param bookingIdentifier Retrieve record for this bookingIdentifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;PropertyBooking&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PropertyBooking>> showPropertyBookingWithHttpInfo(String propertyIdentifier, String bookingIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyBooking> localVarReturnType = new ParameterizedTypeReference<PropertyBooking>() {};
        return showPropertyBookingRequestCreation(propertyIdentifier, bookingIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Booking
     * Retrieves a specific booking by property / booking combo.
     * <p><b>404</b> - Not Found
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param propertyIdentifier Retrieve record owned by propertyIdentifier
     * @param bookingIdentifier Retrieve record for this bookingIdentifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showPropertyBookingWithResponseSpec(String propertyIdentifier, String bookingIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showPropertyBookingRequestCreation(propertyIdentifier, bookingIdentifier, winkVersion, accept);
    }
    /**
     * Show Bookings
     * Retrieves a list of all bookings created for the specified property within the specified date range.
     * <p><b>404</b> - Not Found
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param propertyIdentifier Retrieve record owned by this propertyIdentifier
     * @param startDate Limit results on date range starting with
     * @param endDate Limit results on date range ending with
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;PropertyBooking&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showPropertyBookingsRequestCreation(String propertyIdentifier, java.time.LocalDateTime startDate, java.time.LocalDateTime endDate, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showPropertyBookings", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'startDate' is set
        if (startDate == null) {
            throw new WebClientResponseException("Missing the required parameter 'startDate' when calling showPropertyBookings", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "startDate", startDate));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "endDate", endDate));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "application/hal+json", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oAuth2ClientCredentials" };

        ParameterizedTypeReference<PropertyBooking> localVarReturnType = new ParameterizedTypeReference<PropertyBooking>() {};
        return apiClient.invokeAPI("/api/channel-manager/property/{propertyIdentifier}/booking/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Bookings
     * Retrieves a list of all bookings created for the specified property within the specified date range.
     * <p><b>404</b> - Not Found
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param propertyIdentifier Retrieve record owned by this propertyIdentifier
     * @param startDate Limit results on date range starting with
     * @param endDate Limit results on date range ending with
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;PropertyBooking&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<PropertyBooking> showPropertyBookings(String propertyIdentifier, java.time.LocalDateTime startDate, java.time.LocalDateTime endDate, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyBooking> localVarReturnType = new ParameterizedTypeReference<PropertyBooking>() {};
        return showPropertyBookingsRequestCreation(propertyIdentifier, startDate, endDate, winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Bookings
     * Retrieves a list of all bookings created for the specified property within the specified date range.
     * <p><b>404</b> - Not Found
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param propertyIdentifier Retrieve record owned by this propertyIdentifier
     * @param startDate Limit results on date range starting with
     * @param endDate Limit results on date range ending with
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;PropertyBooking&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<PropertyBooking>>> showPropertyBookingsWithHttpInfo(String propertyIdentifier, java.time.LocalDateTime startDate, java.time.LocalDateTime endDate, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyBooking> localVarReturnType = new ParameterizedTypeReference<PropertyBooking>() {};
        return showPropertyBookingsRequestCreation(propertyIdentifier, startDate, endDate, winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show Bookings
     * Retrieves a list of all bookings created for the specified property within the specified date range.
     * <p><b>404</b> - Not Found
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param propertyIdentifier Retrieve record owned by this propertyIdentifier
     * @param startDate Limit results on date range starting with
     * @param endDate Limit results on date range ending with
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showPropertyBookingsWithResponseSpec(String propertyIdentifier, java.time.LocalDateTime startDate, java.time.LocalDateTime endDate, String winkVersion, String accept) throws WebClientResponseException {
        return showPropertyBookingsRequestCreation(propertyIdentifier, startDate, endDate, winkVersion, accept);
    }
    /**
     * Show Daily Rates
     * Retrieves all daily rates for for property / master rate combo and a date range.
     * <p><b>404</b> - Not Found
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param propertyIdentifier Retrieve record owned by this propertyIdentifier
     * @param masterRateIdentifier Retrieve record owned by this masterRateIdentifier
     * @param startDate Limit results on date range starting with
     * @param endDate Limit results on date range ending with
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return PropertyRoomRateWithRateList
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showPropertyRoomRatesRequestCreation(String propertyIdentifier, String masterRateIdentifier, LocalDate startDate, LocalDate endDate, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showPropertyRoomRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'masterRateIdentifier' is set
        if (masterRateIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'masterRateIdentifier' when calling showPropertyRoomRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'startDate' is set
        if (startDate == null) {
            throw new WebClientResponseException("Missing the required parameter 'startDate' when calling showPropertyRoomRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'endDate' is set
        if (endDate == null) {
            throw new WebClientResponseException("Missing the required parameter 'endDate' when calling showPropertyRoomRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("masterRateIdentifier", masterRateIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "startDate", startDate));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "endDate", endDate));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "application/hal+json", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oAuth2ClientCredentials" };

        ParameterizedTypeReference<PropertyRoomRateWithRateList> localVarReturnType = new ParameterizedTypeReference<PropertyRoomRateWithRateList>() {};
        return apiClient.invokeAPI("/api/channel-manager/property/{propertyIdentifier}/master-rate/{masterRateIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Daily Rates
     * Retrieves all daily rates for for property / master rate combo and a date range.
     * <p><b>404</b> - Not Found
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param propertyIdentifier Retrieve record owned by this propertyIdentifier
     * @param masterRateIdentifier Retrieve record owned by this masterRateIdentifier
     * @param startDate Limit results on date range starting with
     * @param endDate Limit results on date range ending with
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return PropertyRoomRateWithRateList
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PropertyRoomRateWithRateList> showPropertyRoomRates(String propertyIdentifier, String masterRateIdentifier, LocalDate startDate, LocalDate endDate, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyRoomRateWithRateList> localVarReturnType = new ParameterizedTypeReference<PropertyRoomRateWithRateList>() {};
        return showPropertyRoomRatesRequestCreation(propertyIdentifier, masterRateIdentifier, startDate, endDate, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Daily Rates
     * Retrieves all daily rates for for property / master rate combo and a date range.
     * <p><b>404</b> - Not Found
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param propertyIdentifier Retrieve record owned by this propertyIdentifier
     * @param masterRateIdentifier Retrieve record owned by this masterRateIdentifier
     * @param startDate Limit results on date range starting with
     * @param endDate Limit results on date range ending with
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;PropertyRoomRateWithRateList&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PropertyRoomRateWithRateList>> showPropertyRoomRatesWithHttpInfo(String propertyIdentifier, String masterRateIdentifier, LocalDate startDate, LocalDate endDate, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyRoomRateWithRateList> localVarReturnType = new ParameterizedTypeReference<PropertyRoomRateWithRateList>() {};
        return showPropertyRoomRatesRequestCreation(propertyIdentifier, masterRateIdentifier, startDate, endDate, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Daily Rates
     * Retrieves all daily rates for for property / master rate combo and a date range.
     * <p><b>404</b> - Not Found
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param propertyIdentifier Retrieve record owned by this propertyIdentifier
     * @param masterRateIdentifier Retrieve record owned by this masterRateIdentifier
     * @param startDate Limit results on date range starting with
     * @param endDate Limit results on date range ending with
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showPropertyRoomRatesWithResponseSpec(String propertyIdentifier, String masterRateIdentifier, LocalDate startDate, LocalDate endDate, String winkVersion, String accept) throws WebClientResponseException {
        return showPropertyRoomRatesRequestCreation(propertyIdentifier, masterRateIdentifier, startDate, endDate, winkVersion, accept);
    }
    /**
     * Update Daily Rates
     * Update daily rate / availability for a property / master rate combo.
     * <p><b>404</b> - Not Found
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update rates owned by this propertyIdentifier
     * @param masterRateIdentifier Update rates owned by this masterRateIdentifier
     * @param propertyRateUpdateRequest The propertyRateUpdateRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;PropertyRate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateRatesRequestCreation(String propertyIdentifier, String masterRateIdentifier, PropertyRateUpdateRequest propertyRateUpdateRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = propertyRateUpdateRequest;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling updateRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'masterRateIdentifier' is set
        if (masterRateIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'masterRateIdentifier' when calling updateRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'propertyRateUpdateRequest' is set
        if (propertyRateUpdateRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyRateUpdateRequest' when calling updateRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("masterRateIdentifier", masterRateIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "application/hal+json", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oAuth2ClientCredentials" };

        ParameterizedTypeReference<PropertyRate> localVarReturnType = new ParameterizedTypeReference<PropertyRate>() {};
        return apiClient.invokeAPI("/api/channel-manager/property/{propertyIdentifier}/master-rate/{masterRateIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Daily Rates
     * Update daily rate / availability for a property / master rate combo.
     * <p><b>404</b> - Not Found
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update rates owned by this propertyIdentifier
     * @param masterRateIdentifier Update rates owned by this masterRateIdentifier
     * @param propertyRateUpdateRequest The propertyRateUpdateRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;PropertyRate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<PropertyRate> updateRates(String propertyIdentifier, String masterRateIdentifier, PropertyRateUpdateRequest propertyRateUpdateRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyRate> localVarReturnType = new ParameterizedTypeReference<PropertyRate>() {};
        return updateRatesRequestCreation(propertyIdentifier, masterRateIdentifier, propertyRateUpdateRequest, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Update Daily Rates
     * Update daily rate / availability for a property / master rate combo.
     * <p><b>404</b> - Not Found
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update rates owned by this propertyIdentifier
     * @param masterRateIdentifier Update rates owned by this masterRateIdentifier
     * @param propertyRateUpdateRequest The propertyRateUpdateRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;PropertyRate&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<PropertyRate>>> updateRatesWithHttpInfo(String propertyIdentifier, String masterRateIdentifier, PropertyRateUpdateRequest propertyRateUpdateRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyRate> localVarReturnType = new ParameterizedTypeReference<PropertyRate>() {};
        return updateRatesRequestCreation(propertyIdentifier, masterRateIdentifier, propertyRateUpdateRequest, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Update Daily Rates
     * Update daily rate / availability for a property / master rate combo.
     * <p><b>404</b> - Not Found
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update rates owned by this propertyIdentifier
     * @param masterRateIdentifier Update rates owned by this masterRateIdentifier
     * @param propertyRateUpdateRequest The propertyRateUpdateRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateRatesWithResponseSpec(String propertyIdentifier, String masterRateIdentifier, PropertyRateUpdateRequest propertyRateUpdateRequest, String winkVersion) throws WebClientResponseException {
        return updateRatesRequestCreation(propertyIdentifier, masterRateIdentifier, propertyRateUpdateRequest, winkVersion);
    }
}
