/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md   # Channel Manager API Wink exposes a secured REST-based, JSON API to its channel manager partners. The connection is \"channel-wide\". Partners are free to integrate with the REST-based API using any programming language.  # Intended Audience This document is intended for external channel partners who wish to integrate with Wink.  # Requirements - Active account with Wink. Sign up for your Channel Manager account:    - Staging: [https://staging-studio.wink.travel](https://staging-studio.wink.travel).    - Production: [https://studio.wink.travel](https://studio.wink.travel). - Active application. An application provides you with Oauth2 credentials you can pass to our endpoints. One is already created for you upon account creation. - Your production IP numbers. They need to be whitelisted before you can talk to our production environment.  # Performance A particular attention to performance should be given when integrating with this API. A few things to be aware of: - Enable gzip compression to make payloads smaller. - Fewer large REST calls are preferred to many small ones. E.g. It is better to update many dates instead of individual dates. - It is possible to update both rate and availability with a single request. - Request only date ranges that you will use. There is no need to request an entire year if you will only be working with the first seven days.  ## Reservation notification (PUSH) Wink supports PUSH notifications to communicate reservations. We also support BASIC AUTH to your endpoint. If you want to enable PUSH, add your PUSH endpoint and credentials (optional) to your account.
 *
 * The version of the OpenAPI document: 30.17.8
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.channel.manager.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import travel.wink.sdk.channel.manager.model.ChannelManagerProperty;
import travel.wink.sdk.channel.manager.model.PageableObject;
import travel.wink.sdk.channel.manager.model.SortObject;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * PageChannelManagerProperty
 */
@JsonPropertyOrder({
  PageChannelManagerProperty.JSON_PROPERTY_TOTAL_ELEMENTS,
  PageChannelManagerProperty.JSON_PROPERTY_TOTAL_PAGES,
  PageChannelManagerProperty.JSON_PROPERTY_SIZE,
  PageChannelManagerProperty.JSON_PROPERTY_CONTENT,
  PageChannelManagerProperty.JSON_PROPERTY_NUMBER,
  PageChannelManagerProperty.JSON_PROPERTY_NUMBER_OF_ELEMENTS,
  PageChannelManagerProperty.JSON_PROPERTY_SORT,
  PageChannelManagerProperty.JSON_PROPERTY_PAGEABLE,
  PageChannelManagerProperty.JSON_PROPERTY_FIRST,
  PageChannelManagerProperty.JSON_PROPERTY_LAST,
  PageChannelManagerProperty.JSON_PROPERTY_EMPTY
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-26T20:17:17.459970342+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class PageChannelManagerProperty {
  public static final String JSON_PROPERTY_TOTAL_ELEMENTS = "totalElements";
  @jakarta.annotation.Nullable
  private Long totalElements;

  public static final String JSON_PROPERTY_TOTAL_PAGES = "totalPages";
  @jakarta.annotation.Nullable
  private Integer totalPages;

  public static final String JSON_PROPERTY_SIZE = "size";
  @jakarta.annotation.Nullable
  private Integer size;

  public static final String JSON_PROPERTY_CONTENT = "content";
  @jakarta.annotation.Nullable
  private List<@Valid ChannelManagerProperty> content = new ArrayList<>();

  public static final String JSON_PROPERTY_NUMBER = "number";
  @jakarta.annotation.Nullable
  private Integer number;

  public static final String JSON_PROPERTY_NUMBER_OF_ELEMENTS = "numberOfElements";
  @jakarta.annotation.Nullable
  private Integer numberOfElements;

  public static final String JSON_PROPERTY_SORT = "sort";
  @jakarta.annotation.Nullable
  private SortObject sort;

  public static final String JSON_PROPERTY_PAGEABLE = "pageable";
  @jakarta.annotation.Nullable
  private PageableObject pageable;

  public static final String JSON_PROPERTY_FIRST = "first";
  @jakarta.annotation.Nullable
  private Boolean first;

  public static final String JSON_PROPERTY_LAST = "last";
  @jakarta.annotation.Nullable
  private Boolean last;

  public static final String JSON_PROPERTY_EMPTY = "empty";
  @jakarta.annotation.Nullable
  private Boolean empty;

  public PageChannelManagerProperty() {
  }

  public PageChannelManagerProperty totalElements(@jakarta.annotation.Nullable Long totalElements) {
    
    this.totalElements = totalElements;
    return this;
  }

  /**
   * Get totalElements
   * @return totalElements
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_ELEMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getTotalElements() {
    return totalElements;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_ELEMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalElements(@jakarta.annotation.Nullable Long totalElements) {
    this.totalElements = totalElements;
  }

  public PageChannelManagerProperty totalPages(@jakarta.annotation.Nullable Integer totalPages) {
    
    this.totalPages = totalPages;
    return this;
  }

  /**
   * Get totalPages
   * @return totalPages
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_PAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getTotalPages() {
    return totalPages;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_PAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalPages(@jakarta.annotation.Nullable Integer totalPages) {
    this.totalPages = totalPages;
  }

  public PageChannelManagerProperty size(@jakarta.annotation.Nullable Integer size) {
    
    this.size = size;
    return this;
  }

  /**
   * Get size
   * @return size
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSize() {
    return size;
  }


  @JsonProperty(JSON_PROPERTY_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSize(@jakarta.annotation.Nullable Integer size) {
    this.size = size;
  }

  public PageChannelManagerProperty content(@jakarta.annotation.Nullable List<@Valid ChannelManagerProperty> content) {
    
    this.content = content;
    return this;
  }

  public PageChannelManagerProperty addContentItem(ChannelManagerProperty contentItem) {
    if (this.content == null) {
      this.content = new ArrayList<>();
    }
    this.content.add(contentItem);
    return this;
  }

  /**
   * Get content
   * @return content
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CONTENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<@Valid ChannelManagerProperty> getContent() {
    return content;
  }


  @JsonProperty(JSON_PROPERTY_CONTENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContent(@jakarta.annotation.Nullable List<@Valid ChannelManagerProperty> content) {
    this.content = content;
  }

  public PageChannelManagerProperty number(@jakarta.annotation.Nullable Integer number) {
    
    this.number = number;
    return this;
  }

  /**
   * Get number
   * @return number
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getNumber() {
    return number;
  }


  @JsonProperty(JSON_PROPERTY_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNumber(@jakarta.annotation.Nullable Integer number) {
    this.number = number;
  }

  public PageChannelManagerProperty numberOfElements(@jakarta.annotation.Nullable Integer numberOfElements) {
    
    this.numberOfElements = numberOfElements;
    return this;
  }

  /**
   * Get numberOfElements
   * @return numberOfElements
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NUMBER_OF_ELEMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getNumberOfElements() {
    return numberOfElements;
  }


  @JsonProperty(JSON_PROPERTY_NUMBER_OF_ELEMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNumberOfElements(@jakarta.annotation.Nullable Integer numberOfElements) {
    this.numberOfElements = numberOfElements;
  }

  public PageChannelManagerProperty sort(@jakarta.annotation.Nullable SortObject sort) {
    
    this.sort = sort;
    return this;
  }

  /**
   * Get sort
   * @return sort
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SortObject getSort() {
    return sort;
  }


  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSort(@jakarta.annotation.Nullable SortObject sort) {
    this.sort = sort;
  }

  public PageChannelManagerProperty pageable(@jakarta.annotation.Nullable PageableObject pageable) {
    
    this.pageable = pageable;
    return this;
  }

  /**
   * Get pageable
   * @return pageable
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PAGEABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PageableObject getPageable() {
    return pageable;
  }


  @JsonProperty(JSON_PROPERTY_PAGEABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPageable(@jakarta.annotation.Nullable PageableObject pageable) {
    this.pageable = pageable;
  }

  public PageChannelManagerProperty first(@jakarta.annotation.Nullable Boolean first) {
    
    this.first = first;
    return this;
  }

  /**
   * Get first
   * @return first
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FIRST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getFirst() {
    return first;
  }


  @JsonProperty(JSON_PROPERTY_FIRST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFirst(@jakarta.annotation.Nullable Boolean first) {
    this.first = first;
  }

  public PageChannelManagerProperty last(@jakarta.annotation.Nullable Boolean last) {
    
    this.last = last;
    return this;
  }

  /**
   * Get last
   * @return last
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LAST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getLast() {
    return last;
  }


  @JsonProperty(JSON_PROPERTY_LAST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLast(@jakarta.annotation.Nullable Boolean last) {
    this.last = last;
  }

  public PageChannelManagerProperty empty(@jakarta.annotation.Nullable Boolean empty) {
    
    this.empty = empty;
    return this;
  }

  /**
   * Get empty
   * @return empty
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_EMPTY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getEmpty() {
    return empty;
  }


  @JsonProperty(JSON_PROPERTY_EMPTY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEmpty(@jakarta.annotation.Nullable Boolean empty) {
    this.empty = empty;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PageChannelManagerProperty pageChannelManagerProperty = (PageChannelManagerProperty) o;
    return Objects.equals(this.totalElements, pageChannelManagerProperty.totalElements) &&
        Objects.equals(this.totalPages, pageChannelManagerProperty.totalPages) &&
        Objects.equals(this.size, pageChannelManagerProperty.size) &&
        Objects.equals(this.content, pageChannelManagerProperty.content) &&
        Objects.equals(this.number, pageChannelManagerProperty.number) &&
        Objects.equals(this.numberOfElements, pageChannelManagerProperty.numberOfElements) &&
        Objects.equals(this.sort, pageChannelManagerProperty.sort) &&
        Objects.equals(this.pageable, pageChannelManagerProperty.pageable) &&
        Objects.equals(this.first, pageChannelManagerProperty.first) &&
        Objects.equals(this.last, pageChannelManagerProperty.last) &&
        Objects.equals(this.empty, pageChannelManagerProperty.empty);
  }

  @Override
  public int hashCode() {
    return Objects.hash(totalElements, totalPages, size, content, number, numberOfElements, sort, pageable, first, last, empty);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PageChannelManagerProperty {\n");
    sb.append("    totalElements: ").append(toIndentedString(totalElements)).append("\n");
    sb.append("    totalPages: ").append(toIndentedString(totalPages)).append("\n");
    sb.append("    size: ").append(toIndentedString(size)).append("\n");
    sb.append("    content: ").append(toIndentedString(content)).append("\n");
    sb.append("    number: ").append(toIndentedString(number)).append("\n");
    sb.append("    numberOfElements: ").append(toIndentedString(numberOfElements)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("    pageable: ").append(toIndentedString(pageable)).append("\n");
    sb.append("    first: ").append(toIndentedString(first)).append("\n");
    sb.append("    last: ").append(toIndentedString(last)).append("\n");
    sb.append("    empty: ").append(toIndentedString(empty)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

