/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md   # Channel Manager API Wink exposes a secured REST-based, JSON API to its channel manager partners. The connection is \"channel-wide\". Partners are free to integrate with the REST-based API using any programming language.  # Intended Audience This document is intended for external channel partners who wish to integrate with Wink.  # Requirements - Active account with Wink. Sign up for your Channel Manager account:    - Staging: [https://staging-studio.wink.travel](https://staging-studio.wink.travel).    - Production: [https://studio.wink.travel](https://studio.wink.travel). - Active application. An application provides you with Oauth2 credentials you can pass to our endpoints. One is already created for you upon account creation. - Your production IP numbers. They need to be whitelisted before you can talk to our production environment.  # Performance A particular attention to performance should be given when integrating with this API. A few things to be aware of: - Enable gzip compression to make payloads smaller. - Fewer large REST calls are preferred to many small ones. E.g. It is better to update many dates instead of individual dates. - It is possible to update both rate and availability with a single request. - Request only date ranges that you will use. There is no need to request an entire year if you will only be working with the first seven days.  ## Reservation notification (PUSH) Wink supports PUSH notifications to communicate reservations. We also support BASIC AUTH to your endpoint. If you want to enable PUSH, add your PUSH endpoint and credentials (optional) to your account.
 *
 * The version of the OpenAPI document: 30.17.8
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.channel.manager.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.LocalDateTime;
import java.util.UUID;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * PropertyBooking
 */
@JsonPropertyOrder({
  PropertyBooking.JSON_PROPERTY_BOOKING_IDENTIFIER,
  PropertyBooking.JSON_PROPERTY_PROPERTY_IDENTIFIER,
  PropertyBooking.JSON_PROPERTY_ROOM_RATE_IDENTIFIER,
  PropertyBooking.JSON_PROPERTY_NAME,
  PropertyBooking.JSON_PROPERTY_GUEST_ROOM_NAME,
  PropertyBooking.JSON_PROPERTY_RATE_PLAN_NAME,
  PropertyBooking.JSON_PROPERTY_ROOMS,
  PropertyBooking.JSON_PROPERTY_GUESTS,
  PropertyBooking.JSON_PROPERTY_ADULTS,
  PropertyBooking.JSON_PROPERTY_CHILDREN,
  PropertyBooking.JSON_PROPERTY_FIRST_NAME,
  PropertyBooking.JSON_PROPERTY_LAST_NAME,
  PropertyBooking.JSON_PROPERTY_EMAIL,
  PropertyBooking.JSON_PROPERTY_AMOUNT,
  PropertyBooking.JSON_PROPERTY_CURRENCY_CODE,
  PropertyBooking.JSON_PROPERTY_BOOKING_CODE,
  PropertyBooking.JSON_PROPERTY_START_DATE,
  PropertyBooking.JSON_PROPERTY_END_DATE,
  PropertyBooking.JSON_PROPERTY_CREATED_DATE,
  PropertyBooking.JSON_PROPERTY_CANCELLED,
  PropertyBooking.JSON_PROPERTY_CANCEL_DATE,
  PropertyBooking.JSON_PROPERTY_PAYMENT_METHOD_TYPE,
  PropertyBooking.JSON_PROPERTY_PAYMENT_WALLET_TYPE,
  PropertyBooking.JSON_PROPERTY_PAYMENT_METHOD_STATUS,
  PropertyBooking.JSON_PROPERTY_SALES_CHANNEL_NAME,
  PropertyBooking.JSON_PROPERTY_SALES_CHANNEL_IDENTIFIER
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-26T20:17:17.459970342+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class PropertyBooking {
  public static final String JSON_PROPERTY_BOOKING_IDENTIFIER = "bookingIdentifier";
  @jakarta.annotation.Nonnull
  private UUID bookingIdentifier;

  public static final String JSON_PROPERTY_PROPERTY_IDENTIFIER = "propertyIdentifier";
  @jakarta.annotation.Nonnull
  private UUID propertyIdentifier;

  public static final String JSON_PROPERTY_ROOM_RATE_IDENTIFIER = "roomRateIdentifier";
  @jakarta.annotation.Nonnull
  private UUID roomRateIdentifier;

  public static final String JSON_PROPERTY_NAME = "name";
  @jakarta.annotation.Nonnull
  private String name;

  public static final String JSON_PROPERTY_GUEST_ROOM_NAME = "guestRoomName";
  @jakarta.annotation.Nonnull
  private String guestRoomName;

  public static final String JSON_PROPERTY_RATE_PLAN_NAME = "ratePlanName";
  @jakarta.annotation.Nonnull
  private String ratePlanName;

  public static final String JSON_PROPERTY_ROOMS = "rooms";
  @jakarta.annotation.Nonnull
  private Integer rooms;

  public static final String JSON_PROPERTY_GUESTS = "guests";
  @jakarta.annotation.Nonnull
  private Integer guests;

  public static final String JSON_PROPERTY_ADULTS = "adults";
  @jakarta.annotation.Nonnull
  private Integer adults;

  public static final String JSON_PROPERTY_CHILDREN = "children";
  @jakarta.annotation.Nonnull
  private Integer children;

  public static final String JSON_PROPERTY_FIRST_NAME = "firstName";
  @jakarta.annotation.Nonnull
  private String firstName;

  public static final String JSON_PROPERTY_LAST_NAME = "lastName";
  @jakarta.annotation.Nonnull
  private String lastName;

  public static final String JSON_PROPERTY_EMAIL = "email";
  @jakarta.annotation.Nonnull
  private String email;

  public static final String JSON_PROPERTY_AMOUNT = "amount";
  @jakarta.annotation.Nonnull
  private BigDecimal amount;

  public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
  @jakarta.annotation.Nonnull
  private String currencyCode;

  public static final String JSON_PROPERTY_BOOKING_CODE = "bookingCode";
  @jakarta.annotation.Nonnull
  private String bookingCode;

  public static final String JSON_PROPERTY_START_DATE = "startDate";
  @jakarta.annotation.Nonnull
  private LocalDate startDate;

  public static final String JSON_PROPERTY_END_DATE = "endDate";
  @jakarta.annotation.Nonnull
  private LocalDate endDate;

  public static final String JSON_PROPERTY_CREATED_DATE = "createdDate";
  @jakarta.annotation.Nonnull
  private java.time.LocalDateTime createdDate;

  public static final String JSON_PROPERTY_CANCELLED = "cancelled";
  @jakarta.annotation.Nonnull
  private Boolean cancelled;

  public static final String JSON_PROPERTY_CANCEL_DATE = "cancelDate";
  @jakarta.annotation.Nullable
  private java.time.LocalDateTime cancelDate;

  public static final String JSON_PROPERTY_PAYMENT_METHOD_TYPE = "paymentMethodType";
  @jakarta.annotation.Nonnull
  private String paymentMethodType;

  public static final String JSON_PROPERTY_PAYMENT_WALLET_TYPE = "paymentWalletType";
  @jakarta.annotation.Nullable
  private String paymentWalletType;

  /**
   * Status of payment
   */
  public enum PaymentMethodStatusEnum {
    INITIALIZED(String.valueOf("INITIALIZED")),
    
    PROCESSING(String.valueOf("PROCESSING")),
    
    SUCCEEDED(String.valueOf("SUCCEEDED")),
    
    FAILED(String.valueOf("FAILED"));

    private String value;

    PaymentMethodStatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PaymentMethodStatusEnum fromValue(String value) {
      for (PaymentMethodStatusEnum b : PaymentMethodStatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PAYMENT_METHOD_STATUS = "paymentMethodStatus";
  @jakarta.annotation.Nonnull
  private PaymentMethodStatusEnum paymentMethodStatus;

  public static final String JSON_PROPERTY_SALES_CHANNEL_NAME = "salesChannelName";
  @jakarta.annotation.Nonnull
  private String salesChannelName;

  public static final String JSON_PROPERTY_SALES_CHANNEL_IDENTIFIER = "salesChannelIdentifier";
  @jakarta.annotation.Nonnull
  private UUID salesChannelIdentifier;

  public PropertyBooking() {
  }

  public PropertyBooking bookingIdentifier(@jakarta.annotation.Nonnull UUID bookingIdentifier) {
    
    this.bookingIdentifier = bookingIdentifier;
    return this;
  }

  /**
   * Booking ID
   * @return bookingIdentifier
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_BOOKING_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getBookingIdentifier() {
    return bookingIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_BOOKING_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBookingIdentifier(@jakarta.annotation.Nonnull UUID bookingIdentifier) {
    this.bookingIdentifier = bookingIdentifier;
  }

  public PropertyBooking propertyIdentifier(@jakarta.annotation.Nonnull UUID propertyIdentifier) {
    
    this.propertyIdentifier = propertyIdentifier;
    return this;
  }

  /**
   * ChannelManagerProperty ID
   * @return propertyIdentifier
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getPropertyIdentifier() {
    return propertyIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPropertyIdentifier(@jakarta.annotation.Nonnull UUID propertyIdentifier) {
    this.propertyIdentifier = propertyIdentifier;
  }

  public PropertyBooking roomRateIdentifier(@jakarta.annotation.Nonnull UUID roomRateIdentifier) {
    
    this.roomRateIdentifier = roomRateIdentifier;
    return this;
  }

  /**
   * Master Rate ID
   * @return roomRateIdentifier
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_ROOM_RATE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getRoomRateIdentifier() {
    return roomRateIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_RATE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoomRateIdentifier(@jakarta.annotation.Nonnull UUID roomRateIdentifier) {
    this.roomRateIdentifier = roomRateIdentifier;
  }

  public PropertyBooking name(@jakarta.annotation.Nonnull String name) {
    
    this.name = name;
    return this;
  }

  /**
   * Master Rate name
   * @return name
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(@jakarta.annotation.Nonnull String name) {
    this.name = name;
  }

  public PropertyBooking guestRoomName(@jakarta.annotation.Nonnull String guestRoomName) {
    
    this.guestRoomName = guestRoomName;
    return this;
  }

  /**
   * Guest room name
   * @return guestRoomName
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_GUEST_ROOM_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getGuestRoomName() {
    return guestRoomName;
  }


  @JsonProperty(JSON_PROPERTY_GUEST_ROOM_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setGuestRoomName(@jakarta.annotation.Nonnull String guestRoomName) {
    this.guestRoomName = guestRoomName;
  }

  public PropertyBooking ratePlanName(@jakarta.annotation.Nonnull String ratePlanName) {
    
    this.ratePlanName = ratePlanName;
    return this;
  }

  /**
   * Rate plan name
   * @return ratePlanName
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_RATE_PLAN_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRatePlanName() {
    return ratePlanName;
  }


  @JsonProperty(JSON_PROPERTY_RATE_PLAN_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRatePlanName(@jakarta.annotation.Nonnull String ratePlanName) {
    this.ratePlanName = ratePlanName;
  }

  public PropertyBooking rooms(@jakarta.annotation.Nonnull Integer rooms) {
    
    this.rooms = rooms;
    return this;
  }

  /**
   * Number of rooms
   * @return rooms
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ROOMS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getRooms() {
    return rooms;
  }


  @JsonProperty(JSON_PROPERTY_ROOMS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRooms(@jakarta.annotation.Nonnull Integer rooms) {
    this.rooms = rooms;
  }

  public PropertyBooking guests(@jakarta.annotation.Nonnull Integer guests) {
    
    this.guests = guests;
    return this;
  }

  /**
   * Number of guests
   * @return guests
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_GUESTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getGuests() {
    return guests;
  }


  @JsonProperty(JSON_PROPERTY_GUESTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setGuests(@jakarta.annotation.Nonnull Integer guests) {
    this.guests = guests;
  }

  public PropertyBooking adults(@jakarta.annotation.Nonnull Integer adults) {
    
    this.adults = adults;
    return this;
  }

  /**
   * Number of adults
   * @return adults
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ADULTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getAdults() {
    return adults;
  }


  @JsonProperty(JSON_PROPERTY_ADULTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAdults(@jakarta.annotation.Nonnull Integer adults) {
    this.adults = adults;
  }

  public PropertyBooking children(@jakarta.annotation.Nonnull Integer children) {
    
    this.children = children;
    return this;
  }

  /**
   * Number of children
   * @return children
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getChildren() {
    return children;
  }


  @JsonProperty(JSON_PROPERTY_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setChildren(@jakarta.annotation.Nonnull Integer children) {
    this.children = children;
  }

  public PropertyBooking firstName(@jakarta.annotation.Nonnull String firstName) {
    
    this.firstName = firstName;
    return this;
  }

  /**
   * First name of traveler
   * @return firstName
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_FIRST_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getFirstName() {
    return firstName;
  }


  @JsonProperty(JSON_PROPERTY_FIRST_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setFirstName(@jakarta.annotation.Nonnull String firstName) {
    this.firstName = firstName;
  }

  public PropertyBooking lastName(@jakarta.annotation.Nonnull String lastName) {
    
    this.lastName = lastName;
    return this;
  }

  /**
   * Last name of traveler
   * @return lastName
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_LAST_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getLastName() {
    return lastName;
  }


  @JsonProperty(JSON_PROPERTY_LAST_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLastName(@jakarta.annotation.Nonnull String lastName) {
    this.lastName = lastName;
  }

  public PropertyBooking email(@jakarta.annotation.Nonnull String email) {
    
    this.email = email;
    return this;
  }

  /**
   * E-mail of traveler
   * @return email
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getEmail() {
    return email;
  }


  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEmail(@jakarta.annotation.Nonnull String email) {
    this.email = email;
  }

  public PropertyBooking amount(@jakarta.annotation.Nonnull BigDecimal amount) {
    
    this.amount = amount;
    return this;
  }

  /**
   * Total booking amount
   * @return amount
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BigDecimal getAmount() {
    return amount;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAmount(@jakarta.annotation.Nonnull BigDecimal amount) {
    this.amount = amount;
  }

  public PropertyBooking currencyCode(@jakarta.annotation.Nonnull String currencyCode) {
    
    this.currencyCode = currencyCode;
    return this;
  }

  /**
   * Supplier currency
   * @return currencyCode
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCurrencyCode() {
    return currencyCode;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCurrencyCode(@jakarta.annotation.Nonnull String currencyCode) {
    this.currencyCode = currencyCode;
  }

  public PropertyBooking bookingCode(@jakarta.annotation.Nonnull String bookingCode) {
    
    this.bookingCode = bookingCode;
    return this;
  }

  /**
   * Ref. code for traveler
   * @return bookingCode
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_BOOKING_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getBookingCode() {
    return bookingCode;
  }


  @JsonProperty(JSON_PROPERTY_BOOKING_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBookingCode(@jakarta.annotation.Nonnull String bookingCode) {
    this.bookingCode = bookingCode;
  }

  public PropertyBooking startDate(@jakarta.annotation.Nonnull LocalDate startDate) {
    
    this.startDate = startDate;
    return this;
  }

  /**
   * Arrival date
   * @return startDate
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LocalDate getStartDate() {
    return startDate;
  }


  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStartDate(@jakarta.annotation.Nonnull LocalDate startDate) {
    this.startDate = startDate;
  }

  public PropertyBooking endDate(@jakarta.annotation.Nonnull LocalDate endDate) {
    
    this.endDate = endDate;
    return this;
  }

  /**
   * Departure date
   * @return endDate
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LocalDate getEndDate() {
    return endDate;
  }


  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEndDate(@jakarta.annotation.Nonnull LocalDate endDate) {
    this.endDate = endDate;
  }

  public PropertyBooking createdDate(@jakarta.annotation.Nonnull java.time.LocalDateTime createdDate) {
    
    this.createdDate = createdDate;
    return this;
  }

  /**
   * Created date
   * @return createdDate
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_CREATED_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.time.LocalDateTime getCreatedDate() {
    return createdDate;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCreatedDate(@jakarta.annotation.Nonnull java.time.LocalDateTime createdDate) {
    this.createdDate = createdDate;
  }

  public PropertyBooking cancelled(@jakarta.annotation.Nonnull Boolean cancelled) {
    
    this.cancelled = cancelled;
    return this;
  }

  /**
   * Whether booking is cancelled or not
   * @return cancelled
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_CANCELLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getCancelled() {
    return cancelled;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCancelled(@jakarta.annotation.Nonnull Boolean cancelled) {
    this.cancelled = cancelled;
  }

  public PropertyBooking cancelDate(@jakarta.annotation.Nullable java.time.LocalDateTime cancelDate) {
    
    this.cancelDate = cancelDate;
    return this;
  }

  /**
   * Cancellation date if booking was cancelled
   * @return cancelDate
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CANCEL_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getCancelDate() {
    return cancelDate;
  }


  @JsonProperty(JSON_PROPERTY_CANCEL_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancelDate(@jakarta.annotation.Nullable java.time.LocalDateTime cancelDate) {
    this.cancelDate = cancelDate;
  }

  public PropertyBooking paymentMethodType(@jakarta.annotation.Nonnull String paymentMethodType) {
    
    this.paymentMethodType = paymentMethodType;
    return this;
  }

  /**
   * Payment method
   * @return paymentMethodType
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_PAYMENT_METHOD_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getPaymentMethodType() {
    return paymentMethodType;
  }


  @JsonProperty(JSON_PROPERTY_PAYMENT_METHOD_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPaymentMethodType(@jakarta.annotation.Nonnull String paymentMethodType) {
    this.paymentMethodType = paymentMethodType;
  }

  public PropertyBooking paymentWalletType(@jakarta.annotation.Nullable String paymentWalletType) {
    
    this.paymentWalletType = paymentWalletType;
    return this;
  }

  /**
   * Optional payment wallet type
   * @return paymentWalletType
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PAYMENT_WALLET_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPaymentWalletType() {
    return paymentWalletType;
  }


  @JsonProperty(JSON_PROPERTY_PAYMENT_WALLET_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaymentWalletType(@jakarta.annotation.Nullable String paymentWalletType) {
    this.paymentWalletType = paymentWalletType;
  }

  public PropertyBooking paymentMethodStatus(@jakarta.annotation.Nonnull PaymentMethodStatusEnum paymentMethodStatus) {
    
    this.paymentMethodStatus = paymentMethodStatus;
    return this;
  }

  /**
   * Status of payment
   * @return paymentMethodStatus
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_PAYMENT_METHOD_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PaymentMethodStatusEnum getPaymentMethodStatus() {
    return paymentMethodStatus;
  }


  @JsonProperty(JSON_PROPERTY_PAYMENT_METHOD_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPaymentMethodStatus(@jakarta.annotation.Nonnull PaymentMethodStatusEnum paymentMethodStatus) {
    this.paymentMethodStatus = paymentMethodStatus;
  }

  public PropertyBooking salesChannelName(@jakarta.annotation.Nonnull String salesChannelName) {
    
    this.salesChannelName = salesChannelName;
    return this;
  }

  /**
   * Sales channel name
   * @return salesChannelName
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_SALES_CHANNEL_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSalesChannelName() {
    return salesChannelName;
  }


  @JsonProperty(JSON_PROPERTY_SALES_CHANNEL_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSalesChannelName(@jakarta.annotation.Nonnull String salesChannelName) {
    this.salesChannelName = salesChannelName;
  }

  public PropertyBooking salesChannelIdentifier(@jakarta.annotation.Nonnull UUID salesChannelIdentifier) {
    
    this.salesChannelIdentifier = salesChannelIdentifier;
    return this;
  }

  /**
   * Sales channel ID
   * @return salesChannelIdentifier
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_SALES_CHANNEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getSalesChannelIdentifier() {
    return salesChannelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_SALES_CHANNEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSalesChannelIdentifier(@jakarta.annotation.Nonnull UUID salesChannelIdentifier) {
    this.salesChannelIdentifier = salesChannelIdentifier;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PropertyBooking propertyBooking = (PropertyBooking) o;
    return Objects.equals(this.bookingIdentifier, propertyBooking.bookingIdentifier) &&
        Objects.equals(this.propertyIdentifier, propertyBooking.propertyIdentifier) &&
        Objects.equals(this.roomRateIdentifier, propertyBooking.roomRateIdentifier) &&
        Objects.equals(this.name, propertyBooking.name) &&
        Objects.equals(this.guestRoomName, propertyBooking.guestRoomName) &&
        Objects.equals(this.ratePlanName, propertyBooking.ratePlanName) &&
        Objects.equals(this.rooms, propertyBooking.rooms) &&
        Objects.equals(this.guests, propertyBooking.guests) &&
        Objects.equals(this.adults, propertyBooking.adults) &&
        Objects.equals(this.children, propertyBooking.children) &&
        Objects.equals(this.firstName, propertyBooking.firstName) &&
        Objects.equals(this.lastName, propertyBooking.lastName) &&
        Objects.equals(this.email, propertyBooking.email) &&
        Objects.equals(this.amount, propertyBooking.amount) &&
        Objects.equals(this.currencyCode, propertyBooking.currencyCode) &&
        Objects.equals(this.bookingCode, propertyBooking.bookingCode) &&
        Objects.equals(this.startDate, propertyBooking.startDate) &&
        Objects.equals(this.endDate, propertyBooking.endDate) &&
        Objects.equals(this.createdDate, propertyBooking.createdDate) &&
        Objects.equals(this.cancelled, propertyBooking.cancelled) &&
        Objects.equals(this.cancelDate, propertyBooking.cancelDate) &&
        Objects.equals(this.paymentMethodType, propertyBooking.paymentMethodType) &&
        Objects.equals(this.paymentWalletType, propertyBooking.paymentWalletType) &&
        Objects.equals(this.paymentMethodStatus, propertyBooking.paymentMethodStatus) &&
        Objects.equals(this.salesChannelName, propertyBooking.salesChannelName) &&
        Objects.equals(this.salesChannelIdentifier, propertyBooking.salesChannelIdentifier);
  }

  @Override
  public int hashCode() {
    return Objects.hash(bookingIdentifier, propertyIdentifier, roomRateIdentifier, name, guestRoomName, ratePlanName, rooms, guests, adults, children, firstName, lastName, email, amount, currencyCode, bookingCode, startDate, endDate, createdDate, cancelled, cancelDate, paymentMethodType, paymentWalletType, paymentMethodStatus, salesChannelName, salesChannelIdentifier);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PropertyBooking {\n");
    sb.append("    bookingIdentifier: ").append(toIndentedString(bookingIdentifier)).append("\n");
    sb.append("    propertyIdentifier: ").append(toIndentedString(propertyIdentifier)).append("\n");
    sb.append("    roomRateIdentifier: ").append(toIndentedString(roomRateIdentifier)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    guestRoomName: ").append(toIndentedString(guestRoomName)).append("\n");
    sb.append("    ratePlanName: ").append(toIndentedString(ratePlanName)).append("\n");
    sb.append("    rooms: ").append(toIndentedString(rooms)).append("\n");
    sb.append("    guests: ").append(toIndentedString(guests)).append("\n");
    sb.append("    adults: ").append(toIndentedString(adults)).append("\n");
    sb.append("    children: ").append(toIndentedString(children)).append("\n");
    sb.append("    firstName: ").append(toIndentedString(firstName)).append("\n");
    sb.append("    lastName: ").append(toIndentedString(lastName)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    currencyCode: ").append(toIndentedString(currencyCode)).append("\n");
    sb.append("    bookingCode: ").append(toIndentedString(bookingCode)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    createdDate: ").append(toIndentedString(createdDate)).append("\n");
    sb.append("    cancelled: ").append(toIndentedString(cancelled)).append("\n");
    sb.append("    cancelDate: ").append(toIndentedString(cancelDate)).append("\n");
    sb.append("    paymentMethodType: ").append(toIndentedString(paymentMethodType)).append("\n");
    sb.append("    paymentWalletType: ").append(toIndentedString(paymentWalletType)).append("\n");
    sb.append("    paymentMethodStatus: ").append(toIndentedString(paymentMethodStatus)).append("\n");
    sb.append("    salesChannelName: ").append(toIndentedString(salesChannelName)).append("\n");
    sb.append("    salesChannelIdentifier: ").append(toIndentedString(salesChannelIdentifier)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

