/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md   # Channel Manager API Wink exposes a secured REST-based, JSON API to its channel manager partners. The connection is \"channel-wide\". Partners are free to integrate with the REST-based API using any programming language.  # Intended Audience This document is intended for external channel partners who wish to integrate with Wink.  # Requirements - Active account with Wink. Sign up for your Channel Manager account:    - Staging: [https://staging-studio.wink.travel](https://staging-studio.wink.travel).    - Production: [https://studio.wink.travel](https://studio.wink.travel). - Active application. An application provides you with Oauth2 credentials you can pass to our endpoints. One is already created for you upon account creation. - Your production IP numbers. They need to be whitelisted before you can talk to our production environment.  # Performance A particular attention to performance should be given when integrating with this API. A few things to be aware of: - Enable gzip compression to make payloads smaller. - Fewer large REST calls are preferred to many small ones. E.g. It is better to update many dates instead of individual dates. - It is possible to update both rate and availability with a single request. - Request only date ranges that you will use. There is no need to request an entire year if you will only be working with the first seven days.  ## Reservation notification (PUSH) Wink supports PUSH notifications to communicate reservations. We also support BASIC AUTH to your endpoint. If you want to enable PUSH, add your PUSH endpoint and credentials (optional) to your account.
 *
 * The version of the OpenAPI document: 30.17.8
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.channel.manager.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import travel.wink.sdk.channel.manager.model.CustomMonetaryAmount;
import travel.wink.sdk.channel.manager.model.VariableCharge;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * PropertyRoomRate
 */
@JsonPropertyOrder({
  PropertyRoomRate.JSON_PROPERTY_IDENTIFIER,
  PropertyRoomRate.JSON_PROPERTY_PROPERTY_IDENTIFIER,
  PropertyRoomRate.JSON_PROPERTY_NAME,
  PropertyRoomRate.JSON_PROPERTY_ROOM_TYPE_IDENTIFIER,
  PropertyRoomRate.JSON_PROPERTY_RATE_PLAN_IDENTIFIER,
  PropertyRoomRate.JSON_PROPERTY_GUEST_ROOM_NAME,
  PropertyRoomRate.JSON_PROPERTY_RATE_PLAN_NAME,
  PropertyRoomRate.JSON_PROPERTY_MIN_OCCUPANCY,
  PropertyRoomRate.JSON_PROPERTY_MAX_OCCUPANCY,
  PropertyRoomRate.JSON_PROPERTY_MAX_ADULT_OCCUPANCY,
  PropertyRoomRate.JSON_PROPERTY_MAX_CHILD_OCCUPANCY,
  PropertyRoomRate.JSON_PROPERTY_INCLUDED_ADULT_OCCUPANCY,
  PropertyRoomRate.JSON_PROPERTY_INCLUDED_CHILD_OCCUPANCY,
  PropertyRoomRate.JSON_PROPERTY_BASE_RATE,
  PropertyRoomRate.JSON_PROPERTY_SINGLE_OCCUPANCY_RATE_MODIFIER,
  PropertyRoomRate.JSON_PROPERTY_EXTRA_PAX_RATE_MODIFIER,
  PropertyRoomRate.JSON_PROPERTY_EXTRA_CHILD_RATE_MODIFIER
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-26T20:17:17.459970342+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class PropertyRoomRate {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  @jakarta.annotation.Nonnull
  private String identifier;

  public static final String JSON_PROPERTY_PROPERTY_IDENTIFIER = "propertyIdentifier";
  @jakarta.annotation.Nonnull
  private String propertyIdentifier;

  public static final String JSON_PROPERTY_NAME = "name";
  @jakarta.annotation.Nonnull
  private String name;

  public static final String JSON_PROPERTY_ROOM_TYPE_IDENTIFIER = "roomTypeIdentifier";
  @jakarta.annotation.Nonnull
  private String roomTypeIdentifier;

  public static final String JSON_PROPERTY_RATE_PLAN_IDENTIFIER = "ratePlanIdentifier";
  @jakarta.annotation.Nonnull
  private String ratePlanIdentifier;

  public static final String JSON_PROPERTY_GUEST_ROOM_NAME = "guestRoomName";
  @jakarta.annotation.Nonnull
  private String guestRoomName;

  public static final String JSON_PROPERTY_RATE_PLAN_NAME = "ratePlanName";
  @jakarta.annotation.Nonnull
  private String ratePlanName;

  public static final String JSON_PROPERTY_MIN_OCCUPANCY = "minOccupancy";
  @jakarta.annotation.Nonnull
  private Integer minOccupancy;

  public static final String JSON_PROPERTY_MAX_OCCUPANCY = "maxOccupancy";
  @jakarta.annotation.Nonnull
  private Integer maxOccupancy;

  public static final String JSON_PROPERTY_MAX_ADULT_OCCUPANCY = "maxAdultOccupancy";
  @jakarta.annotation.Nonnull
  private Integer maxAdultOccupancy;

  public static final String JSON_PROPERTY_MAX_CHILD_OCCUPANCY = "maxChildOccupancy";
  @jakarta.annotation.Nonnull
  private Integer maxChildOccupancy;

  public static final String JSON_PROPERTY_INCLUDED_ADULT_OCCUPANCY = "includedAdultOccupancy";
  @jakarta.annotation.Nonnull
  private Integer includedAdultOccupancy;

  public static final String JSON_PROPERTY_INCLUDED_CHILD_OCCUPANCY = "includedChildOccupancy";
  @jakarta.annotation.Nonnull
  private Integer includedChildOccupancy;

  public static final String JSON_PROPERTY_BASE_RATE = "baseRate";
  @jakarta.annotation.Nonnull
  private CustomMonetaryAmount baseRate;

  public static final String JSON_PROPERTY_SINGLE_OCCUPANCY_RATE_MODIFIER = "singleOccupancyRateModifier";
  @jakarta.annotation.Nonnull
  private VariableCharge singleOccupancyRateModifier;

  public static final String JSON_PROPERTY_EXTRA_PAX_RATE_MODIFIER = "extraPaxRateModifier";
  @jakarta.annotation.Nonnull
  private VariableCharge extraPaxRateModifier;

  public static final String JSON_PROPERTY_EXTRA_CHILD_RATE_MODIFIER = "extraChildRateModifier";
  @jakarta.annotation.Nonnull
  private VariableCharge extraChildRateModifier;

  public PropertyRoomRate() {
  }

  public PropertyRoomRate identifier(@jakarta.annotation.Nonnull String identifier) {
    
    this.identifier = identifier;
    return this;
  }

  /**
   * Get identifier
   * @return identifier
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(@jakarta.annotation.Nonnull String identifier) {
    this.identifier = identifier;
  }

  public PropertyRoomRate propertyIdentifier(@jakarta.annotation.Nonnull String propertyIdentifier) {
    
    this.propertyIdentifier = propertyIdentifier;
    return this;
  }

  /**
   * Get propertyIdentifier
   * @return propertyIdentifier
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getPropertyIdentifier() {
    return propertyIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPropertyIdentifier(@jakarta.annotation.Nonnull String propertyIdentifier) {
    this.propertyIdentifier = propertyIdentifier;
  }

  public PropertyRoomRate name(@jakarta.annotation.Nonnull String name) {
    
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(@jakarta.annotation.Nonnull String name) {
    this.name = name;
  }

  public PropertyRoomRate roomTypeIdentifier(@jakarta.annotation.Nonnull String roomTypeIdentifier) {
    
    this.roomTypeIdentifier = roomTypeIdentifier;
    return this;
  }

  /**
   * Get roomTypeIdentifier
   * @return roomTypeIdentifier
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_ROOM_TYPE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRoomTypeIdentifier() {
    return roomTypeIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_TYPE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoomTypeIdentifier(@jakarta.annotation.Nonnull String roomTypeIdentifier) {
    this.roomTypeIdentifier = roomTypeIdentifier;
  }

  public PropertyRoomRate ratePlanIdentifier(@jakarta.annotation.Nonnull String ratePlanIdentifier) {
    
    this.ratePlanIdentifier = ratePlanIdentifier;
    return this;
  }

  /**
   * Get ratePlanIdentifier
   * @return ratePlanIdentifier
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_RATE_PLAN_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRatePlanIdentifier() {
    return ratePlanIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_RATE_PLAN_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRatePlanIdentifier(@jakarta.annotation.Nonnull String ratePlanIdentifier) {
    this.ratePlanIdentifier = ratePlanIdentifier;
  }

  public PropertyRoomRate guestRoomName(@jakarta.annotation.Nonnull String guestRoomName) {
    
    this.guestRoomName = guestRoomName;
    return this;
  }

  /**
   * Get guestRoomName
   * @return guestRoomName
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_GUEST_ROOM_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getGuestRoomName() {
    return guestRoomName;
  }


  @JsonProperty(JSON_PROPERTY_GUEST_ROOM_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setGuestRoomName(@jakarta.annotation.Nonnull String guestRoomName) {
    this.guestRoomName = guestRoomName;
  }

  public PropertyRoomRate ratePlanName(@jakarta.annotation.Nonnull String ratePlanName) {
    
    this.ratePlanName = ratePlanName;
    return this;
  }

  /**
   * Get ratePlanName
   * @return ratePlanName
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_RATE_PLAN_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRatePlanName() {
    return ratePlanName;
  }


  @JsonProperty(JSON_PROPERTY_RATE_PLAN_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRatePlanName(@jakarta.annotation.Nonnull String ratePlanName) {
    this.ratePlanName = ratePlanName;
  }

  public PropertyRoomRate minOccupancy(@jakarta.annotation.Nonnull Integer minOccupancy) {
    
    this.minOccupancy = minOccupancy;
    return this;
  }

  /**
   * Get minOccupancy
   * @return minOccupancy
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_MIN_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getMinOccupancy() {
    return minOccupancy;
  }


  @JsonProperty(JSON_PROPERTY_MIN_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMinOccupancy(@jakarta.annotation.Nonnull Integer minOccupancy) {
    this.minOccupancy = minOccupancy;
  }

  public PropertyRoomRate maxOccupancy(@jakarta.annotation.Nonnull Integer maxOccupancy) {
    
    this.maxOccupancy = maxOccupancy;
    return this;
  }

  /**
   * Get maxOccupancy
   * @return maxOccupancy
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_MAX_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getMaxOccupancy() {
    return maxOccupancy;
  }


  @JsonProperty(JSON_PROPERTY_MAX_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMaxOccupancy(@jakarta.annotation.Nonnull Integer maxOccupancy) {
    this.maxOccupancy = maxOccupancy;
  }

  public PropertyRoomRate maxAdultOccupancy(@jakarta.annotation.Nonnull Integer maxAdultOccupancy) {
    
    this.maxAdultOccupancy = maxAdultOccupancy;
    return this;
  }

  /**
   * Get maxAdultOccupancy
   * @return maxAdultOccupancy
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_MAX_ADULT_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getMaxAdultOccupancy() {
    return maxAdultOccupancy;
  }


  @JsonProperty(JSON_PROPERTY_MAX_ADULT_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMaxAdultOccupancy(@jakarta.annotation.Nonnull Integer maxAdultOccupancy) {
    this.maxAdultOccupancy = maxAdultOccupancy;
  }

  public PropertyRoomRate maxChildOccupancy(@jakarta.annotation.Nonnull Integer maxChildOccupancy) {
    
    this.maxChildOccupancy = maxChildOccupancy;
    return this;
  }

  /**
   * Get maxChildOccupancy
   * @return maxChildOccupancy
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_MAX_CHILD_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getMaxChildOccupancy() {
    return maxChildOccupancy;
  }


  @JsonProperty(JSON_PROPERTY_MAX_CHILD_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMaxChildOccupancy(@jakarta.annotation.Nonnull Integer maxChildOccupancy) {
    this.maxChildOccupancy = maxChildOccupancy;
  }

  public PropertyRoomRate includedAdultOccupancy(@jakarta.annotation.Nonnull Integer includedAdultOccupancy) {
    
    this.includedAdultOccupancy = includedAdultOccupancy;
    return this;
  }

  /**
   * Get includedAdultOccupancy
   * @return includedAdultOccupancy
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_INCLUDED_ADULT_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getIncludedAdultOccupancy() {
    return includedAdultOccupancy;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDED_ADULT_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIncludedAdultOccupancy(@jakarta.annotation.Nonnull Integer includedAdultOccupancy) {
    this.includedAdultOccupancy = includedAdultOccupancy;
  }

  public PropertyRoomRate includedChildOccupancy(@jakarta.annotation.Nonnull Integer includedChildOccupancy) {
    
    this.includedChildOccupancy = includedChildOccupancy;
    return this;
  }

  /**
   * Get includedChildOccupancy
   * @return includedChildOccupancy
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_INCLUDED_CHILD_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getIncludedChildOccupancy() {
    return includedChildOccupancy;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDED_CHILD_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIncludedChildOccupancy(@jakarta.annotation.Nonnull Integer includedChildOccupancy) {
    this.includedChildOccupancy = includedChildOccupancy;
  }

  public PropertyRoomRate baseRate(@jakarta.annotation.Nonnull CustomMonetaryAmount baseRate) {
    
    this.baseRate = baseRate;
    return this;
  }

  /**
   * Get baseRate
   * @return baseRate
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_BASE_RATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CustomMonetaryAmount getBaseRate() {
    return baseRate;
  }


  @JsonProperty(JSON_PROPERTY_BASE_RATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBaseRate(@jakarta.annotation.Nonnull CustomMonetaryAmount baseRate) {
    this.baseRate = baseRate;
  }

  public PropertyRoomRate singleOccupancyRateModifier(@jakarta.annotation.Nonnull VariableCharge singleOccupancyRateModifier) {
    
    this.singleOccupancyRateModifier = singleOccupancyRateModifier;
    return this;
  }

  /**
   * Get singleOccupancyRateModifier
   * @return singleOccupancyRateModifier
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_SINGLE_OCCUPANCY_RATE_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public VariableCharge getSingleOccupancyRateModifier() {
    return singleOccupancyRateModifier;
  }


  @JsonProperty(JSON_PROPERTY_SINGLE_OCCUPANCY_RATE_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSingleOccupancyRateModifier(@jakarta.annotation.Nonnull VariableCharge singleOccupancyRateModifier) {
    this.singleOccupancyRateModifier = singleOccupancyRateModifier;
  }

  public PropertyRoomRate extraPaxRateModifier(@jakarta.annotation.Nonnull VariableCharge extraPaxRateModifier) {
    
    this.extraPaxRateModifier = extraPaxRateModifier;
    return this;
  }

  /**
   * Get extraPaxRateModifier
   * @return extraPaxRateModifier
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_EXTRA_PAX_RATE_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public VariableCharge getExtraPaxRateModifier() {
    return extraPaxRateModifier;
  }


  @JsonProperty(JSON_PROPERTY_EXTRA_PAX_RATE_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setExtraPaxRateModifier(@jakarta.annotation.Nonnull VariableCharge extraPaxRateModifier) {
    this.extraPaxRateModifier = extraPaxRateModifier;
  }

  public PropertyRoomRate extraChildRateModifier(@jakarta.annotation.Nonnull VariableCharge extraChildRateModifier) {
    
    this.extraChildRateModifier = extraChildRateModifier;
    return this;
  }

  /**
   * Get extraChildRateModifier
   * @return extraChildRateModifier
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_EXTRA_CHILD_RATE_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public VariableCharge getExtraChildRateModifier() {
    return extraChildRateModifier;
  }


  @JsonProperty(JSON_PROPERTY_EXTRA_CHILD_RATE_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setExtraChildRateModifier(@jakarta.annotation.Nonnull VariableCharge extraChildRateModifier) {
    this.extraChildRateModifier = extraChildRateModifier;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PropertyRoomRate propertyRoomRate = (PropertyRoomRate) o;
    return Objects.equals(this.identifier, propertyRoomRate.identifier) &&
        Objects.equals(this.propertyIdentifier, propertyRoomRate.propertyIdentifier) &&
        Objects.equals(this.name, propertyRoomRate.name) &&
        Objects.equals(this.roomTypeIdentifier, propertyRoomRate.roomTypeIdentifier) &&
        Objects.equals(this.ratePlanIdentifier, propertyRoomRate.ratePlanIdentifier) &&
        Objects.equals(this.guestRoomName, propertyRoomRate.guestRoomName) &&
        Objects.equals(this.ratePlanName, propertyRoomRate.ratePlanName) &&
        Objects.equals(this.minOccupancy, propertyRoomRate.minOccupancy) &&
        Objects.equals(this.maxOccupancy, propertyRoomRate.maxOccupancy) &&
        Objects.equals(this.maxAdultOccupancy, propertyRoomRate.maxAdultOccupancy) &&
        Objects.equals(this.maxChildOccupancy, propertyRoomRate.maxChildOccupancy) &&
        Objects.equals(this.includedAdultOccupancy, propertyRoomRate.includedAdultOccupancy) &&
        Objects.equals(this.includedChildOccupancy, propertyRoomRate.includedChildOccupancy) &&
        Objects.equals(this.baseRate, propertyRoomRate.baseRate) &&
        Objects.equals(this.singleOccupancyRateModifier, propertyRoomRate.singleOccupancyRateModifier) &&
        Objects.equals(this.extraPaxRateModifier, propertyRoomRate.extraPaxRateModifier) &&
        Objects.equals(this.extraChildRateModifier, propertyRoomRate.extraChildRateModifier);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, propertyIdentifier, name, roomTypeIdentifier, ratePlanIdentifier, guestRoomName, ratePlanName, minOccupancy, maxOccupancy, maxAdultOccupancy, maxChildOccupancy, includedAdultOccupancy, includedChildOccupancy, baseRate, singleOccupancyRateModifier, extraPaxRateModifier, extraChildRateModifier);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PropertyRoomRate {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    propertyIdentifier: ").append(toIndentedString(propertyIdentifier)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    roomTypeIdentifier: ").append(toIndentedString(roomTypeIdentifier)).append("\n");
    sb.append("    ratePlanIdentifier: ").append(toIndentedString(ratePlanIdentifier)).append("\n");
    sb.append("    guestRoomName: ").append(toIndentedString(guestRoomName)).append("\n");
    sb.append("    ratePlanName: ").append(toIndentedString(ratePlanName)).append("\n");
    sb.append("    minOccupancy: ").append(toIndentedString(minOccupancy)).append("\n");
    sb.append("    maxOccupancy: ").append(toIndentedString(maxOccupancy)).append("\n");
    sb.append("    maxAdultOccupancy: ").append(toIndentedString(maxAdultOccupancy)).append("\n");
    sb.append("    maxChildOccupancy: ").append(toIndentedString(maxChildOccupancy)).append("\n");
    sb.append("    includedAdultOccupancy: ").append(toIndentedString(includedAdultOccupancy)).append("\n");
    sb.append("    includedChildOccupancy: ").append(toIndentedString(includedChildOccupancy)).append("\n");
    sb.append("    baseRate: ").append(toIndentedString(baseRate)).append("\n");
    sb.append("    singleOccupancyRateModifier: ").append(toIndentedString(singleOccupancyRateModifier)).append("\n");
    sb.append("    extraPaxRateModifier: ").append(toIndentedString(extraPaxRateModifier)).append("\n");
    sb.append("    extraChildRateModifier: ").append(toIndentedString(extraChildRateModifier)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

