/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.channel.manager.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import travel.wink.sdk.channel.manager.model.PropertyRate;
import travel.wink.sdk.channel.manager.model.PropertyRoomRate;

@JsonPropertyOrder(value={"room", "rates", "startDate", "endDate"})
public class PropertyRoomRateWithRateList {
    public static final String JSON_PROPERTY_ROOM = "room";
    @Nonnull
    private PropertyRoomRate room;
    public static final String JSON_PROPERTY_RATES = "rates";
    @Nullable
    private List<@Valid PropertyRate> rates = new ArrayList<PropertyRate>();
    public static final String JSON_PROPERTY_START_DATE = "startDate";
    @Nullable
    private LocalDate startDate;
    public static final String JSON_PROPERTY_END_DATE = "endDate";
    @Nullable
    private LocalDate endDate;

    public PropertyRoomRateWithRateList room(@Nonnull PropertyRoomRate room) {
        this.room = room;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="room")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PropertyRoomRate getRoom() {
        return this.room;
    }

    @JsonProperty(value="room")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoom(@Nonnull PropertyRoomRate room) {
        this.room = room;
    }

    public PropertyRoomRateWithRateList rates(@Nullable List<@Valid PropertyRate> rates) {
        this.rates = rates;
        return this;
    }

    public PropertyRoomRateWithRateList addRatesItem(PropertyRate ratesItem) {
        if (this.rates == null) {
            this.rates = new ArrayList<PropertyRate>();
        }
        this.rates.add(ratesItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="rates")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Valid List<@Valid PropertyRate> getRates() {
        return this.rates;
    }

    @JsonProperty(value="rates")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRates(@Nullable List<@Valid PropertyRate> rates) {
        this.rates = rates;
    }

    public PropertyRoomRateWithRateList startDate(@Nullable LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStartDate(@Nullable LocalDate startDate) {
        this.startDate = startDate;
    }

    public PropertyRoomRateWithRateList endDate(@Nullable LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEndDate(@Nullable LocalDate endDate) {
        this.endDate = endDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyRoomRateWithRateList propertyRoomRateWithRateList = (PropertyRoomRateWithRateList)o;
        return Objects.equals(this.room, propertyRoomRateWithRateList.room) && Objects.equals(this.rates, propertyRoomRateWithRateList.rates) && Objects.equals(this.startDate, propertyRoomRateWithRateList.startDate) && Objects.equals(this.endDate, propertyRoomRateWithRateList.endDate);
    }

    public int hashCode() {
        return Objects.hash(this.room, this.rates, this.startDate, this.endDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PropertyRoomRateWithRateList {\n");
        sb.append("    room: ").append(this.toIndentedString(this.room)).append("\n");
        sb.append("    rates: ").append(this.toIndentedString(this.rates)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

