package com.duffel.sdk.api;

import com.duffel.sdk.invoker.ApiClient;

import com.duffel.sdk.model.CreateOrderRequest;
import com.duffel.sdk.model.GetOrderById200Response;
import com.duffel.sdk.model.GetOrders200Response;
import com.duffel.sdk.model.GetOrdersArrivingAtParameter;
import com.duffel.sdk.model.GetOrdersCreatedAtParameter;
import com.duffel.sdk.model.GetOrdersDepartingAtParameter;
import com.duffel.sdk.model.UpdateOrderByIdRequest;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:13:42.592945+07:00[Asia/Bangkok]")
public class OrdersApi {
    private ApiClient apiClient;

    public OrdersApi() {
        this(new ApiClient());
    }

    @Autowired
    public OrdersApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create an order
     * Creates a booking with an airline based on an offer.  Orders are usually paid at the time of creation, but can be held and paid for at a later date if the offer supports it (see &#x60;offer.payment_requirements.requires_instant_payment&#x60;). To create an order and pay for it at the same time, specify a &#x60;payments&#x60; key. To hold the order and pay for it later, specify the type as &#x60;hold&#x60;, omit the &#x60;payments&#x60; and &#x60;services&#x60; keys, and complete payment after creating the order through the [Create a payment endpoint](/docs/api/payments/create-payment).  When presenting an order confirmation to your customers (e.g. on screen or in an email), you should include  the &#x60;booking_reference&#x60; and details of the full itinerary and show the full name of the operating carrier  of each segment (&#x60;slices[].segments[].operating_carrier.name&#x60;) in order to comply with [US regulations](https://www.ecfr.gov/cgi-bin/text-idx?SID&#x3D;8e736a5c813a737a5c2f6700a4c9006d&amp;mc&#x3D;true&amp;node&#x3D;pt14.4.257&amp;rgn&#x3D;div5).  ### Validation errors  | Field      | Code                                             | Description                                                                                                                                | | ---------- | ------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------ | | &#x60;payments&#x60; | &#x60;payments_not_allowed_for_order_type&#x60;            | You’ve included a &#x60;payments&#x60; key for a &#x60;hold&#x60; order, but the key should be omitted.                                                        | | &#x60;services&#x60; | &#x60;services_not_allowed_for_order_type&#x60;            | You’ve included &#x60;services&#x60; for a &#x60;hold&#x60; order, but they’re not currently supported.                                                        | | &#x60;type&#x60;     | &#x60;not_valid_with_selected_offer&#x60;                  | The type is not valid with selected offer because either &#x60;requires_instant_payment&#x60; is &#x60;true&#x60; or the &#x60;payment_required_by&#x60; is in the past. | 
     * <p><b>201</b> - An order
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param createOrderRequest The createOrderRequest parameter
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param contentType All request bodies sent to the API should be in JSON format. A &#x60;Content-Type&#x60; header is required whenever you&#39;re sending a request body (i.e. for POST and PUT requests).
     * @return GetOrderById200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createOrderRequestCreation(String accept, String duffelVersion, CreateOrderRequest createOrderRequest, String acceptEncoding, String contentType) throws WebClientResponseException {
        Object postBody = createOrderRequest;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling createOrder", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling createOrder", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'createOrderRequest' is set
        if (createOrderRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'createOrderRequest' when calling createOrder", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (contentType != null)
        headerParams.add("Content-Type", apiClient.parameterToString(contentType));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "bearerAuth" };

        ParameterizedTypeReference<GetOrderById200Response> localVarReturnType = new ParameterizedTypeReference<GetOrderById200Response>() {};
        return apiClient.invokeAPI("/air/orders", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create an order
     * Creates a booking with an airline based on an offer.  Orders are usually paid at the time of creation, but can be held and paid for at a later date if the offer supports it (see &#x60;offer.payment_requirements.requires_instant_payment&#x60;). To create an order and pay for it at the same time, specify a &#x60;payments&#x60; key. To hold the order and pay for it later, specify the type as &#x60;hold&#x60;, omit the &#x60;payments&#x60; and &#x60;services&#x60; keys, and complete payment after creating the order through the [Create a payment endpoint](/docs/api/payments/create-payment).  When presenting an order confirmation to your customers (e.g. on screen or in an email), you should include  the &#x60;booking_reference&#x60; and details of the full itinerary and show the full name of the operating carrier  of each segment (&#x60;slices[].segments[].operating_carrier.name&#x60;) in order to comply with [US regulations](https://www.ecfr.gov/cgi-bin/text-idx?SID&#x3D;8e736a5c813a737a5c2f6700a4c9006d&amp;mc&#x3D;true&amp;node&#x3D;pt14.4.257&amp;rgn&#x3D;div5).  ### Validation errors  | Field      | Code                                             | Description                                                                                                                                | | ---------- | ------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------ | | &#x60;payments&#x60; | &#x60;payments_not_allowed_for_order_type&#x60;            | You’ve included a &#x60;payments&#x60; key for a &#x60;hold&#x60; order, but the key should be omitted.                                                        | | &#x60;services&#x60; | &#x60;services_not_allowed_for_order_type&#x60;            | You’ve included &#x60;services&#x60; for a &#x60;hold&#x60; order, but they’re not currently supported.                                                        | | &#x60;type&#x60;     | &#x60;not_valid_with_selected_offer&#x60;                  | The type is not valid with selected offer because either &#x60;requires_instant_payment&#x60; is &#x60;true&#x60; or the &#x60;payment_required_by&#x60; is in the past. | 
     * <p><b>201</b> - An order
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param createOrderRequest The createOrderRequest parameter
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param contentType All request bodies sent to the API should be in JSON format. A &#x60;Content-Type&#x60; header is required whenever you&#39;re sending a request body (i.e. for POST and PUT requests).
     * @return GetOrderById200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GetOrderById200Response> createOrder(String accept, String duffelVersion, CreateOrderRequest createOrderRequest, String acceptEncoding, String contentType) throws WebClientResponseException {
        ParameterizedTypeReference<GetOrderById200Response> localVarReturnType = new ParameterizedTypeReference<GetOrderById200Response>() {};
        return createOrderRequestCreation(accept, duffelVersion, createOrderRequest, acceptEncoding, contentType).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<GetOrderById200Response>> createOrderWithHttpInfo(String accept, String duffelVersion, CreateOrderRequest createOrderRequest, String acceptEncoding, String contentType) throws WebClientResponseException {
        ParameterizedTypeReference<GetOrderById200Response> localVarReturnType = new ParameterizedTypeReference<GetOrderById200Response>() {};
        return createOrderRequestCreation(accept, duffelVersion, createOrderRequest, acceptEncoding, contentType).toEntity(localVarReturnType);
    }
    /**
     * Get a single order
     * Retrieves an order by its ID
     * <p><b>200</b> - A single order
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the order
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @return GetOrderById200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec getOrderByIdRequestCreation(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling getOrderById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling getOrderById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling getOrderById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "bearerAuth" };

        ParameterizedTypeReference<GetOrderById200Response> localVarReturnType = new ParameterizedTypeReference<GetOrderById200Response>() {};
        return apiClient.invokeAPI("/air/orders/{id}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Get a single order
     * Retrieves an order by its ID
     * <p><b>200</b> - A single order
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the order
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @return GetOrderById200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GetOrderById200Response> getOrderById(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        ParameterizedTypeReference<GetOrderById200Response> localVarReturnType = new ParameterizedTypeReference<GetOrderById200Response>() {};
        return getOrderByIdRequestCreation(accept, duffelVersion, id, acceptEncoding).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<GetOrderById200Response>> getOrderByIdWithHttpInfo(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        ParameterizedTypeReference<GetOrderById200Response> localVarReturnType = new ParameterizedTypeReference<GetOrderById200Response>() {};
        return getOrderByIdRequestCreation(accept, duffelVersion, id, acceptEncoding).toEntity(localVarReturnType);
    }
    /**
     * List orders
     * Retrieves a paginated list of all orders. The results may be returned in  any order, unless a sorting parameter is provided. 
     * <p><b>200</b> - A paginated list of orders
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param after A cursor pointing to the previous page of records. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param before A cursor pointing to the next page of records. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param limit The maximum number of records to return per page. Defaults to &#x60;50&#x60;.  May be set to any integer between &#x60;1&#x60; and &#x60;200&#x60;. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param bookingReference Filters orders by their &#x60;booking reference&#x60;.  The filter requires an exact match but is case insensitive. 
     * @param awaitingPayment Whether to filter orders that are awaiting payment or not. If not specified, all orders regardless of their payment state will be returned. 
     * @param sort By default, orders aren&#39;t returned in any specific order. This parameter allows you to sort the list of orders by the &#x60;payment_required_by&#x60;, &#x60;total_amount&#x60;, &#x60;created_at&#x60;, or &#x60;next_departure&#x60;. If you wish to sort in descending order, a &#x60;-&#x60; prefix will be needed (e.g. &#x60;-payment_required_by&#x60;). When sorting by next departure (&#x60;next_departure&#x60;), flown orders will be last. 
     * @param ownerId Filters the returned orders by &#x60;owner.id&#x60;. Values must be valid &#x60;airline.id&#x60;s. Check the [Airline schema](/docs/api/airlines/schema#id) for details. 
     * @param originId Filters the returned orders by &#x60;origin&#x60;. Values must be valid origin identifiers. Check the [Order schema](/docs/api/orders#slices-origin-id) for details.  Orders will be included if **any** of their slices matches the given criteria. 
     * @param destinationId Filters the returned orders by &#x60;destination&#x60;. Values must be valid destination identifiers. Check the [Order schema](/docs/api/orders#slices-destination-id) for details.  Orders will be included if **any** of their slices matches the given criteria. 
     * @param departingAt Filters the returned orders by [departure datetime](/docs/api/orders/schema#slices-segments-departing_at). Orders will be included if **any** of their segments matches the given criteria. 
     * @param arrivingAt Filters the returned orders by [arrival datetime](/docs/api/orders/schema#slices-segments-arriving_at). Orders will be included if **any** of their segments matches the given criteria. 
     * @param createdAt Filters the returned orders by [creation datetime](docs/api/orders#created_at). 
     * @param passengerName Filters the returned orders by passengers&#39; &#x60;family_name&#x60; and &#x60;given_name&#x60;.  Orders will be included if **any** of their passengers matches **any** of the given names. Matches are case insensitive, and include partial matches.  For example, &#x60;?passenger_name[]&#x3D;roger&#x60; will return orders for both &#x60;Anna Rogers&#x60; and &#x60;Roger Smith&#x60;. 
     * @param requiresAction Orders will be included if they have any Airline-Inititated Changes that are unactioned. 
     * @return GetOrders200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec getOrdersRequestCreation(String accept, String duffelVersion, String acceptEncoding, String after, String before, Integer limit, String bookingReference, Boolean awaitingPayment, String sort, List<String> ownerId, List<String> originId, List<String> destinationId, GetOrdersDepartingAtParameter departingAt, GetOrdersArrivingAtParameter arrivingAt, GetOrdersCreatedAtParameter createdAt, List<String> passengerName, Boolean requiresAction) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling getOrders", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling getOrders", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "before", before));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "booking_reference", bookingReference));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "awaiting_payment", awaitingPayment));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "sort", sort));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "owner_id[]", ownerId));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "origin_id[]", originId));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "destination_id[]", destinationId));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "departing_at", departingAt));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "arriving_at", arrivingAt));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "created_at", createdAt));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "passenger_name[]", passengerName));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "requires_action", requiresAction));

        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "bearerAuth" };

        ParameterizedTypeReference<GetOrders200Response> localVarReturnType = new ParameterizedTypeReference<GetOrders200Response>() {};
        return apiClient.invokeAPI("/air/orders", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List orders
     * Retrieves a paginated list of all orders. The results may be returned in  any order, unless a sorting parameter is provided. 
     * <p><b>200</b> - A paginated list of orders
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param after A cursor pointing to the previous page of records. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param before A cursor pointing to the next page of records. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param limit The maximum number of records to return per page. Defaults to &#x60;50&#x60;.  May be set to any integer between &#x60;1&#x60; and &#x60;200&#x60;. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param bookingReference Filters orders by their &#x60;booking reference&#x60;.  The filter requires an exact match but is case insensitive. 
     * @param awaitingPayment Whether to filter orders that are awaiting payment or not. If not specified, all orders regardless of their payment state will be returned. 
     * @param sort By default, orders aren&#39;t returned in any specific order. This parameter allows you to sort the list of orders by the &#x60;payment_required_by&#x60;, &#x60;total_amount&#x60;, &#x60;created_at&#x60;, or &#x60;next_departure&#x60;. If you wish to sort in descending order, a &#x60;-&#x60; prefix will be needed (e.g. &#x60;-payment_required_by&#x60;). When sorting by next departure (&#x60;next_departure&#x60;), flown orders will be last. 
     * @param ownerId Filters the returned orders by &#x60;owner.id&#x60;. Values must be valid &#x60;airline.id&#x60;s. Check the [Airline schema](/docs/api/airlines/schema#id) for details. 
     * @param originId Filters the returned orders by &#x60;origin&#x60;. Values must be valid origin identifiers. Check the [Order schema](/docs/api/orders#slices-origin-id) for details.  Orders will be included if **any** of their slices matches the given criteria. 
     * @param destinationId Filters the returned orders by &#x60;destination&#x60;. Values must be valid destination identifiers. Check the [Order schema](/docs/api/orders#slices-destination-id) for details.  Orders will be included if **any** of their slices matches the given criteria. 
     * @param departingAt Filters the returned orders by [departure datetime](/docs/api/orders/schema#slices-segments-departing_at). Orders will be included if **any** of their segments matches the given criteria. 
     * @param arrivingAt Filters the returned orders by [arrival datetime](/docs/api/orders/schema#slices-segments-arriving_at). Orders will be included if **any** of their segments matches the given criteria. 
     * @param createdAt Filters the returned orders by [creation datetime](docs/api/orders#created_at). 
     * @param passengerName Filters the returned orders by passengers&#39; &#x60;family_name&#x60; and &#x60;given_name&#x60;.  Orders will be included if **any** of their passengers matches **any** of the given names. Matches are case insensitive, and include partial matches.  For example, &#x60;?passenger_name[]&#x3D;roger&#x60; will return orders for both &#x60;Anna Rogers&#x60; and &#x60;Roger Smith&#x60;. 
     * @param requiresAction Orders will be included if they have any Airline-Inititated Changes that are unactioned. 
     * @return GetOrders200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GetOrders200Response> getOrders(String accept, String duffelVersion, String acceptEncoding, String after, String before, Integer limit, String bookingReference, Boolean awaitingPayment, String sort, List<String> ownerId, List<String> originId, List<String> destinationId, GetOrdersDepartingAtParameter departingAt, GetOrdersArrivingAtParameter arrivingAt, GetOrdersCreatedAtParameter createdAt, List<String> passengerName, Boolean requiresAction) throws WebClientResponseException {
        ParameterizedTypeReference<GetOrders200Response> localVarReturnType = new ParameterizedTypeReference<GetOrders200Response>() {};
        return getOrdersRequestCreation(accept, duffelVersion, acceptEncoding, after, before, limit, bookingReference, awaitingPayment, sort, ownerId, originId, destinationId, departingAt, arrivingAt, createdAt, passengerName, requiresAction).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<GetOrders200Response>> getOrdersWithHttpInfo(String accept, String duffelVersion, String acceptEncoding, String after, String before, Integer limit, String bookingReference, Boolean awaitingPayment, String sort, List<String> ownerId, List<String> originId, List<String> destinationId, GetOrdersDepartingAtParameter departingAt, GetOrdersArrivingAtParameter arrivingAt, GetOrdersCreatedAtParameter createdAt, List<String> passengerName, Boolean requiresAction) throws WebClientResponseException {
        ParameterizedTypeReference<GetOrders200Response> localVarReturnType = new ParameterizedTypeReference<GetOrders200Response>() {};
        return getOrdersRequestCreation(accept, duffelVersion, acceptEncoding, after, before, limit, bookingReference, awaitingPayment, sort, ownerId, originId, destinationId, departingAt, arrivingAt, createdAt, passengerName, requiresAction).toEntity(localVarReturnType);
    }
    /**
     * Update a single order
     * Some order fields are updateable. Each field that can be updated is detailed in the request object. 
     * <p><b>200</b> - A single order
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the order
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param updateOrderByIdRequest The updateOrderByIdRequest parameter
     * @return GetOrderById200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateOrderByIdRequestCreation(String accept, String duffelVersion, String id, String acceptEncoding, UpdateOrderByIdRequest updateOrderByIdRequest) throws WebClientResponseException {
        Object postBody = updateOrderByIdRequest;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling updateOrderById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling updateOrderById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling updateOrderById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<GetOrderById200Response> localVarReturnType = new ParameterizedTypeReference<GetOrderById200Response>() {};
        return apiClient.invokeAPI("/air/orders/{id}", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update a single order
     * Some order fields are updateable. Each field that can be updated is detailed in the request object. 
     * <p><b>200</b> - A single order
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the order
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param updateOrderByIdRequest The updateOrderByIdRequest parameter
     * @return GetOrderById200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GetOrderById200Response> updateOrderById(String accept, String duffelVersion, String id, String acceptEncoding, UpdateOrderByIdRequest updateOrderByIdRequest) throws WebClientResponseException {
        ParameterizedTypeReference<GetOrderById200Response> localVarReturnType = new ParameterizedTypeReference<GetOrderById200Response>() {};
        return updateOrderByIdRequestCreation(accept, duffelVersion, id, acceptEncoding, updateOrderByIdRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<GetOrderById200Response>> updateOrderByIdWithHttpInfo(String accept, String duffelVersion, String id, String acceptEncoding, UpdateOrderByIdRequest updateOrderByIdRequest) throws WebClientResponseException {
        ParameterizedTypeReference<GetOrderById200Response> localVarReturnType = new ParameterizedTypeReference<GetOrderById200Response>() {};
        return updateOrderByIdRequestCreation(accept, duffelVersion, id, acceptEncoding, updateOrderByIdRequest).toEntity(localVarReturnType);
    }
}
