/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * CreatePaymentIntentRequestData
 */
@JsonPropertyOrder({
  CreatePaymentIntentRequestData.JSON_PROPERTY_AMOUNT,
  CreatePaymentIntentRequestData.JSON_PROPERTY_CURRENCY
})
@JsonTypeName("createPaymentIntent_request_data")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:13:42.592945+07:00[Asia/Bangkok]")
public class CreatePaymentIntentRequestData {
  public static final String JSON_PROPERTY_AMOUNT = "amount";
  private String amount;

  public static final String JSON_PROPERTY_CURRENCY = "currency";
  private String currency;

  public CreatePaymentIntentRequestData() { 
  }

  public CreatePaymentIntentRequestData amount(String amount) {
    
    this.amount = amount;
    return this;
  }

   /**
   * This is the amount that the card payment being taken will be charged.  It should be enough to cover the service(s) you want to sell (enough to book an __Offer__ for example) and the processing fees.  If the currency is different from your Balance currency you should also account for foreign exchange.  It can be higher than that, in which case the remainder will be considered your markup.  If it&#39;s higher than the maximum allowed for you organisation you will get a validation error. By default the maximum is 5,000.00 GBP (or equivalent in the same currency). If you need a maximum higher than the default please get in touch with us via &lt;help@duffel.com&gt;. 
   * @return amount
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "30.20", required = true, value = "This is the amount that the card payment being taken will be charged.  It should be enough to cover the service(s) you want to sell (enough to book an __Offer__ for example) and the processing fees.  If the currency is different from your Balance currency you should also account for foreign exchange.  It can be higher than that, in which case the remainder will be considered your markup.  If it's higher than the maximum allowed for you organisation you will get a validation error. By default the maximum is 5,000.00 GBP (or equivalent in the same currency). If you need a maximum higher than the default please get in touch with us via <help@duffel.com>. ")
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getAmount() {
    return amount;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAmount(String amount) {
    this.amount = amount;
  }


  public CreatePaymentIntentRequestData currency(String currency) {
    
    this.currency = currency;
    return this;
  }

   /**
   * The currency of the &#x60;amount&#x60;, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code.  This is going to be the currency that the card payment being taken in will be charged in. 
   * @return currency
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "GBP", required = true, value = "The currency of the `amount`, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code.  This is going to be the currency that the card payment being taken in will be charged in. ")
  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCurrency() {
    return currency;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCurrency(String currency) {
    this.currency = currency;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreatePaymentIntentRequestData createPaymentIntentRequestData = (CreatePaymentIntentRequestData) o;
    return Objects.equals(this.amount, createPaymentIntentRequestData.amount) &&
        Objects.equals(this.currency, createPaymentIntentRequestData.currency);
  }

  @Override
  public int hashCode() {
    return Objects.hash(amount, currency);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreatePaymentIntentRequestData {\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

