/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.duffel.sdk.model.CreateWebhook201ResponseDataAllOf;
import com.duffel.sdk.model.Webhook1;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * CreateWebhook201ResponseData
 */
@JsonPropertyOrder({
  CreateWebhook201ResponseData.JSON_PROPERTY_ACTIVE,
  CreateWebhook201ResponseData.JSON_PROPERTY_CREATED_AT,
  CreateWebhook201ResponseData.JSON_PROPERTY_EVENTS,
  CreateWebhook201ResponseData.JSON_PROPERTY_ID,
  CreateWebhook201ResponseData.JSON_PROPERTY_LIVE_MODE,
  CreateWebhook201ResponseData.JSON_PROPERTY_UPDATED_AT,
  CreateWebhook201ResponseData.JSON_PROPERTY_URL,
  CreateWebhook201ResponseData.JSON_PROPERTY_SECRET
})
@JsonTypeName("createWebhook_201_response_data")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:13:42.592945+07:00[Asia/Bangkok]")
public class CreateWebhook201ResponseData {
  public static final String JSON_PROPERTY_ACTIVE = "active";
  private Boolean active;

  public static final String JSON_PROPERTY_CREATED_AT = "created_at";
  private OffsetDateTime createdAt;

  public static final String JSON_PROPERTY_EVENTS = "events";
  private List<String> events = new ArrayList<>();

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_LIVE_MODE = "live_mode";
  private Boolean liveMode;

  public static final String JSON_PROPERTY_UPDATED_AT = "updated_at";
  private OffsetDateTime updatedAt;

  public static final String JSON_PROPERTY_URL = "url";
  private String url;

  public static final String JSON_PROPERTY_SECRET = "secret";
  private String secret;

  public CreateWebhook201ResponseData() { 
  }

  public CreateWebhook201ResponseData active(Boolean active) {
    
    this.active = active;
    return this;
  }

   /**
   * Whether the webhook receiver is actively being notified or not
   * @return active
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "true", required = true, value = "Whether the webhook receiver is actively being notified or not")
  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getActive() {
    return active;
  }


  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setActive(Boolean active) {
    this.active = active;
  }


  public CreateWebhook201ResponseData createdAt(OffsetDateTime createdAt) {
    
    this.createdAt = createdAt;
    return this;
  }

   /**
   * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the order change was created
   * @return createdAt
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(example = "2020-04-11T15:48:11.642Z", required = true, value = "The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the order change was created")
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }


  public CreateWebhook201ResponseData events(List<String> events) {
    
    this.events = events;
    return this;
  }

  public CreateWebhook201ResponseData addEventsItem(String eventsItem) {
    this.events.add(eventsItem);
    return this;
  }

   /**
   * The events that this webhook will be subscribed to
   * @return events
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "[\"order.created\",\"order.airline_initiated_change_detected\"]", required = true, value = "The events that this webhook will be subscribed to")
  @JsonProperty(JSON_PROPERTY_EVENTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<String> getEvents() {
    return events;
  }


  @JsonProperty(JSON_PROPERTY_EVENTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEvents(List<String> events) {
    this.events = events;
  }


  public CreateWebhook201ResponseData id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Duffel&#39;s unique identifier for the webhook receiver
   * @return id
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "end_0000A3tQSmKyqOrcySrGbo", required = true, value = "Duffel's unique identifier for the webhook receiver")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setId(String id) {
    this.id = id;
  }


  public CreateWebhook201ResponseData liveMode(Boolean liveMode) {
    
    this.liveMode = liveMode;
    return this;
  }

   /**
   * The live mode that the webhook was created in. It will _only_ receive events for that same live mode. For example, you won&#39;t receive &#x60;order.created&#x60; events for orders that you created in the sandbox, if your webook is for &#x60;live_mode: true&#x60;. 
   * @return liveMode
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "true", required = true, value = "The live mode that the webhook was created in. It will _only_ receive events for that same live mode. For example, you won't receive `order.created` events for orders that you created in the sandbox, if your webook is for `live_mode: true`. ")
  @JsonProperty(JSON_PROPERTY_LIVE_MODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getLiveMode() {
    return liveMode;
  }


  @JsonProperty(JSON_PROPERTY_LIVE_MODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLiveMode(Boolean liveMode) {
    this.liveMode = liveMode;
  }


  public CreateWebhook201ResponseData updatedAt(OffsetDateTime updatedAt) {
    
    this.updatedAt = updatedAt;
    return this;
  }

   /**
   * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the order change was updated
   * @return updatedAt
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(example = "2020-04-11T15:48:11.642Z", required = true, value = "The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the order change was updated")
  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OffsetDateTime getUpdatedAt() {
    return updatedAt;
  }


  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUpdatedAt(OffsetDateTime updatedAt) {
    this.updatedAt = updatedAt;
  }


  public CreateWebhook201ResponseData url(String url) {
    
    this.url = url;
    return this;
  }

   /**
   * The URL where your webhook will be received
   * @return url
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "https://www.example.com:4000/webhooks", required = true, value = "The URL where your webhook will be received")
  @JsonProperty(JSON_PROPERTY_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getUrl() {
    return url;
  }


  @JsonProperty(JSON_PROPERTY_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUrl(String url) {
    this.url = url;
  }


  public CreateWebhook201ResponseData secret(String secret) {
    
    this.secret = secret;
    return this;
  }

   /**
   * The secret used to secure the payload being sent. This will only be returned when the webhook is first created. 
   * @return secret
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "QKfUULLQh+8SegYmIsF6kA==", value = "The secret used to secure the payload being sent. This will only be returned when the webhook is first created. ")
  @JsonProperty(JSON_PROPERTY_SECRET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSecret() {
    return secret;
  }


  @JsonProperty(JSON_PROPERTY_SECRET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSecret(String secret) {
    this.secret = secret;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateWebhook201ResponseData createWebhook201ResponseData = (CreateWebhook201ResponseData) o;
    return Objects.equals(this.active, createWebhook201ResponseData.active) &&
        Objects.equals(this.createdAt, createWebhook201ResponseData.createdAt) &&
        Objects.equals(this.events, createWebhook201ResponseData.events) &&
        Objects.equals(this.id, createWebhook201ResponseData.id) &&
        Objects.equals(this.liveMode, createWebhook201ResponseData.liveMode) &&
        Objects.equals(this.updatedAt, createWebhook201ResponseData.updatedAt) &&
        Objects.equals(this.url, createWebhook201ResponseData.url) &&
        Objects.equals(this.secret, createWebhook201ResponseData.secret);
  }

  @Override
  public int hashCode() {
    return Objects.hash(active, createdAt, events, id, liveMode, updatedAt, url, secret);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateWebhook201ResponseData {\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    events: ").append(toIndentedString(events)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    liveMode: ").append(toIndentedString(liveMode)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("    secret: ").append(toIndentedString(secret)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

