/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.duffel.sdk.model.OfferPaymentRequirements;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * OfferIndexPaymentRequirements
 */
@JsonPropertyOrder({
  OfferIndexPaymentRequirements.JSON_PROPERTY_PAYMENT_REQUIRED_BY,
  OfferIndexPaymentRequirements.JSON_PROPERTY_PRICE_GUARANTEE_EXPIRES_AT,
  OfferIndexPaymentRequirements.JSON_PROPERTY_REQUIRES_INSTANT_PAYMENT
})
@JsonTypeName("Offer_Index_payment_requirements")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:13:42.592945+07:00[Asia/Bangkok]")
public class OfferIndexPaymentRequirements {
  public static final String JSON_PROPERTY_PAYMENT_REQUIRED_BY = "payment_required_by";
  private JsonNullable<OffsetDateTime> paymentRequiredBy = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_PRICE_GUARANTEE_EXPIRES_AT = "price_guarantee_expires_at";
  private JsonNullable<OffsetDateTime> priceGuaranteeExpiresAt = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_REQUIRES_INSTANT_PAYMENT = "requires_instant_payment";
  private Boolean requiresInstantPayment;

  public OfferIndexPaymentRequirements() { 
  }

  public OfferIndexPaymentRequirements paymentRequiredBy(OffsetDateTime paymentRequiredBy) {
    this.paymentRequiredBy = JsonNullable.<OffsetDateTime>of(paymentRequiredBy);
    
    return this;
  }

   /**
   * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime by which you must pay for this offer. At this time, if still unpaid, the reserved space on the flight(s) will be released and you will have to create a new order. This will be &#x60;null&#x60; when the offer requires immediate payment - that is, when &#x60;requires_instant_payment&#x60; is &#x60;true&#x60;. 
   * @return paymentRequiredBy
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(example = "2020-01-17T10:42:14Z", value = "The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime by which you must pay for this offer. At this time, if still unpaid, the reserved space on the flight(s) will be released and you will have to create a new order. This will be `null` when the offer requires immediate payment - that is, when `requires_instant_payment` is `true`. ")
  @JsonIgnore

  public OffsetDateTime getPaymentRequiredBy() {
        return paymentRequiredBy.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PAYMENT_REQUIRED_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getPaymentRequiredBy_JsonNullable() {
    return paymentRequiredBy;
  }
  
  @JsonProperty(JSON_PROPERTY_PAYMENT_REQUIRED_BY)
  public void setPaymentRequiredBy_JsonNullable(JsonNullable<OffsetDateTime> paymentRequiredBy) {
    this.paymentRequiredBy = paymentRequiredBy;
  }

  public void setPaymentRequiredBy(OffsetDateTime paymentRequiredBy) {
    this.paymentRequiredBy = JsonNullable.<OffsetDateTime>of(paymentRequiredBy);
  }


  public OfferIndexPaymentRequirements priceGuaranteeExpiresAt(OffsetDateTime priceGuaranteeExpiresAt) {
    this.priceGuaranteeExpiresAt = JsonNullable.<OffsetDateTime>of(priceGuaranteeExpiresAt);
    
    return this;
  }

   /**
   * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the price associated with the order will no longer be guaranteed by the airline and may change before payment. This will be &#x60;null&#x60; when &#x60;requires_instant_payment&#x60; is &#x60;true&#x60;. 
   * @return priceGuaranteeExpiresAt
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the price associated with the order will no longer be guaranteed by the airline and may change before payment. This will be `null` when `requires_instant_payment` is `true`. ")
  @JsonIgnore

  public OffsetDateTime getPriceGuaranteeExpiresAt() {
        return priceGuaranteeExpiresAt.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PRICE_GUARANTEE_EXPIRES_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getPriceGuaranteeExpiresAt_JsonNullable() {
    return priceGuaranteeExpiresAt;
  }
  
  @JsonProperty(JSON_PROPERTY_PRICE_GUARANTEE_EXPIRES_AT)
  public void setPriceGuaranteeExpiresAt_JsonNullable(JsonNullable<OffsetDateTime> priceGuaranteeExpiresAt) {
    this.priceGuaranteeExpiresAt = priceGuaranteeExpiresAt;
  }

  public void setPriceGuaranteeExpiresAt(OffsetDateTime priceGuaranteeExpiresAt) {
    this.priceGuaranteeExpiresAt = JsonNullable.<OffsetDateTime>of(priceGuaranteeExpiresAt);
  }


  public OfferIndexPaymentRequirements requiresInstantPayment(Boolean requiresInstantPayment) {
    
    this.requiresInstantPayment = requiresInstantPayment;
    return this;
  }

   /**
   * When payment is required at the time of booking this will be &#x60;true&#x60; and &#x60;payment_required_by&#x60; and &#x60;price_guarantee_expires_at&#x60; will be &#x60;null&#x60;. When payment can be made at a time after booking, this will be &#x60;false&#x60; and the time limits on the payment will be provided in &#x60;payment_required_by&#x60; and &#x60;price_guarantee_expires_at&#x60;. 
   * @return requiresInstantPayment
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "When payment is required at the time of booking this will be `true` and `payment_required_by` and `price_guarantee_expires_at` will be `null`. When payment can be made at a time after booking, this will be `false` and the time limits on the payment will be provided in `payment_required_by` and `price_guarantee_expires_at`. ")
  @JsonProperty(JSON_PROPERTY_REQUIRES_INSTANT_PAYMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getRequiresInstantPayment() {
    return requiresInstantPayment;
  }


  @JsonProperty(JSON_PROPERTY_REQUIRES_INSTANT_PAYMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRequiresInstantPayment(Boolean requiresInstantPayment) {
    this.requiresInstantPayment = requiresInstantPayment;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OfferIndexPaymentRequirements offerIndexPaymentRequirements = (OfferIndexPaymentRequirements) o;
    return equalsNullable(this.paymentRequiredBy, offerIndexPaymentRequirements.paymentRequiredBy) &&
        equalsNullable(this.priceGuaranteeExpiresAt, offerIndexPaymentRequirements.priceGuaranteeExpiresAt) &&
        Objects.equals(this.requiresInstantPayment, offerIndexPaymentRequirements.requiresInstantPayment);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(paymentRequiredBy), hashCodeNullable(priceGuaranteeExpiresAt), requiresInstantPayment);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OfferIndexPaymentRequirements {\n");
    sb.append("    paymentRequiredBy: ").append(toIndentedString(paymentRequiredBy)).append("\n");
    sb.append("    priceGuaranteeExpiresAt: ").append(toIndentedString(priceGuaranteeExpiresAt)).append("\n");
    sb.append("    requiresInstantPayment: ").append(toIndentedString(requiresInstantPayment)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

