/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.duffel.sdk.model.OfferSliceSegmentAircraft;
import com.duffel.sdk.model.OfferSliceSegmentDestination;
import com.duffel.sdk.model.OfferSliceSegmentMarketingCarrier;
import com.duffel.sdk.model.OfferSliceSegmentOperatingCarrier;
import com.duffel.sdk.model.OfferSliceSegmentOrigin;
import com.duffel.sdk.model.OfferSliceSegmentPassenger;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * OfferSliceSegment
 */
@JsonPropertyOrder({
  OfferSliceSegment.JSON_PROPERTY_AIRCRAFT,
  OfferSliceSegment.JSON_PROPERTY_ARRIVING_AT,
  OfferSliceSegment.JSON_PROPERTY_DEPARTING_AT,
  OfferSliceSegment.JSON_PROPERTY_DESTINATION,
  OfferSliceSegment.JSON_PROPERTY_DESTINATION_TERMINAL,
  OfferSliceSegment.JSON_PROPERTY_DISTANCE,
  OfferSliceSegment.JSON_PROPERTY_DURATION,
  OfferSliceSegment.JSON_PROPERTY_ID,
  OfferSliceSegment.JSON_PROPERTY_MARKETING_CARRIER,
  OfferSliceSegment.JSON_PROPERTY_MARKETING_CARRIER_FLIGHT_NUMBER,
  OfferSliceSegment.JSON_PROPERTY_OPERATING_CARRIER,
  OfferSliceSegment.JSON_PROPERTY_OPERATING_CARRIER_FLIGHT_NUMBER,
  OfferSliceSegment.JSON_PROPERTY_ORIGIN,
  OfferSliceSegment.JSON_PROPERTY_ORIGIN_TERMINAL,
  OfferSliceSegment.JSON_PROPERTY_PASSENGERS
})
@JsonTypeName("Offer_Slice_Segment")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:13:42.592945+07:00[Asia/Bangkok]")
public class OfferSliceSegment {
  public static final String JSON_PROPERTY_AIRCRAFT = "aircraft";
  private OfferSliceSegmentAircraft aircraft;

  public static final String JSON_PROPERTY_ARRIVING_AT = "arriving_at";
  private OffsetDateTime arrivingAt;

  public static final String JSON_PROPERTY_DEPARTING_AT = "departing_at";
  private OffsetDateTime departingAt;

  public static final String JSON_PROPERTY_DESTINATION = "destination";
  private OfferSliceSegmentDestination destination;

  public static final String JSON_PROPERTY_DESTINATION_TERMINAL = "destination_terminal";
  private JsonNullable<String> destinationTerminal = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_DISTANCE = "distance";
  private JsonNullable<String> distance = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_DURATION = "duration";
  private JsonNullable<String> duration = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_MARKETING_CARRIER = "marketing_carrier";
  private OfferSliceSegmentMarketingCarrier marketingCarrier;

  public static final String JSON_PROPERTY_MARKETING_CARRIER_FLIGHT_NUMBER = "marketing_carrier_flight_number";
  private String marketingCarrierFlightNumber;

  public static final String JSON_PROPERTY_OPERATING_CARRIER = "operating_carrier";
  private OfferSliceSegmentOperatingCarrier operatingCarrier;

  public static final String JSON_PROPERTY_OPERATING_CARRIER_FLIGHT_NUMBER = "operating_carrier_flight_number";
  private JsonNullable<String> operatingCarrierFlightNumber = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ORIGIN = "origin";
  private OfferSliceSegmentOrigin origin;

  public static final String JSON_PROPERTY_ORIGIN_TERMINAL = "origin_terminal";
  private JsonNullable<String> originTerminal = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PASSENGERS = "passengers";
  private List<OfferSliceSegmentPassenger> passengers = null;

  public OfferSliceSegment() { 
  }

  public OfferSliceSegment aircraft(OfferSliceSegmentAircraft aircraft) {
    
    this.aircraft = aircraft;
    return this;
  }

   /**
   * Get aircraft
   * @return aircraft
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_AIRCRAFT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OfferSliceSegmentAircraft getAircraft() {
    return aircraft;
  }


  @JsonProperty(JSON_PROPERTY_AIRCRAFT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAircraft(OfferSliceSegmentAircraft aircraft) {
    this.aircraft = aircraft;
  }


  public OfferSliceSegment arrivingAt(OffsetDateTime arrivingAt) {
    
    this.arrivingAt = arrivingAt;
    return this;
  }

   /**
   * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the segment is scheduled to arrive, in the destination airport timezone (see &#x60;destination.timezone&#x60;)
   * @return arrivingAt
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the segment is scheduled to arrive, in the destination airport timezone (see `destination.timezone`)")
  @JsonProperty(JSON_PROPERTY_ARRIVING_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getArrivingAt() {
    return arrivingAt;
  }


  @JsonProperty(JSON_PROPERTY_ARRIVING_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setArrivingAt(OffsetDateTime arrivingAt) {
    this.arrivingAt = arrivingAt;
  }


  public OfferSliceSegment departingAt(OffsetDateTime departingAt) {
    
    this.departingAt = departingAt;
    return this;
  }

   /**
   * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the segment is scheduled to depart, in the origin airport timezone (see &#x60;origin.timezone&#x60;)
   * @return departingAt
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the segment is scheduled to depart, in the origin airport timezone (see `origin.timezone`)")
  @JsonProperty(JSON_PROPERTY_DEPARTING_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getDepartingAt() {
    return departingAt;
  }


  @JsonProperty(JSON_PROPERTY_DEPARTING_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDepartingAt(OffsetDateTime departingAt) {
    this.departingAt = departingAt;
  }


  public OfferSliceSegment destination(OfferSliceSegmentDestination destination) {
    
    this.destination = destination;
    return this;
  }

   /**
   * Get destination
   * @return destination
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DESTINATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OfferSliceSegmentDestination getDestination() {
    return destination;
  }


  @JsonProperty(JSON_PROPERTY_DESTINATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDestination(OfferSliceSegmentDestination destination) {
    this.destination = destination;
  }


  public OfferSliceSegment destinationTerminal(String destinationTerminal) {
    this.destinationTerminal = JsonNullable.<String>of(destinationTerminal);
    
    return this;
  }

   /**
   * The terminal at the &#x60;destination&#x60; airport where the segment is scheduled to arrive
   * @return destinationTerminal
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "5", value = "The terminal at the `destination` airport where the segment is scheduled to arrive")
  @JsonIgnore

  public String getDestinationTerminal() {
        return destinationTerminal.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DESTINATION_TERMINAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getDestinationTerminal_JsonNullable() {
    return destinationTerminal;
  }
  
  @JsonProperty(JSON_PROPERTY_DESTINATION_TERMINAL)
  public void setDestinationTerminal_JsonNullable(JsonNullable<String> destinationTerminal) {
    this.destinationTerminal = destinationTerminal;
  }

  public void setDestinationTerminal(String destinationTerminal) {
    this.destinationTerminal = JsonNullable.<String>of(destinationTerminal);
  }


  public OfferSliceSegment distance(String distance) {
    this.distance = JsonNullable.<String>of(distance);
    
    return this;
  }

   /**
   * The distance of the segment in kilometres
   * @return distance
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "424.2", value = "The distance of the segment in kilometres")
  @JsonIgnore

  public String getDistance() {
        return distance.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DISTANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getDistance_JsonNullable() {
    return distance;
  }
  
  @JsonProperty(JSON_PROPERTY_DISTANCE)
  public void setDistance_JsonNullable(JsonNullable<String> distance) {
    this.distance = distance;
  }

  public void setDistance(String distance) {
    this.distance = JsonNullable.<String>of(distance);
  }


  public OfferSliceSegment duration(String duration) {
    this.duration = JsonNullable.<String>of(duration);
    
    return this;
  }

   /**
   * The duration of the segment, represented as a [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601#Durations) duration
   * @return duration
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "PT02H26M", value = "The duration of the segment, represented as a [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601#Durations) duration")
  @JsonIgnore

  public String getDuration() {
        return duration.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getDuration_JsonNullable() {
    return duration;
  }
  
  @JsonProperty(JSON_PROPERTY_DURATION)
  public void setDuration_JsonNullable(JsonNullable<String> duration) {
    this.duration = duration;
  }

  public void setDuration(String duration) {
    this.duration = JsonNullable.<String>of(duration);
  }


  public OfferSliceSegment id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Duffel&#39;s unique identifier for the segment. It identifies the segment of an offer (i.e. the same segment across offers will have different &#x60;id&#x60;s).
   * @return id
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "seg_00009htYpSCXrwaB9Dn456", value = "Duffel's unique identifier for the segment. It identifies the segment of an offer (i.e. the same segment across offers will have different `id`s).")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public OfferSliceSegment marketingCarrier(OfferSliceSegmentMarketingCarrier marketingCarrier) {
    
    this.marketingCarrier = marketingCarrier;
    return this;
  }

   /**
   * Get marketingCarrier
   * @return marketingCarrier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MARKETING_CARRIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OfferSliceSegmentMarketingCarrier getMarketingCarrier() {
    return marketingCarrier;
  }


  @JsonProperty(JSON_PROPERTY_MARKETING_CARRIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMarketingCarrier(OfferSliceSegmentMarketingCarrier marketingCarrier) {
    this.marketingCarrier = marketingCarrier;
  }


  public OfferSliceSegment marketingCarrierFlightNumber(String marketingCarrierFlightNumber) {
    
    this.marketingCarrierFlightNumber = marketingCarrierFlightNumber;
    return this;
  }

   /**
   * The flight number assigned by the marketing carrier
   * @return marketingCarrierFlightNumber
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1234", value = "The flight number assigned by the marketing carrier")
  @JsonProperty(JSON_PROPERTY_MARKETING_CARRIER_FLIGHT_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMarketingCarrierFlightNumber() {
    return marketingCarrierFlightNumber;
  }


  @JsonProperty(JSON_PROPERTY_MARKETING_CARRIER_FLIGHT_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMarketingCarrierFlightNumber(String marketingCarrierFlightNumber) {
    this.marketingCarrierFlightNumber = marketingCarrierFlightNumber;
  }


  public OfferSliceSegment operatingCarrier(OfferSliceSegmentOperatingCarrier operatingCarrier) {
    
    this.operatingCarrier = operatingCarrier;
    return this;
  }

   /**
   * Get operatingCarrier
   * @return operatingCarrier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_OPERATING_CARRIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OfferSliceSegmentOperatingCarrier getOperatingCarrier() {
    return operatingCarrier;
  }


  @JsonProperty(JSON_PROPERTY_OPERATING_CARRIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOperatingCarrier(OfferSliceSegmentOperatingCarrier operatingCarrier) {
    this.operatingCarrier = operatingCarrier;
  }


  public OfferSliceSegment operatingCarrierFlightNumber(String operatingCarrierFlightNumber) {
    this.operatingCarrierFlightNumber = JsonNullable.<String>of(operatingCarrierFlightNumber);
    
    return this;
  }

   /**
   * The flight number assigned by the operating carrier. This may not be present, in which case you should display the &#x60;marketing_carrier&#x60;&#39;s information and the &#x60;marketing_carrier_flight_number&#x60;, and simply state the name of the &#x60;operating_carrier&#x60;.
   * @return operatingCarrierFlightNumber
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "4321", value = "The flight number assigned by the operating carrier. This may not be present, in which case you should display the `marketing_carrier`'s information and the `marketing_carrier_flight_number`, and simply state the name of the `operating_carrier`.")
  @JsonIgnore

  public String getOperatingCarrierFlightNumber() {
        return operatingCarrierFlightNumber.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_OPERATING_CARRIER_FLIGHT_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getOperatingCarrierFlightNumber_JsonNullable() {
    return operatingCarrierFlightNumber;
  }
  
  @JsonProperty(JSON_PROPERTY_OPERATING_CARRIER_FLIGHT_NUMBER)
  public void setOperatingCarrierFlightNumber_JsonNullable(JsonNullable<String> operatingCarrierFlightNumber) {
    this.operatingCarrierFlightNumber = operatingCarrierFlightNumber;
  }

  public void setOperatingCarrierFlightNumber(String operatingCarrierFlightNumber) {
    this.operatingCarrierFlightNumber = JsonNullable.<String>of(operatingCarrierFlightNumber);
  }


  public OfferSliceSegment origin(OfferSliceSegmentOrigin origin) {
    
    this.origin = origin;
    return this;
  }

   /**
   * Get origin
   * @return origin
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ORIGIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OfferSliceSegmentOrigin getOrigin() {
    return origin;
  }


  @JsonProperty(JSON_PROPERTY_ORIGIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOrigin(OfferSliceSegmentOrigin origin) {
    this.origin = origin;
  }


  public OfferSliceSegment originTerminal(String originTerminal) {
    this.originTerminal = JsonNullable.<String>of(originTerminal);
    
    return this;
  }

   /**
   * The terminal at the &#x60;origin&#x60; airport from which the segment is scheduled to depart
   * @return originTerminal
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "B", value = "The terminal at the `origin` airport from which the segment is scheduled to depart")
  @JsonIgnore

  public String getOriginTerminal() {
        return originTerminal.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ORIGIN_TERMINAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getOriginTerminal_JsonNullable() {
    return originTerminal;
  }
  
  @JsonProperty(JSON_PROPERTY_ORIGIN_TERMINAL)
  public void setOriginTerminal_JsonNullable(JsonNullable<String> originTerminal) {
    this.originTerminal = originTerminal;
  }

  public void setOriginTerminal(String originTerminal) {
    this.originTerminal = JsonNullable.<String>of(originTerminal);
  }


  public OfferSliceSegment passengers(List<OfferSliceSegmentPassenger> passengers) {
    
    this.passengers = passengers;
    return this;
  }

  public OfferSliceSegment addPassengersItem(OfferSliceSegmentPassenger passengersItem) {
    if (this.passengers == null) {
      this.passengers = new ArrayList<>();
    }
    this.passengers.add(passengersItem);
    return this;
  }

   /**
   * Additional segment-specific information about the passengers included in the offer (e.g. their baggage allowance and the cabin class they will be travelling in)
   * @return passengers
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Additional segment-specific information about the passengers included in the offer (e.g. their baggage allowance and the cabin class they will be travelling in)")
  @JsonProperty(JSON_PROPERTY_PASSENGERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OfferSliceSegmentPassenger> getPassengers() {
    return passengers;
  }


  @JsonProperty(JSON_PROPERTY_PASSENGERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPassengers(List<OfferSliceSegmentPassenger> passengers) {
    this.passengers = passengers;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OfferSliceSegment offerSliceSegment = (OfferSliceSegment) o;
    return Objects.equals(this.aircraft, offerSliceSegment.aircraft) &&
        Objects.equals(this.arrivingAt, offerSliceSegment.arrivingAt) &&
        Objects.equals(this.departingAt, offerSliceSegment.departingAt) &&
        Objects.equals(this.destination, offerSliceSegment.destination) &&
        equalsNullable(this.destinationTerminal, offerSliceSegment.destinationTerminal) &&
        equalsNullable(this.distance, offerSliceSegment.distance) &&
        equalsNullable(this.duration, offerSliceSegment.duration) &&
        Objects.equals(this.id, offerSliceSegment.id) &&
        Objects.equals(this.marketingCarrier, offerSliceSegment.marketingCarrier) &&
        Objects.equals(this.marketingCarrierFlightNumber, offerSliceSegment.marketingCarrierFlightNumber) &&
        Objects.equals(this.operatingCarrier, offerSliceSegment.operatingCarrier) &&
        equalsNullable(this.operatingCarrierFlightNumber, offerSliceSegment.operatingCarrierFlightNumber) &&
        Objects.equals(this.origin, offerSliceSegment.origin) &&
        equalsNullable(this.originTerminal, offerSliceSegment.originTerminal) &&
        Objects.equals(this.passengers, offerSliceSegment.passengers);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(aircraft, arrivingAt, departingAt, destination, hashCodeNullable(destinationTerminal), hashCodeNullable(distance), hashCodeNullable(duration), id, marketingCarrier, marketingCarrierFlightNumber, operatingCarrier, hashCodeNullable(operatingCarrierFlightNumber), origin, hashCodeNullable(originTerminal), passengers);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OfferSliceSegment {\n");
    sb.append("    aircraft: ").append(toIndentedString(aircraft)).append("\n");
    sb.append("    arrivingAt: ").append(toIndentedString(arrivingAt)).append("\n");
    sb.append("    departingAt: ").append(toIndentedString(departingAt)).append("\n");
    sb.append("    destination: ").append(toIndentedString(destination)).append("\n");
    sb.append("    destinationTerminal: ").append(toIndentedString(destinationTerminal)).append("\n");
    sb.append("    distance: ").append(toIndentedString(distance)).append("\n");
    sb.append("    duration: ").append(toIndentedString(duration)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    marketingCarrier: ").append(toIndentedString(marketingCarrier)).append("\n");
    sb.append("    marketingCarrierFlightNumber: ").append(toIndentedString(marketingCarrierFlightNumber)).append("\n");
    sb.append("    operatingCarrier: ").append(toIndentedString(operatingCarrier)).append("\n");
    sb.append("    operatingCarrierFlightNumber: ").append(toIndentedString(operatingCarrierFlightNumber)).append("\n");
    sb.append("    origin: ").append(toIndentedString(origin)).append("\n");
    sb.append("    originTerminal: ").append(toIndentedString(originTerminal)).append("\n");
    sb.append("    passengers: ").append(toIndentedString(passengers)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

