/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.duffel.sdk.model.Airport2;
import com.duffel.sdk.model.City3;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * OfferSliceSegmentOrigin
 */
@JsonPropertyOrder({
  OfferSliceSegmentOrigin.JSON_PROPERTY_CITY,
  OfferSliceSegmentOrigin.JSON_PROPERTY_CITY_NAME,
  OfferSliceSegmentOrigin.JSON_PROPERTY_IATA_CODE,
  OfferSliceSegmentOrigin.JSON_PROPERTY_IATA_COUNTRY_CODE,
  OfferSliceSegmentOrigin.JSON_PROPERTY_ICAO_CODE,
  OfferSliceSegmentOrigin.JSON_PROPERTY_ID,
  OfferSliceSegmentOrigin.JSON_PROPERTY_LATITUDE,
  OfferSliceSegmentOrigin.JSON_PROPERTY_LONGITUDE,
  OfferSliceSegmentOrigin.JSON_PROPERTY_NAME,
  OfferSliceSegmentOrigin.JSON_PROPERTY_TIME_ZONE
})
@JsonTypeName("Offer_Slice_Segment_origin")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:13:42.592945+07:00[Asia/Bangkok]")
public class OfferSliceSegmentOrigin {
  public static final String JSON_PROPERTY_CITY = "city";
  private JsonNullable<City3> city = JsonNullable.<City3>undefined();

  public static final String JSON_PROPERTY_CITY_NAME = "city_name";
  private String cityName;

  public static final String JSON_PROPERTY_IATA_CODE = "iata_code";
  private JsonNullable<String> iataCode = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_IATA_COUNTRY_CODE = "iata_country_code";
  private String iataCountryCode;

  public static final String JSON_PROPERTY_ICAO_CODE = "icao_code";
  private JsonNullable<String> icaoCode = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_LATITUDE = "latitude";
  private Float latitude;

  public static final String JSON_PROPERTY_LONGITUDE = "longitude";
  private Float longitude;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_TIME_ZONE = "time_zone";
  private String timeZone;

  public OfferSliceSegmentOrigin() { 
  }

  public OfferSliceSegmentOrigin city(City3 city) {
    this.city = JsonNullable.<City3>of(city);
    
    return this;
  }

   /**
   * Get city
   * @return city
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonIgnore

  public City3 getCity() {
        return city.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<City3> getCity_JsonNullable() {
    return city;
  }
  
  @JsonProperty(JSON_PROPERTY_CITY)
  public void setCity_JsonNullable(JsonNullable<City3> city) {
    this.city = city;
  }

  public void setCity(City3 city) {
    this.city = JsonNullable.<City3>of(city);
  }


  public OfferSliceSegmentOrigin cityName(String cityName) {
    
    this.cityName = cityName;
    return this;
  }

   /**
   * The name of the city (or cities separated by a &#x60;/&#x60;) where the airport is located
   * @return cityName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "London", value = "The name of the city (or cities separated by a `/`) where the airport is located")
  @JsonProperty(JSON_PROPERTY_CITY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCityName() {
    return cityName;
  }


  @JsonProperty(JSON_PROPERTY_CITY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCityName(String cityName) {
    this.cityName = cityName;
  }


  public OfferSliceSegmentOrigin iataCode(String iataCode) {
    this.iataCode = JsonNullable.<String>of(iataCode);
    
    return this;
  }

   /**
   * The three-character IATA code for the airport
   * @return iataCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "LHR", value = "The three-character IATA code for the airport")
  @JsonIgnore

  public String getIataCode() {
        return iataCode.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_IATA_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getIataCode_JsonNullable() {
    return iataCode;
  }
  
  @JsonProperty(JSON_PROPERTY_IATA_CODE)
  public void setIataCode_JsonNullable(JsonNullable<String> iataCode) {
    this.iataCode = iataCode;
  }

  public void setIataCode(String iataCode) {
    this.iataCode = JsonNullable.<String>of(iataCode);
  }


  public OfferSliceSegmentOrigin iataCountryCode(String iataCountryCode) {
    
    this.iataCountryCode = iataCountryCode;
    return this;
  }

   /**
   * The [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) code for the country where the airport is located
   * @return iataCountryCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "GB", value = "The [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) code for the country where the airport is located")
  @JsonProperty(JSON_PROPERTY_IATA_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIataCountryCode() {
    return iataCountryCode;
  }


  @JsonProperty(JSON_PROPERTY_IATA_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIataCountryCode(String iataCountryCode) {
    this.iataCountryCode = iataCountryCode;
  }


  public OfferSliceSegmentOrigin icaoCode(String icaoCode) {
    this.icaoCode = JsonNullable.<String>of(icaoCode);
    
    return this;
  }

   /**
   * The four-character ICAO code for the airport
   * @return icaoCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "EGLL", value = "The four-character ICAO code for the airport")
  @JsonIgnore

  public String getIcaoCode() {
        return icaoCode.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ICAO_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getIcaoCode_JsonNullable() {
    return icaoCode;
  }
  
  @JsonProperty(JSON_PROPERTY_ICAO_CODE)
  public void setIcaoCode_JsonNullable(JsonNullable<String> icaoCode) {
    this.icaoCode = icaoCode;
  }

  public void setIcaoCode(String icaoCode) {
    this.icaoCode = JsonNullable.<String>of(icaoCode);
  }


  public OfferSliceSegmentOrigin id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Duffel&#39;s unique identifier for the airport
   * @return id
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "arp_lhr_gb", value = "Duffel's unique identifier for the airport")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public OfferSliceSegmentOrigin latitude(Float latitude) {
    
    this.latitude = latitude;
    return this;
  }

   /**
   * The latitude position of the airport represented in [Decimal degrees](https://en.wikipedia.org/wiki/Decimal_degrees) with 6 decimal points with a range between -90° and 90°
   * @return latitude
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "64.068865", value = "The latitude position of the airport represented in [Decimal degrees](https://en.wikipedia.org/wiki/Decimal_degrees) with 6 decimal points with a range between -90° and 90°")
  @JsonProperty(JSON_PROPERTY_LATITUDE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getLatitude() {
    return latitude;
  }


  @JsonProperty(JSON_PROPERTY_LATITUDE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLatitude(Float latitude) {
    this.latitude = latitude;
  }


  public OfferSliceSegmentOrigin longitude(Float longitude) {
    
    this.longitude = longitude;
    return this;
  }

   /**
   * The longitude position of the airport represented in [Decimal degrees](https://en.wikipedia.org/wiki/Decimal_degrees) with 6 decimal points with a range between -180° and 180°
   * @return longitude
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "-141.951519", value = "The longitude position of the airport represented in [Decimal degrees](https://en.wikipedia.org/wiki/Decimal_degrees) with 6 decimal points with a range between -180° and 180°")
  @JsonProperty(JSON_PROPERTY_LONGITUDE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getLongitude() {
    return longitude;
  }


  @JsonProperty(JSON_PROPERTY_LONGITUDE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLongitude(Float longitude) {
    this.longitude = longitude;
  }


  public OfferSliceSegmentOrigin name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * The name of the airport
   * @return name
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Heathrow", value = "The name of the airport")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }


  public OfferSliceSegmentOrigin timeZone(String timeZone) {
    
    this.timeZone = timeZone;
    return this;
  }

   /**
   * The time zone of the airport, specified by name from the [tz database](https://en.wikipedia.org/wiki/Tz_database)
   * @return timeZone
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Europe/London", value = "The time zone of the airport, specified by name from the [tz database](https://en.wikipedia.org/wiki/Tz_database)")
  @JsonProperty(JSON_PROPERTY_TIME_ZONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTimeZone() {
    return timeZone;
  }


  @JsonProperty(JSON_PROPERTY_TIME_ZONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTimeZone(String timeZone) {
    this.timeZone = timeZone;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OfferSliceSegmentOrigin offerSliceSegmentOrigin = (OfferSliceSegmentOrigin) o;
    return equalsNullable(this.city, offerSliceSegmentOrigin.city) &&
        Objects.equals(this.cityName, offerSliceSegmentOrigin.cityName) &&
        equalsNullable(this.iataCode, offerSliceSegmentOrigin.iataCode) &&
        Objects.equals(this.iataCountryCode, offerSliceSegmentOrigin.iataCountryCode) &&
        equalsNullable(this.icaoCode, offerSliceSegmentOrigin.icaoCode) &&
        Objects.equals(this.id, offerSliceSegmentOrigin.id) &&
        Objects.equals(this.latitude, offerSliceSegmentOrigin.latitude) &&
        Objects.equals(this.longitude, offerSliceSegmentOrigin.longitude) &&
        Objects.equals(this.name, offerSliceSegmentOrigin.name) &&
        Objects.equals(this.timeZone, offerSliceSegmentOrigin.timeZone);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(city), cityName, hashCodeNullable(iataCode), iataCountryCode, hashCodeNullable(icaoCode), id, latitude, longitude, name, timeZone);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OfferSliceSegmentOrigin {\n");
    sb.append("    city: ").append(toIndentedString(city)).append("\n");
    sb.append("    cityName: ").append(toIndentedString(cityName)).append("\n");
    sb.append("    iataCode: ").append(toIndentedString(iataCode)).append("\n");
    sb.append("    iataCountryCode: ").append(toIndentedString(iataCountryCode)).append("\n");
    sb.append("    icaoCode: ").append(toIndentedString(icaoCode)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    latitude: ").append(toIndentedString(latitude)).append("\n");
    sb.append("    longitude: ").append(toIndentedString(longitude)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    timeZone: ").append(toIndentedString(timeZone)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

