/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * An order cancellation is used to cancel an order with an airline
 */
@ApiModel(description = "An order cancellation is used to cancel an order with an airline")
@JsonPropertyOrder({
  OrderCancellation.JSON_PROPERTY_CONFIRMED_AT,
  OrderCancellation.JSON_PROPERTY_CREATED_AT,
  OrderCancellation.JSON_PROPERTY_EXPIRES_AT,
  OrderCancellation.JSON_PROPERTY_ID,
  OrderCancellation.JSON_PROPERTY_LIVE_MODE,
  OrderCancellation.JSON_PROPERTY_ORDER_ID,
  OrderCancellation.JSON_PROPERTY_REFUND_AMOUNT,
  OrderCancellation.JSON_PROPERTY_REFUND_CURRENCY,
  OrderCancellation.JSON_PROPERTY_REFUND_TO
})
@JsonTypeName("Order_Cancellation")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:13:42.592945+07:00[Asia/Bangkok]")
public class OrderCancellation {
  public static final String JSON_PROPERTY_CONFIRMED_AT = "confirmed_at";
  private OffsetDateTime confirmedAt;

  public static final String JSON_PROPERTY_CREATED_AT = "created_at";
  private OffsetDateTime createdAt;

  public static final String JSON_PROPERTY_EXPIRES_AT = "expires_at";
  private OffsetDateTime expiresAt;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_LIVE_MODE = "live_mode";
  private Boolean liveMode;

  public static final String JSON_PROPERTY_ORDER_ID = "order_id";
  private String orderId;

  public static final String JSON_PROPERTY_REFUND_AMOUNT = "refund_amount";
  private String refundAmount;

  public static final String JSON_PROPERTY_REFUND_CURRENCY = "refund_currency";
  private String refundCurrency;

  /**
   * Where the refund, once confirmed, will be sent. &#x60;card&#x60; is currently a restricted feature. &#x60;awaiting_payment&#x60; is for pay later orders where no payment has been made yet. 
   */
  public enum RefundToEnum {
    ARC_BSP_CASH("arc_bsp_cash"),
    
    BALANCE("balance"),
    
    CARD("card"),
    
    VOUCHER("voucher"),
    
    AWAITING_PAYMENT("awaiting_payment");

    private String value;

    RefundToEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RefundToEnum fromValue(String value) {
      for (RefundToEnum b : RefundToEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_REFUND_TO = "refund_to";
  private RefundToEnum refundTo;

  public OrderCancellation() { 
  }

  public OrderCancellation confirmedAt(OffsetDateTime confirmedAt) {
    
    this.confirmedAt = confirmedAt;
    return this;
  }

   /**
   * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime that indicates when the order cancellation was confirmed
   * @return confirmedAt
  **/
  @javax.annotation.Nullable
  @NotNull
  @Valid
  @ApiModelProperty(example = "2020-01-17T11:51:43.114803Z", required = true, value = "The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime that indicates when the order cancellation was confirmed")
  @JsonProperty(JSON_PROPERTY_CONFIRMED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OffsetDateTime getConfirmedAt() {
    return confirmedAt;
  }


  @JsonProperty(JSON_PROPERTY_CONFIRMED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setConfirmedAt(OffsetDateTime confirmedAt) {
    this.confirmedAt = confirmedAt;
  }


  public OrderCancellation createdAt(OffsetDateTime createdAt) {
    
    this.createdAt = createdAt;
    return this;
  }

   /**
   * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the order cancellation was created
   * @return createdAt
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(example = "2020-04-11T15:48:11.642Z", required = true, value = "The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the order cancellation was created")
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }


  public OrderCancellation expiresAt(OffsetDateTime expiresAt) {
    
    this.expiresAt = expiresAt;
    return this;
  }

   /**
   * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime by which this cancellation must be confirmed
   * @return expiresAt
  **/
  @javax.annotation.Nullable
  @NotNull
  @Valid
  @ApiModelProperty(example = "2020-01-17T10:42:14Z", required = true, value = "The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime by which this cancellation must be confirmed")
  @JsonProperty(JSON_PROPERTY_EXPIRES_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OffsetDateTime getExpiresAt() {
    return expiresAt;
  }


  @JsonProperty(JSON_PROPERTY_EXPIRES_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setExpiresAt(OffsetDateTime expiresAt) {
    this.expiresAt = expiresAt;
  }


  public OrderCancellation id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Duffel&#39;s unique identifier for the order cancellation
   * @return id
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "ore_00009qzZWzjDipIkqpaUAj", required = true, value = "Duffel's unique identifier for the order cancellation")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setId(String id) {
    this.id = id;
  }


  public OrderCancellation liveMode(Boolean liveMode) {
    
    this.liveMode = liveMode;
    return this;
  }

   /**
   * Whether the order cancellation was created in live mode. This field will be set to &#x60;true&#x60; if the order cancellation was created in live mode, or &#x60;false&#x60; if it was created in test mode.
   * @return liveMode
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "false", required = true, value = "Whether the order cancellation was created in live mode. This field will be set to `true` if the order cancellation was created in live mode, or `false` if it was created in test mode.")
  @JsonProperty(JSON_PROPERTY_LIVE_MODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getLiveMode() {
    return liveMode;
  }


  @JsonProperty(JSON_PROPERTY_LIVE_MODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLiveMode(Boolean liveMode) {
    this.liveMode = liveMode;
  }


  public OrderCancellation orderId(String orderId) {
    
    this.orderId = orderId;
    return this;
  }

   /**
   * Duffel&#39;s unique identifier for the order
   * @return orderId
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "ord_00009hthhsUZ8W4LxQgkjo", required = true, value = "Duffel's unique identifier for the order")
  @JsonProperty(JSON_PROPERTY_ORDER_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getOrderId() {
    return orderId;
  }


  @JsonProperty(JSON_PROPERTY_ORDER_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOrderId(String orderId) {
    this.orderId = orderId;
  }


  public OrderCancellation refundAmount(String refundAmount) {
    
    this.refundAmount = refundAmount;
    return this;
  }

   /**
   * The amount that will be returned to the original payment method if the order is cancelled, determined according to the fare conditions. This may be &#x60;0.00&#x60; if the fare is non-refundable. It will include the refund amount of the flights and the services booked.
   * @return refundAmount
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "90.80", required = true, value = "The amount that will be returned to the original payment method if the order is cancelled, determined according to the fare conditions. This may be `0.00` if the fare is non-refundable. It will include the refund amount of the flights and the services booked.")
  @JsonProperty(JSON_PROPERTY_REFUND_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRefundAmount() {
    return refundAmount;
  }


  @JsonProperty(JSON_PROPERTY_REFUND_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRefundAmount(String refundAmount) {
    this.refundAmount = refundAmount;
  }


  public OrderCancellation refundCurrency(String refundCurrency) {
    
    this.refundCurrency = refundCurrency;
    return this;
  }

   /**
   * The currency of the &#x60;refund_amount&#x60;, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code. It will match your organisation&#39;s billing currency unless you’re using Duffel as an accredited IATA agent, in which case it will be in the currency provided by the airline (which will usually be based on the country where your IATA agency is registered). For &#x60;hold&#x60; orders that are awaiting payment, the refund amount will always be 0.00. 
   * @return refundCurrency
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "GBP", required = true, value = "The currency of the `refund_amount`, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code. It will match your organisation's billing currency unless you’re using Duffel as an accredited IATA agent, in which case it will be in the currency provided by the airline (which will usually be based on the country where your IATA agency is registered). For `hold` orders that are awaiting payment, the refund amount will always be 0.00. ")
  @JsonProperty(JSON_PROPERTY_REFUND_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRefundCurrency() {
    return refundCurrency;
  }


  @JsonProperty(JSON_PROPERTY_REFUND_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRefundCurrency(String refundCurrency) {
    this.refundCurrency = refundCurrency;
  }


  public OrderCancellation refundTo(RefundToEnum refundTo) {
    
    this.refundTo = refundTo;
    return this;
  }

   /**
   * Where the refund, once confirmed, will be sent. &#x60;card&#x60; is currently a restricted feature. &#x60;awaiting_payment&#x60; is for pay later orders where no payment has been made yet. 
   * @return refundTo
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "arc_bsp_cash", required = true, value = "Where the refund, once confirmed, will be sent. `card` is currently a restricted feature. `awaiting_payment` is for pay later orders where no payment has been made yet. ")
  @JsonProperty(JSON_PROPERTY_REFUND_TO)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public RefundToEnum getRefundTo() {
    return refundTo;
  }


  @JsonProperty(JSON_PROPERTY_REFUND_TO)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRefundTo(RefundToEnum refundTo) {
    this.refundTo = refundTo;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OrderCancellation orderCancellation = (OrderCancellation) o;
    return Objects.equals(this.confirmedAt, orderCancellation.confirmedAt) &&
        Objects.equals(this.createdAt, orderCancellation.createdAt) &&
        Objects.equals(this.expiresAt, orderCancellation.expiresAt) &&
        Objects.equals(this.id, orderCancellation.id) &&
        Objects.equals(this.liveMode, orderCancellation.liveMode) &&
        Objects.equals(this.orderId, orderCancellation.orderId) &&
        Objects.equals(this.refundAmount, orderCancellation.refundAmount) &&
        Objects.equals(this.refundCurrency, orderCancellation.refundCurrency) &&
        Objects.equals(this.refundTo, orderCancellation.refundTo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(confirmedAt, createdAt, expiresAt, id, liveMode, orderId, refundAmount, refundCurrency, refundTo);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OrderCancellation {\n");
    sb.append("    confirmedAt: ").append(toIndentedString(confirmedAt)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    expiresAt: ").append(toIndentedString(expiresAt)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    liveMode: ").append(toIndentedString(liveMode)).append("\n");
    sb.append("    orderId: ").append(toIndentedString(orderId)).append("\n");
    sb.append("    refundAmount: ").append(toIndentedString(refundAmount)).append("\n");
    sb.append("    refundCurrency: ").append(toIndentedString(refundCurrency)).append("\n");
    sb.append("    refundTo: ").append(toIndentedString(refundTo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

