/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.duffel.sdk.model.OrderChangeSlices;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * An order change represents alterations to an existing order with an airline
 */
@ApiModel(description = "An order change represents alterations to an existing order with an airline")
@JsonPropertyOrder({
  OrderChange.JSON_PROPERTY_CHANGE_TOTAL_AMOUNT,
  OrderChange.JSON_PROPERTY_CHANGE_TOTAL_CURRENCY,
  OrderChange.JSON_PROPERTY_CONFIRMED_AT,
  OrderChange.JSON_PROPERTY_CREATED_AT,
  OrderChange.JSON_PROPERTY_EXPIRES_AT,
  OrderChange.JSON_PROPERTY_ID,
  OrderChange.JSON_PROPERTY_LIVE_MODE,
  OrderChange.JSON_PROPERTY_NEW_TOTAL_AMOUNT,
  OrderChange.JSON_PROPERTY_NEW_TOTAL_CURRENCY,
  OrderChange.JSON_PROPERTY_ORDER_ID,
  OrderChange.JSON_PROPERTY_PENALTY_TOTAL_AMOUNT,
  OrderChange.JSON_PROPERTY_PENALTY_TOTAL_CURRENCY,
  OrderChange.JSON_PROPERTY_REFUND_TO,
  OrderChange.JSON_PROPERTY_SLICES
})
@JsonTypeName("Order_Change")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:13:42.592945+07:00[Asia/Bangkok]")
public class OrderChange {
  public static final String JSON_PROPERTY_CHANGE_TOTAL_AMOUNT = "change_total_amount";
  private String changeTotalAmount;

  public static final String JSON_PROPERTY_CHANGE_TOTAL_CURRENCY = "change_total_currency";
  private String changeTotalCurrency;

  public static final String JSON_PROPERTY_CONFIRMED_AT = "confirmed_at";
  private JsonNullable<OffsetDateTime> confirmedAt = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_CREATED_AT = "created_at";
  private OffsetDateTime createdAt;

  public static final String JSON_PROPERTY_EXPIRES_AT = "expires_at";
  private OffsetDateTime expiresAt;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_LIVE_MODE = "live_mode";
  private Boolean liveMode;

  public static final String JSON_PROPERTY_NEW_TOTAL_AMOUNT = "new_total_amount";
  private String newTotalAmount;

  public static final String JSON_PROPERTY_NEW_TOTAL_CURRENCY = "new_total_currency";
  private String newTotalCurrency;

  public static final String JSON_PROPERTY_ORDER_ID = "order_id";
  private String orderId;

  public static final String JSON_PROPERTY_PENALTY_TOTAL_AMOUNT = "penalty_total_amount";
  private String penaltyTotalAmount;

  public static final String JSON_PROPERTY_PENALTY_TOTAL_CURRENCY = "penalty_total_currency";
  private String penaltyTotalCurrency;

  /**
   * Where the refund, once confirmed, will be sent. Refunds are indicated by a negative &#x60;change_total_amount&#x60;. If the change does not require a refund, this field will be &#x60;null&#x60;. &#x60;original_form_of_payment&#x60; refers to the form of payment used to create the order. 
   */
  public enum RefundToEnum {
    VOUCHER("voucher"),
    
    ORIGINAL_FORM_OF_PAYMENT("original_form_of_payment");

    private String value;

    RefundToEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RefundToEnum fromValue(String value) {
      for (RefundToEnum b : RefundToEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }
  }

  public static final String JSON_PROPERTY_REFUND_TO = "refund_to";
  private JsonNullable<RefundToEnum> refundTo = JsonNullable.<RefundToEnum>undefined();

  public static final String JSON_PROPERTY_SLICES = "slices";
  private OrderChangeSlices slices;

  public OrderChange() { 
  }

  public OrderChange changeTotalAmount(String changeTotalAmount) {
    
    this.changeTotalAmount = changeTotalAmount;
    return this;
  }

   /**
   * The amount that will be charged or refunded, determined according to the fare conditions. A negative value will reflect a refund. 
   * @return changeTotalAmount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "30.50", value = "The amount that will be charged or refunded, determined according to the fare conditions. A negative value will reflect a refund. ")
  @JsonProperty(JSON_PROPERTY_CHANGE_TOTAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getChangeTotalAmount() {
    return changeTotalAmount;
  }


  @JsonProperty(JSON_PROPERTY_CHANGE_TOTAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChangeTotalAmount(String changeTotalAmount) {
    this.changeTotalAmount = changeTotalAmount;
  }


  public OrderChange changeTotalCurrency(String changeTotalCurrency) {
    
    this.changeTotalCurrency = changeTotalCurrency;
    return this;
  }

   /**
   * The currency of the &#x60;change_total_amount&#x60;, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code. It will match your organisation&#39;s billing currency unless you’re using Duffel as an accredited IATA agent, in which case it will be in the currency provided by the airline (which will usually be based on the country where your IATA agency is registered). 
   * @return changeTotalCurrency
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "GBP", value = "The currency of the `change_total_amount`, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code. It will match your organisation's billing currency unless you’re using Duffel as an accredited IATA agent, in which case it will be in the currency provided by the airline (which will usually be based on the country where your IATA agency is registered). ")
  @JsonProperty(JSON_PROPERTY_CHANGE_TOTAL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getChangeTotalCurrency() {
    return changeTotalCurrency;
  }


  @JsonProperty(JSON_PROPERTY_CHANGE_TOTAL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChangeTotalCurrency(String changeTotalCurrency) {
    this.changeTotalCurrency = changeTotalCurrency;
  }


  public OrderChange confirmedAt(OffsetDateTime confirmedAt) {
    this.confirmedAt = JsonNullable.<OffsetDateTime>of(confirmedAt);
    
    return this;
  }

   /**
   * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime that indicates when the order change was confirmed
   * @return confirmedAt
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(example = "2020-01-17T11:51:43.114803Z", value = "The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime that indicates when the order change was confirmed")
  @JsonIgnore

  public OffsetDateTime getConfirmedAt() {
        return confirmedAt.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CONFIRMED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getConfirmedAt_JsonNullable() {
    return confirmedAt;
  }
  
  @JsonProperty(JSON_PROPERTY_CONFIRMED_AT)
  public void setConfirmedAt_JsonNullable(JsonNullable<OffsetDateTime> confirmedAt) {
    this.confirmedAt = confirmedAt;
  }

  public void setConfirmedAt(OffsetDateTime confirmedAt) {
    this.confirmedAt = JsonNullable.<OffsetDateTime>of(confirmedAt);
  }


  public OrderChange createdAt(OffsetDateTime createdAt) {
    
    this.createdAt = createdAt;
    return this;
  }

   /**
   * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the order change was created
   * @return createdAt
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(example = "2020-04-11T15:48:11.642Z", value = "The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the order change was created")
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }


  public OrderChange expiresAt(OffsetDateTime expiresAt) {
    
    this.expiresAt = expiresAt;
    return this;
  }

   /**
   * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime by which this change must be confirmed
   * @return expiresAt
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(example = "2020-01-17T10:42:14.545052Z", value = "The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime by which this change must be confirmed")
  @JsonProperty(JSON_PROPERTY_EXPIRES_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getExpiresAt() {
    return expiresAt;
  }


  @JsonProperty(JSON_PROPERTY_EXPIRES_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExpiresAt(OffsetDateTime expiresAt) {
    this.expiresAt = expiresAt;
  }


  public OrderChange id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Duffel&#39;s unique identifier for the order change
   * @return id
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "ocr_0000A3tQSmKyqOrcySrGbo", value = "Duffel's unique identifier for the order change")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public OrderChange liveMode(Boolean liveMode) {
    
    this.liveMode = liveMode;
    return this;
  }

   /**
   * Whether the order change was created in live mode. This field will be set to &#x60;true&#x60; if the order change was created in live mode, or &#x60;false&#x60; if it was created in test mode.
   * @return liveMode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Whether the order change was created in live mode. This field will be set to `true` if the order change was created in live mode, or `false` if it was created in test mode.")
  @JsonProperty(JSON_PROPERTY_LIVE_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getLiveMode() {
    return liveMode;
  }


  @JsonProperty(JSON_PROPERTY_LIVE_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLiveMode(Boolean liveMode) {
    this.liveMode = liveMode;
  }


  public OrderChange newTotalAmount(String newTotalAmount) {
    
    this.newTotalAmount = newTotalAmount;
    return this;
  }

   /**
   * The total price of the order for all the flights and services booked, including taxes, once the change is confirmed.
   * @return newTotalAmount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "121.30", value = "The total price of the order for all the flights and services booked, including taxes, once the change is confirmed.")
  @JsonProperty(JSON_PROPERTY_NEW_TOTAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getNewTotalAmount() {
    return newTotalAmount;
  }


  @JsonProperty(JSON_PROPERTY_NEW_TOTAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNewTotalAmount(String newTotalAmount) {
    this.newTotalAmount = newTotalAmount;
  }


  public OrderChange newTotalCurrency(String newTotalCurrency) {
    
    this.newTotalCurrency = newTotalCurrency;
    return this;
  }

   /**
   * The currency of the &#x60;new_total_amount&#x60;, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code. It will match your organisation&#39;s billing currency unless you’re using Duffel as an accredited IATA agent, in which case it will be in the currency provided by the airline (which will usually be based on the country where your IATA agency is registered). 
   * @return newTotalCurrency
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "GBP", value = "The currency of the `new_total_amount`, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code. It will match your organisation's billing currency unless you’re using Duffel as an accredited IATA agent, in which case it will be in the currency provided by the airline (which will usually be based on the country where your IATA agency is registered). ")
  @JsonProperty(JSON_PROPERTY_NEW_TOTAL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getNewTotalCurrency() {
    return newTotalCurrency;
  }


  @JsonProperty(JSON_PROPERTY_NEW_TOTAL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNewTotalCurrency(String newTotalCurrency) {
    this.newTotalCurrency = newTotalCurrency;
  }


  public OrderChange orderId(String orderId) {
    
    this.orderId = orderId;
    return this;
  }

   /**
   * Duffel&#39;s unique identifier for the order which is being changed
   * @return orderId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "ord_0000A3tQcCRZ9R8OY0QlxA", value = "Duffel's unique identifier for the order which is being changed")
  @JsonProperty(JSON_PROPERTY_ORDER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOrderId() {
    return orderId;
  }


  @JsonProperty(JSON_PROPERTY_ORDER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOrderId(String orderId) {
    this.orderId = orderId;
  }


  public OrderChange penaltyTotalAmount(String penaltyTotalAmount) {
    
    this.penaltyTotalAmount = penaltyTotalAmount;
    return this;
  }

   /**
   * The amount charged by the airline for making this change.
   * @return penaltyTotalAmount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "15.50", value = "The amount charged by the airline for making this change.")
  @JsonProperty(JSON_PROPERTY_PENALTY_TOTAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPenaltyTotalAmount() {
    return penaltyTotalAmount;
  }


  @JsonProperty(JSON_PROPERTY_PENALTY_TOTAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPenaltyTotalAmount(String penaltyTotalAmount) {
    this.penaltyTotalAmount = penaltyTotalAmount;
  }


  public OrderChange penaltyTotalCurrency(String penaltyTotalCurrency) {
    
    this.penaltyTotalCurrency = penaltyTotalCurrency;
    return this;
  }

   /**
   * The currency of the &#x60;penalty_total_amount&#x60;, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code. It will match your organisation&#39;s billing currency unless you’re using Duffel as an accredited IATA agent, in which case it will be in the currency provided by the airline (which will usually be based on the country where your IATA agency is registered). 
   * @return penaltyTotalCurrency
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "GBP", value = "The currency of the `penalty_total_amount`, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code. It will match your organisation's billing currency unless you’re using Duffel as an accredited IATA agent, in which case it will be in the currency provided by the airline (which will usually be based on the country where your IATA agency is registered). ")
  @JsonProperty(JSON_PROPERTY_PENALTY_TOTAL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPenaltyTotalCurrency() {
    return penaltyTotalCurrency;
  }


  @JsonProperty(JSON_PROPERTY_PENALTY_TOTAL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPenaltyTotalCurrency(String penaltyTotalCurrency) {
    this.penaltyTotalCurrency = penaltyTotalCurrency;
  }


  public OrderChange refundTo(RefundToEnum refundTo) {
    this.refundTo = JsonNullable.<RefundToEnum>of(refundTo);
    
    return this;
  }

   /**
   * Where the refund, once confirmed, will be sent. Refunds are indicated by a negative &#x60;change_total_amount&#x60;. If the change does not require a refund, this field will be &#x60;null&#x60;. &#x60;original_form_of_payment&#x60; refers to the form of payment used to create the order. 
   * @return refundTo
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "voucher", value = "Where the refund, once confirmed, will be sent. Refunds are indicated by a negative `change_total_amount`. If the change does not require a refund, this field will be `null`. `original_form_of_payment` refers to the form of payment used to create the order. ")
  @JsonIgnore

  public RefundToEnum getRefundTo() {
        return refundTo.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_REFUND_TO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<RefundToEnum> getRefundTo_JsonNullable() {
    return refundTo;
  }
  
  @JsonProperty(JSON_PROPERTY_REFUND_TO)
  public void setRefundTo_JsonNullable(JsonNullable<RefundToEnum> refundTo) {
    this.refundTo = refundTo;
  }

  public void setRefundTo(RefundToEnum refundTo) {
    this.refundTo = JsonNullable.<RefundToEnum>of(refundTo);
  }


  public OrderChange slices(OrderChangeSlices slices) {
    
    this.slices = slices;
    return this;
  }

   /**
   * Get slices
   * @return slices
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SLICES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OrderChangeSlices getSlices() {
    return slices;
  }


  @JsonProperty(JSON_PROPERTY_SLICES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSlices(OrderChangeSlices slices) {
    this.slices = slices;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OrderChange orderChange = (OrderChange) o;
    return Objects.equals(this.changeTotalAmount, orderChange.changeTotalAmount) &&
        Objects.equals(this.changeTotalCurrency, orderChange.changeTotalCurrency) &&
        equalsNullable(this.confirmedAt, orderChange.confirmedAt) &&
        Objects.equals(this.createdAt, orderChange.createdAt) &&
        Objects.equals(this.expiresAt, orderChange.expiresAt) &&
        Objects.equals(this.id, orderChange.id) &&
        Objects.equals(this.liveMode, orderChange.liveMode) &&
        Objects.equals(this.newTotalAmount, orderChange.newTotalAmount) &&
        Objects.equals(this.newTotalCurrency, orderChange.newTotalCurrency) &&
        Objects.equals(this.orderId, orderChange.orderId) &&
        Objects.equals(this.penaltyTotalAmount, orderChange.penaltyTotalAmount) &&
        Objects.equals(this.penaltyTotalCurrency, orderChange.penaltyTotalCurrency) &&
        equalsNullable(this.refundTo, orderChange.refundTo) &&
        Objects.equals(this.slices, orderChange.slices);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(changeTotalAmount, changeTotalCurrency, hashCodeNullable(confirmedAt), createdAt, expiresAt, id, liveMode, newTotalAmount, newTotalCurrency, orderId, penaltyTotalAmount, penaltyTotalCurrency, hashCodeNullable(refundTo), slices);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OrderChange {\n");
    sb.append("    changeTotalAmount: ").append(toIndentedString(changeTotalAmount)).append("\n");
    sb.append("    changeTotalCurrency: ").append(toIndentedString(changeTotalCurrency)).append("\n");
    sb.append("    confirmedAt: ").append(toIndentedString(confirmedAt)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    expiresAt: ").append(toIndentedString(expiresAt)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    liveMode: ").append(toIndentedString(liveMode)).append("\n");
    sb.append("    newTotalAmount: ").append(toIndentedString(newTotalAmount)).append("\n");
    sb.append("    newTotalCurrency: ").append(toIndentedString(newTotalCurrency)).append("\n");
    sb.append("    orderId: ").append(toIndentedString(orderId)).append("\n");
    sb.append("    penaltyTotalAmount: ").append(toIndentedString(penaltyTotalAmount)).append("\n");
    sb.append("    penaltyTotalCurrency: ").append(toIndentedString(penaltyTotalCurrency)).append("\n");
    sb.append("    refundTo: ").append(toIndentedString(refundTo)).append("\n");
    sb.append("    slices: ").append(toIndentedString(slices)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

