/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Whether the whole order can be changed before the departure of the first slice. If all of the slices on the order can be changed then the &#x60;allowed&#x60; property will be &#x60;true&#x60;. Refer to the &#x60;slices&#x60; for information about change penalties. If any of the slices on the order can&#39;t be changed then the &#x60;allowed&#x60; property will be &#x60;false&#x60;. In this case you should refer to the &#x60;slices&#x60; conditions to determine if any part of the order is changeable. If the airline hasn&#39;t provided any information about whether this order can be changed then this property will be &#x60;null&#x60;. 
 */
@ApiModel(description = "Whether the whole order can be changed before the departure of the first slice. If all of the slices on the order can be changed then the `allowed` property will be `true`. Refer to the `slices` for information about change penalties. If any of the slices on the order can't be changed then the `allowed` property will be `false`. In this case you should refer to the `slices` conditions to determine if any part of the order is changeable. If the airline hasn't provided any information about whether this order can be changed then this property will be `null`. ")
@JsonPropertyOrder({
  OrderConditions1ChangeBeforeDeparture.JSON_PROPERTY_ALLOWED,
  OrderConditions1ChangeBeforeDeparture.JSON_PROPERTY_PENALTY_AMOUNT,
  OrderConditions1ChangeBeforeDeparture.JSON_PROPERTY_PENALTY_CURRENCY
})
@JsonTypeName("OrderConditions_1_change_before_departure")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:13:42.592945+07:00[Asia/Bangkok]")
public class OrderConditions1ChangeBeforeDeparture {
  public static final String JSON_PROPERTY_ALLOWED = "allowed";
  private Boolean allowed;

  public static final String JSON_PROPERTY_PENALTY_AMOUNT = "penalty_amount";
  private JsonNullable<String> penaltyAmount = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PENALTY_CURRENCY = "penalty_currency";
  private JsonNullable<String> penaltyCurrency = JsonNullable.<String>undefined();

  public OrderConditions1ChangeBeforeDeparture() { 
  }

  public OrderConditions1ChangeBeforeDeparture allowed(Boolean allowed) {
    
    this.allowed = allowed;
    return this;
  }

   /**
   * Whether this kind of modification is allowed post-booking
   * @return allowed
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Whether this kind of modification is allowed post-booking")
  @JsonProperty(JSON_PROPERTY_ALLOWED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAllowed() {
    return allowed;
  }


  @JsonProperty(JSON_PROPERTY_ALLOWED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAllowed(Boolean allowed) {
    this.allowed = allowed;
  }


  public OrderConditions1ChangeBeforeDeparture penaltyAmount(String penaltyAmount) {
    this.penaltyAmount = JsonNullable.<String>of(penaltyAmount);
    
    return this;
  }

   /**
   * If the modification is &#x60;allowed&#x60; then this is the amount payable to apply the modification to all passengers. If there is no penalty, the value will be zero. If the modification isn&#39;t &#x60;allowed&#x60; or the penalty is not known then this field will be &#x60;null&#x60;. If this is &#x60;null&#x60; then the &#x60;penalty_currency&#x60; will also be &#x60;null&#x60;. 
   * @return penaltyAmount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "100.00", value = "If the modification is `allowed` then this is the amount payable to apply the modification to all passengers. If there is no penalty, the value will be zero. If the modification isn't `allowed` or the penalty is not known then this field will be `null`. If this is `null` then the `penalty_currency` will also be `null`. ")
  @JsonIgnore

  public String getPenaltyAmount() {
        return penaltyAmount.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PENALTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getPenaltyAmount_JsonNullable() {
    return penaltyAmount;
  }
  
  @JsonProperty(JSON_PROPERTY_PENALTY_AMOUNT)
  public void setPenaltyAmount_JsonNullable(JsonNullable<String> penaltyAmount) {
    this.penaltyAmount = penaltyAmount;
  }

  public void setPenaltyAmount(String penaltyAmount) {
    this.penaltyAmount = JsonNullable.<String>of(penaltyAmount);
  }


  public OrderConditions1ChangeBeforeDeparture penaltyCurrency(String penaltyCurrency) {
    this.penaltyCurrency = JsonNullable.<String>of(penaltyCurrency);
    
    return this;
  }

   /**
   * The currency of the &#x60;penalty_amount&#x60; as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code. This will be in a currency determined by the airline, which is not necessarily the same as the currency of the offer or order. If this is &#x60;null&#x60; then &#x60;penalty_amount&#x60; will also be &#x60;null&#x60;. 
   * @return penaltyCurrency
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "GBP", value = "The currency of the `penalty_amount` as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code. This will be in a currency determined by the airline, which is not necessarily the same as the currency of the offer or order. If this is `null` then `penalty_amount` will also be `null`. ")
  @JsonIgnore

  public String getPenaltyCurrency() {
        return penaltyCurrency.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PENALTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getPenaltyCurrency_JsonNullable() {
    return penaltyCurrency;
  }
  
  @JsonProperty(JSON_PROPERTY_PENALTY_CURRENCY)
  public void setPenaltyCurrency_JsonNullable(JsonNullable<String> penaltyCurrency) {
    this.penaltyCurrency = penaltyCurrency;
  }

  public void setPenaltyCurrency(String penaltyCurrency) {
    this.penaltyCurrency = JsonNullable.<String>of(penaltyCurrency);
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OrderConditions1ChangeBeforeDeparture orderConditions1ChangeBeforeDeparture = (OrderConditions1ChangeBeforeDeparture) o;
    return Objects.equals(this.allowed, orderConditions1ChangeBeforeDeparture.allowed) &&
        equalsNullable(this.penaltyAmount, orderConditions1ChangeBeforeDeparture.penaltyAmount) &&
        equalsNullable(this.penaltyCurrency, orderConditions1ChangeBeforeDeparture.penaltyCurrency);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(allowed, hashCodeNullable(penaltyAmount), hashCodeNullable(penaltyCurrency));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OrderConditions1ChangeBeforeDeparture {\n");
    sb.append("    allowed: ").append(toIndentedString(allowed)).append("\n");
    sb.append("    penaltyAmount: ").append(toIndentedString(penaltyAmount)).append("\n");
    sb.append("    penaltyCurrency: ").append(toIndentedString(penaltyCurrency)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

