/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * An object containing metadata about the service, like the maximum weight and dimensions of the baggage.
 */
@ApiModel(description = "An object containing metadata about the service, like the maximum weight and dimensions of the baggage.")
@JsonPropertyOrder({
  ServiceMetadataBaggage.JSON_PROPERTY_MAXIMUM_DEPTH_CM,
  ServiceMetadataBaggage.JSON_PROPERTY_MAXIMUM_HEIGHT_CM,
  ServiceMetadataBaggage.JSON_PROPERTY_MAXIMUM_LENGTH_CM,
  ServiceMetadataBaggage.JSON_PROPERTY_MAXIMUM_WEIGHT_KG,
  ServiceMetadataBaggage.JSON_PROPERTY_TYPE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:13:42.592945+07:00[Asia/Bangkok]")
public class ServiceMetadataBaggage {
  public static final String JSON_PROPERTY_MAXIMUM_DEPTH_CM = "maximum_depth_cm";
  private BigDecimal maximumDepthCm;

  public static final String JSON_PROPERTY_MAXIMUM_HEIGHT_CM = "maximum_height_cm";
  private BigDecimal maximumHeightCm;

  public static final String JSON_PROPERTY_MAXIMUM_LENGTH_CM = "maximum_length_cm";
  private BigDecimal maximumLengthCm;

  public static final String JSON_PROPERTY_MAXIMUM_WEIGHT_KG = "maximum_weight_kg";
  private BigDecimal maximumWeightKg;

  /**
   * The type of the baggage
   */
  public enum TypeEnum {
    CHECKED("checked"),
    
    CARRY_ON("carry_on");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public ServiceMetadataBaggage() { 
  }

  public ServiceMetadataBaggage maximumDepthCm(BigDecimal maximumDepthCm) {
    
    this.maximumDepthCm = maximumDepthCm;
    return this;
  }

   /**
   * The maximum depth that the baggage can have in centimetres
   * @return maximumDepthCm
  **/
  @javax.annotation.Nullable
  @NotNull
  @Valid
  @ApiModelProperty(example = "75", required = true, value = "The maximum depth that the baggage can have in centimetres")
  @JsonProperty(JSON_PROPERTY_MAXIMUM_DEPTH_CM)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BigDecimal getMaximumDepthCm() {
    return maximumDepthCm;
  }


  @JsonProperty(JSON_PROPERTY_MAXIMUM_DEPTH_CM)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMaximumDepthCm(BigDecimal maximumDepthCm) {
    this.maximumDepthCm = maximumDepthCm;
  }


  public ServiceMetadataBaggage maximumHeightCm(BigDecimal maximumHeightCm) {
    
    this.maximumHeightCm = maximumHeightCm;
    return this;
  }

   /**
   * The maximum height that the baggage can have in centimetres
   * @return maximumHeightCm
  **/
  @javax.annotation.Nullable
  @NotNull
  @Valid
  @ApiModelProperty(example = "90", required = true, value = "The maximum height that the baggage can have in centimetres")
  @JsonProperty(JSON_PROPERTY_MAXIMUM_HEIGHT_CM)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BigDecimal getMaximumHeightCm() {
    return maximumHeightCm;
  }


  @JsonProperty(JSON_PROPERTY_MAXIMUM_HEIGHT_CM)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMaximumHeightCm(BigDecimal maximumHeightCm) {
    this.maximumHeightCm = maximumHeightCm;
  }


  public ServiceMetadataBaggage maximumLengthCm(BigDecimal maximumLengthCm) {
    
    this.maximumLengthCm = maximumLengthCm;
    return this;
  }

   /**
   * The maximum length that the baggage can have in centimetres
   * @return maximumLengthCm
  **/
  @javax.annotation.Nullable
  @NotNull
  @Valid
  @ApiModelProperty(example = "90", required = true, value = "The maximum length that the baggage can have in centimetres")
  @JsonProperty(JSON_PROPERTY_MAXIMUM_LENGTH_CM)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BigDecimal getMaximumLengthCm() {
    return maximumLengthCm;
  }


  @JsonProperty(JSON_PROPERTY_MAXIMUM_LENGTH_CM)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMaximumLengthCm(BigDecimal maximumLengthCm) {
    this.maximumLengthCm = maximumLengthCm;
  }


  public ServiceMetadataBaggage maximumWeightKg(BigDecimal maximumWeightKg) {
    
    this.maximumWeightKg = maximumWeightKg;
    return this;
  }

   /**
   * The maximum weight that the baggage can have in kilograms
   * @return maximumWeightKg
  **/
  @javax.annotation.Nullable
  @NotNull
  @Valid
  @ApiModelProperty(example = "23", required = true, value = "The maximum weight that the baggage can have in kilograms")
  @JsonProperty(JSON_PROPERTY_MAXIMUM_WEIGHT_KG)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BigDecimal getMaximumWeightKg() {
    return maximumWeightKg;
  }


  @JsonProperty(JSON_PROPERTY_MAXIMUM_WEIGHT_KG)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMaximumWeightKg(BigDecimal maximumWeightKg) {
    this.maximumWeightKg = maximumWeightKg;
  }


  public ServiceMetadataBaggage type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * The type of the baggage
   * @return type
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "checked", required = true, value = "The type of the baggage")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ServiceMetadataBaggage serviceMetadataBaggage = (ServiceMetadataBaggage) o;
    return Objects.equals(this.maximumDepthCm, serviceMetadataBaggage.maximumDepthCm) &&
        Objects.equals(this.maximumHeightCm, serviceMetadataBaggage.maximumHeightCm) &&
        Objects.equals(this.maximumLengthCm, serviceMetadataBaggage.maximumLengthCm) &&
        Objects.equals(this.maximumWeightKg, serviceMetadataBaggage.maximumWeightKg) &&
        Objects.equals(this.type, serviceMetadataBaggage.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(maximumDepthCm, maximumHeightCm, maximumLengthCm, maximumWeightKg, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ServiceMetadataBaggage {\n");
    sb.append("    maximumDepthCm: ").append(toIndentedString(maximumDepthCm)).append("\n");
    sb.append("    maximumHeightCm: ").append(toIndentedString(maximumHeightCm)).append("\n");
    sb.append("    maximumLengthCm: ").append(toIndentedString(maximumLengthCm)).append("\n");
    sb.append("    maximumWeightKg: ").append(toIndentedString(maximumWeightKg)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

