/*
 * Decompiled with CFR 0.152.
 */
package com.duffel.sdk.api;

import com.duffel.sdk.invoker.ApiClient;
import com.duffel.sdk.model.GetOfferById200Response;
import com.duffel.sdk.model.GetOffers200Response;
import com.duffel.sdk.model.UpdateOfferPassengerById200Response;
import com.duffel.sdk.model.UpdateOfferPassengerByIdRequest;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;

public class OffersApi {
    private ApiClient apiClient;

    public OffersApi() {
        this(new ApiClient());
    }

    @Autowired
    public OffersApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec getOfferByIdRequestCreation(String accept, String duffelVersion, String id, String acceptEncoding, Boolean returnAvailableServices) throws WebClientResponseException {
        Object postBody = null;
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling getOfferById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling getOfferById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling getOfferById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "return_available_services", returnAvailableServices));
        if (acceptEncoding != null) {
            headerParams.add("Accept-Encoding", this.apiClient.parameterToString(acceptEncoding));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        if (duffelVersion != null) {
            headerParams.add("Duffel-Version", this.apiClient.parameterToString(duffelVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        ParameterizedTypeReference<GetOfferById200Response> localVarReturnType = new ParameterizedTypeReference<GetOfferById200Response>(){};
        return this.apiClient.invokeAPI("/air/offers/{id}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<GetOfferById200Response> getOfferById(String accept, String duffelVersion, String id, String acceptEncoding, Boolean returnAvailableServices) throws WebClientResponseException {
        ParameterizedTypeReference<GetOfferById200Response> localVarReturnType = new ParameterizedTypeReference<GetOfferById200Response>(){};
        return this.getOfferByIdRequestCreation(accept, duffelVersion, id, acceptEncoding, returnAvailableServices).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<GetOfferById200Response>> getOfferByIdWithHttpInfo(String accept, String duffelVersion, String id, String acceptEncoding, Boolean returnAvailableServices) throws WebClientResponseException {
        ParameterizedTypeReference<GetOfferById200Response> localVarReturnType = new ParameterizedTypeReference<GetOfferById200Response>(){};
        return this.getOfferByIdRequestCreation(accept, duffelVersion, id, acceptEncoding, returnAvailableServices).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec getOffersRequestCreation(String accept, String duffelVersion, String offerRequestId, String acceptEncoding, String after, String before, Integer limit, String sort, Integer maxConnections) throws WebClientResponseException {
        Object postBody = null;
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling getOffers", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling getOffers", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (offerRequestId == null) {
            throw new WebClientResponseException("Missing the required parameter 'offerRequestId' when calling getOffers", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", after));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "before", before));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "limit", limit));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "offer_request_id", offerRequestId));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "sort", sort));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "max_connections", maxConnections));
        if (acceptEncoding != null) {
            headerParams.add("Accept-Encoding", this.apiClient.parameterToString(acceptEncoding));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        if (duffelVersion != null) {
            headerParams.add("Duffel-Version", this.apiClient.parameterToString(duffelVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        ParameterizedTypeReference<GetOffers200Response> localVarReturnType = new ParameterizedTypeReference<GetOffers200Response>(){};
        return this.apiClient.invokeAPI("/air/offers", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<GetOffers200Response> getOffers(String accept, String duffelVersion, String offerRequestId, String acceptEncoding, String after, String before, Integer limit, String sort, Integer maxConnections) throws WebClientResponseException {
        ParameterizedTypeReference<GetOffers200Response> localVarReturnType = new ParameterizedTypeReference<GetOffers200Response>(){};
        return this.getOffersRequestCreation(accept, duffelVersion, offerRequestId, acceptEncoding, after, before, limit, sort, maxConnections).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<GetOffers200Response>> getOffersWithHttpInfo(String accept, String duffelVersion, String offerRequestId, String acceptEncoding, String after, String before, Integer limit, String sort, Integer maxConnections) throws WebClientResponseException {
        ParameterizedTypeReference<GetOffers200Response> localVarReturnType = new ParameterizedTypeReference<GetOffers200Response>(){};
        return this.getOffersRequestCreation(accept, duffelVersion, offerRequestId, acceptEncoding, after, before, limit, sort, maxConnections).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec updateOfferPassengerByIdRequestCreation(String accept, String duffelVersion, String offerId, String offerPassengerId, String acceptEncoding, UpdateOfferPassengerByIdRequest updateOfferPassengerByIdRequest) throws WebClientResponseException {
        UpdateOfferPassengerByIdRequest postBody = updateOfferPassengerByIdRequest;
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling updateOfferPassengerById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling updateOfferPassengerById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (offerId == null) {
            throw new WebClientResponseException("Missing the required parameter 'offerId' when calling updateOfferPassengerById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (offerPassengerId == null) {
            throw new WebClientResponseException("Missing the required parameter 'offerPassengerId' when calling updateOfferPassengerById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("offer_id", offerId);
        pathParams.put("offer_passenger_id", offerPassengerId);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (acceptEncoding != null) {
            headerParams.add("Accept-Encoding", this.apiClient.parameterToString(acceptEncoding));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        if (duffelVersion != null) {
            headerParams.add("Duffel-Version", this.apiClient.parameterToString(duffelVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<UpdateOfferPassengerById200Response> localVarReturnType = new ParameterizedTypeReference<UpdateOfferPassengerById200Response>(){};
        return this.apiClient.invokeAPI("/air/offers/{offer_id}/passengers/{offer_passenger_id}", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<UpdateOfferPassengerById200Response> updateOfferPassengerById(String accept, String duffelVersion, String offerId, String offerPassengerId, String acceptEncoding, UpdateOfferPassengerByIdRequest updateOfferPassengerByIdRequest) throws WebClientResponseException {
        ParameterizedTypeReference<UpdateOfferPassengerById200Response> localVarReturnType = new ParameterizedTypeReference<UpdateOfferPassengerById200Response>(){};
        return this.updateOfferPassengerByIdRequestCreation(accept, duffelVersion, offerId, offerPassengerId, acceptEncoding, updateOfferPassengerByIdRequest).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<UpdateOfferPassengerById200Response>> updateOfferPassengerByIdWithHttpInfo(String accept, String duffelVersion, String offerId, String offerPassengerId, String acceptEncoding, UpdateOfferPassengerByIdRequest updateOfferPassengerByIdRequest) throws WebClientResponseException {
        ParameterizedTypeReference<UpdateOfferPassengerById200Response> localVarReturnType = new ParameterizedTypeReference<UpdateOfferPassengerById200Response>(){};
        return this.updateOfferPassengerByIdRequestCreation(accept, duffelVersion, offerId, offerPassengerId, acceptEncoding, updateOfferPassengerByIdRequest).toEntity((ParameterizedTypeReference)localVarReturnType);
    }
}

