/*
 * Decompiled with CFR 0.152.
 */
package com.duffel.sdk.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="The airline selling the tickets for this segment. This may differ from the `operating_carrier` in the case of a \"codeshare\", where one airline sells flights operated by another airline.")
@JsonPropertyOrder(value={"iata_code", "id", "logo_lockup_url", "logo_symbol_url", "name"})
@JsonTypeName(value="Airline_2")
public class Airline2 {
    public static final String JSON_PROPERTY_IATA_CODE = "iata_code";
    private JsonNullable<String> iataCode = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_LOGO_LOCKUP_URL = "logo_lockup_url";
    private JsonNullable<String> logoLockupUrl = JsonNullable.undefined();
    public static final String JSON_PROPERTY_LOGO_SYMBOL_URL = "logo_symbol_url";
    private JsonNullable<String> logoSymbolUrl = JsonNullable.undefined();
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public Airline2 iataCode(String iataCode) {
        this.iataCode = JsonNullable.of((Object)iataCode);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="BA", value="The two-character IATA code for the airline. This may be `null` for non-IATA carriers.")
    @JsonIgnore
    public String getIataCode() {
        return (String)this.iataCode.orElse(null);
    }

    @JsonProperty(value="iata_code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getIataCode_JsonNullable() {
        return this.iataCode;
    }

    @JsonProperty(value="iata_code")
    public void setIataCode_JsonNullable(JsonNullable<String> iataCode) {
        this.iataCode = iataCode;
    }

    public void setIataCode(String iataCode) {
        this.iataCode = JsonNullable.of((Object)iataCode);
    }

    public Airline2 id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="aln_00001876aqC8c5umZmrRds", value="Duffel's unique identifier for the airline")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public Airline2 logoLockupUrl(String logoLockupUrl) {
        this.logoLockupUrl = JsonNullable.of((Object)logoLockupUrl);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://assets.duffel.com/img/airlines/for-light-background/full-color-lockup/BA.svg", value="Path to a svg of the airline lockup logo. A lockup logo is also called a combination logo, in which it combines the logotype and logomark. This may be `null` if no logo is available.")
    @JsonIgnore
    public String getLogoLockupUrl() {
        return (String)this.logoLockupUrl.orElse(null);
    }

    @JsonProperty(value="logo_lockup_url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getLogoLockupUrl_JsonNullable() {
        return this.logoLockupUrl;
    }

    @JsonProperty(value="logo_lockup_url")
    public void setLogoLockupUrl_JsonNullable(JsonNullable<String> logoLockupUrl) {
        this.logoLockupUrl = logoLockupUrl;
    }

    public void setLogoLockupUrl(String logoLockupUrl) {
        this.logoLockupUrl = JsonNullable.of((Object)logoLockupUrl);
    }

    public Airline2 logoSymbolUrl(String logoSymbolUrl) {
        this.logoSymbolUrl = JsonNullable.of((Object)logoSymbolUrl);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://assets.duffel.com/img/airlines/for-light-background/full-color-logo/BA.svg", value="Path to a svg of the airline logo. This may be `null` if no logo is available.")
    @JsonIgnore
    public String getLogoSymbolUrl() {
        return (String)this.logoSymbolUrl.orElse(null);
    }

    @JsonProperty(value="logo_symbol_url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getLogoSymbolUrl_JsonNullable() {
        return this.logoSymbolUrl;
    }

    @JsonProperty(value="logo_symbol_url")
    public void setLogoSymbolUrl_JsonNullable(JsonNullable<String> logoSymbolUrl) {
        this.logoSymbolUrl = logoSymbolUrl;
    }

    public void setLogoSymbolUrl(String logoSymbolUrl) {
        this.logoSymbolUrl = JsonNullable.of((Object)logoSymbolUrl);
    }

    public Airline2 name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="British Airways", value="The name of the airline")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Airline2 airline2 = (Airline2)o;
        return Airline2.equalsNullable(this.iataCode, airline2.iataCode) && Objects.equals(this.id, airline2.id) && Airline2.equalsNullable(this.logoLockupUrl, airline2.logoLockupUrl) && Airline2.equalsNullable(this.logoSymbolUrl, airline2.logoSymbolUrl) && Objects.equals(this.name, airline2.name);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(Airline2.hashCodeNullable(this.iataCode), this.id, Airline2.hashCodeNullable(this.logoLockupUrl), Airline2.hashCodeNullable(this.logoSymbolUrl), this.name);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Airline2 {\n");
        sb.append("    iataCode: ").append(this.toIndentedString(this.iataCode)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    logoLockupUrl: ").append(this.toIndentedString(this.logoLockupUrl)).append("\n");
        sb.append("    logoSymbolUrl: ").append(this.toIndentedString(this.logoSymbolUrl)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

