/*
 * Decompiled with CFR 0.152.
 */
package com.duffel.sdk.model;

import com.duffel.sdk.model.SeatService;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"available_services", "designator", "disclosures", "name", "type"})
@JsonTypeName(value="Cabin_Row_Section_elements_inner")
public class CabinRowSectionElementsInner {
    public static final String JSON_PROPERTY_AVAILABLE_SERVICES = "available_services";
    private List<SeatService> availableServices = new ArrayList<SeatService>();
    public static final String JSON_PROPERTY_DESIGNATOR = "designator";
    private String designator;
    public static final String JSON_PROPERTY_DISCLOSURES = "disclosures";
    private List<String> disclosures = new ArrayList<String>();
    public static final String JSON_PROPERTY_NAME = "name";
    private JsonNullable<String> name = JsonNullable.undefined();
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public CabinRowSectionElementsInner availableServices(List<SeatService> availableServices) {
        this.availableServices = availableServices;
        return this;
    }

    public CabinRowSectionElementsInner addAvailableServicesItem(SeatService availableServicesItem) {
        this.availableServices.add(availableServicesItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Seats are considered a special kind of service. There will be at most one service per seat per passenger. A seat can only be booked for one passenger. If a seat has no available services (which will be represented as an empty list : `[]`) then it's unavailable. ")
    @JsonProperty(value="available_services")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<SeatService> getAvailableServices() {
        return this.availableServices;
    }

    @JsonProperty(value="available_services")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAvailableServices(List<SeatService> availableServices) {
        this.availableServices = availableServices;
    }

    public CabinRowSectionElementsInner designator(String designator) {
        this.designator = designator;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="14B", required=true, value="The designator used to uniquely identify the seat, usually made up of a  row number and a column letter ")
    @JsonProperty(value="designator")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDesignator() {
        return this.designator;
    }

    @JsonProperty(value="designator")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDesignator(String designator) {
        this.designator = designator;
    }

    public CabinRowSectionElementsInner disclosures(List<String> disclosures) {
        this.disclosures = disclosures;
        return this;
    }

    public CabinRowSectionElementsInner addDisclosuresItem(String disclosuresItem) {
        this.disclosures.add(disclosuresItem);
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="[\"Do not seat children in exit row seats\",\"Do not seat passengers with special needs in exit row seats\"]", required=true, value="Each disclosure is text, in English, provided by the airline that  describes the terms and conditions of this seat. We recommend showing  this in your user interface to make sure that customers understand any  restrictions and limitations. ")
    @JsonProperty(value="disclosures")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getDisclosures() {
        return this.disclosures;
    }

    @JsonProperty(value="disclosures")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDisclosures(List<String> disclosures) {
        this.disclosures = disclosures;
    }

    public CabinRowSectionElementsInner name(String name) {
        this.name = JsonNullable.of((Object)name);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Exit row seat", value="A name which describes the type of seat, which you can display in your  user interface to help customers to understand its features ")
    @JsonIgnore
    public String getName() {
        return (String)this.name.orElse(null);
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getName_JsonNullable() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName_JsonNullable(JsonNullable<String> name) {
        this.name = name;
    }

    public void setName(String name) {
        this.name = JsonNullable.of((Object)name);
    }

    public CabinRowSectionElementsInner type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="stairs", required=true, value="The type of this element")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CabinRowSectionElementsInner cabinRowSectionElementsInner = (CabinRowSectionElementsInner)o;
        return Objects.equals(this.availableServices, cabinRowSectionElementsInner.availableServices) && Objects.equals(this.designator, cabinRowSectionElementsInner.designator) && Objects.equals(this.disclosures, cabinRowSectionElementsInner.disclosures) && CabinRowSectionElementsInner.equalsNullable(this.name, cabinRowSectionElementsInner.name) && Objects.equals((Object)this.type, (Object)cabinRowSectionElementsInner.type);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.availableServices, this.designator, this.disclosures, CabinRowSectionElementsInner.hashCodeNullable(this.name), this.type});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CabinRowSectionElementsInner {\n");
        sb.append("    availableServices: ").append(this.toIndentedString(this.availableServices)).append("\n");
        sb.append("    designator: ").append(this.toIndentedString(this.designator)).append("\n");
        sb.append("    disclosures: ").append(this.toIndentedString(this.disclosures)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        STAIRS("stairs");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

