/*
 * Decompiled with CFR 0.152.
 */
package com.duffel.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The metropolitan area where the airport is located. Only present for airports which are registered with IATA as belonging to a [metropolitan area](https://portal.iata.org/faq/articles/en_US/FAQ/How-do-I-create-a-new-Metropolitan-Area).")
@JsonPropertyOrder(value={"iata_code", "iata_country_code", "id", "name"})
@JsonTypeName(value="City_1")
public class City1 {
    public static final String JSON_PROPERTY_IATA_CODE = "iata_code";
    private String iataCode;
    public static final String JSON_PROPERTY_IATA_COUNTRY_CODE = "iata_country_code";
    private String iataCountryCode;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public City1 iataCode(String iataCode) {
        this.iataCode = iataCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="NYC", value="The three-character IATA code for the city")
    @JsonProperty(value="iata_code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIataCode() {
        return this.iataCode;
    }

    @JsonProperty(value="iata_code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIataCode(String iataCode) {
        this.iataCode = iataCode;
    }

    public City1 iataCountryCode(String iataCountryCode) {
        this.iataCountryCode = iataCountryCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="US", value="The [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) code for the country where the city is located")
    @JsonProperty(value="iata_country_code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIataCountryCode() {
        return this.iataCountryCode;
    }

    @JsonProperty(value="iata_country_code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIataCountryCode(String iataCountryCode) {
        this.iataCountryCode = iataCountryCode;
    }

    public City1 id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="cit_nyc_us", value="Duffel's unique identifier for the city")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public City1 name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="New York", value="The name of the city")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        City1 city1 = (City1)o;
        return Objects.equals(this.iataCode, city1.iataCode) && Objects.equals(this.iataCountryCode, city1.iataCountryCode) && Objects.equals(this.id, city1.id) && Objects.equals(this.name, city1.name);
    }

    public int hashCode() {
        return Objects.hash(this.iataCode, this.iataCountryCode, this.id, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class City1 {\n");
        sb.append("    iataCode: ").append(this.toIndentedString(this.iataCode)).append("\n");
        sb.append("    iataCountryCode: ").append(this.toIndentedString(this.iataCountryCode)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

