/*
 * Decompiled with CFR 0.152.
 */
package com.duffel.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.validation.constraints.NotNull;

@JsonPropertyOrder(value={"amount", "currency"})
@JsonTypeName(value="createPaymentIntent_request_data")
public class CreatePaymentIntentRequestData {
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private String amount;
    public static final String JSON_PROPERTY_CURRENCY = "currency";
    private String currency;

    public CreatePaymentIntentRequestData amount(String amount) {
        this.amount = amount;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="30.20", required=true, value="This is the amount that the card payment being taken will be charged.  It should be enough to cover the service(s) you want to sell (enough to book an __Offer__ for example) and the processing fees.  If the currency is different from your Balance currency you should also account for foreign exchange.  It can be higher than that, in which case the remainder will be considered your markup.  If it's higher than the maximum allowed for you organisation you will get a validation error. By default the maximum is 5,000.00 GBP (or equivalent in the same currency). If you need a maximum higher than the default please get in touch with us via <help@duffel.com>. ")
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAmount(String amount) {
        this.amount = amount;
    }

    public CreatePaymentIntentRequestData currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="GBP", required=true, value="The currency of the `amount`, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code.  This is going to be the currency that the card payment being taken in will be charged in. ")
    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreatePaymentIntentRequestData createPaymentIntentRequestData = (CreatePaymentIntentRequestData)o;
        return Objects.equals(this.amount, createPaymentIntentRequestData.amount) && Objects.equals(this.currency, createPaymentIntentRequestData.currency);
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.currency);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreatePaymentIntentRequestData {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

