/*
 * Decompiled with CFR 0.152.
 */
package com.duffel.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonPropertyOrder(value={"active", "created_at", "events", "id", "live_mode", "updated_at", "url", "secret"})
@JsonTypeName(value="createWebhook_201_response_data")
public class CreateWebhook201ResponseData {
    public static final String JSON_PROPERTY_ACTIVE = "active";
    private Boolean active;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_EVENTS = "events";
    private List<String> events = new ArrayList<String>();
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_LIVE_MODE = "live_mode";
    private Boolean liveMode;
    public static final String JSON_PROPERTY_UPDATED_AT = "updated_at";
    private OffsetDateTime updatedAt;
    public static final String JSON_PROPERTY_URL = "url";
    private String url;
    public static final String JSON_PROPERTY_SECRET = "secret";
    private String secret;

    public CreateWebhook201ResponseData active(Boolean active) {
        this.active = active;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="true", required=true, value="Whether the webhook receiver is actively being notified or not")
    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getActive() {
        return this.active;
    }

    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setActive(Boolean active) {
        this.active = active;
    }

    public CreateWebhook201ResponseData createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(example="2020-04-11T15:48:11.642Z", required=true, value="The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the order change was created")
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public CreateWebhook201ResponseData events(List<String> events) {
        this.events = events;
        return this;
    }

    public CreateWebhook201ResponseData addEventsItem(String eventsItem) {
        this.events.add(eventsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="[\"order.created\",\"order.airline_initiated_change_detected\"]", required=true, value="The events that this webhook will be subscribed to")
    @JsonProperty(value="events")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getEvents() {
        return this.events;
    }

    @JsonProperty(value="events")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEvents(List<String> events) {
        this.events = events;
    }

    public CreateWebhook201ResponseData id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="end_0000A3tQSmKyqOrcySrGbo", required=true, value="Duffel's unique identifier for the webhook receiver")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(String id) {
        this.id = id;
    }

    public CreateWebhook201ResponseData liveMode(Boolean liveMode) {
        this.liveMode = liveMode;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="true", required=true, value="The live mode that the webhook was created in. It will _only_ receive events for that same live mode. For example, you won't receive `order.created` events for orders that you created in the sandbox, if your webook is for `live_mode: true`. ")
    @JsonProperty(value="live_mode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getLiveMode() {
        return this.liveMode;
    }

    @JsonProperty(value="live_mode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLiveMode(Boolean liveMode) {
        this.liveMode = liveMode;
    }

    public CreateWebhook201ResponseData updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(example="2020-04-11T15:48:11.642Z", required=true, value="The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the order change was updated")
    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public CreateWebhook201ResponseData url(String url) {
        this.url = url;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="https://www.example.com:4000/webhooks", required=true, value="The URL where your webhook will be received")
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUrl(String url) {
        this.url = url;
    }

    public CreateWebhook201ResponseData secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="QKfUULLQh+8SegYmIsF6kA==", value="The secret used to secure the payload being sent. This will only be returned when the webhook is first created. ")
    @JsonProperty(value="secret")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSecret() {
        return this.secret;
    }

    @JsonProperty(value="secret")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSecret(String secret) {
        this.secret = secret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateWebhook201ResponseData createWebhook201ResponseData = (CreateWebhook201ResponseData)o;
        return Objects.equals(this.active, createWebhook201ResponseData.active) && Objects.equals(this.createdAt, createWebhook201ResponseData.createdAt) && Objects.equals(this.events, createWebhook201ResponseData.events) && Objects.equals(this.id, createWebhook201ResponseData.id) && Objects.equals(this.liveMode, createWebhook201ResponseData.liveMode) && Objects.equals(this.updatedAt, createWebhook201ResponseData.updatedAt) && Objects.equals(this.url, createWebhook201ResponseData.url) && Objects.equals(this.secret, createWebhook201ResponseData.secret);
    }

    public int hashCode() {
        return Objects.hash(this.active, this.createdAt, this.events, this.id, this.liveMode, this.updatedAt, this.url, this.secret);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateWebhook201ResponseData {\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    events: ").append(this.toIndentedString(this.events)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    liveMode: ").append(this.toIndentedString(this.liveMode)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

