/*
 * Decompiled with CFR 0.152.
 */
package com.duffel.sdk.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"payment_required_by", "price_guarantee_expires_at", "requires_instant_payment"})
@JsonTypeName(value="Offer_Index_payment_requirements")
public class OfferIndexPaymentRequirements {
    public static final String JSON_PROPERTY_PAYMENT_REQUIRED_BY = "payment_required_by";
    private JsonNullable<OffsetDateTime> paymentRequiredBy = JsonNullable.undefined();
    public static final String JSON_PROPERTY_PRICE_GUARANTEE_EXPIRES_AT = "price_guarantee_expires_at";
    private JsonNullable<OffsetDateTime> priceGuaranteeExpiresAt = JsonNullable.undefined();
    public static final String JSON_PROPERTY_REQUIRES_INSTANT_PAYMENT = "requires_instant_payment";
    private Boolean requiresInstantPayment;

    public OfferIndexPaymentRequirements paymentRequiredBy(OffsetDateTime paymentRequiredBy) {
        this.paymentRequiredBy = JsonNullable.of((Object)paymentRequiredBy);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(example="2020-01-17T10:42:14Z", value="The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime by which you must pay for this offer. At this time, if still unpaid, the reserved space on the flight(s) will be released and you will have to create a new order. This will be `null` when the offer requires immediate payment - that is, when `requires_instant_payment` is `true`. ")
    @JsonIgnore
    public OffsetDateTime getPaymentRequiredBy() {
        return (OffsetDateTime)this.paymentRequiredBy.orElse(null);
    }

    @JsonProperty(value="payment_required_by")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<OffsetDateTime> getPaymentRequiredBy_JsonNullable() {
        return this.paymentRequiredBy;
    }

    @JsonProperty(value="payment_required_by")
    public void setPaymentRequiredBy_JsonNullable(JsonNullable<OffsetDateTime> paymentRequiredBy) {
        this.paymentRequiredBy = paymentRequiredBy;
    }

    public void setPaymentRequiredBy(OffsetDateTime paymentRequiredBy) {
        this.paymentRequiredBy = JsonNullable.of((Object)paymentRequiredBy);
    }

    public OfferIndexPaymentRequirements priceGuaranteeExpiresAt(OffsetDateTime priceGuaranteeExpiresAt) {
        this.priceGuaranteeExpiresAt = JsonNullable.of((Object)priceGuaranteeExpiresAt);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the price associated with the order will no longer be guaranteed by the airline and may change before payment. This will be `null` when `requires_instant_payment` is `true`. ")
    @JsonIgnore
    public OffsetDateTime getPriceGuaranteeExpiresAt() {
        return (OffsetDateTime)this.priceGuaranteeExpiresAt.orElse(null);
    }

    @JsonProperty(value="price_guarantee_expires_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<OffsetDateTime> getPriceGuaranteeExpiresAt_JsonNullable() {
        return this.priceGuaranteeExpiresAt;
    }

    @JsonProperty(value="price_guarantee_expires_at")
    public void setPriceGuaranteeExpiresAt_JsonNullable(JsonNullable<OffsetDateTime> priceGuaranteeExpiresAt) {
        this.priceGuaranteeExpiresAt = priceGuaranteeExpiresAt;
    }

    public void setPriceGuaranteeExpiresAt(OffsetDateTime priceGuaranteeExpiresAt) {
        this.priceGuaranteeExpiresAt = JsonNullable.of((Object)priceGuaranteeExpiresAt);
    }

    public OfferIndexPaymentRequirements requiresInstantPayment(Boolean requiresInstantPayment) {
        this.requiresInstantPayment = requiresInstantPayment;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="When payment is required at the time of booking this will be `true` and `payment_required_by` and `price_guarantee_expires_at` will be `null`. When payment can be made at a time after booking, this will be `false` and the time limits on the payment will be provided in `payment_required_by` and `price_guarantee_expires_at`. ")
    @JsonProperty(value="requires_instant_payment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getRequiresInstantPayment() {
        return this.requiresInstantPayment;
    }

    @JsonProperty(value="requires_instant_payment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRequiresInstantPayment(Boolean requiresInstantPayment) {
        this.requiresInstantPayment = requiresInstantPayment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OfferIndexPaymentRequirements offerIndexPaymentRequirements = (OfferIndexPaymentRequirements)o;
        return OfferIndexPaymentRequirements.equalsNullable(this.paymentRequiredBy, offerIndexPaymentRequirements.paymentRequiredBy) && OfferIndexPaymentRequirements.equalsNullable(this.priceGuaranteeExpiresAt, offerIndexPaymentRequirements.priceGuaranteeExpiresAt) && Objects.equals(this.requiresInstantPayment, offerIndexPaymentRequirements.requiresInstantPayment);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(OfferIndexPaymentRequirements.hashCodeNullable(this.paymentRequiredBy), OfferIndexPaymentRequirements.hashCodeNullable(this.priceGuaranteeExpiresAt), this.requiresInstantPayment);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OfferIndexPaymentRequirements {\n");
        sb.append("    paymentRequiredBy: ").append(this.toIndentedString(this.paymentRequiredBy)).append("\n");
        sb.append("    priceGuaranteeExpiresAt: ").append(this.toIndentedString(this.priceGuaranteeExpiresAt)).append("\n");
        sb.append("    requiresInstantPayment: ").append(this.toIndentedString(this.requiresInstantPayment)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

