/*
 * Decompiled with CFR 0.152.
 */
package com.duffel.sdk.model;

import com.duffel.sdk.model.LoyaltyProgrammeAccount;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@JsonPropertyOrder(value={"family_name", "given_name", "loyalty_programme_accounts", "type", "age"})
@JsonTypeName(value="Offer_Request_Body_passengers_inner")
public class OfferRequestBodyPassengersInner {
    public static final String JSON_PROPERTY_FAMILY_NAME = "family_name";
    private String familyName;
    public static final String JSON_PROPERTY_GIVEN_NAME = "given_name";
    private String givenName;
    public static final String JSON_PROPERTY_LOYALTY_PROGRAMME_ACCOUNTS = "loyalty_programme_accounts";
    private List<LoyaltyProgrammeAccount> loyaltyProgrammeAccounts = null;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_AGE = "age";
    private Integer age;

    public OfferRequestBodyPassengersInner familyName(String familyName) {
        this.familyName = familyName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Earhart", value="The passenger's family name. Only `space`, `-`, `'`, and letters from the [`ASCII`](https://www.unicode.org/charts/PDF/U0000.pdf), [`Latin-1 Supplement`](https://www.unicode.org/charts/PDF/U0080.pdf) and [`Latin Extended-A`](https://www.unicode.org/charts/PDF/U0100.pdf) (with the exceptions of `\u00c6`, `\u00e6`, `\u0132`, `\u0133`, `\u0152`, `\u0153`, `\u00de`, and `\u00f0`) Unicode charts are accepted. All other characters will result in a validation error. The minimum length is 1 character, and the maximum is 20 characters.  This is only required if you're also including __Loyalty Programme Accounts__. ")
    @JsonProperty(value="family_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFamilyName() {
        return this.familyName;
    }

    @JsonProperty(value="family_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFamilyName(String familyName) {
        this.familyName = familyName;
    }

    public OfferRequestBodyPassengersInner givenName(String givenName) {
        this.givenName = givenName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Amelia", value="The passenger's given name. Only `space`, `-`, `'`, and letters from the [`ASCII`](https://www.unicode.org/charts/PDF/U0000.pdf), [`Latin-1 Supplement`](https://www.unicode.org/charts/PDF/U0080.pdf) and [`Latin Extended-A`](https://www.unicode.org/charts/PDF/U0100.pdf) (with the exceptions of `\u00c6`, `\u00e6`, `\u0132`, `\u0133`, `\u0152`, `\u0153`, `\u00de`, and `\u00f0`) Unicode charts are accepted. All other characters will result in a validation error. The minimum length is 1 character, and the maximum is 20 characters.  This is only required if you're also including __Loyalty Programme Accounts__. ")
    @JsonProperty(value="given_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGivenName() {
        return this.givenName;
    }

    @JsonProperty(value="given_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    public OfferRequestBodyPassengersInner loyaltyProgrammeAccounts(List<LoyaltyProgrammeAccount> loyaltyProgrammeAccounts) {
        this.loyaltyProgrammeAccounts = loyaltyProgrammeAccounts;
        return this;
    }

    public OfferRequestBodyPassengersInner addLoyaltyProgrammeAccountsItem(LoyaltyProgrammeAccount loyaltyProgrammeAccountsItem) {
        if (this.loyaltyProgrammeAccounts == null) {
            this.loyaltyProgrammeAccounts = new ArrayList<LoyaltyProgrammeAccount>();
        }
        this.loyaltyProgrammeAccounts.add(loyaltyProgrammeAccountsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="The __Loyalty Programme Accounts__ for this passenger")
    @JsonProperty(value="loyalty_programme_accounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<LoyaltyProgrammeAccount> getLoyaltyProgrammeAccounts() {
        return this.loyaltyProgrammeAccounts;
    }

    @JsonProperty(value="loyalty_programme_accounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLoyaltyProgrammeAccounts(List<LoyaltyProgrammeAccount> loyaltyProgrammeAccounts) {
        this.loyaltyProgrammeAccounts = loyaltyProgrammeAccounts;
    }

    public OfferRequestBodyPassengersInner type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="adult", required=true, value="The type of the passenger. If the passenger is aged 18 or over, you should specify a `type` of `adult`. If a passenger is aged under 18, you should specify their `age` instead of a `type`. A passenger can have only a type or an age, but not both.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public OfferRequestBodyPassengersInner age(Integer age) {
        this.age = age;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @Max(value=130L)
    @ApiModelProperty(example="14", required=true, value="The age of the passenger on the `departure_date` of the final slice. e.g. if you a searching for a round trip and the passenger is 15 years old at the time of the outbound flight, but they then have their birthday and are 16 years old for the inbound flight, you must set the age to 16. You should specify an `age` for passengers who are under 18 years old. A passenger can have only a type or an age, but not both.")
    @JsonProperty(value="age")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) @Max(value=130L) Integer getAge() {
        return this.age;
    }

    @JsonProperty(value="age")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAge(Integer age) {
        this.age = age;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OfferRequestBodyPassengersInner offerRequestBodyPassengersInner = (OfferRequestBodyPassengersInner)o;
        return Objects.equals(this.familyName, offerRequestBodyPassengersInner.familyName) && Objects.equals(this.givenName, offerRequestBodyPassengersInner.givenName) && Objects.equals(this.loyaltyProgrammeAccounts, offerRequestBodyPassengersInner.loyaltyProgrammeAccounts) && Objects.equals((Object)this.type, (Object)offerRequestBodyPassengersInner.type) && Objects.equals(this.age, offerRequestBodyPassengersInner.age);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.familyName, this.givenName, this.loyaltyProgrammeAccounts, this.type, this.age});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OfferRequestBodyPassengersInner {\n");
        sb.append("    familyName: ").append(this.toIndentedString(this.familyName)).append("\n");
        sb.append("    givenName: ").append(this.toIndentedString(this.givenName)).append("\n");
        sb.append("    loyaltyProgrammeAccounts: ").append(this.toIndentedString(this.loyaltyProgrammeAccounts)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    age: ").append(this.toIndentedString(this.age)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        ADULT("adult"),
        CHILD("child"),
        INFANT_WITHOUT_SEAT("infant_without_seat");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

