/*
 * Decompiled with CFR 0.152.
 */
package com.duffel.sdk.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="Whether the whole order can be refunded before the departure of the first slice. If all of the slices on the order can be refunded then the `allowed` property will be `true` and information will be provided about any penalties. If any of the slices on the order can't be refunded then the `allowed` property will be `false`. If the airline hasn't provided any information about whether this order can be refunded then this property will be `null`. ")
@JsonPropertyOrder(value={"allowed", "penalty_amount", "penalty_currency"})
@JsonTypeName(value="OrderConditions_1_refund_before_departure")
public class OrderConditions1RefundBeforeDeparture {
    public static final String JSON_PROPERTY_ALLOWED = "allowed";
    private Boolean allowed;
    public static final String JSON_PROPERTY_PENALTY_AMOUNT = "penalty_amount";
    private JsonNullable<String> penaltyAmount = JsonNullable.undefined();
    public static final String JSON_PROPERTY_PENALTY_CURRENCY = "penalty_currency";
    private JsonNullable<String> penaltyCurrency = JsonNullable.undefined();

    public OrderConditions1RefundBeforeDeparture allowed(Boolean allowed) {
        this.allowed = allowed;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Whether this kind of modification is allowed post-booking")
    @JsonProperty(value="allowed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAllowed() {
        return this.allowed;
    }

    @JsonProperty(value="allowed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAllowed(Boolean allowed) {
        this.allowed = allowed;
    }

    public OrderConditions1RefundBeforeDeparture penaltyAmount(String penaltyAmount) {
        this.penaltyAmount = JsonNullable.of((Object)penaltyAmount);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="100.00", value="If the modification is `allowed` then this is the amount payable to apply the modification to all passengers. If there is no penalty, the value will be zero. If the modification isn't `allowed` or the penalty is not known then this field will be `null`. If this is `null` then the `penalty_currency` will also be `null`. ")
    @JsonIgnore
    public String getPenaltyAmount() {
        return (String)this.penaltyAmount.orElse(null);
    }

    @JsonProperty(value="penalty_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getPenaltyAmount_JsonNullable() {
        return this.penaltyAmount;
    }

    @JsonProperty(value="penalty_amount")
    public void setPenaltyAmount_JsonNullable(JsonNullable<String> penaltyAmount) {
        this.penaltyAmount = penaltyAmount;
    }

    public void setPenaltyAmount(String penaltyAmount) {
        this.penaltyAmount = JsonNullable.of((Object)penaltyAmount);
    }

    public OrderConditions1RefundBeforeDeparture penaltyCurrency(String penaltyCurrency) {
        this.penaltyCurrency = JsonNullable.of((Object)penaltyCurrency);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="GBP", value="The currency of the `penalty_amount` as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code. This will be in a currency determined by the airline, which is not necessarily the same as the currency of the offer or order. If this is `null` then `penalty_amount` will also be `null`. ")
    @JsonIgnore
    public String getPenaltyCurrency() {
        return (String)this.penaltyCurrency.orElse(null);
    }

    @JsonProperty(value="penalty_currency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getPenaltyCurrency_JsonNullable() {
        return this.penaltyCurrency;
    }

    @JsonProperty(value="penalty_currency")
    public void setPenaltyCurrency_JsonNullable(JsonNullable<String> penaltyCurrency) {
        this.penaltyCurrency = penaltyCurrency;
    }

    public void setPenaltyCurrency(String penaltyCurrency) {
        this.penaltyCurrency = JsonNullable.of((Object)penaltyCurrency);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderConditions1RefundBeforeDeparture orderConditions1RefundBeforeDeparture = (OrderConditions1RefundBeforeDeparture)o;
        return Objects.equals(this.allowed, orderConditions1RefundBeforeDeparture.allowed) && OrderConditions1RefundBeforeDeparture.equalsNullable(this.penaltyAmount, orderConditions1RefundBeforeDeparture.penaltyAmount) && OrderConditions1RefundBeforeDeparture.equalsNullable(this.penaltyCurrency, orderConditions1RefundBeforeDeparture.penaltyCurrency);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.allowed, OrderConditions1RefundBeforeDeparture.hashCodeNullable(this.penaltyAmount), OrderConditions1RefundBeforeDeparture.hashCodeNullable(this.penaltyCurrency));
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderConditions1RefundBeforeDeparture {\n");
        sb.append("    allowed: ").append(this.toIndentedString(this.allowed)).append("\n");
        sb.append("    penaltyAmount: ").append(this.toIndentedString(this.penaltyAmount)).append("\n");
        sb.append("    penaltyCurrency: ").append(this.toIndentedString(this.penaltyCurrency)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

