/*
 * Decompiled with CFR 0.152.
 */
package com.duffel.sdk.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"after", "before", "limit"})
@JsonTypeName(value="Pagination_Meta")
public class PaginationMeta {
    public static final String JSON_PROPERTY_AFTER = "after";
    private JsonNullable<String> after = JsonNullable.undefined();
    public static final String JSON_PROPERTY_BEFORE = "before";
    private JsonNullable<String> before = JsonNullable.undefined();
    public static final String JSON_PROPERTY_LIMIT = "limit";
    private JsonNullable<Integer> limit = JsonNullable.of((Object)50);

    public PaginationMeta after(String after) {
        this.after = JsonNullable.of((Object)after);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="g2wAAAACbQAAABBBZXJvbWlzdC1LaGFya2l2bQAAAB=", value="`after` is a cursor used to identify the next page of results. If `meta.after` is null, then there are no more results to see.")
    @JsonIgnore
    public String getAfter() {
        return (String)this.after.orElse(null);
    }

    @JsonProperty(value="after")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getAfter_JsonNullable() {
        return this.after;
    }

    @JsonProperty(value="after")
    public void setAfter_JsonNullable(JsonNullable<String> after) {
        this.after = after;
    }

    public void setAfter(String after) {
        this.after = JsonNullable.of((Object)after);
    }

    public PaginationMeta before(String before) {
        this.before = JsonNullable.of((Object)before);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="`before` is a cursor used to identify the previous page of results.")
    @JsonIgnore
    public String getBefore() {
        return (String)this.before.orElse(null);
    }

    @JsonProperty(value="before")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getBefore_JsonNullable() {
        return this.before;
    }

    @JsonProperty(value="before")
    public void setBefore_JsonNullable(JsonNullable<String> before) {
        this.before = before;
    }

    public void setBefore(String before) {
        this.before = JsonNullable.of((Object)before);
    }

    public PaginationMeta limit(Integer limit) {
        this.limit = JsonNullable.of((Object)limit);
        return this;
    }

    @Nullable
    @Min(value=1L)
    @Max(value=200L)
    @ApiModelProperty(example="50", value="The limit of entries returned on each page.")
    @JsonIgnore
    public @Min(value=1L) @Max(value=200L) Integer getLimit() {
        return (Integer)this.limit.orElse(null);
    }

    @JsonProperty(value="limit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Integer> getLimit_JsonNullable() {
        return this.limit;
    }

    @JsonProperty(value="limit")
    public void setLimit_JsonNullable(JsonNullable<Integer> limit) {
        this.limit = limit;
    }

    public void setLimit(Integer limit) {
        this.limit = JsonNullable.of((Object)limit);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaginationMeta paginationMeta = (PaginationMeta)o;
        return PaginationMeta.equalsNullable(this.after, paginationMeta.after) && PaginationMeta.equalsNullable(this.before, paginationMeta.before) && PaginationMeta.equalsNullable(this.limit, paginationMeta.limit);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(PaginationMeta.hashCodeNullable(this.after), PaginationMeta.hashCodeNullable(this.before), PaginationMeta.hashCodeNullable(this.limit));
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaginationMeta {\n");
        sb.append("    after: ").append(this.toIndentedString(this.after)).append("\n");
        sb.append("    before: ").append(this.toIndentedString(this.before)).append("\n");
        sb.append("    limit: ").append(this.toIndentedString(this.limit)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

