/*
 * Decompiled with CFR 0.152.
 */
package com.duffel.sdk.model;

import com.duffel.sdk.model.SeatMapCabinRow;
import com.duffel.sdk.model.WingPosition;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="A cabin is a physical section of an aircraft that passengers travel  in. The cabin that a passenger travels in will depend on the fare  they paid (for example an economy cabin versus a business class cabin). ")
@JsonPropertyOrder(value={"aisles", "cabin_class", "deck", "rows", "wings"})
@JsonTypeName(value="Seat_Map_Cabin")
public class SeatMapCabin {
    public static final String JSON_PROPERTY_AISLES = "aisles";
    private Integer aisles;
    public static final String JSON_PROPERTY_CABIN_CLASS = "cabin_class";
    private CabinClassEnum cabinClass;
    public static final String JSON_PROPERTY_DECK = "deck";
    private Integer deck;
    public static final String JSON_PROPERTY_ROWS = "rows";
    private List<SeatMapCabinRow> rows = new ArrayList<SeatMapCabinRow>();
    public static final String JSON_PROPERTY_WINGS = "wings";
    private JsonNullable<WingPosition> wings = JsonNullable.undefined();

    public SeatMapCabin aisles(Integer aisles) {
        this.aisles = aisles;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @Max(value=2L)
    @ApiModelProperty(example="1", required=true, value="The number of aisles in this cabin.   If this is set to `1`, each row of the cabin is split into two sections. If this is set to `2`, each row of the cabin is split into three sections. ")
    @JsonProperty(value="aisles")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) @Max(value=2L) Integer getAisles() {
        return this.aisles;
    }

    @JsonProperty(value="aisles")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAisles(Integer aisles) {
        this.aisles = aisles;
    }

    public SeatMapCabin cabinClass(CabinClassEnum cabinClass) {
        this.cabinClass = cabinClass;
        return this;
    }

    @Nullable
    @NotNull
    @ApiModelProperty(example="economy", required=true, value="The cabin class that the passenger will travel in on this segment")
    @JsonProperty(value="cabin_class")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CabinClassEnum getCabinClass() {
        return this.cabinClass;
    }

    @JsonProperty(value="cabin_class")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCabinClass(CabinClassEnum cabinClass) {
        this.cabinClass = cabinClass;
    }

    public SeatMapCabin deck(Integer deck) {
        this.deck = deck;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @Max(value=1L)
    @ApiModelProperty(example="0", required=true, value="Level 0 is the main deck and level 1 is the upper deck above that,  which is found on some large aircraft. ")
    @JsonProperty(value="deck")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) @Max(value=1L) Integer getDeck() {
        return this.deck;
    }

    @JsonProperty(value="deck")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDeck(Integer deck) {
        this.deck = deck;
    }

    public SeatMapCabin rows(List<SeatMapCabinRow> rows) {
        this.rows = rows;
        return this;
    }

    public SeatMapCabin addRowsItem(SeatMapCabinRow rowsItem) {
        this.rows.add(rowsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="A list of rows in this cabin.   Row sections are broken up by aisles. Rows are ordered from front to  back of the aircraft. ")
    @JsonProperty(value="rows")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<SeatMapCabinRow> getRows() {
        return this.rows;
    }

    @JsonProperty(value="rows")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRows(List<SeatMapCabinRow> rows) {
        this.rows = rows;
    }

    public SeatMapCabin wings(WingPosition wings) {
        this.wings = JsonNullable.of((Object)wings);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonIgnore
    public WingPosition getWings() {
        return (WingPosition)this.wings.orElse(null);
    }

    @JsonProperty(value="wings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<WingPosition> getWings_JsonNullable() {
        return this.wings;
    }

    @JsonProperty(value="wings")
    public void setWings_JsonNullable(JsonNullable<WingPosition> wings) {
        this.wings = wings;
    }

    public void setWings(WingPosition wings) {
        this.wings = JsonNullable.of((Object)wings);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SeatMapCabin seatMapCabin = (SeatMapCabin)o;
        return Objects.equals(this.aisles, seatMapCabin.aisles) && Objects.equals((Object)this.cabinClass, (Object)seatMapCabin.cabinClass) && Objects.equals(this.deck, seatMapCabin.deck) && Objects.equals(this.rows, seatMapCabin.rows) && SeatMapCabin.equalsNullable(this.wings, seatMapCabin.wings);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.aisles, this.cabinClass, this.deck, this.rows, SeatMapCabin.hashCodeNullable(this.wings)});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SeatMapCabin {\n");
        sb.append("    aisles: ").append(this.toIndentedString(this.aisles)).append("\n");
        sb.append("    cabinClass: ").append(this.toIndentedString((Object)this.cabinClass)).append("\n");
        sb.append("    deck: ").append(this.toIndentedString(this.deck)).append("\n");
        sb.append("    rows: ").append(this.toIndentedString(this.rows)).append("\n");
        sb.append("    wings: ").append(this.toIndentedString(this.wings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CabinClassEnum {
        FIRST("first"),
        BUSINESS("business"),
        PREMIUM_ECONOMY("premium_economy"),
        ECONOMY("economy");

        private String value;

        private CabinClassEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CabinClassEnum fromValue(String value) {
            for (CabinClassEnum b : CabinClassEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }
    }
}

