package com.duffel.sdk.api;

import com.duffel.sdk.invoker.ApiClient;

import com.duffel.sdk.model.GetAirlineInitiatedChanges200Response;
import com.duffel.sdk.model.UpdateAirlineInitiatedChanges200Response;
import com.duffel.sdk.model.UpdateAirlineInitiatedChangesRequest;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:18:14.926970+07:00[Asia/Bangkok]")
public class AirlineInitiatedChangesApi {
    private ApiClient apiClient;

    public AirlineInitiatedChangesApi() {
        this(new ApiClient());
    }

    @Autowired
    public AirlineInitiatedChangesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Accept the airline-initiated change
     * Once there is an airline-initiated change you can choose to accept it.
     * <p><b>200</b> - Airline-initiated Change has been accepted with airline
     * <p><b>202</b> - Airline-initiated Change acceptance is in progress
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the airline-initiated change
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @return UpdateAirlineInitiatedChanges200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec acceptAirlineInitiatedChangesRequestCreation(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling acceptAirlineInitiatedChanges", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling acceptAirlineInitiatedChanges", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling acceptAirlineInitiatedChanges", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "bearerAuth" };

        ParameterizedTypeReference<UpdateAirlineInitiatedChanges200Response> localVarReturnType = new ParameterizedTypeReference<UpdateAirlineInitiatedChanges200Response>() {};
        return apiClient.invokeAPI("/air/airline_initiated_changes/{id}/actions/accept", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Accept the airline-initiated change
     * Once there is an airline-initiated change you can choose to accept it.
     * <p><b>200</b> - Airline-initiated Change has been accepted with airline
     * <p><b>202</b> - Airline-initiated Change acceptance is in progress
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the airline-initiated change
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @return UpdateAirlineInitiatedChanges200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<UpdateAirlineInitiatedChanges200Response> acceptAirlineInitiatedChanges(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        ParameterizedTypeReference<UpdateAirlineInitiatedChanges200Response> localVarReturnType = new ParameterizedTypeReference<UpdateAirlineInitiatedChanges200Response>() {};
        return acceptAirlineInitiatedChangesRequestCreation(accept, duffelVersion, id, acceptEncoding).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<UpdateAirlineInitiatedChanges200Response>> acceptAirlineInitiatedChangesWithHttpInfo(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        ParameterizedTypeReference<UpdateAirlineInitiatedChanges200Response> localVarReturnType = new ParameterizedTypeReference<UpdateAirlineInitiatedChanges200Response>() {};
        return acceptAirlineInitiatedChangesRequestCreation(accept, duffelVersion, id, acceptEncoding).toEntity(localVarReturnType);
    }
    /**
     * List airline-initiated changes
     * Retrieves a list of all airline-initiated changes.
     * <p><b>200</b> - A list of airline-initiated changes
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param orderId Filters airline-initiated changes by their order ID. Value must be a valid order ID. Check the [Order schema](/docs/api/orders/schema#orders-schema-id) for details. 
     * @return GetAirlineInitiatedChanges200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec getAirlineInitiatedChangesRequestCreation(String accept, String duffelVersion, String acceptEncoding, String orderId) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling getAirlineInitiatedChanges", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling getAirlineInitiatedChanges", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "order_id", orderId));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "bearerAuth" };

        ParameterizedTypeReference<GetAirlineInitiatedChanges200Response> localVarReturnType = new ParameterizedTypeReference<GetAirlineInitiatedChanges200Response>() {};
        return apiClient.invokeAPI("/air/airline_initiated_changes", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List airline-initiated changes
     * Retrieves a list of all airline-initiated changes.
     * <p><b>200</b> - A list of airline-initiated changes
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param orderId Filters airline-initiated changes by their order ID. Value must be a valid order ID. Check the [Order schema](/docs/api/orders/schema#orders-schema-id) for details. 
     * @return GetAirlineInitiatedChanges200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GetAirlineInitiatedChanges200Response> getAirlineInitiatedChanges(String accept, String duffelVersion, String acceptEncoding, String orderId) throws WebClientResponseException {
        ParameterizedTypeReference<GetAirlineInitiatedChanges200Response> localVarReturnType = new ParameterizedTypeReference<GetAirlineInitiatedChanges200Response>() {};
        return getAirlineInitiatedChangesRequestCreation(accept, duffelVersion, acceptEncoding, orderId).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<GetAirlineInitiatedChanges200Response>> getAirlineInitiatedChangesWithHttpInfo(String accept, String duffelVersion, String acceptEncoding, String orderId) throws WebClientResponseException {
        ParameterizedTypeReference<GetAirlineInitiatedChanges200Response> localVarReturnType = new ParameterizedTypeReference<GetAirlineInitiatedChanges200Response>() {};
        return getAirlineInitiatedChangesRequestCreation(accept, duffelVersion, acceptEncoding, orderId).toEntity(localVarReturnType);
    }
    /**
     * Update an airline-initiated change
     * This endpoint is only available to those airline-initiated changes that Duffel cannot accept on behalf of the customer. Duffel is unable to accept an airline-initiated change when these two conditions aretrue: the order was booked with the merchant&#39;s IATA number and Duffel is unable to accept the airline-initiated change programatically. In this case you, the customer, are responsible to resolve airline-initiated changes concerning this order (e.g. by contacting the airline directly). Once these have been resolved, you need to inform us of the action taken so we can mark it accordingly in our system.  
     * <p><b>200</b> - A single airline-initiated change
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the airline-initiated change
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param updateAirlineInitiatedChangesRequest The updateAirlineInitiatedChangesRequest parameter
     * @return UpdateAirlineInitiatedChanges200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateAirlineInitiatedChangesRequestCreation(String accept, String duffelVersion, String id, String acceptEncoding, UpdateAirlineInitiatedChangesRequest updateAirlineInitiatedChangesRequest) throws WebClientResponseException {
        Object postBody = updateAirlineInitiatedChangesRequest;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling updateAirlineInitiatedChanges", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling updateAirlineInitiatedChanges", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling updateAirlineInitiatedChanges", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "bearerAuth" };

        ParameterizedTypeReference<UpdateAirlineInitiatedChanges200Response> localVarReturnType = new ParameterizedTypeReference<UpdateAirlineInitiatedChanges200Response>() {};
        return apiClient.invokeAPI("/air/airline_initiated_changes/{id}", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update an airline-initiated change
     * This endpoint is only available to those airline-initiated changes that Duffel cannot accept on behalf of the customer. Duffel is unable to accept an airline-initiated change when these two conditions aretrue: the order was booked with the merchant&#39;s IATA number and Duffel is unable to accept the airline-initiated change programatically. In this case you, the customer, are responsible to resolve airline-initiated changes concerning this order (e.g. by contacting the airline directly). Once these have been resolved, you need to inform us of the action taken so we can mark it accordingly in our system.  
     * <p><b>200</b> - A single airline-initiated change
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the airline-initiated change
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param updateAirlineInitiatedChangesRequest The updateAirlineInitiatedChangesRequest parameter
     * @return UpdateAirlineInitiatedChanges200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<UpdateAirlineInitiatedChanges200Response> updateAirlineInitiatedChanges(String accept, String duffelVersion, String id, String acceptEncoding, UpdateAirlineInitiatedChangesRequest updateAirlineInitiatedChangesRequest) throws WebClientResponseException {
        ParameterizedTypeReference<UpdateAirlineInitiatedChanges200Response> localVarReturnType = new ParameterizedTypeReference<UpdateAirlineInitiatedChanges200Response>() {};
        return updateAirlineInitiatedChangesRequestCreation(accept, duffelVersion, id, acceptEncoding, updateAirlineInitiatedChangesRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<UpdateAirlineInitiatedChanges200Response>> updateAirlineInitiatedChangesWithHttpInfo(String accept, String duffelVersion, String id, String acceptEncoding, UpdateAirlineInitiatedChangesRequest updateAirlineInitiatedChangesRequest) throws WebClientResponseException {
        ParameterizedTypeReference<UpdateAirlineInitiatedChanges200Response> localVarReturnType = new ParameterizedTypeReference<UpdateAirlineInitiatedChanges200Response>() {};
        return updateAirlineInitiatedChangesRequestCreation(accept, duffelVersion, id, acceptEncoding, updateAirlineInitiatedChangesRequest).toEntity(localVarReturnType);
    }
}
