package com.duffel.sdk.api;

import com.duffel.sdk.invoker.ApiClient;

import com.duffel.sdk.model.CreateOfferRequestRequest;
import com.duffel.sdk.model.GetOfferRequestById200Response;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:18:14.926970+07:00[Asia/Bangkok]")
public class PartialOfferRequestsApi {
    private ApiClient apiClient;

    public PartialOfferRequestsApi() {
        this(new ApiClient());
    }

    @Autowired
    public PartialOfferRequestsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create a partial offer request
     * To search for and select flights separately for each slice of the journey, you&#39;ll need to create a __partial offer request__. A partial offer request describes the passengers and where and when they want to travel (in the form of a list of __slices__). It may also include additional filters (e.g. a particular cabin to travel in).  We&#39;ll send your search to a range of airlines, and return your offer request back to you with a series of __offers__ for the first slice in your journey. Offers returned from a partial offer request will have the __partial__ flag set to &#x60;true&#x60;.  Each partial offer represents a set of flights you can buy from an airline at a particular price that meet the criteria of a slice in your search.  Inside the partial offer you&#39;ll see the slice it pertains to, and each slice will also include a list of one or more specific flights (called __segments__) that the airline is *offering* to get the passengers where they want to go.  When presenting partial offers to your customers, you should always show the full name of the operating carrier of each segment (&#x60;slices[].segments[].operating_carrier.name&#x60;). This must be displayed prominently on the first screen where the offer is presented in order to comply with [US regulations](https://www.ecfr.gov/cgi-bin/text-idx?SID&#x3D;8e736a5c813a737a5c2f6700a4c9006d&amp;mc&#x3D;true&amp;node&#x3D;pt14.4.257&amp;rgn&#x3D;div5). 
     * <p><b>200</b> - An offer request
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param contentType All request bodies sent to the API should be in JSON format. A &#x60;Content-Type&#x60; header is required whenever you&#39;re sending a request body (i.e. for POST and PUT requests).
     * @param supplierTimeout The maximum amount of time in milliseconds to wait for each airline to respond. This timeout only applies to the [response time](/docs/api/overview/response-times) of the call to the airline and doesn&#39;t include additional overhead added by Duffel. Value should be between 2 seconds and 60 seconds. Any values outside the range will be ignored and the default &#x60;supplier_timeout&#x60; will be used. If a value is set, the response will only include offers from airlines that returned within the given time. If a value is not set, the response will only include offers from airlines that returned within the default &#x60;supplier_timeout&#x60; value of 20 seconds. We recommend setting &#x60;supplier_timeout&#x60; lower than the timeout on the request sent to Duffel API as that will allow us to respond with the offers we received before your request times out with an empty response. 
     * @param createOfferRequestRequest The createOfferRequestRequest parameter
     * @return GetOfferRequestById200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createPartialOfferRequestRequestCreation(String accept, String duffelVersion, String acceptEncoding, String contentType, Integer supplierTimeout, CreateOfferRequestRequest createOfferRequestRequest) throws WebClientResponseException {
        Object postBody = createOfferRequestRequest;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling createPartialOfferRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling createPartialOfferRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "supplier_timeout", supplierTimeout));

        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (contentType != null)
        headerParams.add("Content-Type", apiClient.parameterToString(contentType));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "bearerAuth" };

        ParameterizedTypeReference<GetOfferRequestById200Response> localVarReturnType = new ParameterizedTypeReference<GetOfferRequestById200Response>() {};
        return apiClient.invokeAPI("/air/partial_offer_requests", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create a partial offer request
     * To search for and select flights separately for each slice of the journey, you&#39;ll need to create a __partial offer request__. A partial offer request describes the passengers and where and when they want to travel (in the form of a list of __slices__). It may also include additional filters (e.g. a particular cabin to travel in).  We&#39;ll send your search to a range of airlines, and return your offer request back to you with a series of __offers__ for the first slice in your journey. Offers returned from a partial offer request will have the __partial__ flag set to &#x60;true&#x60;.  Each partial offer represents a set of flights you can buy from an airline at a particular price that meet the criteria of a slice in your search.  Inside the partial offer you&#39;ll see the slice it pertains to, and each slice will also include a list of one or more specific flights (called __segments__) that the airline is *offering* to get the passengers where they want to go.  When presenting partial offers to your customers, you should always show the full name of the operating carrier of each segment (&#x60;slices[].segments[].operating_carrier.name&#x60;). This must be displayed prominently on the first screen where the offer is presented in order to comply with [US regulations](https://www.ecfr.gov/cgi-bin/text-idx?SID&#x3D;8e736a5c813a737a5c2f6700a4c9006d&amp;mc&#x3D;true&amp;node&#x3D;pt14.4.257&amp;rgn&#x3D;div5). 
     * <p><b>200</b> - An offer request
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param contentType All request bodies sent to the API should be in JSON format. A &#x60;Content-Type&#x60; header is required whenever you&#39;re sending a request body (i.e. for POST and PUT requests).
     * @param supplierTimeout The maximum amount of time in milliseconds to wait for each airline to respond. This timeout only applies to the [response time](/docs/api/overview/response-times) of the call to the airline and doesn&#39;t include additional overhead added by Duffel. Value should be between 2 seconds and 60 seconds. Any values outside the range will be ignored and the default &#x60;supplier_timeout&#x60; will be used. If a value is set, the response will only include offers from airlines that returned within the given time. If a value is not set, the response will only include offers from airlines that returned within the default &#x60;supplier_timeout&#x60; value of 20 seconds. We recommend setting &#x60;supplier_timeout&#x60; lower than the timeout on the request sent to Duffel API as that will allow us to respond with the offers we received before your request times out with an empty response. 
     * @param createOfferRequestRequest The createOfferRequestRequest parameter
     * @return GetOfferRequestById200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GetOfferRequestById200Response> createPartialOfferRequest(String accept, String duffelVersion, String acceptEncoding, String contentType, Integer supplierTimeout, CreateOfferRequestRequest createOfferRequestRequest) throws WebClientResponseException {
        ParameterizedTypeReference<GetOfferRequestById200Response> localVarReturnType = new ParameterizedTypeReference<GetOfferRequestById200Response>() {};
        return createPartialOfferRequestRequestCreation(accept, duffelVersion, acceptEncoding, contentType, supplierTimeout, createOfferRequestRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<GetOfferRequestById200Response>> createPartialOfferRequestWithHttpInfo(String accept, String duffelVersion, String acceptEncoding, String contentType, Integer supplierTimeout, CreateOfferRequestRequest createOfferRequestRequest) throws WebClientResponseException {
        ParameterizedTypeReference<GetOfferRequestById200Response> localVarReturnType = new ParameterizedTypeReference<GetOfferRequestById200Response>() {};
        return createPartialOfferRequestRequestCreation(accept, duffelVersion, acceptEncoding, contentType, supplierTimeout, createOfferRequestRequest).toEntity(localVarReturnType);
    }
    /**
     * Get a single partial offer request
     * Retrieves a partial offers request by its ID, only including partial offers for the current slice of multi-step search flow. 
     * <p><b>200</b> - A single partial offer request
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the partial offer request
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param selectedPartialOffer Duffel&#39;s unqiue identifier for the partial offer selected for previous slices. This parameter should be repeated for each selected partial offer.
     * @return GetOfferRequestById200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec getPartialOfferRequestByIdRequestCreation(String accept, String duffelVersion, String id, String acceptEncoding, String selectedPartialOffer) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling getPartialOfferRequestById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling getPartialOfferRequestById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling getPartialOfferRequestById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "selected_partial_offer[]", selectedPartialOffer));

        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "bearerAuth" };

        ParameterizedTypeReference<GetOfferRequestById200Response> localVarReturnType = new ParameterizedTypeReference<GetOfferRequestById200Response>() {};
        return apiClient.invokeAPI("/air/partial_offer_requests/{id}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Get a single partial offer request
     * Retrieves a partial offers request by its ID, only including partial offers for the current slice of multi-step search flow. 
     * <p><b>200</b> - A single partial offer request
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the partial offer request
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param selectedPartialOffer Duffel&#39;s unqiue identifier for the partial offer selected for previous slices. This parameter should be repeated for each selected partial offer.
     * @return GetOfferRequestById200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GetOfferRequestById200Response> getPartialOfferRequestById(String accept, String duffelVersion, String id, String acceptEncoding, String selectedPartialOffer) throws WebClientResponseException {
        ParameterizedTypeReference<GetOfferRequestById200Response> localVarReturnType = new ParameterizedTypeReference<GetOfferRequestById200Response>() {};
        return getPartialOfferRequestByIdRequestCreation(accept, duffelVersion, id, acceptEncoding, selectedPartialOffer).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<GetOfferRequestById200Response>> getPartialOfferRequestByIdWithHttpInfo(String accept, String duffelVersion, String id, String acceptEncoding, String selectedPartialOffer) throws WebClientResponseException {
        ParameterizedTypeReference<GetOfferRequestById200Response> localVarReturnType = new ParameterizedTypeReference<GetOfferRequestById200Response>() {};
        return getPartialOfferRequestByIdRequestCreation(accept, duffelVersion, id, acceptEncoding, selectedPartialOffer).toEntity(localVarReturnType);
    }
    /**
     * Get full offer fares for selected partial offers
     * Retrieves an offer request with offers for fares matching selected partial offers.
     * <p><b>200</b> - A single offer request with full offers for different fares matching selected itinerary in multi-step search flow.
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the partial offer request
     * @param selectedPartialOffer Duffel&#39;s unqiue identifier for the partial offer selected. This parameter should be repeated for each slice in the journey.
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @return GetOfferRequestById200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec getPartialOfferRequestFaresByIdRequestCreation(String accept, String duffelVersion, String id, String selectedPartialOffer, String acceptEncoding) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling getPartialOfferRequestFaresById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling getPartialOfferRequestFaresById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling getPartialOfferRequestFaresById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'selectedPartialOffer' is set
        if (selectedPartialOffer == null) {
            throw new WebClientResponseException("Missing the required parameter 'selectedPartialOffer' when calling getPartialOfferRequestFaresById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "selected_partial_offer[]", selectedPartialOffer));

        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "bearerAuth" };

        ParameterizedTypeReference<GetOfferRequestById200Response> localVarReturnType = new ParameterizedTypeReference<GetOfferRequestById200Response>() {};
        return apiClient.invokeAPI("/air/partial_offer_requests/{id}/fares", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Get full offer fares for selected partial offers
     * Retrieves an offer request with offers for fares matching selected partial offers.
     * <p><b>200</b> - A single offer request with full offers for different fares matching selected itinerary in multi-step search flow.
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the partial offer request
     * @param selectedPartialOffer Duffel&#39;s unqiue identifier for the partial offer selected. This parameter should be repeated for each slice in the journey.
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @return GetOfferRequestById200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GetOfferRequestById200Response> getPartialOfferRequestFaresById(String accept, String duffelVersion, String id, String selectedPartialOffer, String acceptEncoding) throws WebClientResponseException {
        ParameterizedTypeReference<GetOfferRequestById200Response> localVarReturnType = new ParameterizedTypeReference<GetOfferRequestById200Response>() {};
        return getPartialOfferRequestFaresByIdRequestCreation(accept, duffelVersion, id, selectedPartialOffer, acceptEncoding).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<GetOfferRequestById200Response>> getPartialOfferRequestFaresByIdWithHttpInfo(String accept, String duffelVersion, String id, String selectedPartialOffer, String acceptEncoding) throws WebClientResponseException {
        ParameterizedTypeReference<GetOfferRequestById200Response> localVarReturnType = new ParameterizedTypeReference<GetOfferRequestById200Response>() {};
        return getPartialOfferRequestFaresByIdRequestCreation(accept, duffelVersion, id, selectedPartialOffer, acceptEncoding).toEntity(localVarReturnType);
    }
}
