/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * CreateRefundRequestData
 */
@JsonPropertyOrder({
  CreateRefundRequestData.JSON_PROPERTY_AMOUNT,
  CreateRefundRequestData.JSON_PROPERTY_CURRENCY,
  CreateRefundRequestData.JSON_PROPERTY_PAYMENT_INTENT_ID
})
@JsonTypeName("createRefund_request_data")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:18:14.926970+07:00[Asia/Bangkok]")
public class CreateRefundRequestData {
  public static final String JSON_PROPERTY_AMOUNT = "amount";
  private String amount;

  public static final String JSON_PROPERTY_CURRENCY = "currency";
  private String currency;

  public static final String JSON_PROPERTY_PAYMENT_INTENT_ID = "payment_intent_id";
  private String paymentIntentId;

  public CreateRefundRequestData() { 
  }

  public CreateRefundRequestData amount(String amount) {
    
    this.amount = amount;
    return this;
  }

   /**
   * This amount that will be refunded to the customer&#39;s card. 
   * @return amount
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "30.20", required = true, value = "This amount that will be refunded to the customer's card. ")
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getAmount() {
    return amount;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAmount(String amount) {
    this.amount = amount;
  }


  public CreateRefundRequestData currency(String currency) {
    
    this.currency = currency;
    return this;
  }

   /**
   * The currency of the &#x60;amount&#x60;, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code.  It must match the __Payment Intent__ currency. 
   * @return currency
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "GBP", required = true, value = "The currency of the `amount`, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code.  It must match the __Payment Intent__ currency. ")
  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCurrency() {
    return currency;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCurrency(String currency) {
    this.currency = currency;
  }


  public CreateRefundRequestData paymentIntentId(String paymentIntentId) {
    
    this.paymentIntentId = paymentIntentId;
    return this;
  }

   /**
   * Duffel&#39;s unique identifier for the __Payment Intent__ that the __Refund__ is for
   * @return paymentIntentId
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "pit_00009hthhsUZ8W4LxQgkjo", required = true, value = "Duffel's unique identifier for the __Payment Intent__ that the __Refund__ is for")
  @JsonProperty(JSON_PROPERTY_PAYMENT_INTENT_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getPaymentIntentId() {
    return paymentIntentId;
  }


  @JsonProperty(JSON_PROPERTY_PAYMENT_INTENT_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPaymentIntentId(String paymentIntentId) {
    this.paymentIntentId = paymentIntentId;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateRefundRequestData createRefundRequestData = (CreateRefundRequestData) o;
    return Objects.equals(this.amount, createRefundRequestData.amount) &&
        Objects.equals(this.currency, createRefundRequestData.currency) &&
        Objects.equals(this.paymentIntentId, createRefundRequestData.paymentIntentId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(amount, currency, paymentIntentId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateRefundRequestData {\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    paymentIntentId: ").append(toIndentedString(paymentIntentId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

