/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * The payment status for this order
 */
@ApiModel(description = "The payment status for this order")
@JsonPropertyOrder({
  OrderPaymentStatus.JSON_PROPERTY_AWAITING_PAYMENT,
  OrderPaymentStatus.JSON_PROPERTY_PAYMENT_REQUIRED_BY,
  OrderPaymentStatus.JSON_PROPERTY_PRICE_GUARANTEE_EXPIRES_AT
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:18:14.926970+07:00[Asia/Bangkok]")
public class OrderPaymentStatus {
  public static final String JSON_PROPERTY_AWAITING_PAYMENT = "awaiting_payment";
  private Boolean awaitingPayment;

  public static final String JSON_PROPERTY_PAYMENT_REQUIRED_BY = "payment_required_by";
  private JsonNullable<OffsetDateTime> paymentRequiredBy = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_PRICE_GUARANTEE_EXPIRES_AT = "price_guarantee_expires_at";
  private JsonNullable<OffsetDateTime> priceGuaranteeExpiresAt = JsonNullable.<OffsetDateTime>undefined();

  public OrderPaymentStatus() { 
  }

  public OrderPaymentStatus awaitingPayment(Boolean awaitingPayment) {
    
    this.awaitingPayment = awaitingPayment;
    return this;
  }

   /**
   * Whether a full payment has been made, or the airline is waiting for a payment to be made. This will be set to false if the order has been cancelled or if &#x60;payment_required_by&#x60; has elapsed.
   * @return awaitingPayment
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Whether a full payment has been made, or the airline is waiting for a payment to be made. This will be set to false if the order has been cancelled or if `payment_required_by` has elapsed.")
  @JsonProperty(JSON_PROPERTY_AWAITING_PAYMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAwaitingPayment() {
    return awaitingPayment;
  }


  @JsonProperty(JSON_PROPERTY_AWAITING_PAYMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAwaitingPayment(Boolean awaitingPayment) {
    this.awaitingPayment = awaitingPayment;
  }


  public OrderPaymentStatus paymentRequiredBy(OffsetDateTime paymentRequiredBy) {
    this.paymentRequiredBy = JsonNullable.<OffsetDateTime>of(paymentRequiredBy);
    
    return this;
  }

   /**
   * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime by which you must pay for this order. At this time, if still unpaid, the reserved space on the flight(s) will be released and you will have to create a new order. This will be &#x60;null&#x60; only for orders where &#x60;awaiting_payment&#x60; is &#x60;false&#x60;.
   * @return paymentRequiredBy
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(example = "2020-01-17T10:42:14.545Z", value = "The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime by which you must pay for this order. At this time, if still unpaid, the reserved space on the flight(s) will be released and you will have to create a new order. This will be `null` only for orders where `awaiting_payment` is `false`.")
  @JsonIgnore

  public OffsetDateTime getPaymentRequiredBy() {
        return paymentRequiredBy.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PAYMENT_REQUIRED_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getPaymentRequiredBy_JsonNullable() {
    return paymentRequiredBy;
  }
  
  @JsonProperty(JSON_PROPERTY_PAYMENT_REQUIRED_BY)
  public void setPaymentRequiredBy_JsonNullable(JsonNullable<OffsetDateTime> paymentRequiredBy) {
    this.paymentRequiredBy = paymentRequiredBy;
  }

  public void setPaymentRequiredBy(OffsetDateTime paymentRequiredBy) {
    this.paymentRequiredBy = JsonNullable.<OffsetDateTime>of(paymentRequiredBy);
  }


  public OrderPaymentStatus priceGuaranteeExpiresAt(OffsetDateTime priceGuaranteeExpiresAt) {
    this.priceGuaranteeExpiresAt = JsonNullable.<OffsetDateTime>of(priceGuaranteeExpiresAt);
    
    return this;
  }

   /**
   * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the price associated with the order will no longer be guaranteed by the airline and the order will need to be repriced before payment. This will be &#x60;null&#x60; when there is no price guarantee.
   * @return priceGuaranteeExpiresAt
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(example = "2020-01-17T10:42:14.545Z", value = "The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the price associated with the order will no longer be guaranteed by the airline and the order will need to be repriced before payment. This will be `null` when there is no price guarantee.")
  @JsonIgnore

  public OffsetDateTime getPriceGuaranteeExpiresAt() {
        return priceGuaranteeExpiresAt.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PRICE_GUARANTEE_EXPIRES_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getPriceGuaranteeExpiresAt_JsonNullable() {
    return priceGuaranteeExpiresAt;
  }
  
  @JsonProperty(JSON_PROPERTY_PRICE_GUARANTEE_EXPIRES_AT)
  public void setPriceGuaranteeExpiresAt_JsonNullable(JsonNullable<OffsetDateTime> priceGuaranteeExpiresAt) {
    this.priceGuaranteeExpiresAt = priceGuaranteeExpiresAt;
  }

  public void setPriceGuaranteeExpiresAt(OffsetDateTime priceGuaranteeExpiresAt) {
    this.priceGuaranteeExpiresAt = JsonNullable.<OffsetDateTime>of(priceGuaranteeExpiresAt);
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OrderPaymentStatus orderPaymentStatus = (OrderPaymentStatus) o;
    return Objects.equals(this.awaitingPayment, orderPaymentStatus.awaitingPayment) &&
        equalsNullable(this.paymentRequiredBy, orderPaymentStatus.paymentRequiredBy) &&
        equalsNullable(this.priceGuaranteeExpiresAt, orderPaymentStatus.priceGuaranteeExpiresAt);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(awaitingPayment, hashCodeNullable(paymentRequiredBy), hashCodeNullable(priceGuaranteeExpiresAt));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OrderPaymentStatus {\n");
    sb.append("    awaitingPayment: ").append(toIndentedString(awaitingPayment)).append("\n");
    sb.append("    paymentRequiredBy: ").append(toIndentedString(paymentRequiredBy)).append("\n");
    sb.append("    priceGuaranteeExpiresAt: ").append(toIndentedString(priceGuaranteeExpiresAt)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

