/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.duffel.sdk.model.OrderRequestPassengerIdentityDocument;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * OrderRequestPassenger
 */
@JsonPropertyOrder({
  OrderRequestPassenger.JSON_PROPERTY_BORN_ON,
  OrderRequestPassenger.JSON_PROPERTY_EMAIL,
  OrderRequestPassenger.JSON_PROPERTY_FAMILY_NAME,
  OrderRequestPassenger.JSON_PROPERTY_GENDER,
  OrderRequestPassenger.JSON_PROPERTY_GIVEN_NAME,
  OrderRequestPassenger.JSON_PROPERTY_ID,
  OrderRequestPassenger.JSON_PROPERTY_IDENTITY_DOCUMENTS,
  OrderRequestPassenger.JSON_PROPERTY_INFANT_PASSENGER_ID,
  OrderRequestPassenger.JSON_PROPERTY_PHONE_NUMBER,
  OrderRequestPassenger.JSON_PROPERTY_TITLE,
  OrderRequestPassenger.JSON_PROPERTY_TYPE
})
@JsonTypeName("Order_Request_Passenger")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:18:14.926970+07:00[Asia/Bangkok]")
public class OrderRequestPassenger {
  public static final String JSON_PROPERTY_BORN_ON = "born_on";
  private LocalDate bornOn;

  public static final String JSON_PROPERTY_EMAIL = "email";
  private String email;

  public static final String JSON_PROPERTY_FAMILY_NAME = "family_name";
  private String familyName;

  /**
   * The passenger&#39;s gender
   */
  public enum GenderEnum {
    M("m"),
    
    F("f");

    private String value;

    GenderEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static GenderEnum fromValue(String value) {
      for (GenderEnum b : GenderEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_GENDER = "gender";
  private GenderEnum gender;

  public static final String JSON_PROPERTY_GIVEN_NAME = "given_name";
  private String givenName;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_IDENTITY_DOCUMENTS = "identity_documents";
  private JsonNullable<List<OrderRequestPassengerIdentityDocument>> identityDocuments = JsonNullable.<List<OrderRequestPassengerIdentityDocument>>undefined();

  public static final String JSON_PROPERTY_INFANT_PASSENGER_ID = "infant_passenger_id";
  private String infantPassengerId;

  public static final String JSON_PROPERTY_PHONE_NUMBER = "phone_number";
  private String phoneNumber;

  /**
   * The passenger&#39;s title
   */
  public enum TitleEnum {
    MR("mr"),
    
    MS("ms"),
    
    MRS("mrs"),
    
    MISS("miss"),
    
    DR("dr");

    private String value;

    TitleEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TitleEnum fromValue(String value) {
      for (TitleEnum b : TitleEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TITLE = "title";
  private TitleEnum title;

  /**
   * The type of the passenger
   */
  public enum TypeEnum {
    ADULT("adult"),
    
    CHILD("child"),
    
    INFANT_WITHOUT_SEAT("infant_without_seat");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private JsonNullable<TypeEnum> type = JsonNullable.<TypeEnum>undefined();

  public OrderRequestPassenger() { 
  }

  public OrderRequestPassenger bornOn(LocalDate bornOn) {
    
    this.bornOn = bornOn;
    return this;
  }

   /**
   * The passenger&#39;s date of birth
   * @return bornOn
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(example = "Fri Jul 24 07:00:00 ICT 1987", required = true, value = "The passenger's date of birth")
  @JsonProperty(JSON_PROPERTY_BORN_ON)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LocalDate getBornOn() {
    return bornOn;
  }


  @JsonProperty(JSON_PROPERTY_BORN_ON)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBornOn(LocalDate bornOn) {
    this.bornOn = bornOn;
  }


  public OrderRequestPassenger email(String email) {
    
    this.email = email;
    return this;
  }

   /**
   * The passenger&#39;s email address
   * @return email
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "amelia@duffel.com", required = true, value = "The passenger's email address")
  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getEmail() {
    return email;
  }


  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEmail(String email) {
    this.email = email;
  }


  public OrderRequestPassenger familyName(String familyName) {
    
    this.familyName = familyName;
    return this;
  }

   /**
   * The passenger&#39;s family name. Only &#x60;space&#x60;, &#x60;-&#x60;, &#x60;&#39;&#x60;, and letters from the [&#x60;ASCII&#x60;](https://www.unicode.org/charts/PDF/U0000.pdf), [&#x60;Latin-1 Supplement&#x60;](https://www.unicode.org/charts/PDF/U0080.pdf) and [&#x60;Latin Extended-A&#x60;](https://www.unicode.org/charts/PDF/U0100.pdf) (with the exceptions of &#x60;Æ&#x60;, &#x60;æ&#x60;, &#x60;Ĳ&#x60;, &#x60;ĳ&#x60;, &#x60;Œ&#x60;, &#x60;œ&#x60;, &#x60;Þ&#x60;, and &#x60;ð&#x60;) Unicode charts are accepted. All other characters will result in a validation error. The minimum length is 1 character, and the maximum is 20 characters.
   * @return familyName
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "Earhart", required = true, value = "The passenger's family name. Only `space`, `-`, `'`, and letters from the [`ASCII`](https://www.unicode.org/charts/PDF/U0000.pdf), [`Latin-1 Supplement`](https://www.unicode.org/charts/PDF/U0080.pdf) and [`Latin Extended-A`](https://www.unicode.org/charts/PDF/U0100.pdf) (with the exceptions of `Æ`, `æ`, `Ĳ`, `ĳ`, `Œ`, `œ`, `Þ`, and `ð`) Unicode charts are accepted. All other characters will result in a validation error. The minimum length is 1 character, and the maximum is 20 characters.")
  @JsonProperty(JSON_PROPERTY_FAMILY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getFamilyName() {
    return familyName;
  }


  @JsonProperty(JSON_PROPERTY_FAMILY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setFamilyName(String familyName) {
    this.familyName = familyName;
  }


  public OrderRequestPassenger gender(GenderEnum gender) {
    
    this.gender = gender;
    return this;
  }

   /**
   * The passenger&#39;s gender
   * @return gender
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "f", required = true, value = "The passenger's gender")
  @JsonProperty(JSON_PROPERTY_GENDER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public GenderEnum getGender() {
    return gender;
  }


  @JsonProperty(JSON_PROPERTY_GENDER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setGender(GenderEnum gender) {
    this.gender = gender;
  }


  public OrderRequestPassenger givenName(String givenName) {
    
    this.givenName = givenName;
    return this;
  }

   /**
   * The passenger&#39;s given name. Only &#x60;space&#x60;, &#x60;-&#x60;, &#x60;&#39;&#x60;, and letters from the [&#x60;ASCII&#x60;](https://www.unicode.org/charts/PDF/U0000.pdf), [&#x60;Latin-1 Supplement&#x60;](https://www.unicode.org/charts/PDF/U0080.pdf) and [&#x60;Latin Extended-A&#x60;](https://www.unicode.org/charts/PDF/U0100.pdf) (with the exceptions of &#x60;Æ&#x60;, &#x60;æ&#x60;, &#x60;Ĳ&#x60;, &#x60;ĳ&#x60;, &#x60;Œ&#x60;, &#x60;œ&#x60;, &#x60;Þ&#x60;, and &#x60;ð&#x60;) Unicode charts are accepted. All other characters will result in a validation error. The minimum length is 1 character, and the maximum is 20 characters.
   * @return givenName
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "Amelia", required = true, value = "The passenger's given name. Only `space`, `-`, `'`, and letters from the [`ASCII`](https://www.unicode.org/charts/PDF/U0000.pdf), [`Latin-1 Supplement`](https://www.unicode.org/charts/PDF/U0080.pdf) and [`Latin Extended-A`](https://www.unicode.org/charts/PDF/U0100.pdf) (with the exceptions of `Æ`, `æ`, `Ĳ`, `ĳ`, `Œ`, `œ`, `Þ`, and `ð`) Unicode charts are accepted. All other characters will result in a validation error. The minimum length is 1 character, and the maximum is 20 characters.")
  @JsonProperty(JSON_PROPERTY_GIVEN_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getGivenName() {
    return givenName;
  }


  @JsonProperty(JSON_PROPERTY_GIVEN_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setGivenName(String givenName) {
    this.givenName = givenName;
  }


  public OrderRequestPassenger id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * The &#x60;id&#x60; of the passenger, returned when the [offer request](/docs/api/offer-requests) was created
   * @return id
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "pas_00009hj8USM7Ncg31cBCLL", required = true, value = "The `id` of the passenger, returned when the [offer request](/docs/api/offer-requests) was created")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setId(String id) {
    this.id = id;
  }


  public OrderRequestPassenger identityDocuments(List<OrderRequestPassengerIdentityDocument> identityDocuments) {
    this.identityDocuments = JsonNullable.<List<OrderRequestPassengerIdentityDocument>>of(identityDocuments);
    
    return this;
  }

  public OrderRequestPassenger addIdentityDocumentsItem(OrderRequestPassengerIdentityDocument identityDocumentsItem) {
    if (this.identityDocuments == null || !this.identityDocuments.isPresent()) {
      this.identityDocuments = JsonNullable.<List<OrderRequestPassengerIdentityDocument>>of(new ArrayList<>());
    }
    try {
      this.identityDocuments.get().add(identityDocumentsItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * The passenger&#39;s identity documents. You may only provide one identity document per passenger. The identity document&#39;s type must be included in the offer&#39;s &#x60;allowed_passenger_identity_document_types&#x60;. If the offer&#39;s &#x60;passenger_identity_documents_required&#x60; is set to &#x60;true&#x60;, then an identity document must be provided.
   * @return identityDocuments
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "The passenger's identity documents. You may only provide one identity document per passenger. The identity document's type must be included in the offer's `allowed_passenger_identity_document_types`. If the offer's `passenger_identity_documents_required` is set to `true`, then an identity document must be provided.")
  @JsonIgnore

  public List<OrderRequestPassengerIdentityDocument> getIdentityDocuments() {
        return identityDocuments.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_IDENTITY_DOCUMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<OrderRequestPassengerIdentityDocument>> getIdentityDocuments_JsonNullable() {
    return identityDocuments;
  }
  
  @JsonProperty(JSON_PROPERTY_IDENTITY_DOCUMENTS)
  public void setIdentityDocuments_JsonNullable(JsonNullable<List<OrderRequestPassengerIdentityDocument>> identityDocuments) {
    this.identityDocuments = identityDocuments;
  }

  public void setIdentityDocuments(List<OrderRequestPassengerIdentityDocument> identityDocuments) {
    this.identityDocuments = JsonNullable.<List<OrderRequestPassengerIdentityDocument>>of(identityDocuments);
  }


  public OrderRequestPassenger infantPassengerId(String infantPassengerId) {
    
    this.infantPassengerId = infantPassengerId;
    return this;
  }

   /**
   * Infant passengers, with an &#x60;age&#x60; of 0 or 1, must be associated with an adult passenger. This field should be used to make this association. It should contain the &#x60;id&#x60; of the infant passenger as returned in the [offer request](/docs/api/offer-requests).
   * @return infantPassengerId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "pas_00009hj8USM8Ncg32aTGHL", value = "Infant passengers, with an `age` of 0 or 1, must be associated with an adult passenger. This field should be used to make this association. It should contain the `id` of the infant passenger as returned in the [offer request](/docs/api/offer-requests).")
  @JsonProperty(JSON_PROPERTY_INFANT_PASSENGER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getInfantPassengerId() {
    return infantPassengerId;
  }


  @JsonProperty(JSON_PROPERTY_INFANT_PASSENGER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInfantPassengerId(String infantPassengerId) {
    this.infantPassengerId = infantPassengerId;
  }


  public OrderRequestPassenger phoneNumber(String phoneNumber) {
    
    this.phoneNumber = phoneNumber;
    return this;
  }

   /**
   * The passenger&#39;s phone number in [E.164](https://www.twilio.com/docs/glossary/what-e164) (international) format
   * @return phoneNumber
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "+442080160509", required = true, value = "The passenger's phone number in [E.164](https://www.twilio.com/docs/glossary/what-e164) (international) format")
  @JsonProperty(JSON_PROPERTY_PHONE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getPhoneNumber() {
    return phoneNumber;
  }


  @JsonProperty(JSON_PROPERTY_PHONE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPhoneNumber(String phoneNumber) {
    this.phoneNumber = phoneNumber;
  }


  public OrderRequestPassenger title(TitleEnum title) {
    
    this.title = title;
    return this;
  }

   /**
   * The passenger&#39;s title
   * @return title
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "mrs", required = true, value = "The passenger's title")
  @JsonProperty(JSON_PROPERTY_TITLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TitleEnum getTitle() {
    return title;
  }


  @JsonProperty(JSON_PROPERTY_TITLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTitle(TitleEnum title) {
    this.title = title;
  }


  public OrderRequestPassenger type(TypeEnum type) {
    this.type = JsonNullable.<TypeEnum>of(type);
    
    return this;
  }

   /**
   * The type of the passenger
   * @return type
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "adult", value = "The type of the passenger")
  @JsonIgnore

  public TypeEnum getType() {
        return type.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<TypeEnum> getType_JsonNullable() {
    return type;
  }
  
  @JsonProperty(JSON_PROPERTY_TYPE)
  public void setType_JsonNullable(JsonNullable<TypeEnum> type) {
    this.type = type;
  }

  public void setType(TypeEnum type) {
    this.type = JsonNullable.<TypeEnum>of(type);
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OrderRequestPassenger orderRequestPassenger = (OrderRequestPassenger) o;
    return Objects.equals(this.bornOn, orderRequestPassenger.bornOn) &&
        Objects.equals(this.email, orderRequestPassenger.email) &&
        Objects.equals(this.familyName, orderRequestPassenger.familyName) &&
        Objects.equals(this.gender, orderRequestPassenger.gender) &&
        Objects.equals(this.givenName, orderRequestPassenger.givenName) &&
        Objects.equals(this.id, orderRequestPassenger.id) &&
        equalsNullable(this.identityDocuments, orderRequestPassenger.identityDocuments) &&
        Objects.equals(this.infantPassengerId, orderRequestPassenger.infantPassengerId) &&
        Objects.equals(this.phoneNumber, orderRequestPassenger.phoneNumber) &&
        Objects.equals(this.title, orderRequestPassenger.title) &&
        equalsNullable(this.type, orderRequestPassenger.type);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(bornOn, email, familyName, gender, givenName, id, hashCodeNullable(identityDocuments), infantPassengerId, phoneNumber, title, hashCodeNullable(type));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OrderRequestPassenger {\n");
    sb.append("    bornOn: ").append(toIndentedString(bornOn)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    familyName: ").append(toIndentedString(familyName)).append("\n");
    sb.append("    gender: ").append(toIndentedString(gender)).append("\n");
    sb.append("    givenName: ").append(toIndentedString(givenName)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    identityDocuments: ").append(toIndentedString(identityDocuments)).append("\n");
    sb.append("    infantPassengerId: ").append(toIndentedString(infantPassengerId)).append("\n");
    sb.append("    phoneNumber: ").append(toIndentedString(phoneNumber)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

