/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.duffel.sdk.model.ServiceMetadataForASeat1;
import com.duffel.sdk.model.SliceSegmentPassengerBaggage;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * OrderSliceSegmentPassenger
 */
@JsonPropertyOrder({
  OrderSliceSegmentPassenger.JSON_PROPERTY_BAGGAGES,
  OrderSliceSegmentPassenger.JSON_PROPERTY_CABIN_CLASS,
  OrderSliceSegmentPassenger.JSON_PROPERTY_CABIN_CLASS_MARKETING_NAME,
  OrderSliceSegmentPassenger.JSON_PROPERTY_PASSENGER_ID,
  OrderSliceSegmentPassenger.JSON_PROPERTY_SEAT
})
@JsonTypeName("Order_Slice_Segment_Passenger")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:18:14.926970+07:00[Asia/Bangkok]")
public class OrderSliceSegmentPassenger {
  public static final String JSON_PROPERTY_BAGGAGES = "baggages";
  private List<SliceSegmentPassengerBaggage> baggages = null;

  /**
   * The cabin class that the passenger will travel in on this segment
   */
  public enum CabinClassEnum {
    FIRST("first"),
    
    BUSINESS("business"),
    
    PREMIUM_ECONOMY("premium_economy"),
    
    ECONOMY("economy");

    private String value;

    CabinClassEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CabinClassEnum fromValue(String value) {
      for (CabinClassEnum b : CabinClassEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }
  }

  public static final String JSON_PROPERTY_CABIN_CLASS = "cabin_class";
  private JsonNullable<CabinClassEnum> cabinClass = JsonNullable.<CabinClassEnum>undefined();

  public static final String JSON_PROPERTY_CABIN_CLASS_MARKETING_NAME = "cabin_class_marketing_name";
  private JsonNullable<String> cabinClassMarketingName = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PASSENGER_ID = "passenger_id";
  private String passengerId;

  public static final String JSON_PROPERTY_SEAT = "seat";
  private JsonNullable<ServiceMetadataForASeat1> seat = JsonNullable.<ServiceMetadataForASeat1>undefined();

  public OrderSliceSegmentPassenger() { 
  }

  public OrderSliceSegmentPassenger baggages(List<SliceSegmentPassengerBaggage> baggages) {
    
    this.baggages = baggages;
    return this;
  }

  public OrderSliceSegmentPassenger addBaggagesItem(SliceSegmentPassengerBaggage baggagesItem) {
    if (this.baggages == null) {
      this.baggages = new ArrayList<>();
    }
    this.baggages.add(baggagesItem);
    return this;
  }

   /**
   * The baggage allowances for the passenger on this segment that were included in the original offer. Any extra baggage items which were booked as services will be listed in the &#x60;services&#x60; field instead of here.
   * @return baggages
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "The baggage allowances for the passenger on this segment that were included in the original offer. Any extra baggage items which were booked as services will be listed in the `services` field instead of here.")
  @JsonProperty(JSON_PROPERTY_BAGGAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SliceSegmentPassengerBaggage> getBaggages() {
    return baggages;
  }


  @JsonProperty(JSON_PROPERTY_BAGGAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBaggages(List<SliceSegmentPassengerBaggage> baggages) {
    this.baggages = baggages;
  }


  public OrderSliceSegmentPassenger cabinClass(CabinClassEnum cabinClass) {
    this.cabinClass = JsonNullable.<CabinClassEnum>of(cabinClass);
    
    return this;
  }

   /**
   * The cabin class that the passenger will travel in on this segment
   * @return cabinClass
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "economy", value = "The cabin class that the passenger will travel in on this segment")
  @JsonIgnore

  public CabinClassEnum getCabinClass() {
        return cabinClass.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CABIN_CLASS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<CabinClassEnum> getCabinClass_JsonNullable() {
    return cabinClass;
  }
  
  @JsonProperty(JSON_PROPERTY_CABIN_CLASS)
  public void setCabinClass_JsonNullable(JsonNullable<CabinClassEnum> cabinClass) {
    this.cabinClass = cabinClass;
  }

  public void setCabinClass(CabinClassEnum cabinClass) {
    this.cabinClass = JsonNullable.<CabinClassEnum>of(cabinClass);
  }


  public OrderSliceSegmentPassenger cabinClassMarketingName(String cabinClassMarketingName) {
    this.cabinClassMarketingName = JsonNullable.<String>of(cabinClassMarketingName);
    
    return this;
  }

   /**
   * The name that the marketing carrier uses to market this cabin class
   * @return cabinClassMarketingName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Economy Basic", value = "The name that the marketing carrier uses to market this cabin class")
  @JsonIgnore

  public String getCabinClassMarketingName() {
        return cabinClassMarketingName.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CABIN_CLASS_MARKETING_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getCabinClassMarketingName_JsonNullable() {
    return cabinClassMarketingName;
  }
  
  @JsonProperty(JSON_PROPERTY_CABIN_CLASS_MARKETING_NAME)
  public void setCabinClassMarketingName_JsonNullable(JsonNullable<String> cabinClassMarketingName) {
    this.cabinClassMarketingName = cabinClassMarketingName;
  }

  public void setCabinClassMarketingName(String cabinClassMarketingName) {
    this.cabinClassMarketingName = JsonNullable.<String>of(cabinClassMarketingName);
  }


  public OrderSliceSegmentPassenger passengerId(String passengerId) {
    
    this.passengerId = passengerId;
    return this;
  }

   /**
   * The identifier for the passenger. You may have specified this ID yourself when creating the offer request, or otherwise, Duffel will have generated its own random ID.
   * @return passengerId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "passenger_0", value = "The identifier for the passenger. You may have specified this ID yourself when creating the offer request, or otherwise, Duffel will have generated its own random ID.")
  @JsonProperty(JSON_PROPERTY_PASSENGER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPassengerId() {
    return passengerId;
  }


  @JsonProperty(JSON_PROPERTY_PASSENGER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPassengerId(String passengerId) {
    this.passengerId = passengerId;
  }


  public OrderSliceSegmentPassenger seat(ServiceMetadataForASeat1 seat) {
    this.seat = JsonNullable.<ServiceMetadataForASeat1>of(seat);
    
    return this;
  }

   /**
   * Get seat
   * @return seat
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonIgnore

  public ServiceMetadataForASeat1 getSeat() {
        return seat.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_SEAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<ServiceMetadataForASeat1> getSeat_JsonNullable() {
    return seat;
  }
  
  @JsonProperty(JSON_PROPERTY_SEAT)
  public void setSeat_JsonNullable(JsonNullable<ServiceMetadataForASeat1> seat) {
    this.seat = seat;
  }

  public void setSeat(ServiceMetadataForASeat1 seat) {
    this.seat = JsonNullable.<ServiceMetadataForASeat1>of(seat);
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OrderSliceSegmentPassenger orderSliceSegmentPassenger = (OrderSliceSegmentPassenger) o;
    return Objects.equals(this.baggages, orderSliceSegmentPassenger.baggages) &&
        equalsNullable(this.cabinClass, orderSliceSegmentPassenger.cabinClass) &&
        equalsNullable(this.cabinClassMarketingName, orderSliceSegmentPassenger.cabinClassMarketingName) &&
        Objects.equals(this.passengerId, orderSliceSegmentPassenger.passengerId) &&
        equalsNullable(this.seat, orderSliceSegmentPassenger.seat);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(baggages, hashCodeNullable(cabinClass), hashCodeNullable(cabinClassMarketingName), passengerId, hashCodeNullable(seat));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OrderSliceSegmentPassenger {\n");
    sb.append("    baggages: ").append(toIndentedString(baggages)).append("\n");
    sb.append("    cabinClass: ").append(toIndentedString(cabinClass)).append("\n");
    sb.append("    cabinClassMarketingName: ").append(toIndentedString(cabinClassMarketingName)).append("\n");
    sb.append("    passengerId: ").append(toIndentedString(passengerId)).append("\n");
    sb.append("    seat: ").append(toIndentedString(seat)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

