/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.duffel.sdk.model.Refund1;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * A __Payment Intent__ is used to collect and capture a payment from a customer to top-up your __Balance__ and then pay for an __Offer__, __Order__, or __Order Change Offer__. You&#39;re able to include markup here. 
 */
@ApiModel(description = "A __Payment Intent__ is used to collect and capture a payment from a customer to top-up your __Balance__ and then pay for an __Offer__, __Order__, or __Order Change Offer__. You're able to include markup here. ")
@JsonPropertyOrder({
  PaymentIntent.JSON_PROPERTY_AMOUNT,
  PaymentIntent.JSON_PROPERTY_CARD_COUNTRY_CODE,
  PaymentIntent.JSON_PROPERTY_CARD_LAST_FOUR_DIGITS,
  PaymentIntent.JSON_PROPERTY_CARD_NETWORK,
  PaymentIntent.JSON_PROPERTY_CLIENT_TOKEN,
  PaymentIntent.JSON_PROPERTY_CONFIRMED_AT,
  PaymentIntent.JSON_PROPERTY_CREATED_AT,
  PaymentIntent.JSON_PROPERTY_CURRENCY,
  PaymentIntent.JSON_PROPERTY_FEES_AMOUNT,
  PaymentIntent.JSON_PROPERTY_FEES_CURRENCY,
  PaymentIntent.JSON_PROPERTY_ID,
  PaymentIntent.JSON_PROPERTY_LIVE_MODE,
  PaymentIntent.JSON_PROPERTY_NET_AMOUNT,
  PaymentIntent.JSON_PROPERTY_NET_CURRENCY,
  PaymentIntent.JSON_PROPERTY_REFUNDS,
  PaymentIntent.JSON_PROPERTY_STATUS,
  PaymentIntent.JSON_PROPERTY_UPDATED_AT
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:18:14.926970+07:00[Asia/Bangkok]")
public class PaymentIntent {
  public static final String JSON_PROPERTY_AMOUNT = "amount";
  private String amount;

  public static final String JSON_PROPERTY_CARD_COUNTRY_CODE = "card_country_code";
  private JsonNullable<String> cardCountryCode = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CARD_LAST_FOUR_DIGITS = "card_last_four_digits";
  private JsonNullable<String> cardLastFourDigits = JsonNullable.<String>undefined();

  /**
   * The card network in which the __Payment Intent__ was processed on.  It will be &#x60;null&#x60; until the __Payment Intent__ is confirmed. 
   */
  public enum CardNetworkEnum {
    AMEX("amex"),
    
    CARTES_BANCAIRES("cartes_bancaires"),
    
    DINERS("diners"),
    
    DISCOVER("discover"),
    
    INTERAC("interac"),
    
    JCB("jcb"),
    
    MASTERCARD("mastercard"),
    
    UNIONPAY("unionpay"),
    
    VISA("visa"),
    
    UNKNOWN("unknown");

    private String value;

    CardNetworkEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CardNetworkEnum fromValue(String value) {
      for (CardNetworkEnum b : CardNetworkEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }
  }

  public static final String JSON_PROPERTY_CARD_NETWORK = "card_network";
  private JsonNullable<CardNetworkEnum> cardNetwork = JsonNullable.<CardNetworkEnum>undefined();

  public static final String JSON_PROPERTY_CLIENT_TOKEN = "client_token";
  private String clientToken;

  public static final String JSON_PROPERTY_CONFIRMED_AT = "confirmed_at";
  private JsonNullable<OffsetDateTime> confirmedAt = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_CREATED_AT = "created_at";
  private OffsetDateTime createdAt;

  public static final String JSON_PROPERTY_CURRENCY = "currency";
  private String currency;

  public static final String JSON_PROPERTY_FEES_AMOUNT = "fees_amount";
  private JsonNullable<String> feesAmount = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_FEES_CURRENCY = "fees_currency";
  private JsonNullable<String> feesCurrency = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_LIVE_MODE = "live_mode";
  private Boolean liveMode;

  public static final String JSON_PROPERTY_NET_AMOUNT = "net_amount";
  private JsonNullable<String> netAmount = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_NET_CURRENCY = "net_currency";
  private JsonNullable<String> netCurrency = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_REFUNDS = "refunds";
  private List<Refund1> refunds = null;

  /**
   * The status of this Payment Intent 
   */
  public enum StatusEnum {
    REQUIRES_PAYMENT_METHOD("requires_payment_method"),
    
    REQUIRES_CONFIRMATION("requires_confirmation"),
    
    REQUIRES_ACTION("requires_action"),
    
    PROCESSING("processing"),
    
    REQUIRES_CAPTURE("requires_capture"),
    
    CANCELLED("cancelled"),
    
    SUCCEEDED("succeeded");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status;

  public static final String JSON_PROPERTY_UPDATED_AT = "updated_at";
  private OffsetDateTime updatedAt;

  public PaymentIntent() { 
  }

  public PaymentIntent amount(String amount) {
    
    this.amount = amount;
    return this;
  }

   /**
   * The amount of the __Payment Intent__ that covers the cost of the flight being sold and any additional markup.  The card payment will be charged this amount. 
   * @return amount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "300.10", value = "The amount of the __Payment Intent__ that covers the cost of the flight being sold and any additional markup.  The card payment will be charged this amount. ")
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAmount() {
    return amount;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmount(String amount) {
    this.amount = amount;
  }


  public PaymentIntent cardCountryCode(String cardCountryCode) {
    this.cardCountryCode = JsonNullable.<String>of(cardCountryCode);
    
    return this;
  }

   /**
   * The [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) code of the country that issued the card used to confirm the __Payment Intent__.  It will be &#x60;null&#x60; until the __Payment Intent__ is confirmed. 
   * @return cardCountryCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "GB", value = "The [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) code of the country that issued the card used to confirm the __Payment Intent__.  It will be `null` until the __Payment Intent__ is confirmed. ")
  @JsonIgnore

  public String getCardCountryCode() {
        return cardCountryCode.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CARD_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getCardCountryCode_JsonNullable() {
    return cardCountryCode;
  }
  
  @JsonProperty(JSON_PROPERTY_CARD_COUNTRY_CODE)
  public void setCardCountryCode_JsonNullable(JsonNullable<String> cardCountryCode) {
    this.cardCountryCode = cardCountryCode;
  }

  public void setCardCountryCode(String cardCountryCode) {
    this.cardCountryCode = JsonNullable.<String>of(cardCountryCode);
  }


  public PaymentIntent cardLastFourDigits(String cardLastFourDigits) {
    this.cardLastFourDigits = JsonNullable.<String>of(cardLastFourDigits);
    
    return this;
  }

   /**
   * The last four digits of the card used to confirm the __Payment Intent__.  It will be &#x60;null&#x60; until the __Payment Intent__ is confirmed. 
   * @return cardLastFourDigits
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "4242", value = "The last four digits of the card used to confirm the __Payment Intent__.  It will be `null` until the __Payment Intent__ is confirmed. ")
  @JsonIgnore

  public String getCardLastFourDigits() {
        return cardLastFourDigits.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CARD_LAST_FOUR_DIGITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getCardLastFourDigits_JsonNullable() {
    return cardLastFourDigits;
  }
  
  @JsonProperty(JSON_PROPERTY_CARD_LAST_FOUR_DIGITS)
  public void setCardLastFourDigits_JsonNullable(JsonNullable<String> cardLastFourDigits) {
    this.cardLastFourDigits = cardLastFourDigits;
  }

  public void setCardLastFourDigits(String cardLastFourDigits) {
    this.cardLastFourDigits = JsonNullable.<String>of(cardLastFourDigits);
  }


  public PaymentIntent cardNetwork(CardNetworkEnum cardNetwork) {
    this.cardNetwork = JsonNullable.<CardNetworkEnum>of(cardNetwork);
    
    return this;
  }

   /**
   * The card network in which the __Payment Intent__ was processed on.  It will be &#x60;null&#x60; until the __Payment Intent__ is confirmed. 
   * @return cardNetwork
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "visa", value = "The card network in which the __Payment Intent__ was processed on.  It will be `null` until the __Payment Intent__ is confirmed. ")
  @JsonIgnore

  public CardNetworkEnum getCardNetwork() {
        return cardNetwork.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CARD_NETWORK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<CardNetworkEnum> getCardNetwork_JsonNullable() {
    return cardNetwork;
  }
  
  @JsonProperty(JSON_PROPERTY_CARD_NETWORK)
  public void setCardNetwork_JsonNullable(JsonNullable<CardNetworkEnum> cardNetwork) {
    this.cardNetwork = cardNetwork;
  }

  public void setCardNetwork(CardNetworkEnum cardNetwork) {
    this.cardNetwork = JsonNullable.<CardNetworkEnum>of(cardNetwork);
  }


  public PaymentIntent clientToken(String clientToken) {
    
    this.clientToken = clientToken;
    return this;
  }

   /**
   * This value is used when displaying the payment collection form to securely identify and transmit the values to Duffel. 
   * @return clientToken
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "eyJjbGllbnRfc2VjcmV0IjoicGlfMUl5YTBiQW5rMVRkeXJvRE1iWkJPN0ZSX3NlY3JldF9TbGFrYnJjYnFHZGZha2VrcjdCNE5jZWVyIiwicHVibGlzaGFibGVfa2V5IjoicGtfbGl2ZV81MUl0Q3YwQW5rMUdkeXJvRFlFU3M3RnBTUEdrNG9kbDhneDF3Y1RBNVEzaUcyWEFWVEhxdFlKSVhWMUxoSU5GQUtFMjA1dFdmRGVIcXhwUVdnYkIzTkVFbzAwMmdVY1hzR0YifQ==", value = "This value is used when displaying the payment collection form to securely identify and transmit the values to Duffel. ")
  @JsonProperty(JSON_PROPERTY_CLIENT_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getClientToken() {
    return clientToken;
  }


  @JsonProperty(JSON_PROPERTY_CLIENT_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setClientToken(String clientToken) {
    this.clientToken = clientToken;
  }


  public PaymentIntent confirmedAt(OffsetDateTime confirmedAt) {
    this.confirmedAt = JsonNullable.<OffsetDateTime>of(confirmedAt);
    
    return this;
  }

   /**
   * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the __Payment Intent__ was confirmed.  It will be &#x60;null&#x60; until the __Payment Intent__ is confirmed. 
   * @return confirmedAt
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(example = "2020-04-11T15:49:02.642Z", value = "The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the __Payment Intent__ was confirmed.  It will be `null` until the __Payment Intent__ is confirmed. ")
  @JsonIgnore

  public OffsetDateTime getConfirmedAt() {
        return confirmedAt.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CONFIRMED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getConfirmedAt_JsonNullable() {
    return confirmedAt;
  }
  
  @JsonProperty(JSON_PROPERTY_CONFIRMED_AT)
  public void setConfirmedAt_JsonNullable(JsonNullable<OffsetDateTime> confirmedAt) {
    this.confirmedAt = confirmedAt;
  }

  public void setConfirmedAt(OffsetDateTime confirmedAt) {
    this.confirmedAt = JsonNullable.<OffsetDateTime>of(confirmedAt);
  }


  public PaymentIntent createdAt(OffsetDateTime createdAt) {
    
    this.createdAt = createdAt;
    return this;
  }

   /**
   * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the __Payment Intent__ was created
   * @return createdAt
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(example = "2020-04-11T15:48:11.642Z", value = "The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the __Payment Intent__ was created")
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }


  public PaymentIntent currency(String currency) {
    
    this.currency = currency;
    return this;
  }

   /**
   * The currency of the &#x60;amount&#x60;, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code.  The card payment will be charged in this currency.  If it&#39;s different to your __Balance__ currency, it will be converted to your __Balance__ currency before the __Balance__ is topped up. 
   * @return currency
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "GBP", value = "The currency of the `amount`, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code.  The card payment will be charged in this currency.  If it's different to your __Balance__ currency, it will be converted to your __Balance__ currency before the __Balance__ is topped up. ")
  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCurrency() {
    return currency;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrency(String currency) {
    this.currency = currency;
  }


  public PaymentIntent feesAmount(String feesAmount) {
    this.feesAmount = JsonNullable.<String>of(feesAmount);
    
    return this;
  }

   /**
   * The amount of the fees to process the __Payment Intent__.  It will be &#x60;null&#x60; until the __Payment Intent__ is confirmed. 
   * @return feesAmount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "3.00", value = "The amount of the fees to process the __Payment Intent__.  It will be `null` until the __Payment Intent__ is confirmed. ")
  @JsonIgnore

  public String getFeesAmount() {
        return feesAmount.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_FEES_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getFeesAmount_JsonNullable() {
    return feesAmount;
  }
  
  @JsonProperty(JSON_PROPERTY_FEES_AMOUNT)
  public void setFeesAmount_JsonNullable(JsonNullable<String> feesAmount) {
    this.feesAmount = feesAmount;
  }

  public void setFeesAmount(String feesAmount) {
    this.feesAmount = JsonNullable.<String>of(feesAmount);
  }


  public PaymentIntent feesCurrency(String feesCurrency) {
    this.feesCurrency = JsonNullable.<String>of(feesCurrency);
    
    return this;
  }

   /**
   * The currency of the &#x60;fees_amount&#x60;, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code.  This currency will match your __Balance__ currency.  It will be &#x60;null&#x60; until the __Payment Intent__ is confirmed. 
   * @return feesCurrency
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "GBP", value = "The currency of the `fees_amount`, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code.  This currency will match your __Balance__ currency.  It will be `null` until the __Payment Intent__ is confirmed. ")
  @JsonIgnore

  public String getFeesCurrency() {
        return feesCurrency.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_FEES_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getFeesCurrency_JsonNullable() {
    return feesCurrency;
  }
  
  @JsonProperty(JSON_PROPERTY_FEES_CURRENCY)
  public void setFeesCurrency_JsonNullable(JsonNullable<String> feesCurrency) {
    this.feesCurrency = feesCurrency;
  }

  public void setFeesCurrency(String feesCurrency) {
    this.feesCurrency = JsonNullable.<String>of(feesCurrency);
  }


  public PaymentIntent id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Duffel&#39;s unique identifier for the __Payment Intent__
   * @return id
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "pit_00009hthhsUZ8W4LxQgkjo", value = "Duffel's unique identifier for the __Payment Intent__")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public PaymentIntent liveMode(Boolean liveMode) {
    
    this.liveMode = liveMode;
    return this;
  }

   /**
   * Whether the __Payment Intent__ was created in live mode. This field will be set to &#x60;true&#x60; if the __Payment Intent__ was created in live mode, or &#x60;false&#x60; if it was created in test mode.
   * @return liveMode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Whether the __Payment Intent__ was created in live mode. This field will be set to `true` if the __Payment Intent__ was created in live mode, or `false` if it was created in test mode.")
  @JsonProperty(JSON_PROPERTY_LIVE_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getLiveMode() {
    return liveMode;
  }


  @JsonProperty(JSON_PROPERTY_LIVE_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLiveMode(Boolean liveMode) {
    this.liveMode = liveMode;
  }


  public PaymentIntent netAmount(String netAmount) {
    this.netAmount = JsonNullable.<String>of(netAmount);
    
    return this;
  }

   /**
   * The amount of the __Payment Intent__ that was added to the __Balance__.  It&#39;ll be &#x60;amount&#x60; (in the __Balance__ currency) less the &#x60;fees_amount&#x60;.  It will be &#x60;null&#x60; until the __Payment Intent__ is confirmed. 
   * @return netAmount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "297.10", value = "The amount of the __Payment Intent__ that was added to the __Balance__.  It'll be `amount` (in the __Balance__ currency) less the `fees_amount`.  It will be `null` until the __Payment Intent__ is confirmed. ")
  @JsonIgnore

  public String getNetAmount() {
        return netAmount.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_NET_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getNetAmount_JsonNullable() {
    return netAmount;
  }
  
  @JsonProperty(JSON_PROPERTY_NET_AMOUNT)
  public void setNetAmount_JsonNullable(JsonNullable<String> netAmount) {
    this.netAmount = netAmount;
  }

  public void setNetAmount(String netAmount) {
    this.netAmount = JsonNullable.<String>of(netAmount);
  }


  public PaymentIntent netCurrency(String netCurrency) {
    this.netCurrency = JsonNullable.<String>of(netCurrency);
    
    return this;
  }

   /**
   * The currency of the &#x60;net_amount&#x60;, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code.  This currency will match your __Balance__ currency.  It will be &#x60;null&#x60; until the __Payment Intent__ is confirmed. 
   * @return netCurrency
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "GBP", value = "The currency of the `net_amount`, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code.  This currency will match your __Balance__ currency.  It will be `null` until the __Payment Intent__ is confirmed. ")
  @JsonIgnore

  public String getNetCurrency() {
        return netCurrency.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_NET_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getNetCurrency_JsonNullable() {
    return netCurrency;
  }
  
  @JsonProperty(JSON_PROPERTY_NET_CURRENCY)
  public void setNetCurrency_JsonNullable(JsonNullable<String> netCurrency) {
    this.netCurrency = netCurrency;
  }

  public void setNetCurrency(String netCurrency) {
    this.netCurrency = JsonNullable.<String>of(netCurrency);
  }


  public PaymentIntent refunds(List<Refund1> refunds) {
    
    this.refunds = refunds;
    return this;
  }

  public PaymentIntent addRefundsItem(Refund1 refundsItem) {
    if (this.refunds == null) {
      this.refunds = new ArrayList<>();
    }
    this.refunds.add(refundsItem);
    return this;
  }

   /**
   * The __Refunds__ for this __Payment Intent__
   * @return refunds
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "The __Refunds__ for this __Payment Intent__")
  @JsonProperty(JSON_PROPERTY_REFUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Refund1> getRefunds() {
    return refunds;
  }


  @JsonProperty(JSON_PROPERTY_REFUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRefunds(List<Refund1> refunds) {
    this.refunds = refunds;
  }


  public PaymentIntent status(StatusEnum status) {
    
    this.status = status;
    return this;
  }

   /**
   * The status of this Payment Intent 
   * @return status
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "succeeded", value = "The status of this Payment Intent ")
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StatusEnum getStatus() {
    return status;
  }


  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(StatusEnum status) {
    this.status = status;
  }


  public PaymentIntent updatedAt(OffsetDateTime updatedAt) {
    
    this.updatedAt = updatedAt;
    return this;
  }

   /**
   * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the __Payment Intent__ was updated
   * @return updatedAt
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(example = "2020-04-11T15:48:11.642Z", value = "The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the __Payment Intent__ was updated")
  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getUpdatedAt() {
    return updatedAt;
  }


  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUpdatedAt(OffsetDateTime updatedAt) {
    this.updatedAt = updatedAt;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentIntent paymentIntent = (PaymentIntent) o;
    return Objects.equals(this.amount, paymentIntent.amount) &&
        equalsNullable(this.cardCountryCode, paymentIntent.cardCountryCode) &&
        equalsNullable(this.cardLastFourDigits, paymentIntent.cardLastFourDigits) &&
        equalsNullable(this.cardNetwork, paymentIntent.cardNetwork) &&
        Objects.equals(this.clientToken, paymentIntent.clientToken) &&
        equalsNullable(this.confirmedAt, paymentIntent.confirmedAt) &&
        Objects.equals(this.createdAt, paymentIntent.createdAt) &&
        Objects.equals(this.currency, paymentIntent.currency) &&
        equalsNullable(this.feesAmount, paymentIntent.feesAmount) &&
        equalsNullable(this.feesCurrency, paymentIntent.feesCurrency) &&
        Objects.equals(this.id, paymentIntent.id) &&
        Objects.equals(this.liveMode, paymentIntent.liveMode) &&
        equalsNullable(this.netAmount, paymentIntent.netAmount) &&
        equalsNullable(this.netCurrency, paymentIntent.netCurrency) &&
        Objects.equals(this.refunds, paymentIntent.refunds) &&
        Objects.equals(this.status, paymentIntent.status) &&
        Objects.equals(this.updatedAt, paymentIntent.updatedAt);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(amount, hashCodeNullable(cardCountryCode), hashCodeNullable(cardLastFourDigits), hashCodeNullable(cardNetwork), clientToken, hashCodeNullable(confirmedAt), createdAt, currency, hashCodeNullable(feesAmount), hashCodeNullable(feesCurrency), id, liveMode, hashCodeNullable(netAmount), hashCodeNullable(netCurrency), refunds, status, updatedAt);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentIntent {\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    cardCountryCode: ").append(toIndentedString(cardCountryCode)).append("\n");
    sb.append("    cardLastFourDigits: ").append(toIndentedString(cardLastFourDigits)).append("\n");
    sb.append("    cardNetwork: ").append(toIndentedString(cardNetwork)).append("\n");
    sb.append("    clientToken: ").append(toIndentedString(clientToken)).append("\n");
    sb.append("    confirmedAt: ").append(toIndentedString(confirmedAt)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    feesAmount: ").append(toIndentedString(feesAmount)).append("\n");
    sb.append("    feesCurrency: ").append(toIndentedString(feesCurrency)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    liveMode: ").append(toIndentedString(liveMode)).append("\n");
    sb.append("    netAmount: ").append(toIndentedString(netAmount)).append("\n");
    sb.append("    netCurrency: ").append(toIndentedString(netCurrency)).append("\n");
    sb.append("    refunds: ").append(toIndentedString(refunds)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

