/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.duffel.sdk.model.SeatMapCabin;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Each seat map is for a specific segment
 */
@ApiModel(description = "Each seat map is for a specific segment")
@JsonPropertyOrder({
  SeatMap.JSON_PROPERTY_CABINS,
  SeatMap.JSON_PROPERTY_ID,
  SeatMap.JSON_PROPERTY_SEGMENT_ID,
  SeatMap.JSON_PROPERTY_SLICE_ID
})
@JsonTypeName("Seat_map")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:18:14.926970+07:00[Asia/Bangkok]")
public class SeatMap {
  public static final String JSON_PROPERTY_CABINS = "cabins";
  private List<SeatMapCabin> cabins = new ArrayList<>();

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_SEGMENT_ID = "segment_id";
  private String segmentId;

  public static final String JSON_PROPERTY_SLICE_ID = "slice_id";
  private String sliceId;

  public SeatMap() { 
  }

  public SeatMap cabins(List<SeatMapCabin> cabins) {
    
    this.cabins = cabins;
    return this;
  }

  public SeatMap addCabinsItem(SeatMapCabin cabinsItem) {
    this.cabins.add(cabinsItem);
    return this;
  }

   /**
   * The list of cabins in this seat map.  Cabins are ordered by deck from lowest to highest, and then within  each deck from the front to back of the aircraft. 
   * @return cabins
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "The list of cabins in this seat map.  Cabins are ordered by deck from lowest to highest, and then within  each deck from the front to back of the aircraft. ")
  @JsonProperty(JSON_PROPERTY_CABINS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<SeatMapCabin> getCabins() {
    return cabins;
  }


  @JsonProperty(JSON_PROPERTY_CABINS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCabins(List<SeatMapCabin> cabins) {
    this.cabins = cabins;
  }


  public SeatMap id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Duffel&#39;s unique identifier for the seat map
   * @return id
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "sea_00003hthlsHZ8W4LxXjkzo", required = true, value = "Duffel's unique identifier for the seat map")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setId(String id) {
    this.id = id;
  }


  public SeatMap segmentId(String segmentId) {
    
    this.segmentId = segmentId;
    return this;
  }

   /**
   * Duffel&#39;s unique identifier for the segment. It identifies the segment of an offer (i.e. the same segment across offers will have different &#x60;id&#x60;s).
   * @return segmentId
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "seg_00009htYpSCXrwaB9Dn456", required = true, value = "Duffel's unique identifier for the segment. It identifies the segment of an offer (i.e. the same segment across offers will have different `id`s).")
  @JsonProperty(JSON_PROPERTY_SEGMENT_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSegmentId() {
    return segmentId;
  }


  @JsonProperty(JSON_PROPERTY_SEGMENT_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSegmentId(String segmentId) {
    this.segmentId = segmentId;
  }


  public SeatMap sliceId(String sliceId) {
    
    this.sliceId = sliceId;
    return this;
  }

   /**
   * Duffel&#39;s unique identifier for the slice. It identifies the slice of an offer (i.e. the same slice across offers will have different &#x60;id&#x60;s.)
   * @return sliceId
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "sli_00009htYpSCXrwaB9Dn123", required = true, value = "Duffel's unique identifier for the slice. It identifies the slice of an offer (i.e. the same slice across offers will have different `id`s.)")
  @JsonProperty(JSON_PROPERTY_SLICE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSliceId() {
    return sliceId;
  }


  @JsonProperty(JSON_PROPERTY_SLICE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSliceId(String sliceId) {
    this.sliceId = sliceId;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SeatMap seatMap = (SeatMap) o;
    return Objects.equals(this.cabins, seatMap.cabins) &&
        Objects.equals(this.id, seatMap.id) &&
        Objects.equals(this.segmentId, seatMap.segmentId) &&
        Objects.equals(this.sliceId, seatMap.sliceId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(cabins, id, segmentId, sliceId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SeatMap {\n");
    sb.append("    cabins: ").append(toIndentedString(cabins)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    segmentId: ").append(toIndentedString(segmentId)).append("\n");
    sb.append("    sliceId: ").append(toIndentedString(sliceId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

