/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * A bookable seat is a special kind of service. Only one seat can be booked per passenger, per segment 
 */
@ApiModel(description = "A bookable seat is a special kind of service. Only one seat can be booked per passenger, per segment ")
@JsonPropertyOrder({
  SeatService.JSON_PROPERTY_ID,
  SeatService.JSON_PROPERTY_PASSENGER_ID,
  SeatService.JSON_PROPERTY_TOTAL_AMOUNT,
  SeatService.JSON_PROPERTY_TOTAL_CURRENCY
})
@JsonTypeName("Seat_Service")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:18:14.926970+07:00[Asia/Bangkok]")
public class SeatService {
  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_PASSENGER_ID = "passenger_id";
  private String passengerId;

  public static final String JSON_PROPERTY_TOTAL_AMOUNT = "total_amount";
  private String totalAmount;

  public static final String JSON_PROPERTY_TOTAL_CURRENCY = "total_currency";
  private String totalCurrency;

  public SeatService() { 
  }

  public SeatService id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Duffel&#39;s unique identifier for the service
   * @return id
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "ase_00009UhD4ongolulWd9123", required = true, value = "Duffel's unique identifier for the service")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setId(String id) {
    this.id = id;
  }


  public SeatService passengerId(String passengerId) {
    
    this.passengerId = passengerId;
    return this;
  }

   /**
   * The passenger that this seat is for
   * @return passengerId
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "pas_00009hj8USM7Ncg31cBCLL", required = true, value = "The passenger that this seat is for")
  @JsonProperty(JSON_PROPERTY_PASSENGER_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getPassengerId() {
    return passengerId;
  }


  @JsonProperty(JSON_PROPERTY_PASSENGER_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPassengerId(String passengerId) {
    this.passengerId = passengerId;
  }


  public SeatService totalAmount(String totalAmount) {
    
    this.totalAmount = totalAmount;
    return this;
  }

   /**
   * The total price of the seat, including taxes
   * @return totalAmount
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "15.00", required = true, value = "The total price of the seat, including taxes")
  @JsonProperty(JSON_PROPERTY_TOTAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getTotalAmount() {
    return totalAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTotalAmount(String totalAmount) {
    this.totalAmount = totalAmount;
  }


  public SeatService totalCurrency(String totalCurrency) {
    
    this.totalCurrency = totalCurrency;
    return this;
  }

   /**
   * The currency of the &#x60;total_amount&#x60;, as an  [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code. It will match your organisation&#39;s billing currency unless you’re using Duffel as an accredited IATA agent, in which case it will be in the currency provided by the airline (which will usually be based on the country where your IATA agency is registered). 
   * @return totalCurrency
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "GBP", required = true, value = "The currency of the `total_amount`, as an  [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code. It will match your organisation's billing currency unless you’re using Duffel as an accredited IATA agent, in which case it will be in the currency provided by the airline (which will usually be based on the country where your IATA agency is registered). ")
  @JsonProperty(JSON_PROPERTY_TOTAL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getTotalCurrency() {
    return totalCurrency;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTotalCurrency(String totalCurrency) {
    this.totalCurrency = totalCurrency;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SeatService seatService = (SeatService) o;
    return Objects.equals(this.id, seatService.id) &&
        Objects.equals(this.passengerId, seatService.passengerId) &&
        Objects.equals(this.totalAmount, seatService.totalAmount) &&
        Objects.equals(this.totalCurrency, seatService.totalCurrency);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, passengerId, totalAmount, totalCurrency);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SeatService {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    passengerId: ").append(toIndentedString(passengerId)).append("\n");
    sb.append("    totalAmount: ").append(toIndentedString(totalAmount)).append("\n");
    sb.append("    totalCurrency: ").append(toIndentedString(totalCurrency)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

