/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * An object containing metadata about the service, like the designator of the  seat. 
 */
@ApiModel(description = "An object containing metadata about the service, like the designator of the  seat. ")
@JsonPropertyOrder({
  ServiceMetadataForASeat1.JSON_PROPERTY_DESIGNATOR,
  ServiceMetadataForASeat1.JSON_PROPERTY_DISCLOSURES,
  ServiceMetadataForASeat1.JSON_PROPERTY_NAME
})
@JsonTypeName("Service_Metadata_for_a_Seat_1")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:18:14.926970+07:00[Asia/Bangkok]")
public class ServiceMetadataForASeat1 {
  public static final String JSON_PROPERTY_DESIGNATOR = "designator";
  private String designator;

  public static final String JSON_PROPERTY_DISCLOSURES = "disclosures";
  private List<String> disclosures = null;

  public static final String JSON_PROPERTY_NAME = "name";
  private JsonNullable<String> name = JsonNullable.<String>undefined();

  public ServiceMetadataForASeat1() { 
  }

  public ServiceMetadataForASeat1 designator(String designator) {
    
    this.designator = designator;
    return this;
  }

   /**
   * The designator used to uniquely identify the seat, usually made up of a  row number and a column letter 
   * @return designator
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "14B", value = "The designator used to uniquely identify the seat, usually made up of a  row number and a column letter ")
  @JsonProperty(JSON_PROPERTY_DESIGNATOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDesignator() {
    return designator;
  }


  @JsonProperty(JSON_PROPERTY_DESIGNATOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDesignator(String designator) {
    this.designator = designator;
  }


  public ServiceMetadataForASeat1 disclosures(List<String> disclosures) {
    
    this.disclosures = disclosures;
    return this;
  }

  public ServiceMetadataForASeat1 addDisclosuresItem(String disclosuresItem) {
    if (this.disclosures == null) {
      this.disclosures = new ArrayList<>();
    }
    this.disclosures.add(disclosuresItem);
    return this;
  }

   /**
   * Each disclosure is text, in English, provided by the airline that  describes the terms and conditions of this seat. We recommend showing  this in your user interface to make sure that customers understand any  restrictions and limitations. 
   * @return disclosures
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "[\"Do not seat children in exit row seats\",\"Do not seat passengers with special needs in exit row seats\"]", value = "Each disclosure is text, in English, provided by the airline that  describes the terms and conditions of this seat. We recommend showing  this in your user interface to make sure that customers understand any  restrictions and limitations. ")
  @JsonProperty(JSON_PROPERTY_DISCLOSURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getDisclosures() {
    return disclosures;
  }


  @JsonProperty(JSON_PROPERTY_DISCLOSURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisclosures(List<String> disclosures) {
    this.disclosures = disclosures;
  }


  public ServiceMetadataForASeat1 name(String name) {
    this.name = JsonNullable.<String>of(name);
    
    return this;
  }

   /**
   * A name which describes the type of seat, which you can display in your  user interface to help customers to understand its features 
   * @return name
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Exit row seat", value = "A name which describes the type of seat, which you can display in your  user interface to help customers to understand its features ")
  @JsonIgnore

  public String getName() {
        return name.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getName_JsonNullable() {
    return name;
  }
  
  @JsonProperty(JSON_PROPERTY_NAME)
  public void setName_JsonNullable(JsonNullable<String> name) {
    this.name = name;
  }

  public void setName(String name) {
    this.name = JsonNullable.<String>of(name);
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ServiceMetadataForASeat1 serviceMetadataForASeat1 = (ServiceMetadataForASeat1) o;
    return Objects.equals(this.designator, serviceMetadataForASeat1.designator) &&
        Objects.equals(this.disclosures, serviceMetadataForASeat1.disclosures) &&
        equalsNullable(this.name, serviceMetadataForASeat1.name);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(designator, disclosures, hashCodeNullable(name));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ServiceMetadataForASeat1 {\n");
    sb.append("    designator: ").append(toIndentedString(designator)).append("\n");
    sb.append("    disclosures: ").append(toIndentedString(disclosures)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

