/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Where the wings of the aircraft are in relation to rows in the cabin.  The numbers correspond to the indices of the first and the last  row which are overwing. You can use this to draw a visual  representation of the wings to help users get a better idea of  what they will see outside their window.  The indices are 0th-based and are for all rows, not just those that have seats.  This is &#x60;null&#x60; when no rows of the cabin are overwing. 
 */
@ApiModel(description = "Where the wings of the aircraft are in relation to rows in the cabin.  The numbers correspond to the indices of the first and the last  row which are overwing. You can use this to draw a visual  representation of the wings to help users get a better idea of  what they will see outside their window.  The indices are 0th-based and are for all rows, not just those that have seats.  This is `null` when no rows of the cabin are overwing. ")
@JsonPropertyOrder({
  WingPosition.JSON_PROPERTY_FIRST_ROW_INDEX,
  WingPosition.JSON_PROPERTY_LAST_ROW_INDEX
})
@JsonTypeName("Wing_Position")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:18:14.926970+07:00[Asia/Bangkok]")
public class WingPosition {
  public static final String JSON_PROPERTY_FIRST_ROW_INDEX = "first_row_index";
  private Integer firstRowIndex;

  public static final String JSON_PROPERTY_LAST_ROW_INDEX = "last_row_index";
  private Integer lastRowIndex;

  public WingPosition() { 
  }

  public WingPosition firstRowIndex(Integer firstRowIndex) {
    
    this.firstRowIndex = firstRowIndex;
    return this;
  }

   /**
   * The index of the first row which is overwing, starting from  the front of the aircraft. 
   * minimum: 0
   * @return firstRowIndex
  **/
  @javax.annotation.Nonnull
  @NotNull
 @Min(0)  @ApiModelProperty(example = "8", required = true, value = "The index of the first row which is overwing, starting from  the front of the aircraft. ")
  @JsonProperty(JSON_PROPERTY_FIRST_ROW_INDEX)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getFirstRowIndex() {
    return firstRowIndex;
  }


  @JsonProperty(JSON_PROPERTY_FIRST_ROW_INDEX)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setFirstRowIndex(Integer firstRowIndex) {
    this.firstRowIndex = firstRowIndex;
  }


  public WingPosition lastRowIndex(Integer lastRowIndex) {
    
    this.lastRowIndex = lastRowIndex;
    return this;
  }

   /**
   * The index of the last row which is overwing, starting from  the front of the aircraft. 
   * minimum: 0
   * @return lastRowIndex
  **/
  @javax.annotation.Nonnull
  @NotNull
 @Min(0)  @ApiModelProperty(example = "12", required = true, value = "The index of the last row which is overwing, starting from  the front of the aircraft. ")
  @JsonProperty(JSON_PROPERTY_LAST_ROW_INDEX)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getLastRowIndex() {
    return lastRowIndex;
  }


  @JsonProperty(JSON_PROPERTY_LAST_ROW_INDEX)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLastRowIndex(Integer lastRowIndex) {
    this.lastRowIndex = lastRowIndex;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WingPosition wingPosition = (WingPosition) o;
    return Objects.equals(this.firstRowIndex, wingPosition.firstRowIndex) &&
        Objects.equals(this.lastRowIndex, wingPosition.lastRowIndex);
  }

  @Override
  public int hashCode() {
    return Objects.hash(firstRowIndex, lastRowIndex);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WingPosition {\n");
    sb.append("    firstRowIndex: ").append(toIndentedString(firstRowIndex)).append("\n");
    sb.append("    lastRowIndex: ").append(toIndentedString(lastRowIndex)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

