/*
 * Decompiled with CFR 0.152.
 */
package com.duffel.sdk.model;

import com.duffel.sdk.model.OfferConditions1;
import com.duffel.sdk.model.OfferIndexOwner;
import com.duffel.sdk.model.OfferIndexPaymentRequirements;
import com.duffel.sdk.model.OfferPassenger;
import com.duffel.sdk.model.OfferService;
import com.duffel.sdk.model.OfferSlice;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"allowed_passenger_identity_document_types", "available_services", "base_amount", "base_currency", "conditions", "created_at", "expires_at", "id", "live_mode", "owner", "partial", "passenger_identity_documents_required", "passengers", "payment_requirements", "slices", "tax_amount", "tax_currency", "total_amount", "total_currency", "total_emissions_kg", "updated_at"})
@JsonTypeName(value="Offer_1")
public class Offer1 {
    public static final String JSON_PROPERTY_ALLOWED_PASSENGER_IDENTITY_DOCUMENT_TYPES = "allowed_passenger_identity_document_types";
    private List<AllowedPassengerIdentityDocumentTypesEnum> allowedPassengerIdentityDocumentTypes = null;
    public static final String JSON_PROPERTY_AVAILABLE_SERVICES = "available_services";
    private List<OfferService> availableServices = null;
    public static final String JSON_PROPERTY_BASE_AMOUNT = "base_amount";
    private String baseAmount;
    public static final String JSON_PROPERTY_BASE_CURRENCY = "base_currency";
    private String baseCurrency;
    public static final String JSON_PROPERTY_CONDITIONS = "conditions";
    private OfferConditions1 conditions;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_EXPIRES_AT = "expires_at";
    private OffsetDateTime expiresAt;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_LIVE_MODE = "live_mode";
    private Boolean liveMode;
    public static final String JSON_PROPERTY_OWNER = "owner";
    private OfferIndexOwner owner;
    public static final String JSON_PROPERTY_PARTIAL = "partial";
    private Boolean partial;
    public static final String JSON_PROPERTY_PASSENGER_IDENTITY_DOCUMENTS_REQUIRED = "passenger_identity_documents_required";
    private Boolean passengerIdentityDocumentsRequired;
    public static final String JSON_PROPERTY_PASSENGERS = "passengers";
    private List<OfferPassenger> passengers = null;
    public static final String JSON_PROPERTY_PAYMENT_REQUIREMENTS = "payment_requirements";
    private OfferIndexPaymentRequirements paymentRequirements;
    public static final String JSON_PROPERTY_SLICES = "slices";
    private List<OfferSlice> slices = null;
    public static final String JSON_PROPERTY_TAX_AMOUNT = "tax_amount";
    private JsonNullable<String> taxAmount = JsonNullable.undefined();
    public static final String JSON_PROPERTY_TAX_CURRENCY = "tax_currency";
    private JsonNullable<String> taxCurrency = JsonNullable.undefined();
    public static final String JSON_PROPERTY_TOTAL_AMOUNT = "total_amount";
    private String totalAmount;
    public static final String JSON_PROPERTY_TOTAL_CURRENCY = "total_currency";
    private String totalCurrency;
    public static final String JSON_PROPERTY_TOTAL_EMISSIONS_KG = "total_emissions_kg";
    private String totalEmissionsKg;
    public static final String JSON_PROPERTY_UPDATED_AT = "updated_at";
    private OffsetDateTime updatedAt;

    public Offer1 allowedPassengerIdentityDocumentTypes(List<AllowedPassengerIdentityDocumentTypesEnum> allowedPassengerIdentityDocumentTypes) {
        this.allowedPassengerIdentityDocumentTypes = allowedPassengerIdentityDocumentTypes;
        return this;
    }

    public Offer1 addAllowedPassengerIdentityDocumentTypesItem(AllowedPassengerIdentityDocumentTypesEnum allowedPassengerIdentityDocumentTypesItem) {
        if (this.allowedPassengerIdentityDocumentTypes == null) {
            this.allowedPassengerIdentityDocumentTypes = new ArrayList<AllowedPassengerIdentityDocumentTypesEnum>();
        }
        this.allowedPassengerIdentityDocumentTypes.add(allowedPassengerIdentityDocumentTypesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"passport\"]", value="The types of identity documents that may be provided for the passengers when creating an order based on this offer. Currently, the only supported type is `passport`. If this is `[]`, then you must not provide identity documents.")
    @JsonProperty(value="allowed_passenger_identity_document_types")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<AllowedPassengerIdentityDocumentTypesEnum> getAllowedPassengerIdentityDocumentTypes() {
        return this.allowedPassengerIdentityDocumentTypes;
    }

    @JsonProperty(value="allowed_passenger_identity_document_types")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAllowedPassengerIdentityDocumentTypes(List<AllowedPassengerIdentityDocumentTypesEnum> allowedPassengerIdentityDocumentTypes) {
        this.allowedPassengerIdentityDocumentTypes = allowedPassengerIdentityDocumentTypes;
    }

    public Offer1 availableServices(List<OfferService> availableServices) {
        this.availableServices = availableServices;
        return this;
    }

    public Offer1 addAvailableServicesItem(OfferService availableServicesItem) {
        if (this.availableServices == null) {
            this.availableServices = new ArrayList<OfferService>();
        }
        this.availableServices.add(availableServicesItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="The services that can be booked along with the offer but are not included by default, for example an additional checked bag. This field is only returned in the [Get single offer](/docs/api/offers/get-offer-by-id) endpoint. When there are no services available, or we don't support services for the airline, this list will be empty. If you want to know which airlines we support services for, please get in touch with the Duffel support team at <help@duffel.com>.")
    @JsonProperty(value="available_services")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<OfferService> getAvailableServices() {
        return this.availableServices;
    }

    @JsonProperty(value="available_services")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAvailableServices(List<OfferService> availableServices) {
        this.availableServices = availableServices;
    }

    public Offer1 baseAmount(String baseAmount) {
        this.baseAmount = baseAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="30.20", value="The base price of the offer for all passengers, excluding taxes. It does not include the base amount of any service(s) that might be booked with the offer.")
    @JsonProperty(value="base_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBaseAmount() {
        return this.baseAmount;
    }

    @JsonProperty(value="base_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBaseAmount(String baseAmount) {
        this.baseAmount = baseAmount;
    }

    public Offer1 baseCurrency(String baseCurrency) {
        this.baseCurrency = baseCurrency;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="GBP", value="The currency of the `base_amount`, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code. It will match your organisation's billing currency unless you\u2019re using Duffel as an accredited IATA agent, in which case it will be in the currency provided by the airline (which will usually be based on the country where your IATA agency is registered). ")
    @JsonProperty(value="base_currency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBaseCurrency() {
        return this.baseCurrency;
    }

    @JsonProperty(value="base_currency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBaseCurrency(String baseCurrency) {
        this.baseCurrency = baseCurrency;
    }

    public Offer1 conditions(OfferConditions1 conditions) {
        this.conditions = conditions;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="conditions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OfferConditions1 getConditions() {
        return this.conditions;
    }

    @JsonProperty(value="conditions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConditions(OfferConditions1 conditions) {
        this.conditions = conditions;
    }

    public Offer1 createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(example="2020-01-17T10:12:14.545Z", value="The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the offer was created")
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public Offer1 expiresAt(OffsetDateTime expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(example="2020-01-17T10:42:14.545Z", value="The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime expiry of the offer before which the traveller should use this offer to create an order. After this time the offer can no longer be used to create an order.")
    @JsonProperty(value="expires_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getExpiresAt() {
        return this.expiresAt;
    }

    @JsonProperty(value="expires_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpiresAt(OffsetDateTime expiresAt) {
        this.expiresAt = expiresAt;
    }

    public Offer1 id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="off_00009htYpSCXrwaB9DnUm0", value="Duffel's unique identifier for the offer")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public Offer1 liveMode(Boolean liveMode) {
        this.liveMode = liveMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Whether the offer request was created in live mode. This field will be set to `true` if the offer request was created in live mode, or `false` if it was created in test mode.")
    @JsonProperty(value="live_mode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getLiveMode() {
        return this.liveMode;
    }

    @JsonProperty(value="live_mode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLiveMode(Boolean liveMode) {
        this.liveMode = liveMode;
    }

    public Offer1 owner(OfferIndexOwner owner) {
        this.owner = owner;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="owner")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OfferIndexOwner getOwner() {
        return this.owner;
    }

    @JsonProperty(value="owner")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwner(OfferIndexOwner owner) {
        this.owner = owner;
    }

    public Offer1 partial(Boolean partial) {
        this.partial = partial;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Partial offers are a new concept we're introducing as a part of a new multi-step search flow that we're currently experimenting with. A partial offer can't be booked directly, but it can be combined with other partial offers to form a full offer. Partial offers are only ever returned through the multi-step search flow. So there's no need to add any handling to deal with partial offers if you're using the traditional `OfferRequest` search flow to create offers. ")
    @JsonProperty(value="partial")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getPartial() {
        return this.partial;
    }

    @JsonProperty(value="partial")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPartial(Boolean partial) {
        this.partial = partial;
    }

    public Offer1 passengerIdentityDocumentsRequired(Boolean passengerIdentityDocumentsRequired) {
        this.passengerIdentityDocumentsRequired = passengerIdentityDocumentsRequired;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Whether identity documents must be provided for each of the passengers when creating an order based on this offer. If this is `true`, you must provide an identity document for every passenger.")
    @JsonProperty(value="passenger_identity_documents_required")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getPassengerIdentityDocumentsRequired() {
        return this.passengerIdentityDocumentsRequired;
    }

    @JsonProperty(value="passenger_identity_documents_required")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPassengerIdentityDocumentsRequired(Boolean passengerIdentityDocumentsRequired) {
        this.passengerIdentityDocumentsRequired = passengerIdentityDocumentsRequired;
    }

    public Offer1 passengers(List<OfferPassenger> passengers) {
        this.passengers = passengers;
        return this;
    }

    public Offer1 addPassengersItem(OfferPassenger passengersItem) {
        if (this.passengers == null) {
            this.passengers = new ArrayList<OfferPassenger>();
        }
        this.passengers.add(passengersItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="The passengers included in the offer")
    @JsonProperty(value="passengers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<OfferPassenger> getPassengers() {
        return this.passengers;
    }

    @JsonProperty(value="passengers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPassengers(List<OfferPassenger> passengers) {
        this.passengers = passengers;
    }

    public Offer1 paymentRequirements(OfferIndexPaymentRequirements paymentRequirements) {
        this.paymentRequirements = paymentRequirements;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="payment_requirements")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OfferIndexPaymentRequirements getPaymentRequirements() {
        return this.paymentRequirements;
    }

    @JsonProperty(value="payment_requirements")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentRequirements(OfferIndexPaymentRequirements paymentRequirements) {
        this.paymentRequirements = paymentRequirements;
    }

    public Offer1 slices(List<OfferSlice> slices) {
        this.slices = slices;
        return this;
    }

    public Offer1 addSlicesItem(OfferSlice slicesItem) {
        if (this.slices == null) {
            this.slices = new ArrayList<OfferSlice>();
        }
        this.slices.add(slicesItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="The [slices](/docs/api/overview/key-principles) that make up this offer. Each slice will include one or more [segments](/docs/api/overview/key-principles), the specific flights that the airline is offering to take the passengers from the slice's `origin` to its `destination`. [Partial](#offers-schema-partial) offers contain a single slice as each partial offer is for a particular slice of the journey.")
    @JsonProperty(value="slices")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<OfferSlice> getSlices() {
        return this.slices;
    }

    @JsonProperty(value="slices")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSlices(List<OfferSlice> slices) {
        this.slices = slices;
    }

    public Offer1 taxAmount(String taxAmount) {
        this.taxAmount = JsonNullable.of((Object)taxAmount);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="40.80", value="The amount of tax payable on the offer for all passengers")
    @JsonIgnore
    public String getTaxAmount() {
        return (String)this.taxAmount.orElse(null);
    }

    @JsonProperty(value="tax_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getTaxAmount_JsonNullable() {
        return this.taxAmount;
    }

    @JsonProperty(value="tax_amount")
    public void setTaxAmount_JsonNullable(JsonNullable<String> taxAmount) {
        this.taxAmount = taxAmount;
    }

    public void setTaxAmount(String taxAmount) {
        this.taxAmount = JsonNullable.of((Object)taxAmount);
    }

    public Offer1 taxCurrency(String taxCurrency) {
        this.taxCurrency = JsonNullable.of((Object)taxCurrency);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="GBP", value="The currency of the `tax_amount`, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code. It will match your organisation's billing currency unless you\u2019re using Duffel as an accredited IATA agent, in which case it will be in the currency provided by the airline (which will usually be based on the country where your IATA agency is registered). ")
    @JsonIgnore
    public String getTaxCurrency() {
        return (String)this.taxCurrency.orElse(null);
    }

    @JsonProperty(value="tax_currency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getTaxCurrency_JsonNullable() {
        return this.taxCurrency;
    }

    @JsonProperty(value="tax_currency")
    public void setTaxCurrency_JsonNullable(JsonNullable<String> taxCurrency) {
        this.taxCurrency = taxCurrency;
    }

    public void setTaxCurrency(String taxCurrency) {
        this.taxCurrency = JsonNullable.of((Object)taxCurrency);
    }

    public Offer1 totalAmount(String totalAmount) {
        this.totalAmount = totalAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="45.00", value="The total price of the offer for all passengers, including taxes. It does not include the total price of any service(s) that might be booked with the offer.")
    @JsonProperty(value="total_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTotalAmount() {
        return this.totalAmount;
    }

    @JsonProperty(value="total_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalAmount(String totalAmount) {
        this.totalAmount = totalAmount;
    }

    public Offer1 totalCurrency(String totalCurrency) {
        this.totalCurrency = totalCurrency;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="GBP", value="The currency of the `total_amount`, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code. It will match your organisation's billing currency unless you\u2019re using Duffel as an accredited IATA agent, in which case it will be in the currency provided by the airline (which will usually be based on the country where your IATA agency is registered). ")
    @JsonProperty(value="total_currency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTotalCurrency() {
        return this.totalCurrency;
    }

    @JsonProperty(value="total_currency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalCurrency(String totalCurrency) {
        this.totalCurrency = totalCurrency;
    }

    public Offer1 totalEmissionsKg(String totalEmissionsKg) {
        this.totalEmissionsKg = totalEmissionsKg;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="460", value="An estimate of the total carbon dioxide (CO\u2082) emissions when all of the passengers fly this offer's itinerary, measured in kilograms")
    @JsonProperty(value="total_emissions_kg")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTotalEmissionsKg() {
        return this.totalEmissionsKg;
    }

    @JsonProperty(value="total_emissions_kg")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalEmissionsKg(String totalEmissionsKg) {
        this.totalEmissionsKg = totalEmissionsKg;
    }

    public Offer1 updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(example="2020-01-17T10:12:14.545Z", value="The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the offer was last updated")
    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Offer1 offer1 = (Offer1)o;
        return Objects.equals(this.allowedPassengerIdentityDocumentTypes, offer1.allowedPassengerIdentityDocumentTypes) && Objects.equals(this.availableServices, offer1.availableServices) && Objects.equals(this.baseAmount, offer1.baseAmount) && Objects.equals(this.baseCurrency, offer1.baseCurrency) && Objects.equals(this.conditions, offer1.conditions) && Objects.equals(this.createdAt, offer1.createdAt) && Objects.equals(this.expiresAt, offer1.expiresAt) && Objects.equals(this.id, offer1.id) && Objects.equals(this.liveMode, offer1.liveMode) && Objects.equals(this.owner, offer1.owner) && Objects.equals(this.partial, offer1.partial) && Objects.equals(this.passengerIdentityDocumentsRequired, offer1.passengerIdentityDocumentsRequired) && Objects.equals(this.passengers, offer1.passengers) && Objects.equals(this.paymentRequirements, offer1.paymentRequirements) && Objects.equals(this.slices, offer1.slices) && Offer1.equalsNullable(this.taxAmount, offer1.taxAmount) && Offer1.equalsNullable(this.taxCurrency, offer1.taxCurrency) && Objects.equals(this.totalAmount, offer1.totalAmount) && Objects.equals(this.totalCurrency, offer1.totalCurrency) && Objects.equals(this.totalEmissionsKg, offer1.totalEmissionsKg) && Objects.equals(this.updatedAt, offer1.updatedAt);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.allowedPassengerIdentityDocumentTypes, this.availableServices, this.baseAmount, this.baseCurrency, this.conditions, this.createdAt, this.expiresAt, this.id, this.liveMode, this.owner, this.partial, this.passengerIdentityDocumentsRequired, this.passengers, this.paymentRequirements, this.slices, Offer1.hashCodeNullable(this.taxAmount), Offer1.hashCodeNullable(this.taxCurrency), this.totalAmount, this.totalCurrency, this.totalEmissionsKg, this.updatedAt);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Offer1 {\n");
        sb.append("    allowedPassengerIdentityDocumentTypes: ").append(this.toIndentedString(this.allowedPassengerIdentityDocumentTypes)).append("\n");
        sb.append("    availableServices: ").append(this.toIndentedString(this.availableServices)).append("\n");
        sb.append("    baseAmount: ").append(this.toIndentedString(this.baseAmount)).append("\n");
        sb.append("    baseCurrency: ").append(this.toIndentedString(this.baseCurrency)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    liveMode: ").append(this.toIndentedString(this.liveMode)).append("\n");
        sb.append("    owner: ").append(this.toIndentedString(this.owner)).append("\n");
        sb.append("    partial: ").append(this.toIndentedString(this.partial)).append("\n");
        sb.append("    passengerIdentityDocumentsRequired: ").append(this.toIndentedString(this.passengerIdentityDocumentsRequired)).append("\n");
        sb.append("    passengers: ").append(this.toIndentedString(this.passengers)).append("\n");
        sb.append("    paymentRequirements: ").append(this.toIndentedString(this.paymentRequirements)).append("\n");
        sb.append("    slices: ").append(this.toIndentedString(this.slices)).append("\n");
        sb.append("    taxAmount: ").append(this.toIndentedString(this.taxAmount)).append("\n");
        sb.append("    taxCurrency: ").append(this.toIndentedString(this.taxCurrency)).append("\n");
        sb.append("    totalAmount: ").append(this.toIndentedString(this.totalAmount)).append("\n");
        sb.append("    totalCurrency: ").append(this.toIndentedString(this.totalCurrency)).append("\n");
        sb.append("    totalEmissionsKg: ").append(this.toIndentedString(this.totalEmissionsKg)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum AllowedPassengerIdentityDocumentTypesEnum {
        PASSPORT("passport");

        private String value;

        private AllowedPassengerIdentityDocumentTypesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AllowedPassengerIdentityDocumentTypesEnum fromValue(String value) {
            for (AllowedPassengerIdentityDocumentTypesEnum b : AllowedPassengerIdentityDocumentTypesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

