/*
 * Decompiled with CFR 0.152.
 */
package com.duffel.sdk.model;

import com.duffel.sdk.model.OfferIndex;
import com.duffel.sdk.model.OfferRequestPassenger;
import com.duffel.sdk.model.OfferRequestSlice;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;

@JsonPropertyOrder(value={"cabin_class", "created_at", "id", "live_mode", "offers", "passengers", "slices"})
@JsonTypeName(value="Offer_Request")
public class OfferRequest {
    public static final String JSON_PROPERTY_CABIN_CLASS = "cabin_class";
    private CabinClassEnum cabinClass;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_LIVE_MODE = "live_mode";
    private Boolean liveMode;
    public static final String JSON_PROPERTY_OFFERS = "offers";
    private List<OfferIndex> offers = null;
    public static final String JSON_PROPERTY_PASSENGERS = "passengers";
    private List<OfferRequestPassenger> passengers = null;
    public static final String JSON_PROPERTY_SLICES = "slices";
    private List<OfferRequestSlice> slices = null;

    public OfferRequest cabinClass(CabinClassEnum cabinClass) {
        this.cabinClass = cabinClass;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="economy", value="The cabin that the passengers want to travel in")
    @JsonProperty(value="cabin_class")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CabinClassEnum getCabinClass() {
        return this.cabinClass;
    }

    @JsonProperty(value="cabin_class")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCabinClass(CabinClassEnum cabinClass) {
        this.cabinClass = cabinClass;
    }

    public OfferRequest createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(example="2020-02-12T15:21:01.927Z", value="The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the offer request was created")
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public OfferRequest id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="orq_00009hjdomFOCJyxHG7k7k", value="Duffel's unique identifier for the offer request")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public OfferRequest liveMode(Boolean liveMode) {
        this.liveMode = liveMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Whether the offer request was created in live mode. This field will be set to `true` if the offer request was created in live mode, or `false` if it was created in test mode.")
    @JsonProperty(value="live_mode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getLiveMode() {
        return this.liveMode;
    }

    @JsonProperty(value="live_mode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLiveMode(Boolean liveMode) {
        this.liveMode = liveMode;
    }

    public OfferRequest offers(List<OfferIndex> offers) {
        this.offers = offers;
        return this;
    }

    public OfferRequest addOffersItem(OfferIndex offersItem) {
        if (this.offers == null) {
            this.offers = new ArrayList<OfferIndex>();
        }
        this.offers.add(offersItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="The offers returned by the airlines")
    @JsonProperty(value="offers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<OfferIndex> getOffers() {
        return this.offers;
    }

    @JsonProperty(value="offers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOffers(List<OfferIndex> offers) {
        this.offers = offers;
    }

    public OfferRequest passengers(List<OfferRequestPassenger> passengers) {
        this.passengers = passengers;
        return this;
    }

    public OfferRequest addPassengersItem(OfferRequestPassenger passengersItem) {
        if (this.passengers == null) {
            this.passengers = new ArrayList<OfferRequestPassenger>();
        }
        this.passengers.add(passengersItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="The passengers who want to travel")
    @JsonProperty(value="passengers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<OfferRequestPassenger> getPassengers() {
        return this.passengers;
    }

    @JsonProperty(value="passengers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPassengers(List<OfferRequestPassenger> passengers) {
        this.passengers = passengers;
    }

    public OfferRequest slices(List<OfferRequestSlice> slices) {
        this.slices = slices;
        return this;
    }

    public OfferRequest addSlicesItem(OfferRequestSlice slicesItem) {
        if (this.slices == null) {
            this.slices = new ArrayList<OfferRequestSlice>();
        }
        this.slices.add(slicesItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="The [slices](/docs/api/overview/key-principles) that make up this offer request. One-way journeys can be expressed using one slice, whereas return trips will need two.")
    @JsonProperty(value="slices")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<OfferRequestSlice> getSlices() {
        return this.slices;
    }

    @JsonProperty(value="slices")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSlices(List<OfferRequestSlice> slices) {
        this.slices = slices;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OfferRequest offerRequest = (OfferRequest)o;
        return Objects.equals((Object)this.cabinClass, (Object)offerRequest.cabinClass) && Objects.equals(this.createdAt, offerRequest.createdAt) && Objects.equals(this.id, offerRequest.id) && Objects.equals(this.liveMode, offerRequest.liveMode) && Objects.equals(this.offers, offerRequest.offers) && Objects.equals(this.passengers, offerRequest.passengers) && Objects.equals(this.slices, offerRequest.slices);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.cabinClass, this.createdAt, this.id, this.liveMode, this.offers, this.passengers, this.slices});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OfferRequest {\n");
        sb.append("    cabinClass: ").append(this.toIndentedString((Object)this.cabinClass)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    liveMode: ").append(this.toIndentedString(this.liveMode)).append("\n");
        sb.append("    offers: ").append(this.toIndentedString(this.offers)).append("\n");
        sb.append("    passengers: ").append(this.toIndentedString(this.passengers)).append("\n");
        sb.append("    slices: ").append(this.toIndentedString(this.slices)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CabinClassEnum {
        FIRST("first"),
        BUSINESS("business"),
        PREMIUM_ECONOMY("premium_economy"),
        ECONOMY("economy");

        private String value;

        private CabinClassEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CabinClassEnum fromValue(String value) {
            for (CabinClassEnum b : CabinClassEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

